/* NOSHIP */
#ifndef _ICVHDR_
  #define _ICVHDR_
/*******************************************************************************
* FILE NAME: icvhdr.hpp                                                        *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     ICanvasHandler                                                           *
*     ICanvasStatics                                                           *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1995       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ihandler.hpp>
#include <ikeyhdr.hpp>

#pragma pack(4)

class ICanvas;
class IFrameWindow;
class IEvent;
class IKeyboardEvent;
class ICanvasHandlerData;
class ICVKeyboardHandlerData;

class ICVKeyboardHandler : public IHandler {
typedef IHandler
  Inherited;
/*******************************************************************************
* This class provides keyboard event processing for canvas objects.
* Its primary purpose is to provide tabbing and cursor movement between
* controls in a manner similar to dialogs.  It also handle SETFOCUS events
* for the canvas.
*   In OS/2, a default object of this class is attached to ICanvas objects.
*   In Windows, a default object of this class is attached to ICanvas
*      objects and to IFrameWindow objects.
*******************************************************************************/
public:
/*------------------------- Constructors/Destructors ---------------------------
| The only way to construct instances of this class is by using the            |
| default constructor, which does not take any parameters.                     |
------------------------------------------------------------------------------*/
  ICVKeyboardHandler        ( );
virtual
 ~ICVKeyboardHandler        ( );

/*---------------------------- Window Attachment -------------------------------
| These functions permit attaching and detaching the handler object to/from    |
| a canvas window:                                                             |
|   handleEventsFor       - Attaches the handler to the specified canvas.      |
|   stopHandlingEventsFor - Detaches the handler from the specified canvas.    |
| In Windows, the handler object may also be attached to an IFrameWindow       |
| object.                                                                      |
------------------------------------------------------------------------------*/
virtual ICVKeyboardHandler
 &handleEventsFor       ( ICanvas* canvas ),
 &stopHandlingEventsFor ( ICanvas* canvas );

#ifdef IC_WIN
virtual ICVKeyboardHandler
 &handleEventsFor       ( IFrameWindow* canvas ),
 &stopHandlingEventsFor ( IFrameWindow* canvas );
#endif


protected:
/*-------------------------------- Overrides -----------------------------------
| This class overrides the following inherited functions:                      |
|   dispatchHandlerEvent - Router for (and provides processing for other)      |
|                          class-specific events.                              |
------------------------------------------------------------------------------*/
virtual Boolean
  dispatchHandlerEvent  ( IEvent& event );

/*----------------------------- Event Processing -------------------------------
| These functions are supplied to implement specific event processing.         |
|   key          - Processes tabbing and cursor movement keys                  |
------------------------------------------------------------------------------*/
virtual Boolean
  key                  ( IKeyboardEvent& event );

/*------------------------------ Implementation --------------------------------
| These functions are supplied in order to provide a canvas window with        |
| support typically expected from a dialog window.                             |
|   gotFocus     - Gives input focus to the appropriate child window           |
|   handleCursorMovement - Handles tabbing between groups and canvases and     |
|                          cursor movement within a group.                     |
|   handleEnter          - Handles selection of a default pushbutton when the  |
|                          Enter key is pressed.                               |
------------------------------------------------------------------------------*/
Boolean
  gotFocus              ( IEvent& event ),
  handleCursorMovement  ( IKeyboardEvent& event ),
  handleEnter           ( IKeyboardEvent& event );

/*------------------------------ Button State ----------------------------------
|   buttonSetup          - Handles cursor selection of radio buttons and       |
|                          default push button hiliting with cursor movement.  |
------------------------------------------------------------------------------*/
enum State {
  enteringGroup, withinGroup, leavingGroup
};
static void
  buttonSetup           ( const IWindow* canvas,
                          const IWindowHandle& child,
                          State state,
                          Boolean fClickRadio = TRUE );  // DEFECT 8015

private:
/*--------------------------------- Private ----------------------------------*/
virtual IHandler
 &handleEventsFor       ( IWindow* window  ),
 &stopHandlingEventsFor ( IWindow* window  );

ICVKeyboardHandlerData
 *fCVKeyboardHandlerData;
};    // class ICVKeyboardHandler

class ICanvasHandler : public IHandler {
typedef IHandler
  Inherited;
/*******************************************************************************
* This class provides event processing for canvas objects.  This includes:     *
*   - expected client area behavior                                            *
*     (e.g. ability to be resized, passing of command events to the owner      *
*   - calling the layout routine when the window is repainted                  *
*                                                                              *
* The management of tabbing and cursor movement between controls,              *
* auto-selecting of radio buttons, processing of mnemonics, etc. is handled    *
* by ICVKeyboardHandler.  For canvas controls default ICanvasHandler and       *
* ICVKeyboardHandler objects are attached to the canvas.  In Windows, the      *
* ICVKeyboardHandler object is also used on IFrameWindows but the              *
* ICanvasHandler object is not.                                                *
*                                                                              *
* The only way to construct instances of this class is by using the            *
* default constructor, which does not take any parameters.                     *
*******************************************************************************/
public:
/*------------------------- Constructors/Destructors ---------------------------
| The only way to construct instances of this class is by using the            |
| default constructor, which does not take any parameters.                     |
------------------------------------------------------------------------------*/
  ICanvasHandler        ( );
virtual
 ~ICanvasHandler        ( );

/*---------------------------- Window Attachment -------------------------------
| These functions permit attaching and detaching the handler object to/from    |
| a canvas window:                                                             |
|   handleEventsFor       - Attaches the handler to the specified canvas.      |
|   stopHandlingEventsFor - Detaches the handler from the specified canvas.    |
------------------------------------------------------------------------------*/
virtual ICanvasHandler
 &handleEventsFor       ( ICanvas* canvas ),
 &stopHandlingEventsFor ( ICanvas* canvas );

protected:
/*-------------------------------- Overrides -----------------------------------
| This class overrides the following inherited functions:                      |
|   dispatchHandlerEvent - Router for (and provides processing for other)      |
|                          class-specific events.                              |
------------------------------------------------------------------------------*/
virtual Boolean
  dispatchHandlerEvent  ( IEvent& event );

/*----------------------------- Event Processing -------------------------------
| These functions are supplied to implement specific event processing.         |
|   layoutCanvas - Calls the virtual layout function.                          |
------------------------------------------------------------------------------*/
virtual Boolean
  layoutCanvas          ( IEvent& event );


private:
/*--------------------------------- Private ----------------------------------*/
virtual IHandler
 &handleEventsFor       ( IWindow* window  ),
 &stopHandlingEventsFor ( IWindow* window  );

ICanvasHandlerData
 *fCanvasHandlerData;
}; // class ICanvasHandler


class ICanvasStatics : public IBase {
typedef IBase
  Inherited;
/*******************************************************************************
* This class manages the lifetime of the static canvas handler.  An object of  *
* this class is constructed during static object initialization.  The handler  *
* object is constructed only if needed, and is deleted at termination of the   *
* application.                                                                 *
*******************************************************************************/
public:
/*-------------------------- Constructor/Destructor ----------------------------
| The only way to construct instances of this class is to use the default      |
| constructor, which does not take any arguments.                              |
------------------------------------------------------------------------------*/
 ~ICanvasStatics      ( );

/*-------------------------------- Accessors -----------------------------------
| This function is used to access the static canvas handler.  This allows one  |
| object to be constructed when needed, and shared by all canvases.            |
|   canvasHandler   - Returns the canvas handler.                              |
|   keyboardHandler   - Returns the canvas keyboard handler.                   |
------------------------------------------------------------------------------*/
static ICanvasHandler
 &canvasHandler         ( );
static ICVKeyboardHandler
 &keyboardHandler     ( );

private:
/*--------------------------------- Private ----------------------------------*/
static ICanvasHandler
 *pClCanvasHandler;
static ICVKeyboardHandler
 *fgcvKeyboardHandler;
}; // class ICanvasStatics

/*----------------------------------------------------------------------------*/
/* Resume compiler default packing.                                           */
/*----------------------------------------------------------------------------*/
#pragma pack()

#endif /* _ICVHDR_ */
