/*******************************************************************************
* FILE NAME: DDE4UDLU.CPP                                                      *
*                                                                              *
* Defect: 9868:icl2                                                            *
* SPECIAL CASE INIT TERM FOR CPPOOU3.DLL                                       *
* - need to clean up the thread watcher thread as specified by OS2             *
*   support, due to potential problem when DosFreeModule on this dll           *
*   when the thread is still active.                                           *
*                                                                              *
* DESCRIPTION: Resource stub file for ICLUI DLLs                               *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1995       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <stdio.h>
#ifdef __WINDOWS__
#include <windows.h>
#endif

// function prototypes
extern "C" {
  int  _CRT_init      (void );
  void __ctordtorInit (void );
  void _CRT_term      (void );
  void __ctordtorTerm (void );
  void threadWatcher_Terminate(void);           // 9868
}


// Segment definitions
#ifdef IC_PAGETUNE
  #define _DDE4UDLL_CPP_
  #include <ipagetun.h>
#endif

#pragma data_seg(ICLNonConst)
#ifdef __WINDOWS__
  HANDLE        CPPOO_dllHandle;
#endif
#ifndef __WINDOWS__
  unsigned long CPPOO_dllHandle = 0;
#endif
#pragma data_seg()

#ifdef __WINDOWS__
INT APIENTRY          _DLL_InitTerm(HANDLE hmodule,
                                    DWORD  reasonCalled,
                                    LPVOID reserved )
{
   INT  rc = TRUE;     /* success */
   switch (reasonCalled)
      {
      case  DLL_PROCESS_ATTACH:
         /*******************************************************************/
         /* The C run-time environment initialization function must be      */
         /* called before any calls to C run-time functions that are not    */
         /* inlined.                                                        */
         /*******************************************************************/
         CPPOO_dllHandle = hmodule; // DLL being loaded
         if (_CRT_init() == -1)
         {
            rc = FALSE;                 // error
         }
         __ctordtorInit();

         break;

      case  DLL_THREAD_ATTACH:
      case  DLL_THREAD_DETACH:
      case  DLL_PROCESS_DETACH:
         /* We currently don't do anything with these */
         break;
      }
   return rc;
}
#endif

#ifndef __WINDOWS__
unsigned long _System _DLL_InitTerm ( unsigned long hmodule, unsigned long ulFlag )
{
  unsigned long ulRc = 1;         // assume no errors

  if (ulFlag == 0)
  {
     CPPOO_dllHandle = hmodule; // DLL being loaded
     if (_CRT_init() == -1)
     {
        ulRc = 0;                 // error
     }
     __ctordtorInit();
  } /* endif */
  else if (ulFlag == 1)
  {                               // DLL being freed

// It appears we should do neither of these at shutdown
// There were problems with Driver 27 when ctordtorTerm() was called
// and _CRT_term() wasn't.
#ifdef IC_STATIC_LINK
     __ctordtorTerm();
     _CRT_term();
#else
     threadWatcher_Terminate();                 // 9868
#endif
  }
  else
  {
     ulRc = 0;                    // error
  }

  return ulRc;
}
#endif
