#ifndef _ISAFEID_
  #define _ISAFEID_
/*******************************************************************************
* FILE NAME: isafeid.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains a static class that allows increment and decrement      *
*   operations that are safe even in multi-processing environments.            *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/

/*******************************************************************************
*  The member variables are static.  They are initialized once,                *
*  automatically during initialization.                                        *
*                                                                              *
*  Therefore when using the class, there is no need to create an instance of   *
*  this class.                                                                 *
*  Call the static functions.  For example:  ISafeIncDec::increment(i)         *
*******************************************************************************/
extern "C" {
   #include <iincdec.h>
}

class ISafeIncDec
{
public:
  static increment (unsigned int &count);
  static decrement (unsigned int &count);
  static increment (long &count);
  static decrement (long &count);
  
private:
  ISafeIncDec();
  static int (*_Optlink incTestFnPtr) (int*);
  static int (*_Optlink decTestFnPtr) (int*);
};
#endif /* _ISAFEID_ */
