#define INCL_PM
#define INCL_BASE
#include <os2.h>

#define MSGFILE "SPACECHK.MSG"
#define MSGNO   1000UL

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

APIRET destroyTemporaryInstallObject(PSZ pArg);
APIRET queryFreeSpaceOnBootDrive(double *pFreeSpace);

int main(int argc,char *argv[])
{
    CHAR szMsg[256];

    double fReqSpace,fFreeSpace;
    APIRET rc;
    HAB hab;
    HMQ hmq;
    PCHAR endptr = NULL;

    if (argc < 3)
    {
        return ERROR_INVALID_PARAMETER;
    }

    fReqSpace = strtod(argv[1],&endptr);
    if (endptr == argv[1])
    {
        return ERROR_INVALID_PARAMETER;
    }

    hab = WinInitialize(0UL);
    hmq = WinCreateMsgQueue(hab,0UL);

    rc = destroyTemporaryInstallObject(argv[2]);

    rc = queryFreeSpaceOnBootDrive(&fFreeSpace);
    if (rc == NO_ERROR)
    {
        if (fFreeSpace > fReqSpace)
        {
            rc = NO_ERROR;
        }
        else
        {
            CHAR szReqSpace[32];
            CHAR szFreeSpace[32];
            PCHAR szTable[2]={szReqSpace,szFreeSpace};
            ULONG ulLen=0UL;

            sprintf(szReqSpace,"%.0f Mega",fReqSpace/1024.0F/1024.0F);
            sprintf(szFreeSpace,"%.0f Mega bytes",fFreeSpace/1024.0F/1024.0F);
            rc = DosGetMessage(szTable,2,szMsg,sizeof(szMsg)-1,MSGNO,MSGFILE,&ulLen);
            szMsg[ulLen]='\0';
            WinMessageBox(HWND_DESKTOP,NULLHANDLE,szMsg,"Error!",1UL,MB_OK|MB_ERROR|MB_MOVEABLE);

            rc = ERROR_DISK_FULL;
        }
    }

    WinDestroyMsgQueue(hmq);
    WinTerminate(hab);
    return rc;
}

APIRET destroyTemporaryInstallObject(PSZ pArg)
{
    APIRET rc;
    ULONG ulBootDrive=0;
    UCHAR ucDrive;

    if (!pArg)
    {
        return ERROR_INVALID_PARAMETER;
    }

    rc = DosQuerySysInfo(QSV_BOOT_DRIVE,QSV_BOOT_DRIVE,&ulBootDrive,sizeof(ulBootDrive));
    if (rc == NO_ERROR)
    {
        CHAR szPath[CCHMAXPATH];
        CHAR szDrive[_MAX_DRIVE];
        CHAR szDir[_MAX_DIR];
        CHAR szName[_MAX_FNAME];
        HOBJECT hobj;

        _splitpath(pArg,NULL,szDir,szName,NULL);
        szDrive[0] = 'A'-1+(CHAR)ulBootDrive;
        szDrive[1] = '\0';
        _makepath(szPath,szDrive,szDir,szName,NULL);

        hobj = WinQueryObject(szPath);
        if (hobj && WinDestroyObject(hobj))
        {
            rc = NO_ERROR;
        }
        else
        {
            rc = ERROR_PATH_NOT_FOUND;
        }
    }
    return rc;
}

APIRET queryFreeSpaceOnBootDrive(double *pFreeSpace)
{
    APIRET rc;
    ULONG ulBootDrive;
    FSALLOCATE fa={0};

    rc = ERROR_INVALID_PARAMETER;
    if (!pFreeSpace)
    {
        return rc;
    }

    rc = DosQuerySysInfo(QSV_BOOT_DRIVE,QSV_BOOT_DRIVE,&ulBootDrive,sizeof(ulBootDrive));
    if (rc == NO_ERROR)
    {
        rc = DosQueryFSInfo(ulBootDrive,FSIL_ALLOC,&fa,sizeof(fa));
        if (rc == NO_ERROR)
        {
            *pFreeSpace = (double)fa.cUnitAvail * (double)fa.cSectorUnit * (double)fa.cbSector;
        }
        else
        {
            *pFreeSpace = 0.0F;
        }
    }
    return rc;
}
