//===============================================================
// vos2.h - Special defs for OS/2 PM version
//
// Copyright (C) 1995,1996  Bruce E. Wampler
//
// This file is part of the V C++ GUI Framework, and is covered
// under the terms of the GNU Library General Public License,
// Version 2. This library has NO WARRANTY.  See the source file
// vapp.cxx for more complete information about license terms.
//===============================================================

#ifndef VOS2_H
#define VOS2_H

//  RGB color macro
#define SETRGB(r,g,b) ((ULONG)(((BYTE)(b)|((USHORT)(g)<<8))|(((ULONG)(BYTE)(r))<<16)))
#define SETRGB2(o,r,g,b) ((ULONG)(((BYTE)(b)|((USHORT)(g)<<8))|(((ULONG)(BYTE)(r))<<16)|(((ULONG)(BYTE)(o))<<24)))

// type FIXED Gpi macros
#define DBLTOFX(x) ((FIXED) ((x)*65536))

#define IDI_APPLICATION     32512
#define IDI_HAND            32513
#define IDI_QUESTION        32514
#define IDI_EXCLAMATION     32515
#define IDI_ASTERISK        32516

#ifdef __BORLANDC__
#define  NEED_SPBCDATA
#endif

#ifdef NEED_SPBCDATA
// For some reason Borland does not include the spin button control data
// structure.

   /**********************************************************************/
   /* Spin Button control data structure                                  */
   /**********************************************************************/
   typedef struct _SPBCDATA     /* spbcd */
   {
      unsigned int   cbSize;                /* Size of control block             */
      unsigned int   ulTextLimit;           /* Entryfield text limit             */
      int            lLowerLimit;           /* Spin lower limit (numeric only)   */
      int            lUpperLimit;           /* Spin upper limit (numeric only)   */
      unsigned int   idMasterSpb;           /* ID of the servant's master spb    */
      void *         pHWXCtlData;           /* reserved for Pen CtlData (penpm.h)*/
   } SPBCDATA;
   typedef SPBCDATA *PSPBCDATA;
#endif

#endif

