//===============================================================
// vframec.cxx  - a frame for holding commands - Windows
//
// Copyright (C) 1995,1996,1997,1998  Bruce E. Wampler
//
// This file is part of the V C++ GUI Framework, and is covered
// under the terms of the GNU Library General Public License,
// Version 2. This library has NO WARRANTY. See the source file
// vapp.cxx for more complete information about license terms.
//===============================================================
#include <v/vos2.h>           // for OS/2 stuff
#include <v/vapp.h>
#include <v/vframec.h>  // our definitions
#include <v/vcmdprnt.h> // a command parent
//=====================>>> vFrameCmd::vFrameCmd <<<=======================
  vFrameCmd::vFrameCmd(vCmdParent* dp, CommandObject* dc) :
    vCmd(dp, dc)
  {
    initialize();
  }
//=====================>>> vFrameCmd::~vFrameCmd <<<=======================
  vFrameCmd::~vFrameCmd()
  {
    SysDebug(Destructor,"vFrameCmd::~vFrameCmd() destructor\n")
  }
//=====================>>> vFrameCmd::initialize <<<=======================
  void vFrameCmd::initialize(void)
  {
    SysDebug(Constructor,"vFrameCmd::vFrameCmd() constructor\n")

    long style = SS_GROUPBOX | WS_GROUP;       // static group box

    CopyToLocal();                      // Make local copies of CmdObject
//    _title = "";                                // never a label, sigh...
    if (!(dlgCmd->attrs & CA_NoBorder))               // Check for Hidden
      style |= WS_VISIBLE;

    // all these positioning coords will be updated later as
    // controls are added to the frame, so this is pretty
    // much irrelevant.
    _w = StdMargin;                             // set my width
    _h = StdMargin;                             // default height
    _parentWin->SetPosition(_x, _y, _w, _h, dlgCmd->cFrame, dlgCmd->cRightOf,
	dlgCmd->cBelow);

// OS/2 can put titles in the frame, but since this is not standard V
// behavior I have disabled it.  Uncomment this code to re-enable it.
//    _CtrlOffset = _parentWin->AddDlgControl(_x, _y, _w, _h, _cmdId,
//	  style, WC_STATIC, _title, NULL, 0, NULL);
    _CtrlOffset = _parentWin->AddDlgControl(_x, _y, _w, _h, _cmdId,
 	  style, WC_STATIC, "", NULL, 0, NULL);
  }

//================>>> vFrameCmd::SetCmdVal <<<============================
  void vFrameCmd::SetCmdVal(ItemVal val, ItemSetType st)
  {
    SysDebug2(Misc,"vFrameCmd::SetCmdVal(val:%d st:%d)\n",val, st)
    HWND myHwnd = GetMyHwnd(_cmdId);
    if (st == Sensitive)             // used so icons won't get
    {                                // focus -- icons use ownerdraw,
      _Sensitive = val;              // which behave like buttons, not
      WinEnableWindow(myHwnd, val);
    }
    else if (st == Hidden)              // hide or unhide
    {
      if (val)
      {
	WinShowWindow(myHwnd,FALSE);
      }
      else
      {
	WinShowWindow(myHwnd,TRUE);
      }
    }

    else if (st == Value && dlgCmd->cmdType == C_ToggleFrame)   // Toggle?
    {

/*    we don't ever want to see the toggle frame, its a virtual thing really
      if (val)                // have to hide/show me first
      {
	WinShowWindow(myHwnd,TRUE);
      }
      else
      {
	 WinShowWindow(myHwnd,FALSE);
      }
*/
      _parentWin->SetFrameChildren(_cmdId,val); // and now set value of childern
    }
 }

//================>>> vFrameCmd::MEASUREITEM <<<============================
  int vFrameCmd::MEASUREITEM(int id, OWNERITEM* mis)
  {
    return 1;
  }

//================>>> vFrameCmd::DRAWITEM <<<============================
  int vFrameCmd::DRAWITEM(int id, OWNERITEM* dis)
  {
    return 0;
  }

//===================>>> vFrameCmd::vCmdCallback <<<=======================
  void vFrameCmd::CmdCallback(UINT uMsg, MPARAM mp1, MPARAM mp2)
  {
   // No Op for a Frame - the icon button may generate one of these!
  }
