//===============================================================
// vicon.cpp - icon class
//
// Copyright (C) 1995,1996,1997,1998  Bruce E. Wampler
//
// This file is part of the V C++ GUI Framework, and is covered
// under the terms of the GNU Library General Public License,
// Version 2. This library has NO WARRANTY. See the source file
// vapp.cxx for more complete information about license terms.
//===============================================================
#include <v/v_defs.h>		// for OS/2 stuff
#include <v/vos2.h>		// for OS/2 stuff
#include <v/vapp.h>
#include <v/vicon.h>
//#include <math.h>
//=============================>>> vIcon::vIcon <<<=====================
  vIcon::vIcon()
  {
    _hbm = 0;
    _currentDC = 0;
  }
//=============================>>> vIcon::vIcon  <<<=====================
  vIcon::vIcon(unsigned char* ic, int h, int w, int d, IconType it)
  {
    icon = ic; height = h; width = w; depth = d; iType = it;
    _hbm = 0;
    _currentDC = 0;
  }
//=============================>>> vIcon::~vIcon <<<=====================
  vIcon::~vIcon()
  {
    if (_hbm != 0)
      GpiDeleteBitmap(_hbm);
  }
//=============================>>> vIcon::NeedBMPBytes <<<==================
  int vIcon::NeedBMPBytes()
  {
    // calculate how many bytes of storage pixel data will take
    // includes allowance for mandatory word boundary alignment of rows
    // note: does not include color map storage

    int needWords = height*((depth*width+31)/32);
    return (needWords * 4);	// convert to bytes
  }
//=============================>>> vIcon::vIconToBMP  <<<=====================
  void vIcon::vIconToBMP(HPS iDC)
  {
    // We use _currentDC to track whether the current _hbm is valid
    // for the requesting DC.  If it is, we can improve performance
    // by just returning the _hbm without recreating it again.  If it
    // is not the same, we need to destroy the _hbm and recreate it
    // with the appropriate compatable memory PS

    // The inline code for GetIconHBM checks to see if the (iDC/HBM)
    // pair is valid.  If we get this far then the pair must be invalid
    // (or undefined) and thus we need to create a new bitmap.

    if (_currentDC != 0)
      GpiDeleteBitmap(_hbm);

    _currentDC = iDC;

    // bitmap data structures
    PBYTE vbytes = (PBYTE) icon;
    PBYTE bmbits;
    PBITMAPINFO2 pbmi;

    // build a memory PS compatible with calling PS
    HDC DevCxtComp = GpiQueryDevice(iDC);
    HDC DevCxtMem = DevOpenDC(theApp->AppHab(), OD_MEMORY, "*", 0L, NULL, DevCxtComp);
    SIZEL size = {width, height};
    HPS hdcMem = GpiCreatePS (theApp->AppHab(), DevCxtMem, &size,
				  PU_PELS | GPIF_DEFAULT | GPIT_MICRO | GPIA_ASSOC );

    // set the PS to RGB mode
    GpiCreateLogColorTable(hdcMem, 0L, LCOLF_RGB, 0L, 0L, NULL);

    // First, create a blank bitmap compatible with the
    // current context that is size of bitmap.
    BITMAPINFOHEADER2 bmih;
    memset(&bmih, 0, sizeof(BITMAPINFOHEADER2));
    bmih.cbFix = sizeof(BITMAPINFOHEADER2);
    bmih.cx = width;
    bmih.cy = height;
    bmih.ulColorEncoding = BCE_RGB;
//  DevQueryCaps (hdcMem, CAPS_COLOR_PLANES, 1, &bmih.cPlanes);
//  DevQueryCaps (hdcMem, CAPS_COLOR_BITCOUNT, 1, &bmih.cBitCount);
    bmih.cPlanes = 1;         // always 1 for OS/2
    bmih.cBitCount = depth;   // bits of color per pixel

    _hbm = GpiCreateBitmap(hdcMem, &bmih, 0L, NULL, NULL);

    // now we need to load the bitmap with data by associating
    // with a memory PS and setting each pel
    GpiSetBitmap(hdcMem, _hbm);

    if (depth == 8)		// 8 bit icons
    {
	// 8 bit vicon structure:
	// header:     [n][rgb0][rgb1][...][rgbn]
	// pixel data: [p1][p2][...][phxw]

	// we first need to create the bitmapinfo structure and
	// color table
	// get the total number of entries in color table
	unsigned int numColors = (unsigned int) *vbytes++ + 1;

	// allocate space for header and color table
	LONG colorTableSize = numColors*sizeof(RGB2);
	pbmi = (PBITMAPINFO2) new BYTE [sizeof(BITMAPINFOHEADER2)+colorTableSize];

	// copy the header to the bitmap info structure
	memcpy(pbmi, &bmih, sizeof(BITMAPINFOHEADER2));
	pbmi->cbImage = NeedBMPBytes();
	pbmi->cclrUsed = numColors ;

	// create the color table
	PRGB2 ColorEntry = pbmi->argbColor;
	for (unsigned int ix = 0 ; ix < numColors ; ++ix) // map the colors
	{
	  ColorEntry->bRed = *vbytes++;
	  ColorEntry->bGreen = *vbytes++;
	  ColorEntry->bBlue = *vbytes++;
	  ColorEntry->fcOptions = 0;
	  ColorEntry++;
	}

	// Colors mapped, vbytes now points to beginning of data
	bmbits = new BYTE[NeedBMPBytes()];	// allocate space

	// Now need to copy pixel data over from V icon format
	// The V format is essentially based on the X way of
	// defining a bitmap.  To fix it up, we need to
	// pad rows to even words.
	// Although OS/2 row order is upsidedown in OS/2 compared
	// to X, since we invert the DC using the model space transform
	// it all works out in the end.

	int rowwords = (width+3) / 4;     // number of words (for OS/2 bitmap data)
//	PBYTE to = bmbits + (height-1)*rowwords*4;   // set to last row of pixel data
	PBYTE to = bmbits;                           // set to first row of pixel data

	for (int row = 0 ; row < height ; ++row)        // copy by row
	{
	  for (int col = 0 ; col < width ; ++col)   // do each V byte per row
	  {
	    *to++ = *vbytes++;
	  }
	  // Finished a row, need to pad to a word boundary
	  while (col < 4*rowwords)
	  {
	    *to++ = 0x00;           // pad with 0's
	    col++;
	  }
	  // now jump back to the row previous to the row just written
	  // since we are writing rows from back to front
//	  to -= rowwords*8;
	}
      }

    else if (depth > 8)		// 24 bit icons
      {

	// We first need to create the bitmapinfo structure
	// (a color table is not needed for 24 bit bitmaps)
	// allocate space for header
	pbmi=(PBITMAPINFO2) new BYTE [sizeof(BITMAPINFOHEADER2)];

	// copy the header to the bitmap info structure
	memcpy(pbmi, &bmih, sizeof(BITMAPINFOHEADER2));
	pbmi->cbImage = width*height*4;   // image size (bytes)
	pbmi->cclrUsed = 0 ;              // no color table needed

	// Now need to copy pixel data over from V icon format
	// The V format is essentially based on the X way of
	// defining a bitmap. To fix it up, we need to
	// swap row order in the data.
	BYTE R, G, B;
	bmbits = new BYTE[NeedBMPBytes()];    // allocate space
	int rowwords = ((width*3)+3) / 4;   // number of words (for OS/2 bitmap data)
//	PBYTE to = bmbits + (height-1)*rowwords*4;  // set to last row of pixel data
	PBYTE to = bmbits;                          // set to first row of pixel data

	for (int row = 0 ; row < height ; ++row)        // copy by row
	{
	  for (int col = 0 ; col < width ; ++col)   // do each V pixel per row
	  {
	    // R G B
	    *to++ = *vbytes++; *to++ = *vbytes++; *to++ = *vbytes++;
	  }
	  // Finished a row, need to pad to a word boundary
	  while ( (col*3)<(4*rowwords) )
	  {
	    *to++ = 0x00;           // pad with 0's
	    col++;
	  }
	  // now jump back to the row previous to the row just written
	  // since we are writing rows from back to front
//	  to -= rowwords*8;
	}
    }
    else
    {
	// We will use depth == 1 as the default case since if the
	// depth isn't legal, we will at least get some kind of picture
	// of the right size.

	// We first need to create the bitmapinfo structure and
	// color table

	// allocate space for header and color table
	LONG colorTableSize=(1<<depth)*sizeof(RGB2);
	pbmi=(PBITMAPINFO2) new BYTE [sizeof(BITMAPINFOHEADER2)+colorTableSize];

	// copy the header to the bitmap info structure
	memcpy(pbmi, &bmih, sizeof(BITMAPINFOHEADER2));
	pbmi->cbImage = NeedBMPBytes();
	pbmi->cclrUsed = 1<<depth ;

	// create the color table
	// for monochrome bitmaps the color choice here
	// will affect which bits become foreground and which
	// are background color in the target canvas.  We choose
	// colors here that will map (1) bits to the foreground
	// color in the target (the expected result)
	PLONG colorTableEntry = (PLONG) pbmi->argbColor;
	*colorTableEntry++ = SETRGB2(0,0,0,0);
	*colorTableEntry = SETRGB2(0,255,255,255);

	static BYTE Xmask[] = {0x01,0x02,0x04,0x08,0x10,0x20,0x40,0x80};
	static BYTE Wmask[] = {0x80,0x40,0x20,0x10,0x08,0x04,0x02,0x01};
	bmbits = new BYTE[NeedBMPBytes()];	// allocate space

	// Now need to copy pixel data over from V icon format
	// The V format is essentially based on the X way of
	// defining a bitmap which is completely orthogonal to
	// the OS/2 way.  To fix it up, we need to swap byte bit order
	// pad rows to even words, and swap row order in the data, yuck!

	int rowbytes = (width+7) / 8;        // number of bytes (for V icon data)
	int rowwords = (rowbytes+3) / 4;     // number of words (for OS/2 bitmap data)
//	PBYTE to = bmbits + (height-1)*rowwords*4;   // set to last row of pixel data
	PBYTE to = bmbits;                           // set to first row of pixel data

	for (int row = 0 ; row < height ; ++row)        // copy by row
	{
	  for (int col = 0 ; col < rowbytes ; ++col)   // do each V byte per row
	  {
	    BYTE X = *vbytes++;            // source V-icon byte
	    BYTE W = 0;                  // target OS/2 byte
	    for (int ix = 0 ; ix < 8 ; ++ix) // reverse bits
	    {
	      if (X & Xmask[ix])   // is there a better way to do this?
		  W |= Wmask[ix];
	    }
	    *to++ = W;             // save the pixel data in the row
	  }
	  // Finished a row, need to pad to a word boundary
	  while (col < 4*rowwords)
	  {
	    *to++ = 0x00;           // pad with 0's
	    col++;
	  }
	  // now jump back to the row previous to the row just written
	  // since we are writing rows from back to front
//	  to -= rowwords*8;
	}
    }

    // Now, create the bitmap
    GpiSetBitmapBits(hdcMem, 0L, pbmi->cy, bmbits, pbmi);
    // free up resources and we are done
    delete [] bmbits;
    delete [] pbmi;

    GpiSetBitmap (hdcMem, NULLHANDLE);
    GpiAssociate (hdcMem, NULLHANDLE);
    GpiDestroyPS (hdcMem);
    DevCloseDC (DevCxtMem);
}


//=============================>>> vIcon::vIconToDLG  <<<=====================
  HBITMAP vIcon::GetIconDLG(CmdType ct)
//  void vIcon::vIconToDLG(HPS iDC)
  // this code is the same as vIconToBMP except it inverts the
  // bitmap image (right-side-up) for use in dialogs
  {
    if (_hbm != 0 && ct != C_Icon)
      return(_hbm);

    //_currentDC = iDC;

    // bitmap data structures
    PBYTE vbytes = (PBYTE) icon;
    PBYTE bmbits;
    PBITMAPINFO2 pbmi;

    // build a memory PS compatible with calling PS
//    HDC DevCxtComp = GpiQueryDevice(iDC);
//    HDC DevCxtMem = DevOpenDC(theApp->AppHab(), OD_MEMORY, "*", 0L, NULL, DevCxtComp);
    HDC DevCxtMem = DevOpenDC(theApp->AppHab(), OD_MEMORY, "*", 0L, NULL, NULLHANDLE);
    SIZEL size = {width, height};
    HPS hdcMem = GpiCreatePS (theApp->AppHab(), DevCxtMem, &size,
				  PU_PELS | GPIF_DEFAULT | GPIT_MICRO | GPIA_ASSOC );

    // set the PS to RGB mode
    GpiCreateLogColorTable(hdcMem, 0L, LCOLF_RGB, 0L, 0L, NULL);

    // First, create a blank bitmap compatible with the
    // current context that is size of bitmap.
    BITMAPINFOHEADER2 bmih;
    memset(&bmih, 0, sizeof(BITMAPINFOHEADER2));
    bmih.cbFix = sizeof(BITMAPINFOHEADER2);
    bmih.cx = width;
    bmih.cy = height;
    bmih.ulColorEncoding = BCE_RGB;
    bmih.cPlanes = 1;         // always 1 for OS/2
    if (depth == 1)
      bmih.cBitCount = 4;   // we treat monochromes as 4 bit due to OS/2 bug
    else
      bmih.cBitCount = depth;   // bits of color per pixel

    _hbm = GpiCreateBitmap(hdcMem, &bmih, 0L, NULL, NULL);

    // now we need to load the bitmap with data by associating
    // with a memory PS and setting each pel
    GpiSetBitmap(hdcMem, _hbm);

    if (depth == 8)		// 8 bit icons
    {
	// 8 bit vicon structure:
	// header:     [n][rgb0][rgb1][...][rgbn]
	// pixel data: [p1][p2][...][phxw]

	// we first need to create the bitmapinfo structure and
	// color table
	// get the total number of entries in color table
	unsigned int numColors = (unsigned int) *vbytes++ + 1;

	// allocate space for header and color table
	LONG colorTableSize = numColors*sizeof(RGB2);
	pbmi = (PBITMAPINFO2) new BYTE [sizeof(BITMAPINFOHEADER2)+colorTableSize];

	// copy the header to the bitmap info structure
	memcpy(pbmi, &bmih, sizeof(BITMAPINFOHEADER2));
	pbmi->cbImage = NeedBMPBytes();
	pbmi->cclrUsed = numColors ;

	// create the color table
	PRGB2 ColorEntry = pbmi->argbColor;
	for (unsigned int ix = 0 ; ix < numColors ; ++ix) // map the colors
	{
	  ColorEntry->bRed = *vbytes++;
	  ColorEntry->bGreen = *vbytes++;
	  ColorEntry->bBlue = *vbytes++;
	  ColorEntry->fcOptions = 0;
	  ColorEntry++;
	}

	// Colors mapped, vbytes now points to beginning of data
	bmbits = new BYTE[NeedBMPBytes()];	// allocate space

	// Now need to copy pixel data over from V icon format
	// The V format is essentially based on the X way of
	// defining a bitmap.  To fix it up, we need to
	// pad rows to even words.
	// Although OS/2 row order is upsidedown in OS/2 compared
	// to X, since we invert the DC using the model space transform
	// it all works out in the end.

	int rowwords = (width+3) / 4;     // number of words (for OS/2 bitmap data)
	PBYTE to = bmbits + (height-1)*rowwords*4;   // set to last row of pixel data
//	PBYTE to = bmbits;                           // set to first row of pixel data

	for (int row = 0 ; row < height ; ++row)        // copy by row
	{
	  for (int col = 0 ; col < width ; ++col)   // do each V byte per row
	  {
	    *to++ = *vbytes++;
	  }
	  // Finished a row, need to pad to a word boundary
	  while (col < 4*rowwords)
	  {
	    *to++ = 0x00;           // pad with 0's
	    col++;
	  }
	  // now jump back to the row previous to the row just written
	  // since we are writing rows from back to front
	  to -= rowwords*8;
	}
      }

    else if (depth > 8)		// 24 bit icons
      {

	// We first need to create the bitmapinfo structure
	// (a color table is not needed for 24 bit bitmaps)
	// allocate space for header
	pbmi=(PBITMAPINFO2) new BYTE [sizeof(BITMAPINFOHEADER2)];

	// copy the header to the bitmap info structure
	memcpy(pbmi, &bmih, sizeof(BITMAPINFOHEADER2));
	pbmi->cbImage = width*height*4;   // image size (bytes)
	pbmi->cclrUsed = 0 ;              // no color table needed

	// Now need to copy pixel data over from V icon format
	// The V format is essentially based on the X way of
	// defining a bitmap. To fix it up, we need to
	// swap row order in the data.
	BYTE R, G, B;
	bmbits = new BYTE[NeedBMPBytes()];    // allocate space
	int rowwords = ((width*3)+3) / 4;   // number of words (for OS/2 bitmap data)
	PBYTE to = bmbits + (height-1)*rowwords*4;  // set to last row of pixel data
//	PBYTE to = bmbits;                          // set to first row of pixel data

	for (int row = 0 ; row < height ; ++row)        // copy by row
	{
	  for (int col = 0 ; col < width ; ++col)   // do each V pixel per row
	  {
	    // R G B
	    *to++ = *vbytes++; *to++ = *vbytes++; *to++ = *vbytes++;
	  }
	  // Finished a row, need to pad to a word boundary
	  while ( (col*3)<(4*rowwords) )
	  {
	    *to++ = 0x00;           // pad with 0's
	    col++;
	  }
	  // now jump back to the row previous to the row just written
	  // since we are writing rows from back to front
	  to -= rowwords*8;
	}
    }
    else
    {
	// we really want a monochrome bitmap here, but the dialog
	// routines do not handle monochrome bitmaps properly (the
	// colors are off).  We will convert the monochrome bitmaps
	// to a 4 bit bitmap but only use 2 colors (ie. monochrome)
	LONG orgDepth = depth;
	depth = 4;    // temporary color depth

	// We first need to create the bitmapinfo structure and
	// color table

	// allocate space for header and color table
	ULONG numColors = 2;
	LONG colorTableSize=numColors * sizeof(RGB2);
	pbmi=(PBITMAPINFO2) new BYTE [sizeof(BITMAPINFOHEADER2)+colorTableSize];

	// copy the header to the bitmap info structure
	memcpy(pbmi, &bmih, sizeof(BITMAPINFOHEADER2));
	pbmi->cbImage = NeedBMPBytes();
	pbmi->cclrUsed = numColors;

	// create the color table
	// for monochrome bitmaps the color choice here
	// will affect which bits become foreground and which
	// are background color in the target canvas.  We choose
	// colors here that will map (1) bits to the foreground
	// color in the target (the expected result)
	PLONG colorTableEntry = (PLONG) pbmi->argbColor;
	*colorTableEntry++ = WinQuerySysColor(HWND_DESKTOP, SYSCLR_BUTTONMIDDLE, 0L);
	*colorTableEntry = WinQuerySysColor(HWND_DESKTOP, SYSCLR_MENUTEXT, 0L);

	static BYTE Xmask[] = {0x01,0x02,0x04,0x08,0x10,0x20,0x40,0x80};
	static BYTE Wmask[] = {0x10,0x01,0x10,0x01,0x10,0x01,0x10,0x01};

	// Now need to copy pixel data over from V icon format.
	// Every byte in the original V monochrome icon data will
	// map exactly to one word (4 bytes) in the OS/2 bitmap data

	int rowwords = (width+7) / 8;     // number of words per row (OS/2 bitmap data)

	bmbits = new BYTE[NeedBMPBytes()];	// allocate space

	PBYTE to = bmbits + (height-1)*rowwords*4;   // set to last row of pixel data
//	PBYTE to = bmbits;                           // set to first row of pixel data

	for (int row = 0 ; row < height ; ++row)        // copy by row
	{
	  for (int col = 0 ; col < rowwords ; col++)   // do each OS/2 word per row
	  {
	    BYTE X = *vbytes++;            // source V-icon byte
	    for (int ix = 0 ; ix < 8 ; ++ix)
	    {
	      BYTE W = 0;                  // target OS/2 byte

	      if (X & Xmask[ix])
		  W |= Wmask[ix];
	      ix++;
	      if (X & Xmask[ix])
		  W |= Wmask[ix];
	      *to++ = W;             // save the pixel data in the row
	    }
	  }
	  // now jump back to the row previous to the row just written
	  // since we are writing rows from back to front
	  to -= rowwords*8;
	}
	depth = orgDepth;   // set back to original depth
    }

    // Now, create the bitmap
    GpiSetBitmapBits(hdcMem, 0L, pbmi->cy, bmbits, pbmi);
    // free up resources and we are done
    delete [] bmbits;
    delete [] pbmi;

    GpiSetBitmap (hdcMem, NULLHANDLE);
    GpiAssociate (hdcMem, NULLHANDLE);
    GpiDestroyPS (hdcMem);
    DevCloseDC (DevCxtMem);

    SysDebug2(OS2Dev,"GetIconDLG CmdType:%d _hbm:%x \n", ct, _hbm)

    return(_hbm);
}

