//=======================================================================
//	vgdefs.h:	Defs for vg app
//=======================================================================
#ifndef VGDEFS_H
#define VGDEFS_H
// Define where V lives on your system

#define VGEN_VERS "1.05"
#define DEF_VPATH "/include"	// to find v_defs.h, etc. for compile, link

#ifdef GNUWIN32
 #ifdef DEVEL
  #define DEF_HOMEV "D:/mingw32" // to find libV.a
 #else   //DEVEL
  #define DEF_HOMEV "C:/mingw32" // to find libV.a
 #endif  //DEVEL
 #define DEF_LIBS "-lV -lcomctl32 -mwindows"
 #define OGLDEF_LIBS "-lV -lVgl -lglu32 -lopengl32 -lcomctl32 -mwindows"

#else  //GNUWIN32

 #ifdef _WIN32
  #define DEF_HOMEV "C:/egcs" // to find libV.a
  #define DEF_LIBS "-lV -lcomctl32 -mwindows"
  #define OGLDEF_LIBS "-lV -lVgl -lglu32 -lopengl32 -lcomctl32 -mwindows"

 #else	//_WIN32    // X version

  #ifdef LINUX
   #define DEF_HOMEV "/usr" // to find libV.a
  #else //LINUX
   #define DEF_HOMEV "/usr/local/v" // to find libV.a
  #endif //LINUX

  #ifdef Motif
   #define DEF_LIBS "-lVm -lXm -lXmu -lXt -lXext -lX11"
   #define OGLDEF_LIBS "-lVm -lVglm -lGLw -lGLU -lGL -lXm -lXmu -lXt -lXext -lX11"
  #else  //Motif
   #define DEF_LIBS "-lV -lXaw -lXmu -lXt -lXext -lX11"
   #define OGLDEF_LIBS "-lV -lVgl -lGLw -lGLU -lGL -lXaw -lXmu -lXt -lXext -lX11"
  #endif  //Motif

 #endif //_WIN32
#endif //GNUWIN32

#ifdef OS2
 #define DEF_HOMEV "E:/devtools/v/lib/os2" // to find libV.a
 #define DEF_LIBS "-lvos2 -los2 -lc -lstdcpp"
 #define OGLDEF_LIBS "-lvos2 -lvos2gl -lopengl -llibaux -los2 -lc -lstdcpp"
#endif // OS2

    enum cnvType {Canvas, Text, OpenGL, NoCanvas};
    typedef struct vgOptions
      {
	    char appName[100];	// base name of app classes
	    char fileName[100]; // base name of app files
	    char title[100];    // title of app
	    char home[100];     // V home
	    int	addDialog,	// if add a dialog
		addModal, 	// if add modal dialog
		addMake, 	// if add makefile
		addVproj,	// if add project file
		extraDialog,	// if making an extra dialog
		addMenu,	// for a menuless app
		addToolBar,	// if add tool bar
		addStatus, 	// if add status bar
		addDate,	// if add date/time
		addTimer,	// if add a timer
		vScroll,	// if include v Scroll bar
		hScroll,	// if include h scroll bar
		winSDI,		// if a Windows SDI model
		fullMenu;	// if a full menu or short menu
	    cnvType canvasType;	// kind of canvas to generate

      } vgOptions;
#endif
