# EXAMPLE makefile for V OpenGL Cube Demo application...
#
# creates .exe's under $(BINDIR)
# assumes that vibmcpp or vibmcppd (debug library) already built
# using vopengl.mak (requires OpenGL)
#
# to create debug versions enter: nmake DEBUG=1 /f vcube.mak
# to create release versions enter: nmake /f vcube.mak
#

include cfgibm.mkh

# ---------------------------------------------------------------------------
SRCDIR=$(VDIR)\vopengl\cube
INCDIR=$(VDIR)\vopengl\cube
BINFILE=$(BINDIR)\vcube.exe
RESFILE=$(OBJDIR)\vapp.res
DEFFILE=$(VSRCDIR)\vos2.def

OBJFILES=$(OBJDIR)\vstartup.obj \
 $(OBJDIR)\cubeapp.obj \
 $(OBJDIR)\cubecmdw.obj \
 $(OBJDIR)\cubecnv.obj 

# ---------------------------------------------------------------------------
.PRECIOUS: $(BINFILE)

.cpp.obj :
 $(CC) $(CFLAGS) /C /Fo$@ $<

{$(SRCDIR)}.cpp{$(OBJDIR)}.obj :
 $(CC) $(CFLAGS) /I$(INCDIR) /C /Fo$@ $<

all : $(BINFILE)

dirs:
	@-mkdir $(OBJDIR)
	@-mkdir $(BINDIR)

clean :
	-del $(OBJDIR)\*.*
	-del $(BINDIR)\*.*

$(BINFILE) : $(OBJFILES) $(RESFILE) $(VLIB)
	-$(CC) /Q /B"$(LFLAGS)" @<<
 /Fe$@
 $(OBJFILES)
 $(LIBS)
 $(DEFFILE)
<<NOKEEP
    $(RC) $(RFLAGS) $(RESFILE) $@

# ---------------------------------------------------------------------------

# Minimum RESOURCE
$(OBJDIR)\vapp.res :: $(VSRCDIR)\vos2.rc \
        $(VSRCDIR)\vapp.ico \
        $(VSRCDIR)\collate.bmp
	@copy $(VSRCDIR)\vapp.ico .
	@copy $(VSRCDIR)\collate.bmp .
    $(RC) -r $(RFLAGS) $(VSRCDIR)\vos2.rc $@ 
	@-attrib -r .\vapp.ico
	@-attrib -r .\collate.bmp
	-del .\vapp.ico
	-del .\collate.bmp

# APP
$(OBJDIR)\vstartup.obj : $(VSRCDIR)\$$(@B).cpp 

$(OBJDIR)\cubeapp.obj : $(SRCDIR)\$$(@B).cpp $(INCDIR)\$$(@B).h \
 $(VINCDIR)\v_defs.h $(INCDIR)\cubecmdw.h $(INCDIR)\cubecnv.h 

$(OBJDIR)\cubecmdw.obj : $(SRCDIR)\$$(@B).cpp $(INCDIR)\$$(@B).h \
 $(VINCDIR)\v_defs.h  $(INCDIR)\cubecnv.h 

$(OBJDIR)\cubecnv.obj : $(SRCDIR)\$$(@B).cpp $(INCDIR)\$$(@B).h \
 $(VINCDIR)\v_defs.h 



