# EXAMPLE makefile for V OpenGL Shapes Demo application...
#
# creates .exe's under $(BINDIR)
# assumes that vibmcpp or vibmcppd (debug library) already built
# using vopengl.mak (requires OpenGL)
#
# to create debug versions enter: nmake DEBUG=1 /f vshapes.mak
# to create release versions enter: nmake /f vshapes.mak
#

include cfgibm.mkh

# ---------------------------------------------------------------------------
SRCDIR=$(VDIR)\vopengl\shapes
INCDIR=$(VDIR)\vopengl\shapes
BINFILE=$(BINDIR)\vshapes.exe
RESFILE=$(OBJDIR)\vapp.res
DEFFILE=$(VSRCDIR)\vos2.def

OBJFILES=$(OBJDIR)\vstartup.obj \
 $(OBJDIR)\tglapp.obj \
 $(OBJDIR)\tglcmdw.obj \
 $(OBJDIR)\tglcnv.obj 

# ---------------------------------------------------------------------------
.PRECIOUS: $(BINFILE)

.cpp.obj :
 $(CC) $(CFLAGS) /C /Fo$@ $<

{$(SRCDIR)}.cpp{$(OBJDIR)}.obj :
 $(CC) $(CFLAGS) /I$(INCDIR) /C /Fo$@ $<

all : $(BINFILE)

dirs:
	@-mkdir $(OBJDIR)
	@-mkdir $(BINDIR)

clean :
	-del $(OBJDIR)\*.*
	-del $(BINDIR)\*.*

$(BINFILE) : $(OBJFILES) $(RESFILE) $(VLIB)
	-$(LD) $(LFLAGS) @<<
 $(OBJFILES),
 $@,
 NUL,
 $(LIBS),
 $(DEFFILE)
<<NOKEEP
    $(RC) $(RFLAGS) $(RESFILE) $@

# ---------------------------------------------------------------------------

# Minimum RESOURCE
$(OBJDIR)\vapp.res :: $(VSRCDIR)\vos2.rc \
        $(VSRCDIR)\vapp.ico \
        $(VSRCDIR)\collate.bmp
	@copy $(VSRCDIR)\vapp.ico .
	@copy $(VSRCDIR)\collate.bmp .
    $(RC) -r $(RFLAGS) $(VSRCDIR)\vos2.rc $@ 
	@-attrib -r .\vapp.ico
	@-attrib -r .\collate.bmp
	-del .\vapp.ico
	-del .\collate.bmp

# APP
$(OBJDIR)\vstartup.obj : $(VSRCDIR)\$$(@B).cpp 

$(OBJDIR)\tglapp.obj : $(SRCDIR)\$$(@B).cpp $(INCDIR)\$$(@B).h 

$(OBJDIR)\tglcmdw.obj : $(SRCDIR)\$$(@B).cpp $(INCDIR)\$$(@B).h 

$(OBJDIR)\tglcnv.obj : $(SRCDIR)\$$(@B).cpp $(INCDIR)\$$(@B).h 



