//===============================================================
// vprogrsc.cxx - Progress Bar - Windows
//
// Copyright (C) 1995,1996,1997,1998  Bruce E. Wampler
//
// This file is part of the V C++ GUI Framework, and is covered
// under the terms of the GNU Library General Public License,
// Version 2. This library has NO WARRANTY. See the source file
// vapp.cxx for more complete information about license terms.
//===============================================================
#include <v/vos2.h>           // for OS/2 stuff
#include <v/vprogrsc.h> // our definitions
#include <v/vcmdprnt.h> // a command parent
#include <v/vapp.h>
#include <v/vutil.h>

//=================>>> vProgressCmd::vProgressCmd <<<=======================
  vProgressCmd::vProgressCmd(vCmdParent* dp, CommandObject* dc) :
	    vCmd(dp, dc)
  {
    initialize();                       // and initialize
  }
//=======================>>> vProgressCmd::~vProgressCmd <<<===================
  vProgressCmd::~vProgressCmd()
  {
    SysDebug(Constructor,"vProgressCmd::~vProgressCmd() Destructor\n")
  }
//=====================>>> vProgressCmd::initialize <<<=======================
  void vProgressCmd::initialize()
  {
    SysDebug(Constructor,"vProgressCmd::vProgressCmd() constructor\n")
    CopyToLocal();
    long style = SLS_PRIMARYSCALE1 | SLS_READONLY |
		 SLS_SNAPTOINCREMENT | SLS_RIBBONSTRIP;

    if (_parentWin->_dialogType != aCmdBar)
	style |= WS_TABSTOP | WS_GROUP;  // default for a button
    else
	style |= WS_GROUP;

    if (!(dlgCmd->attrs & CA_Hidden))   // Check for Hidden
	style |= WS_VISIBLE;

    int* minMax = (int *)_itemList;             // giving range?
    _minVal = 0; _maxVal = 100;                 // default min/max

    if (minMax != 0)                            // They gave a range list
      {
	_minVal = minMax[0];
	_maxVal = minMax[1];
      }

    if (_minVal > _maxVal)
    {
	SysDebug2(BadVals,"vProgressCmd:vSliderCmd - bad range %d to %d\n",_minVal,_maxVal)
	_minVal = 0; _maxVal = 100;     // make some sense!
    }

    if (_retVal < _minVal)      // set a legal value for the top
	_curVal = _minVal;
    else if (_retVal > _maxVal)
	_curVal = _maxVal;
    else
	_curVal = _retVal;


    // Set the size of the slider
    if (dlgCmd->attrs & CA_Vertical)  // vertical bar
    {
      style |= SLS_VERTICAL | SLS_LEFT;

      _h = 56;               // regular size
      _scd.usScale1Increments = 101;
      _scd.usScale1Spacing = 1;

      if (dlgCmd->attrs & CA_Large)
      {
	_h = 106;
	_scd.usScale1Increments = 101;
	_scd.usScale1Spacing = 2;
      }
      else if (dlgCmd->attrs & CA_Small)
      {
	_h = 31;
	_scd.usScale1Increments = 51;
	_scd.usScale1Spacing = 1;
      }
      if (dlgCmd->attrs & CA_NoLabel)
	_w = 14;               // no label
      else
      {
	_w = 14;
	// Try to make the width pretty
	char buff[20];
	IntToStr(_minVal,buff);
	_maxWidth = strlen(buff);
	IntToStr(_maxVal,buff);
	int maxW = strlen(buff);
	if (maxW > _maxWidth)
	  _maxWidth = maxW;
	_w = 14 + 4*_maxWidth;
      }
      // user override
      if (dlgCmd->size > 0 && dlgCmd->size < 2048)
	_w = 6 + (dlgCmd->size/2);
    }
    else   // horizontal bar
    {
      style |= SLS_HORIZONTAL | SLS_BOTTOM;

      _w = 74;    // regular size
      _scd.usScale1Increments = 101;
      _scd.usScale1Spacing = 1;
      if (dlgCmd->attrs & CA_Large)
      {
	_w = 142;
	_scd.usScale1Increments = 101;
	_scd.usScale1Spacing = 2;
      }
      else if (dlgCmd->attrs & CA_Small)
      {
	_w = 42;
	_scd.usScale1Increments = 51;
	_scd.usScale1Spacing = 1;
      }
      if (dlgCmd->attrs & CA_NoLabel)
	_h = 10;               // set my height
      else
	_h = 17;

      // user override
      if (dlgCmd->size > 0 && dlgCmd->size < 2048)
	_h = 10 + ((dlgCmd->size*65)/100);
    }

    _scd.cbSize = sizeof(SLDCDATA);
    _scd.usScale2Increments = 101;
    _scd.usScale2Spacing = 1;

    _parentWin->SetPosition(_x, _y, _w, _h, dlgCmd->cFrame, dlgCmd->cRightOf,
	dlgCmd->cBelow);

    if (dlgCmd->attrs & CA_Vertical)
    {
      _y += 2;
      _h -= 2;   // we play this game to get better positioning in a frame
    }
    else if (dlgCmd->attrs & CA_Horizontal)
    {
//      _x += 1;
      _y += 2;
      _h -= 2;   // we play this game to get better positioning in a frame
    }

    _CtrlOffset = _parentWin->AddDlgControl(_x, _y, _w, _h, _cmdId,
	style, WC_SLIDER, _title, NULL, _scd.cbSize, &_scd);

  }
//==================>>> vProgressCmd::GetCmdValue <<<=========================
  int vProgressCmd::GetCmdValue(ItemVal id) VCONST
  {
    if (id != _cmdId)
	return -1;
    return _curVal;
  }
//=====================>>> vProgressCmd::SetCmdVal <<<=========================
  void vProgressCmd::SetCmdVal(ItemVal val, ItemSetType st)
  {
    SysDebug2(Misc,"vProgressCmd::SetCmdVal(val:%d, type:%d)\n",val,st)
    HWND myHwnd = GetMyHwnd(_cmdId);

    switch (st)
    {
      case Sensitive:
	_Sensitive = val;               // set
	WinEnableWindow (myHwnd, val);
	break;

      case Hidden:
	if (val)
	  WinShowWindow (myHwnd, FALSE);
	else
	  WinShowWindow (myHwnd, TRUE);
	break;

      case Value:
	if (val < _minVal || val > _maxVal )
	  return;
	_curVal = val;
	float frac = val - _minVal;
	frac = frac/(_maxVal - _minVal);
	int percent = (int)( frac * 100 );
	if (dlgCmd->attrs & CA_Small)
	  percent /=2;

	// Now set appropriate _curVal, scroll
	WinSendMsg (myHwnd, SLM_SETSLIDERINFO,
	  MPFROM2SHORT(SMA_SLIDERARMPOSITION, SMA_INCREMENTVALUE), (MPARAM) percent);

	// set a few tick marks
	int ticksize=4;
	if (dlgCmd->attrs & CA_Vertical)
	   ticksize = 4;

	int tickposn[3] = {0, 50, 100};
	if (dlgCmd->attrs & CA_Large)
	{
	  tickposn[0] = 0;
	  tickposn[1] = 50;
	  tickposn[2] = 100;
	}
	else if (dlgCmd->attrs & CA_Small)
	{
	  tickposn[0] = 0;
	  tickposn[1] = 25;
	  tickposn[2] = 50;
	}

	for (int i=0; i<3; i++)
	  WinSendMsg (myHwnd, SLM_SETTICKSIZE,
	      MPFROM2SHORT(tickposn[i], ticksize), (MPARAM) NULL);
	// put text on bar
	if (dlgCmd->attrs & CA_NoLabel)
	{
	  WinSendMsg (myHwnd, SLM_SETSCALETEXT, MPFROMSHORT(0), (MPARAM) NULL);
	  break;
	}
	else
	{
	  char label[40];
#ifdef __BORLANDC__
	  ltoa(_curVal, label,10);
#else
	  _ltoa(_curVal, label,10);
#endif
	  if (dlgCmd->attrs & CA_Small)
	    WinSendMsg (myHwnd, SLM_SETSCALETEXT, MPFROMSHORT(25), (MPARAM) label);
	  else
	    WinSendMsg (myHwnd, SLM_SETSCALETEXT, MPFROMSHORT(50), (MPARAM) label);
	  break;
	}
    }
  }
//================>>> vProgressCmd::MEASUREITEM <<<============================
  int vProgressCmd::MEASUREITEM(int id, OWNERITEM* ois)
  {
    return 1;
  }
//================>>> vProgressCmd::DRAWITEM <<<============================
  int vProgressCmd::DRAWITEM(int id, OWNERITEM* ois)
  {
    return 0;
  }
