//===============================================================
// vWinPrinterC - a basic canvas for drawing
//
// Copyright (C) 1995,1996,1997,1998  Bruce E. Wampler
//
// This file is part of the V C++ GUI Framework, and is covered
// under the terms of the GNU Library General Public License,
// Version 2. This library has NO WARRANTY. See the source file
// vapp.cxx for more complete information about license terms.
//===============================================================

#include <v/vos2.h>           // for OS/2 stuff
#include <math.h>

#include <v/vwinprdc.h>
#include <v/vapp.h>             // need access to the app
//-----------------------------------------------------------------------
//================>>> vWinPrinterDC::vWinPrinterDC <<<========================
  vWinPrinterDC::vWinPrinterDC(const int scalePrinting) : vWinDC()
  {
    SysDebug(Constructor,"vWinPrinterDC::vWinPrinterDC() constructor\n")

    // _isPrinterDC is < 0 if we are scaling. For scaled printing, fonts
    // get treated differently. If we aren't scaling, then we use the old
    // default mode, which lets the GDI handle scaling. This is kind of
    // messy, but it seemed the easiest way to patch things given that
    // _isPrinterDC is really used by vWinDC.

    _isPrinterDC = scalePrinting ? -1 : 1;
    _scalePrinting = scalePrinting;
  }

//================>>> vWinPrinterDC::~vWinPrinterDC <<<========================
  vWinPrinterDC::~vWinPrinterDC()
  {
    SysDebug(Destructor,"vWinPrinterDC::~vWinPrinterDC() destructor\n")
  }
//================>>> vWinPrinterDC::SetBackground <<<==========================
  void vWinPrinterDC::SetBackground(VCONST vColor& color)
  {
    _canvasBG = color.pixel();           // retrieve pixel value
    GpiSetBackColor (_hdc, _canvasBG);
  }
//======================>>> vWinPrinterDC::SetFont <<<===========================
  void vWinPrinterDC::SetFont(VCONST vFont& vf)
  {
    // Change the font associated with this window.
    _font = vf;
  }
//================>>> vWinPrinterDC::BeginPrinting <<<========================
// returns 0 if problem
  int vWinPrinterDC::BeginPrinting()
  {
    // after the printer is chosen and printing is about to start
    // we create the print PS

    // We will support two modes of printing - default and scaled (raw).
    // In scaled (raw), it is up to the user to find the page size and scale
    // things accordingly to make them fit.

    // The default mode produces output that closely matches the postscript
    // printer output, but forces the printer resolution to 72 dpi, which
    // may be inappropriate for bitmaps which will come out scaled and chunky
    // looking. The scaled (raw) mode, will use the printer native resolution
    // so that bitmaps that look good on the screen will be very tiny on
    // the printed page compared to the width of the page.

    // if a PS already exists for this printer, it will be destroyed and
    // re-created with the latest printer setup info

    // _scalePrinting controls the resolution of the resulting PS
    //   0->  default mode (printer resolution artifically set to 72 dpi to match screen)
    //   1 ->  raw mode (native printer resolution usually 300-600 dpi)

    _hdc = _printer.CreateHDC(_scalePrinting);   // set the _hdc in the printer canvas

    if (!_hdc)             // should not happen...
    {
      ERRORID err;
      err = WinGetLastError(theApp->AppHab());
      SysDebug1(Build,"vWinPrinter::BeginPrinting() failed to create _hdc (err=%x)\n",
	err)
      return 0;
    }

    // We set the scaling of the printer canvas to give us either
    // 72 dpi (default) or native printer (scaled).
    SetOS2Map(_printer.GetHeight(_scalePrinting), _printer.GetScale(_scalePrinting));

    _pages = 0;

    BeginPage();
    return 1;
  }

//================>>> vWinPrinterDC::BeginPage <<<========================
  void vWinPrinterDC::BeginPage()
  {
    if (!_printer.GetHDC())             // should not happen...
    {
      return;
    }

    ++_pages;           // bump number of pages so far

    // we send a NEWFRAME command if this is not the first page
    // to eject the previous page
    if (_pages != 1)
    {
      _printer.NewFrame();

//      DevEscape (_printer.GetHDevC(), DEVESC_NEWFRAME, strlen(_printer.GetDocName()),
//      _printer.GetDocName(), NULL, NULL);
    }

    SysDebug(Build,"vWinPrinterDC::BeginPage()  beginning new page \n")
  }

//================>>> vWinPrinterDC::EndPage <<<========================
  void vWinPrinterDC::EndPage()
  {
    // this is a NO-OP for OS/2
  }
//================>>> vWinPrinterDC::EndPrinting <<<========================
  void vWinPrinterDC::EndPrinting()
  {

    if (!_printer.GetHDC())
	return;

    _jobID = _printer.EndDoc();
/*
    // signal end of printjob and get job id
    LONG SizeJobID = sizeof(_jobID);
    DevEscape(_printer.GetHDevC(), DEVESC_ENDDOC, 0, NULL,
      SizeJobID, (PVBYTE) &_jobID);
    // after print is complete free-up the print PS
    _printer.DestroyHDC();
*/
    SysDebug1(Build,"vWinPrinterDC::EndPrinting() Job ID is %hu \n", _jobID)
  }

//=====================>>> vWinPrinterDC::SetPrinter <<<============================
 void vWinPrinterDC::SetPrinter(vPrinter& printer)
  {
    _printer = printer;

    // according to the docs, these are in 1/72 inch units (ie. 72 dpi)
    // for regular print and native printer dpi if _scalePrinting is set
    _physHeight = _printer.GetHeight(_scalePrinting);
    _physWidth = _printer.GetWidth(_scalePrinting);
  }



