//=======================================================================
//@V@:Note: This file generated by vgen V1.02 (23:23:26 06 Apr 1998).
//	mymdlg.cpp:	Source for projectDialog class
//=======================================================================
#include<v/vapp.h>

#include "projdlg.h"
#include <v/vutil.h>

#include <v/vapp.h>
//extern vApp *theApp;


  void Dos2UxFName(char *dosFileName, char *uxFileName, BOOL trimfile)
  {
    //makes things working with gnu-win32/ming32
    //translates a MSDOS file name into a unix like file name
    //*  Only necessary for gnu-win32: Win95 fileSelect gives a DOS filename
    //*                                and file manipulation needs unix style
    //*                                names
    char *np, *p=dosFileName+2;

    np = uxFileName;

    for( ; *p!=0; p++, np++)
      {
	*np = (*p=='\\') ? '/' : *p;
      }
    *np=0;
    if (trimfile)
      {
	int lim = strlen(uxFileName);
	for (int ix = lim ; ix >= 0 ; --ix)
	  {
	    if (uxFileName[ix] == '/' || uxFileName[ix] == '\\')
	      {
		uxFileName[ix] = 0;	// zap rest
		break;
	      }
	  }
      }
  }

//************************************************************************

//@V@:BeginIDs
  enum
    {
    frmTogBtns = 1000,
	tbtFiles, tbtFlags, tbtPaths, tbtDefs, tbtOpts,

    frmMain,

    frmNames,
	lblExeName, txiExeName,lblMkfName,txiMkfName,
	lblCC, txiCC, lblCFlags, txiCFlags,
	lblLibs, txiLibs,

    frmObj,
	lblObj, objList, btnAddSrcFile, btnDelSrcFile,
	btnEditSrcFile, chkMakeMkf,

    frmPaths,
	lblObjPath, txiObjPath, btnBrwObjD, lblBinPath,
	txiBinPath, lblSrcPath, txiSrcPath,  btnBrwSrcD,
	btnBrwBinD, 

    frmIncl,
	lblIncl, lstIncl, btnAddInclPath, btnDelInclPath,
	btnEditInclPath,

    frmLibs,
	lblLibP, lstLibs, btnAddLibsPath, btnDelLibsPath,
	btnEditLibsPath,

    frmDefs,
	lblDefPool, lstDefPool, btnAddDef, btnDelDef, blkBlank1,
	blkBlank2, blkBlank3, btnAdd, btnDel, lblDef, lstDef,
	btnEditDef,

    frmOpts,
	lblUOpt, UOptList, btnAddUOpt, btnDelUOpt, btnEditUOpt,

    xyzzyLast

   };
//@V@:EndIds

//stub vector for listDialogs
 static char* vtmp[1] = { 0 };

//@V@:BeginDialogCmd PCmds
  static DialogCmd PCmds[] =
    {
      // This borderless frame makes the toggle buttons tightly spaced
	{C_Frame,frmTogBtns,0,"",NoList,CA_NoSpace | CA_NoBorder,isSens,NoFrame,0,0},
	{C_ToggleButton,tbtFlags,1,"Names",NoList, CA_None, isSens, frmTogBtns, 0, 0,0,"Set Names and Flags"},
	{C_ToggleButton,tbtFiles,0,"Files",NoList, CA_None, isSens, frmTogBtns, tbtFlags, 0, 0, "Set Source Files"},
	{C_ToggleButton,tbtPaths,0,"Paths",NoList, CA_None, isSens, frmTogBtns, tbtFiles, 0, 0,"Set various paths"},
	{C_ToggleButton,tbtDefs,0,"Defines",NoList, CA_None, isSens, frmTogBtns, tbtPaths, 0,0, "Set Defines"},
	{C_ToggleButton,tbtOpts,0,"Options",NoList, CA_None, isSens, frmTogBtns, tbtDefs, 0, 0, "Add User Makefile Options"},
	// A Master frame to give uniform border to toggle frames
	{C_Frame,frmMain,0, "", NoList,CA_None,isSens,frmTogBtns,0,tbtFiles},

	// This is the default frame - on initially
	{C_ToggleFrame, frmNames, 1, "",NoList,CA_NoBorder,isSens, frmMain, 0, 0},

	{C_Label, lblExeName, 0," Target File Name:", NoList, CA_None, isSens,frmNames,0, 0},
	{C_TextIn, txiExeName, 0, " ", NoList, CA_Large, isSens,frmNames,lblExeName, 0,0,
        	"Name of executable file"},

	{C_Label, lblMkfName, 0," Makefile Name:", NoList, CA_None, isSens,frmNames,0, txiExeName},
	{C_TextIn, txiMkfName, 0, " ", NoList, CA_Large, isSens,frmNames,lblExeName, txiExeName, 0,
        	"Name of makefile"},

	{C_Label, lblCC, 0, " Compiler:             ", NoList, CA_None, isSens,frmNames, 0, lblMkfName},
	{C_TextIn, txiCC, 0, " ", NoList, CA_Large, isSens,frmNames,lblCC, txiMkfName, 0,"Compiler name"},
	{C_Label, lblCFlags, 0," Compiler Flags:   ", NoList, CA_Large, isSens,frmNames,0, lblCC},
	{C_TextIn, txiCFlags, 0, " ", NoList, CA_Large, isSens,frmNames,lblCFlags, txiCC,0,"Compiler flags"},
	{C_Label, lblLibs, 0,  " Linker Flags:       ", NoList, CA_Large, isSens,frmNames,0, lblCFlags},
	{C_TextIn, txiLibs, 0, " ", NoList, CA_Large, isSens,frmNames,lblLibs, txiCFlags,0,"Linker flags"},

	{C_ToggleFrame, frmObj, 0, "", NoList, CA_NoBorder | CA_Hidden, isSens, frmMain, 0, 0},

	{C_Label, lblObj, 0," Source Files:", NoList, CA_None, isSens, frmObj,0, 0},
	{C_List, objList, 160, " ", (void *) vtmp, 
		CA_ListWidth | CA_Size, isSens, frmObj,0, lblObj, 12, "List of source Files" },
	{C_Button, btnAddSrcFile, 0, "Add", NoList,CA_None,
	    isSens,frmObj,0, objList, 0, "Add source file with File Dialog"},
	{C_Button, btnDelSrcFile, 0, "Del", NoList,CA_None,
	    isSens,frmObj, btnAddSrcFile, objList,0,"Delete selected file"},
	{C_Button, btnEditSrcFile, 0, "Edit", NoList,CA_None,
	    isSens,frmObj, btnDelSrcFile, objList,0,"Edit selected file"},


	{C_ToggleFrame, frmPaths, 0, "",NoList,CA_NoBorder | CA_Hidden,isSens,frmMain, 0, 0},
	{C_Label, lblSrcPath, 0, " Src path: ", NoList, CA_None, isSens,frmPaths,0, 0},
	{C_TextIn, txiSrcPath, 0, " ", NoList, CA_Large, isSens,frmPaths, lblSrcPath, 0,0,
		"Path for source files"},
	{C_Button, btnBrwSrcD, 0, " Browse ", NoFrame,CA_None, isSens,frmPaths,txiSrcPath, 0, 0,
		"Select with File Dialog"},
	{C_Label, lblObjPath, 0, " Obj path: ", NoList, CA_None, isSens,frmPaths,0, txiSrcPath},
	{C_TextIn, txiObjPath, 0, " ", NoList, CA_Large, isSens,frmPaths, lblObjPath, txiSrcPath,0,
		"Path to write obj files"},
	{C_Button, btnBrwObjD, 0, " Browse ", NoFrame,CA_None, isSens,frmPaths,txiObjPath, txiSrcPath, 0,
		"Select with File Dialog"},
	{C_Label, lblBinPath, 0, " Bin path: ", NoList, CA_None, isSens,frmPaths, 0, lblObjPath},
	{C_TextIn, txiBinPath, 0, " ", NoList, CA_Large, isSens,frmPaths,lblBinPath, txiObjPath,0,
		"Path to write exectuable"},
	{C_Button, btnBrwBinD, 0, " Browse ", NoFrame,CA_None, isSens,frmPaths,txiBinPath, btnBrwObjD,0,
		"Select with File Dialog"},

	{C_Frame, frmIncl, 0, "", NoList, CA_None, isSens, frmPaths, 0, btnBrwBinD},
	{C_Label, lblIncl, 0, "Include Paths:", NoList, CA_None, isSens, frmIncl,0, 0},
	{C_List,  lstIncl, 130, " ",  ( void * ) vtmp,
	    CA_ListWidth,isSens, frmIncl,0, lblIncl,0,"Paths to search for includes"},
	{C_Button, btnAddInclPath, 0, "Add", NoFrame,CA_None,
	    isSens,frmIncl,0, lstIncl,0,"Add path with file dialog"},
	{C_Button, btnDelInclPath, 0, "Del", NoFrame,CA_None,
	    isSens,frmIncl, btnAddInclPath, lstIncl,0,"Delete selected path"},
	{C_Button, btnEditInclPath, 0, "Edit", NoList,CA_None,
	    isSens,frmIncl, btnDelInclPath, lstIncl,0,"Edit selected item"},

	{C_Frame, frmLibs, 0, "", NoList, CA_None, isSens, frmPaths, frmIncl, btnBrwBinD},
	{C_Label, lblLibP, 0, "Library Paths:", NoList, CA_None, isSens, frmLibs,0, 0},
	{C_List,  lstLibs, 130, " ",  (void * ) vtmp, 
		CA_ListWidth, isSens, frmLibs,0, lblLibP,0,"Paths for libraries"},
	{C_Button, btnAddLibsPath, 0, "Add", NoFrame,CA_None,
	    isSens,frmLibs,0, lstLibs,0,"Add path with File Dialog"},
	{C_Button, btnDelLibsPath, 0, "Del", NoFrame,CA_None,
	    isSens,frmLibs, btnAddLibsPath, lstLibs,0,"Delete selected path"},
	{C_Button, btnEditLibsPath, 0, "Edit", NoList,CA_None,
	    isSens,frmLibs, btnDelLibsPath, lstLibs,0,"Edit selected item"},

	{C_ToggleFrame, frmDefs, 0, "",NoList,CA_NoBorder | CA_Hidden,isSens,frmMain, 0, 0},
     {C_Label, lblDefPool, 0, " Definition Pool", NoList, CA_None, isSens,frmDefs,0, 0},
     {C_List,  lstDefPool, 124, " ",  (void *) vtmp, 
	CA_ListWidth | CA_Size, isSens, frmDefs, 0, lblDefPool, 12,"Defines available, but not used" },
     {C_Button, btnAddDef, 0, "Add", NoFrame,CA_None,
       isSens,frmDefs, 0, lstDefPool,0,"Add define to pool"},
     {C_Button, btnDelDef, 0, "Del", NoFrame,CA_None,
       isSens,frmDefs, btnAddDef, lstDefPool,0,"Delete selected define"},
	{C_Button, btnEditDef, 0, "Edit", NoList,CA_None,
	    isSens,frmDefs, btnDelDef, lstDefPool,0,"Edit selected item"},

     {C_Blank, blkBlank1, 0, " ", NoList, CA_None, isSens,frmDefs,lstDefPool, 0},
     {C_Blank, blkBlank2, 0, " ", NoList, CA_None, isSens,frmDefs,lstDefPool, blkBlank1},
     {C_Blank, blkBlank3, 0, " ", NoList, CA_None, isSens,frmDefs,lstDefPool, blkBlank2},
     {C_Button, btnAdd, 0,   ">", NoFrame,CA_None,
       isSens,frmDefs, lstDefPool, blkBlank3,0,"Add to active defines"},

     {C_Label, lblDef, 0, " Active Definitions ", NoList, CA_None,
       isSens,frmDefs, btnAdd, 0},
     {C_List,  lstDef, 124, " ",  (void *)vtmp,
	CA_ListWidth| CA_Size, isSens, frmDefs,btnAdd, lblDef, 12,"Defines used to build makefile"},
     {C_Button, btnDel, 0,   "Del", NoFrame,CA_None,
       isSens,frmDefs, btnAdd, lstDef,0,"Delete from active defines"},

	{C_ToggleFrame, frmOpts, 0, "",NoList,CA_NoBorder | CA_Hidden,isSens,frmMain, 0, 0},
	{C_Label, lblUOpt, 0," User Makefile Options:", NoList, CA_None, isSens, frmOpts,0, 0},
	{C_List, UOptList, 160, " ", (void *) vtmp, 
		CA_ListWidth | CA_Size, isSens, frmOpts, 0, lblUOpt, 12, "Options included in Makefile" },
	{C_Button, btnAddUOpt, 0, "Add", NoList,CA_None,
	    isSens,frmOpts,0, UOptList, 0, "Add User Option"},
	{C_Button, btnDelUOpt, 0, "Del", NoList,CA_None,
	    isSens,frmOpts, btnAddUOpt, UOptList,0,"Delete selected item"},
	{C_Button, btnEditUOpt, 0, "Edit", NoList,CA_None,
	    isSens,frmOpts, btnDelUOpt, UOptList,0,"Edit selected item"},

	{C_Button, M_OK, 0, "   OK   ", NoList, CA_DefaultButton,
	    isSens, NoFrame, 0, frmTogBtns,0,"Save project file"},

	{C_Button, M_Cancel, 0, " Cancel ",NoList,CA_None,
	    isSens,NoFrame, M_OK, frmTogBtns,0,"Abort Project Edit"},
	{C_CheckBox, chkMakeMkf, 1,"Make Makefile",NoList,CA_None,isSens,NoFrame, M_Cancel, frmTogBtns,
		0,"Write Makefile if checked"},

	{C_EndOfList,0,0,0,0,CA_None,0,0,0}
      };
//@V@:EndDialogCmd

//===================>>> projectDialog::projectDialog <<<====================
  projectDialog::projectDialog(makefileMaker& m, 
	vBaseWindow* bw, char* title)
   	: mm(m), vModalDialog(bw, title)
  {
    cmdw = (videCmdWindow*) bw;
      ta = 0;
      AddDialogCmds(PCmds);
  }
  
//===================>>> projectDialog::projectDialog <<<=====================
  projectDialog::projectDialog(makefileMaker& m, vApp *aw, char* title)
    : mm(m), vModalDialog(aw, title)
  {
   ta = 0;
   AddDialogCmds(PCmds);
  }

//===================>>> projectDialog::~projectDialog <<<====================
  projectDialog::~projectDialog()
  {
    //IMPORTANT: set objList back to original status!
    //has to be fixed in a new cmdList version

    PCmds[vGetcmdIdIndex(objList, PCmds)].itemList = (void * ) vtmp;
    SetValue(objList,-1,ChangeListPtr);

    PCmds[vGetcmdIdIndex(lstIncl, PCmds)].itemList = (void * ) vtmp;
    SetValue(lstIncl,-1,ChangeListPtr);

    PCmds[vGetcmdIdIndex(lstLibs, PCmds)].itemList = (void * ) vtmp;
    SetValue(lstLibs,-1,ChangeListPtr);

    PCmds[vGetcmdIdIndex(lstDefPool, PCmds)].itemList = (void * ) vtmp;
    SetValue(lstDefPool,-1,ChangeListPtr);

    PCmds[vGetcmdIdIndex(lstDef, PCmds)].itemList = (void * ) vtmp;
    SetValue(lstDef,-1,ChangeListPtr);

    PCmds[vGetcmdIdIndex(UOptList, PCmds)].itemList = (void * ) vtmp;
    SetValue(UOptList,-1,ChangeListPtr);
  }

//====================>>> projectDialog::DialogDisplayed <<<====================
  void projectDialog::DialogDisplayed()
  {

    // Display only the top frame

    SetValue(frmNames, 1, Value);	SetValue(frmObj, 0, Value);
    SetValue(frmPaths, 0, Value);	SetValue(frmDefs, 0, Value);
    SetValue(frmOpts, 0, Value);

    // set dialog values to the ones from the mm object

    SetString(txiExeName, mm.exeName);
    SetString(txiMkfName, mm.makeName);
    SetString(txiCC, mm.cc);
    SetString(txiCFlags, mm.cFlags);
    SetString(txiLibs, mm.Libs);
    SetString(txiObjPath, mm.ObjDir);
    SetString(txiBinPath, mm.BinDir);
    SetString(txiSrcPath, mm.SrcDir);

    // set to current lists
    PCmds[vGetcmdIdIndex(lstIncl, PCmds)].itemList = 
	(void *)(mm.incDirs.list);
    SetValue(lstIncl,-1,ChangeListPtr);	// change the whole list & unselect!

    PCmds[vGetcmdIdIndex(objList, PCmds)].itemList = 
	(void *)mm.objFiles.list;
    SetValue(objList,-1,ChangeListPtr);	// change the whole list!

    PCmds[vGetcmdIdIndex(lstLibs, PCmds)].itemList = 
	(void *)(mm.libDirs.list);
    SetValue(lstLibs,-1,ChangeListPtr);	// change the whole list & unselect!

    PCmds[vGetcmdIdIndex(lstDefPool, PCmds)].itemList = (void *)mm.defsPool.list;
    SetValue(lstDefPool, -1, ChangeListPtr);	// change the whole list & unselect!
 
    PCmds[vGetcmdIdIndex(lstDef, PCmds)].itemList = (void *)mm.curDefs.list;
    SetValue(lstDef,-1,ChangeListPtr);	// change the whole list & unselect!

    PCmds[vGetcmdIdIndex(UOptList, PCmds)].itemList = (void *)mm.curOpts.list;
    SetValue(UOptList,-1,ChangeListPtr);	// change the whole list & unselect!
  }

//====================>>> projectDialog::editProject <<<====================
  int projectDialog::editProject()
  {
    ItemVal dans, rval;

    dans = ShowModalDialog("Project Manager",rval);

    if (dans == M_Cancel)
	return Cancel;

    // have to retrieve values now...

    GetTextIn(txiExeName, mm.exeName, 255);
    GetTextIn(txiCC, mm.cc,255);
    GetTextIn(txiCFlags, mm.cFlags, 255);
    GetTextIn(txiLibs, mm.Libs, 255);
    GetTextIn(txiObjPath, mm.ObjDir, 255);
    GetTextIn(txiSrcPath, mm.SrcDir, 255);
    GetTextIn(txiBinPath, mm.BinDir, 255);
    GetTextIn(txiMkfName, mm.makeName, 255);

    if (GetValue(chkMakeMkf))
	mm.saveMakefile();
    return NoBuild;
  }

//====================>>> projectDialog::DialogCommand <<<====================
  void projectDialog::DialogCommand(ItemVal id, ItemVal retval, CmdType ctype)
  {
    UserDebug2(CmdEvents,"projectDialog::DialogCommand(id:%d, val:%d)\n",id, retval)

    switch (id)		// We will do some things depending on value
      {

	case tbtFiles:
	  {
	    SetValue(tbtFiles,1,Value);		SetValue(tbtFlags,0,Value);
	    SetValue(tbtPaths,0,Value);		SetValue(tbtDefs,0,Value);
	    SetValue(tbtOpts,0,Value);

	    SetValue(frmNames, 0, Value);	SetValue(frmObj, 1, Value);
	    SetValue(frmPaths, 0, Value);	SetValue(frmDefs, 0, Value);
	    SetValue(frmOpts, 0, Value);
	    break;
	  }

	case tbtFlags:
	  {
	    SetValue(tbtFiles,0,Value);		SetValue(tbtFlags,1,Value);
	    SetValue(tbtPaths,0,Value);		SetValue(tbtDefs,0,Value);
	    SetValue(tbtOpts,0,Value);

	    SetValue(frmNames, 1, Value);	SetValue(frmObj, 0, Value);
	    SetValue(frmPaths, 0, Value);	SetValue(frmDefs, 0, Value);
	    SetValue(frmOpts, 0, Value);
	    break;
	  }

	case tbtPaths:
	  {
	    SetValue(tbtFiles,0,Value);		SetValue(tbtFlags,0,Value);
	    SetValue(tbtPaths,1,Value);		SetValue(tbtDefs,0,Value);
	    SetValue(tbtOpts,0,Value);

	    SetValue(frmNames, 0, Value);	SetValue(frmObj, 0, Value);
	    SetValue(frmPaths, 1, Value);	SetValue(frmDefs, 0, Value);
	    SetValue(frmOpts, 0, Value);
	    break;
	  }

	case tbtDefs:
	  {
	    SetValue(tbtFiles,0,Value);		SetValue(tbtFlags,0,Value);
	    SetValue(tbtPaths,0,Value);		SetValue(tbtDefs,1,Value);
	    SetValue(tbtOpts,0,Value);

	    SetValue(frmNames, 0, Value);	SetValue(frmObj, 0, Value);
	    SetValue(frmPaths, 0, Value);	SetValue(frmDefs, 1, Value);
	    SetValue(frmOpts, 0, Value);
	    break;
	  }

	case tbtOpts:
	  {
	    SetValue(tbtFiles,0,Value);		SetValue(tbtFlags,0,Value);
	    SetValue(tbtPaths,0,Value);		SetValue(tbtDefs, 0,Value);
	    SetValue(tbtOpts,1,Value);

	    SetValue(frmNames, 0, Value);	SetValue(frmObj, 0, Value);
	    SetValue(frmPaths, 0, Value);	SetValue(frmDefs, 0, Value);
	    SetValue(frmOpts, 1, Value);
	    break;
	  }

        case btnAddSrcFile:
	  {
	    char MSDOSpath[100]= "";
	    int fi = 0;
	    static char* makeFilter[] = {"*.cpp", "*.*", 0};
	    vFileSelect fsel(this);

	    int oans = fsel.FileSelect("Add a Source File",
                                     MSDOSpath,99, makeFilter,fi);
	    if (oans && *MSDOSpath) //filename picked
	      {
		ta=1; // target file added!
		char uxfn[100]="";
		Dos2UxFName(MSDOSpath, uxfn, 0);
		if (!mm.addFile(uxfn))
		  {
		    vNoticeDialog note(this);
		    note.Notice("File already selected for this Project");
		  }
	      }
	    SetValue(objList,-1,ChangeList); // update list & unselect!

	    break;
	  }	//@V@:EndCase

        case btnDelSrcFile:
	  {
            int lval = GetValue(objList); 
            if (lval < 0)
		break;
	    mm.objFiles.deleteItem(lval);
	    SetValue(objList,-1,ChangeList); // update list & unselect!

	  }	//@V@:EndCase

	case btnEditSrcFile:
	  {
            vReplyDialog newDefDlg(this);
            int ans;
            char r[100];

            int lval = GetValue(objList);
            if (lval < 0)
		break;

            ans=newDefDlg.Reply("Edit Source filename", r, 99,
		mm.objFiles.list[lval]);
            if (ans==M_Cancel)
		 break;
            if (*r)
              {
		mm.objFiles.replace(lval,r);
              }
            SetValue(objList,-1,ChangeListPtr); //update list & unselect!
	    break;
	  }
	case btnBrwSrcD:
	  {
	    char MSDOSpath[100]= "";
	    int fi = 0;
	    static char* makeFilter[] = {"*.o", "*.*", 0};
	    vFileSelect fsel(this);

	    fsel.FileSelect("Select a file in the Src Directory",
                                     MSDOSpath,99, makeFilter,fi);
            char uxfn[100]="";
            Dos2UxFName(MSDOSpath, uxfn, 1);
            SetString(txiSrcPath, uxfn);
            break;
          }

	case btnBrwObjD:
	  {
	    char MSDOSpath[100]= "";
	    int fi = 0;
	    static char* makeFilter[] = {"*.o", "*.*", 0};
	    vFileSelect fsel(this);

	    fsel.FileSelect("Select a file in the Obj Directory",
                                     MSDOSpath,99, makeFilter,fi);
            char uxfn[100]="";
            Dos2UxFName(MSDOSpath, uxfn, 1);
            SetString(txiObjPath, uxfn);
            break;
          }

	case btnBrwBinD:
	  {
	    char MSDOSpath[100]= "";
	    int fi = 0;
	    static char* makeFilter[] = {"*.exe", "*.*", 0};
	    vFileSelect fsel(this);

	    fsel.FileSelect("Select file in Bin Directory",
                                     MSDOSpath,99, makeFilter,fi);
            char uxfn[100]="";
            Dos2UxFName(MSDOSpath, uxfn, 1);
            SetString(txiBinPath, uxfn);
            break;
          }

	case btnAddInclPath:
	  {
	    char MSDOSpath[100]= "";
	    int fi = 0;
	    static char* makeFilter[] = {"*.h", "*.*", 0};
	    vFileSelect fsel(this);

	    int oans = fsel.FileSelect("Select file in Include Path",
                                     MSDOSpath,99, makeFilter,fi);

            char uxfn[100]="";
            Dos2UxFName(MSDOSpath, uxfn, 1);
           
            //@@@ Add inc dirs only once!
	    mm.incDirs.insert(-1,uxfn);
	    SetValue(lstIncl,-1,ChangeListPtr); //update list & unselect!

	    break;
	  }	//@V@:EndCase

	case btnDelInclPath:
	  {
	    int lval=GetValue(lstIncl); 
	    if (lval < 0)
		break;
	    mm.incDirs.deleteItem(lval);
	    SetValue(lstIncl,-1,ChangeListPtr); //update list & unselect!
	    break;
	  }	//@V@:EndCase

	case btnEditInclPath:
	  {
            vReplyDialog newDefDlg(this);
            int ans;
            char r[100];

            int lval = GetValue(lstIncl);
            if (lval < 0)
		break;

            ans=newDefDlg.Reply("Edit Include Path", r, 99,
		mm.incDirs.list[lval]);
            if (ans==M_Cancel)
		 break;
            if (*r)
              {
		mm.incDirs.replace(lval,r);
              }
            SetValue(lstIncl,-1,ChangeListPtr); //update list & unselect!
	    break;
	  }

	case btnAddLibsPath:
	  {
	    char MSDOSpath[100]= "";
	    int fi = 0;
	    static char* makeFilter[] = {"*.a", "*.*", 0};
	    vFileSelect fsel(this);

	    int oans = fsel.FileSelect("Select file in Library Path",
	        MSDOSpath,99, makeFilter,fi);
            char uxfn[100]="";
            Dos2UxFName(MSDOSpath, uxfn, 1);
            // @@ Add dirs only once!
	    mm.libDirs.insert(-1,uxfn);
	    SetValue(lstLibs,-1,ChangeListPtr); // update list & unselect!

	    break;
	  }	//@V@:EndCase

	case btnDelLibsPath:
	  {
	    int lval=GetValue(lstLibs); 
	    if (lval < 0)
		break;
	    mm.libDirs.deleteItem(lval);
	    SetValue(lstLibs,-1,ChangeListPtr); //update list & unselect!
	    break;
	  }	//@V@:EndCase

	case btnEditLibsPath:
	  {
            vReplyDialog newDefDlg(this);
            int ans;
            char r[100];

            int lval = GetValue(lstLibs);
            if (lval < 0)
		break;

            ans=newDefDlg.Reply("Edit Lib Path", r, 99,
		mm.libDirs.list[lval]);
            if (ans==M_Cancel)
		 break;
            if (*r)
              {
		mm.libDirs.replace(lval,r);
              }
            SetValue(lstLibs,-1,ChangeListPtr); //update list & unselect!
	    break;
	  }

	  case btnAddDef:
	    {
            vReplyDialog newDefDlg(this);
            int ans;
            char r[100];

            ans=newDefDlg.Reply("Enter define/undefine (including -D or -U):", r, 99);
            if (ans==M_Cancel)
		 break;
            if (*r)
              {
		mm.defsPool.insert(-1,r);
              }
            SetValue(lstDefPool,-1,ChangeListPtr); //update list & unselect!
            break;
          }


        case btnDelDef:
          {
            int lval = GetValue(lstDefPool); 
            if (lval < 0)
		break;
	    mm.defsPool.deleteItem(lval);
            SetValue(lstDefPool,-1,ChangeListPtr); //update list & unselect!
            break;
          } //@V@:EndCase


	case btnEditDef:
	  {
            vReplyDialog newDefDlg(this);
            int ans;
            char r[100];

            int lval = GetValue(lstDefPool);
            if (lval < 0)
		break;

            ans=newDefDlg.Reply("Edit Definition", r, 99,
		mm.defsPool.list[lval]);
            if (ans==M_Cancel)
		 break;
            if (*r)
              {
		mm.defsPool.replace(lval,r);
              }
            SetValue(lstDefPool,-1,ChangeListPtr); //update list & unselect!
	    break;
	  }

        case btnAdd:		// add to def pool
	    {
            int lval=GetValue(lstDefPool); 
            if (lval < 0)
		break;
	    mm.curDefs.insert(-1,mm.defsPool.list[lval]);	// add to def list
            SetValue(lstDef,-1,ChangeListPtr); //update list & unselect!
            SetValue(lstDefPool,-1,ChangeListPtr); // unselect!
            break;
	    }	//@V@:EndCase

        case btnDel:		// delete from active defs
	    {
            int lval=GetValue(lstDef); 
            if (lval < 0)
		break;
	    mm.curDefs.deleteItem(lval);	// add to def list
            SetValue(lstDef, -1, ChangeListPtr); //update list & unselect!

            break;
	    }	//@V@:EndCase

	case btnAddUOpt:
	  {
            vReplyDialog newDefDlg(this);
            int ans;
            char r[100];

            ans=newDefDlg.Reply("Enter Makefile user define:", r, 99);
            if (ans==M_Cancel)
		 break;
            if (*r)
              {
		mm.curOpts.insert(-1,r);
              }
            SetValue(UOptList,-1,ChangeListPtr); //update list & unselect!
	    break;
	  }

	case btnDelUOpt:
	  {
            int lval=GetValue(UOptList);
            if (lval < 0)
		break;
	    mm.curOpts.deleteItem(lval);	// add to def list
            SetValue(UOptList, -1, ChangeListPtr); //update list & unselect!
	    break;
	  }

	case btnEditUOpt:
	  {
            vReplyDialog newDefDlg(this);
            int ans;
            char r[100];

            int lval = GetValue(UOptList);
            if (lval < 0)
		break;

            ans=newDefDlg.Reply("Edit User Makefile definition", r, 99,
		mm.curOpts.list[lval]);
            if (ans==M_Cancel)
		 break;
            if (*r)
              {
		mm.curOpts.replace(lval,r);
              }
            SetValue(UOptList,-1,ChangeListPtr); //update list & unselect!
	    break;
	  }

      }//switch

    vModalDialog::DialogCommand(id,retval,ctype);
  }

//------------------------------------------------------------------------
