/*
 * This file is part of the portable Forth environment written in ANSI C.
 * Copyright (C) 1993  Dirk Uwe Zoller
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This file is version 0.9.5 of 15-May-94
 * Check for the latest version of this package via anonymous ftp at
 *	roxi.rz.fht-mannheim.de
 *	/pub/unix/languages/pfe-VERSION.tar.gz
 * Please direct any comments via internet to
 *	duz@roxi.rz.fht-mannheim.de.
 * Thank You.
 */
/*
 * file.c ---		The Optional File-Access Word Set and
 *			File-Access Extension Words.
 * (duz 12Jul93)
 */

#include <stdio.h>
#include <errno.h>

#include "config.h"
#include "forth.h"
#include "support.h"


Code (bin)
{
  *sp += FMODE_BIN;
}

Code (close_file)
{
  *sp = close_file ((File *)*sp) ? errno : 0;
}

Code (create_file)
{
  sp [2] = (Cell)create_file ((char *)sp [2], sp [1], sp [0]);
  sp++;
  sp [0] = sp [1] ? 0 : errno;
}

Code (delete_file)
{
  char fn [128];

  store_asciiz ((char *)sp [1], sp [0], fn, sizeof fn);
  *++sp = remove (fn) ? errno : 0;
}

Code (file_position)
{
  long pos;
  dCell *d;

  pos = ftell (((File *)*sp)->f);
  sp -= 2;
  d = (dCell *)&sp [1];
  if (pos != -1)
    {
      d->lo = pos;
      d->hi = 0;
      *sp = 0;
    }
  else
    {
      d->lo = d->hi = -1;
      *sp = errno;
    }
}

Code (file_size)
{
  dCell d;
  fpos_t size;
  FILE *f = ((File *)*sp)->f;

  clearerr (f);
  size = fsize (f);
  sp -= 2;
  d.hi = 0;
  if (size != (fpos_t)-1)
    {
      d.lo = size;
      *sp = 0;
    }
  else
    {
      d.lo = 0;
      *sp = errno;
    }
  *(dCell *)&sp [1] = d;
}

Code (include_file)
{
  include_file ((File *)*sp++);
}

Code (included)
{
  char *fn;
  int n;

  fn = (char *)sp [1];
  n = sp [0];
  sp += 2;
  included (fn, n);
}

Code (open_file)
{
  sp [2] = (Cell)open_file ((char *)sp [2], sp [1], sp [0]);
  sp++;
  sp [0] = sp [1] ? 0 : errno;
}

Code (read_file)
{
  char *p = (char *)sp [2];
  sp [2] = sp [1];
  sp [1] = read_file (p, (uCell *)&sp [2], (File *)sp [0]);
  sp++;
}

Code (read_line)
{
  uCell n = sp [1];
  sp [1] = read_line ((char *)sp [2], &n, (File *)sp [0], &sp [0]);
  sp [2] = n;
}

Code (reposition_file)
{
  dCell d = *(dCell *)&sp [1];

  sp [2] = reposition_file (d.lo, (File *)sp [0]);
  sp += 2;
}

Code (resize_file)
{
  File *f = (File *)*sp++;
  dCell d = *(dCell *)sp;
  int r;

  r = resize_file (f, d.lo);
  ++sp;
  if (r)
    f->size = d.lo / BPBUF, *sp = 0;
  else
    *sp = errno;
}

Code (write_file)
{
  sp [2] = write_file ((char *)sp [2], sp [1], (File *)sp [0]);
  sp += 2;
}

Code (write_line)
{
  FILE *f = ((File *)sp [0])->f;
  write_file_();
  putc ('\n', f);
}

Code (file_status)
{
  char fn [0x100];
  int mode;

  store_asciiz ((char *)sp [1], sp [0], fn, sizeof fn);
  mode = file_access (fn);
  if (mode == -1)
    {
      sp [1] = 0;
      sp [0] = errno;
    }
  else
    {
      sp [1] = mode;
      sp [0] = 0;
    }
}

Code (flush_file)
{
  File *f = (File *)sp [0];

  if (BLOCK_FILE == f)
    {
      save_buffers_();
      sp [0] = 0;
    }
  else
    {
      if (fflush (f->f))
	sp [0] = errno;
      else
	sp [0] = 0;
    }
}

Code (rename_file)
{
  char oldnm [80], newnm [80];

  store_asciiz ((char *)sp [3], sp [2], oldnm, sizeof oldnm);
  store_asciiz ((char *)sp [1], sp [0], newnm, sizeof newnm);
  sp += 3;
  *sp = rename (oldnm, newnm) ? errno : 0;
}


LISTWORDS (file) =
{
  CO ("BIN",		bin),
  CO ("CLOSE-FILE",	close_file),
  CO ("CREATE-FILE",	create_file),
  CO ("DELETE-FILE",	delete_file),
  CO ("FILE-POSITION",	file_position),
  CO ("FILE-SIZE",	file_size),
  CO ("INCLUDE-FILE",	include_file),
  CO ("INCLUDED",	included),
  CO ("OPEN-FILE",	open_file),
  OC ("R/O",		FMODE_RO),
  OC ("R/W",		FMODE_RW),
  CO ("READ-FILE",	read_file),
  CO ("READ-LINE",	read_line),
  CO ("REPOSITION-FILE",reposition_file),
  CO ("RESIZE-FILE",	resize_file),
  OC ("W/O",		FMODE_WO),
  CO ("WRITE-FILE",	write_file),
  CO ("WRITE-LINE",	write_line),
  CO ("FILE-STATUS",	file_status),
  CO ("FLUSH-FILE",	flush_file),
  CO ("RENAME-FILE",	rename_file)
};
COUNTWORDS (file, "File-access + extensions");
