@echo off
rem ===========================================================================
rem  Apply CA-REALIZER Windows 2.0B USA Update Patch to a prior 2.0 or 2.0A version
rem ===========================================================================
rem
rem      1.  ***  IMPORTANT  ***
rem
rem                 Manually backup your existing CA-Realizer 2.0 or 2.0A directory and the two CA-Realizer files 
rem                 normally installed in your Windows directory. ( CABLE.DLL and \RLZRUN20\RLZRUN20.RTS)
rem
rem                 This batch file requires CABLE.DLL and \RLZRUN20\RLZRUN20.RTS be in the     
rem                  windows directory where they were originally installed.    
rem
rem			   The existing read.me file will be updated, if you want to preserve its contents you 
rem			    should back it up first.
rem
rem      2  To execute this batch file, on the DOS command line do the following:
rem                -First change the drive/directory to that of the CA-REALIZER update files. 
rem                             ( ex.  a:  or  CD\c:\RLZPatch)
rem                -Type RLZPATCH.BAT Realizer Directory  Patch Directory  Windows Directory
rem                  ex. RLZPATCH.BAT  c:\REALIZER  a:  c:\Windows 
rem             notes-      
rem                Realizer Directory
rem                      Specify both drive letter and directory name of the
rem                      CA-Realizer 2.0 or 2.0A directory to be updated.
rem                Patch Directory
rem                      Specify both drive letter and directory of the
rem                      patch file(ie. d:\filename.RTP) and PATCH.exe program.
rem                Windows Directory
rem                      Specify both drive letter and directory of your
rem                      Windows directory name.
rem      3. Copies two CA-Realizer files which are automatically installed in your windows directory to 
rem                  your CA-Realizer directory.
rem             - Copies the following 2 files  Cable.dll       Rlzrun20.rts
rem                  - If you have changed the location of these files then this batch file will fail.
rem      4. Applys the patch file to your CA-Realizer 2.0 or 2.0A directory or a copy of it.
rem      5. Copies the following patched files back to your windows directories to complete the update.
rem                     Cable.dll       Rlzrun20.rts
rem      6. Erases the 2 files copied in step 3.
rem

if  exist %1\realizer.exe goto Exit1
	echo Wrong path entered for CA-Realizer directory
	echo %1
	goto end
:Exit1
SET RLZUpdateDirectory=%1
if  exist %2\patch.exe goto Exit2
	echo Wrong path entered for patch file
	echo %2
	goto end
:Exit2
SET RLZPatchDirectory=%2

if  exist %3\win.ini  goto Exit3
rem if  exist %3\system  goto Exit3
	echo Wrong path entered for the windows directory
	echo %3
	goto end
:Exit3
SET RLZWinDirectory=%3

if  exist %3\cable.dll goto Exit4
	echo Cable.dll must reside in the windows directory
	goto end
:Exit4        
if  exist %3\rlzrun20\rlzrun20.rts goto Exit5
	echo \Rlzrun20\Rlzrun20.rts must reside in the windows directory
	goto end
:Exit5

if not exist %2\patchapp.txt goto Exit6
	erase %2\patchapp.txt
:Exit6

copy %RLZWinDirectory%\RLZRUN20\RLZRUN20.RTS   %RLZUpdateDirectory%
echo copied %RLZWinDirectory%\RLZRUN20\RLZRUN20.RTS   %RLZUpdateDirectory%

copy %RLZWinDirectory%\CABLE.DLL  %RLZUpdateDirectory%
echo Copied %RLZWinDirectory%\CABLE.DLL  %RLZUpdateDirectory%

ECHO %RLZPatchDirectory%\patch.exe /NOPATHSEARCH  /s %RLZUpdateDirectory%  %RLZPatchDirectory%\Patch.rtp
%RLZPatchDirectory%\patch.exe /NOPATHSEARCH  /s %RLZUpdateDirectory%  %RLZPatchDirectory%\Patch.rtp  >%RLZPatchDirectory%\patchapp.txt

copy %RLZUpdateDirectory%\RLZRUN20.RTS   %RLZWinDirectory%\RLZRUN20
echo Copied  %RLZUpdateDirectory%\RLZRUN20.RTS   TO  %RLZWinDirectory%\RLZRUN20
copy %RLZUpdateDirectory%\CABLE.DLL  %RLZWinDirectory%
echo Copied %RLZUpdateDirectory%\CABLE.DLL  TO  %RLZWinDirectory%

erase %RLZUpdateDirectory%\RLZRUN20.RTS  
echo erased %RLZUpdateDirectory%\RLZRUN20.RTS  
erase %RLZUpdateDirectory%\CABLE.DLL  
echo erased %RLZUpdateDirectory%\CABLE.DLL  
echo -
if  exist %RLZUpdateDirectory%\readme.wri rename %RLZUpdateDirectory%\readme.wri readme.20x
copy %RLZPatchDirectory%\readme.wri %RLZUpdateDirectory%
echo copied %RLZPatchDirectory%\readme.wri %RLZUpdateDirectory%

echo After pressing Enter the update output log will be displayed.
echo Please check the totals listed with those in the read.me file.
echo The listed totals can also be found in patchapp.txt in the patch directory.
pause

type %RLZPatchDirectory%\patchapp.txt  | more

echo ------------------------------------------------------------------------------------
echo CA-Realizer Update to 2.0B is done.
echo -------------------------------------------------------------------------------------
:End
rem  Remove variables
SET RLZUpdateDirectory=
SET RLZPatchDirectory=
SET RLZWinDirectory=
