implementation module EdWindowsMenu;

/*	The commands of the Windows menu */

import	StdClass;
import StdBool, StdString, StdInt, StdChar, StdFile, StdArray;
import deltaEventIO, deltaWindow, deltaMenu, deltaPicture, deltaFont;

import EdProgramState, EdWindows, EdFileMenu, EdFiles, EdDialogs, EdFileMenu;

    
::	InfoDef		:== (Int,Int,[InfoLine]);
::	InfoLine		:== (InfoFontDef,Int,Int,String);
::	InfoFontDef	=  InfoFont Font Centered | NoFont Centered;
::	Centered		:== Bool;
::	Fonts			:== (Font,Font,Font,Font);
::	Heights		:== (Int,Int);

     
	InfoFontName1	:== "Geneva";
	InfoFontName2	:== "Helvetica";
	InfoFontName3	:== "Times";
	NormalSize1		:== 9;
	NormalSize2		:== 12;
	LargeSize1		:== 12;
	LargeSize2		:== 14;
	NormalStyle		:== [];
	BoldStyle		:== ["Bold"];
	Margin			:== 8;
	AboutBegin		:== "\\About";
	AboutEnd			:== "\\EndAbout";
	HelpBegin		:== "\\Help";
	HelpEnd			:== "\\EndHelp";

    

//
//	General AboutDialog construction.
//

MakeAboutDialog	:: String Files (*s -> *( (IOState *s) -> (*s, IOState *s) ))
	                                  -> (DialogDef *s (IOState *s), Files);
MakeAboutDialog appname files helpf
	=  (AboutDialog appname ((0,0),(xmax,ymax)) picture (AboutHelp "Help" helpf), files`);
		where {
		picture                =: DrawAboutInfo nft (xmax,ymax,text);
		(xmax,ymax,text,files`)=: ReadInfo fonts AboutBegin AboutEnd HelpFile files;
		fonts                  =: InfoFonts;
		(nft,lft,bft,dft)      =: fonts;
		};

InfoFonts	::    Fonts;
InfoFonts = (nft,lft,bft,dft);
		where {
		nft=: SelectNormalFont NormalStyle;
		lft=: SelectLargeFont  NormalStyle;
		bft=: SelectNormalFont BoldStyle;
		dft=: SelectLargeFont  BoldStyle;
		};

SelectLargeFont	:: [FontStyle] -> Font;
SelectLargeFont style
	| found1 =  first;
	| found2 =  second;
	=  third;
	   where {
	   (found1,first )=: SelectFont InfoFontName1 style LargeSize1;
	   (found2,second)=: SelectFont InfoFontName2 style LargeSize2;
	   (dummy ,third )=: SelectFont InfoFontName3 style LargeSize2;
	   };

SelectNormalFont	:: [FontStyle] -> Font;
SelectNormalFont style
	| found1 =  first;
	| found2 =  second;
	=  third;
	   where {
	   (found1,first )=: SelectFont InfoFontName1 style NormalSize1;
	   (found2,second)=: SelectFont InfoFontName2 style NormalSize2;
	   (dummy ,third )=: SelectFont InfoFontName3 style NormalSize2;
	   };

/*	Reading and pre-processing of the file containing the about- and help-info. */

ReadInfo	:: Fonts String String String Files -> (Int,Int,[InfoLine],Files);
ReadInfo fonts begin end filename files
	| not succes =  (x3,y3,lines3,files1);
	| not found =  (x3,y3,lines3,files`);
	=  let! {
		strict1;
		} in
		(xm,ym,lines ,files`);
		where {
		(b,files`)          =: strict1;
		(xm,ym,lines)       =: ProcessInfoStrings fonts info;
		(found,info,file`)  =: ReadInfoFile begin end file;
		(succes,file,files1)=: fopen (ApplicationPath filename) FReadText files;
		(x3,y3,lines3)      =: ProcessInfoStrings fonts ["\\DThis is a Clean program."];
		strict1=fclose file` files1;
		};

ProcessInfoStrings	:: Fonts [String] -> InfoDef;
ProcessInfoStrings fonts=:(nft,lft,bft,dft) lines
	=  (maxx`,  maxy + Margin  - lat, lines``);
		where {
		lines``           =: CenterInfoLines nft maxx` lines`;
		maxx`             =: Margin + (maxx + Margin);
		(maxx,maxy,lines`)=: AddFontToInfoLines fonts heights 0 (Margin + lat) lines;
		heights				=: (nat + (ndt + nld), lat + (ldt + lld));
		(nat,ndt,nmw,nld) =: FontMetrics nft;
		(lat,ldt,lmw,lld)	=: FontMetrics lft;
		};

CenterInfoLines	:: Font Int [InfoLine] -> [InfoLine];
CenterInfoLines nft maxx [info=:(inft=:NoFont centered,x,y,line) : rest]
	| centered =  [(inft,x`,y,line) : CenterInfoLines nft maxx rest];
	=  [info : CenterInfoLines nft maxx rest];
		where {
		x`=: (maxx -  FontStringWidth line nft ) / 2;
		};
CenterInfoLines nft maxx [info=:(inft=:InfoFont font centered,x,y,line) : rest]
	| centered =  [(inft,x`,y,line) : CenterInfoLines nft maxx rest];
	=  [info : CenterInfoLines nft maxx rest];
		where {
		x`=: (maxx -  FontStringWidth line font ) / 2;
		};
CenterInfoLines nft maxx [] =  [];

AddFontToInfoLines	:: Fonts Heights Int Int [String] -> InfoDef;
AddFontToInfoLines fonts heights maxx maxy [line : rest]
	=  (maxx`, maxy`, [(font,Margin,maxy,line`) : rest`]);
		where {
		(maxx`,maxy`,rest`) =: AddFontToInfoLines fonts heights (max maxx wid) (maxy + hgt) rest;
		(font,wid,hgt,line`)=: ParseInfoLine fonts heights line;
		};
AddFontToInfoLines fonts heights maxx maxy [] =  (maxx, maxy, []);

ParseInfoLine	:: Fonts Heights String -> (InfoFontDef,Int,Int,String);
ParseInfoLine fonts=:(nft,lft,bft,dft) heights=:(nhgt,lhgt) line
	| linelen < 2 ||  line.[0]  <> '\\' =  (NoFont False, FontStringWidth line nft, nhgt, line);
	=  (infofont, FontStringWidth line` font, height, line`);
		where {
		(infofont,font,height)=: GetInfoFont_and_Height (line.[1]) fonts heights;
		linelen=: size line;
		line`  =: line % (2, dec linelen);
		};

GetInfoFont_and_Height	:: Char Fonts Heights -> (InfoFontDef,Font,Int);
GetInfoFont_and_Height 'L' (nft,lft,bft,dft) (nhgt,lhgt) =  (InfoFont lft False, lft, lhgt);
GetInfoFont_and_Height 'b' (nft,lft,bft,dft) (nhgt,lhgt) =  (InfoFont bft False, bft, nhgt);
GetInfoFont_and_Height 'B' (nft,lft,bft,dft) (nhgt,lhgt) =  (InfoFont dft False, dft, lhgt);
GetInfoFont_and_Height 'c' (nft,lft,bft,dft) (nhgt,lhgt) =  (NoFont True       , nft, nhgt);
GetInfoFont_and_Height 'C' (nft,lft,bft,dft) (nhgt,lhgt) =  (InfoFont lft True , lft, lhgt);
GetInfoFont_and_Height 'd' (nft,lft,bft,dft) (nhgt,lhgt) =  (InfoFont bft True , bft, nhgt);
GetInfoFont_and_Height 'D' (nft,lft,bft,dft) (nhgt,lhgt) =  (InfoFont dft True , dft, lhgt);
GetInfoFont_and_Height chr (nft,lft,bft,dft) (nhgt,lhgt) =  (NoFont False      , nft, nhgt);

ReadInfoFile	:: String String UFILE -> (Bool,[String],UFILE);
ReadInfoFile begin end file
	| not begin_found =  (False, []   , file1);
	=  (True , lines, file`);
		where {
		(lines      ,file`)=: ReadInfoUntil end file1;
		(begin_found,file1)=: FindInfoBegin begin file;
		};

FindInfoBegin	:: String UFILE -> (Bool,UFILE);
FindInfoBegin begin file
	| sfend file =  (False,file);
	| eq_PRFX begin line =  (True,file`);
	=  FindInfoBegin begin file`;
		where {
		(line,file`)=: freadline file;
		};

ReadInfoUntil	:: String UFILE -> ([String],UFILE);
ReadInfoUntil end file
	| sfend file =  ([], file );
	| eq_PRFX end line =  ([], file1);
	=  ([StripNewline line : lines], file`);
		where {
		(lines,file`)=: ReadInfoUntil end file1;
		(line ,file1)=: freadline file;
		};

/*	The drawing of the about/help info. */

DrawAboutInfo	:: Font InfoDef -> [DrawFunction];
DrawAboutInfo nft (xmax,ymax,lines) =  [SetFont nft, DrawInfo nft 0 ymax lines];

DrawInfo	:: Font Int Int [InfoLine] Picture -> Picture;
DrawInfo nft top bot [(InfoFont font c,x,y,line) : rest] pic
	| y > bot =  pic;
	| y < top =  DrawInfo nft top bot rest pic;
	=  DrawInfo nft top bot rest (SetFont nft (DrawString line (SetFont font (MovePenTo (x,y) pic))));
DrawInfo nft top bot [(NoFont c,x,y,line) : rest] pic
	| y > bot =  pic;
	| y < top =  DrawInfo nft top bot rest pic;
	=  DrawInfo nft top bot rest (DrawString line (MovePenTo (x,y) pic));
DrawInfo nft top bot [] pic =  pic;

//
//	Device Function for the Help command.
//

Help	:: Editor IO -> EdIO;
Help editor io =  (editor`,OpenWindows [window] io);
		where {
		window=: FixedWindow HelpWdID (0,0) "Help"
							((0,0),(xmax,ymax)) (UpdateHelpWd nft helptext)
							[Activate ActivateHelpWd, Deactivate DeActHelpWd, GoAway CloseHelp];
		(xmax,ymax,helptext,editor`)=: ReadHelpInfo fonts HelpBegin HelpEnd HelpFile editor;
		fonts                       =: InfoFonts;
		(nft,lft,bft,dft)           =: fonts;
		};

ReadHelpInfo	:: Fonts String String String Editor -> (Int,Int,[InfoLine],Editor);
ReadHelpInfo fonts begin end filename editor
	| not succes =  (x1,y1,lines1,editor` );
	| not found =  (x2,y2,lines2,editor``);
	=  let! {
		editor``;
		} in
		(xm,ym,lines ,editor``);
		where {
		(xm,ym,lines)        =: ProcessInfoStrings fonts info;
		editor``             =: CloseUFile file` editor`;
		(found,info,file`)   =: ReadInfoFile begin end file;
		(editor`,succes,file)=: OpenUFile (ApplicationPath filename) FReadText editor;
		(x1,y1,lines1)       =: ProcessInfoStrings fonts [errpref +++ "could not be found."];
		(x2,y2,lines2)       =: ProcessInfoStrings fonts [errpref +++ "does not contain help information."];
		errpref              =: "The help file \'" +++  filename +++ "\' " ;
		};

UpdateHelpWd	:: Font [InfoLine] UpdateArea * s -> (*s, [DrawFunction]);
UpdateHelpWd nft lines areas s =  (s, [SetFont nft, RedrawAreas nft lines areas]);

RedrawAreas	:: Font [InfoLine] UpdateArea Picture -> Picture;
RedrawAreas nft lines [area=:((l,t),(r,b)) : rest] pict
	=  RedrawAreas nft lines rest (DrawInfo nft (dec t) (b + 40) lines pict);
RedrawAreas nft lines [] pict =  pict;

ActivateHelpWd	:: Editor IO -> EdIO;
ActivateHelpWd editor io =  (editor, io`);
	where {
	io`=: ChangeIOState [ DisableMenus [MEditID,MSearcID],
				EnableMenuItems  [ICloseID],
				DisableMenuItems [ISaveID,ISavesID,IReverID],
				ChangeMenuItemFunctions [(ICloseID,CloseHelp)] ] io;
	};

DeActHelpWd	:: Editor IO -> EdIO;
DeActHelpWd editor io =  (editor,io);

CloseHelp	:: Editor IO -> EdIO;
CloseHelp editor io
	| windows =  (editor, ioa);
	=  (editor, iob);
	where {
	ioa=: ChangeIOState [ EnableMenus [MEditID,MSearcID],
								EnableMenuItems [ISavesID] ] io2;
	iob=: DisableMenuItems [ICloseID] io2;
	io2=: ChangeMenuItemFunctions [(ICloseID,Close)] io1;
	(windows,id,io1)=: GetActiveWindow (CloseWindows [HelpWdID] io);
	};

//
//	Device function for the Save All command
//

SaveAll :: Editor IO -> EdIO;
SaveAll editor io =  (editor`, io`);
	where {
	(editor`,io`)	=: DoSaveAll wdids editor1 io;
	(editor1,wdids)=: GetUsedWdIds editor;
	};

DoSaveAll	:: [EditWdId] Editor IO -> EdIO;
DoSaveAll [] editor io =  (editor,io);
DoSaveAll [id:rest] editor io
	| EW_Saved window =  DoSaveAll rest editor1 io;
	=  DoSaveAll rest editor` io`;
	where {
	io`				 =: DisableMenuItems [ISaveID, IReverID] io1;
	(editor`,io1)	 =: DoSave id window editor1 io;
	(editor1,window)=: GetWindow id editor;
	};

DoSave	:: EditWdId EditWindow Editor IO -> EdIO;
DoSave id window editor io
	| path == "Untitled" =  DoSaveAs id window editor io;
	| good =  (editora, io);
	=  (editorb, AlertDialog ["The file \"" +++   RemovePath path  +++ "\" could not be saved" ,
	                          "because of an I/O error."] io);
	where {
	editora			=: SetWindow id (EW_SetSaved True window) editorb;
	(editorb,good)	=: SaveFile path (EW_GetText window) editor;
	path	 			=: EW_GetPathname window;
	};

DoSaveAs :: EditWdId EditWindow Editor IO -> EdIO;
DoSaveAs id oldwd editor io
	| not save =  (editor` ,io`);
	| name == HelpFile =  (editor`,HelpFileAlert io`);
	| good =  (editora,io``);
	=  (editorb,AlertDialog ["The file could not be saved because",
		                      "of a file I/O error."] io`);
	where {
	editora					  =: SetWindow id window editorb;
	(editorb,good)			  =: SaveFile path (EW_GetText oldwd) editor`;
	io``						  =: ChangeWindowTitle id name io`;
	(save,path,editor`,io`)=: OpenOutputFileSelector (RemovePath oldpath) editor io;
	window					  =: EW_SetSaved True (EW_SetPathname path oldwd);
	oldpath					  =: EW_GetPathname oldwd;
	name						  =: RemovePath path;
	};


//
//	Device function for the Close All command
// 

CloseAll :: Editor IO -> EdIO;
CloseAll editor io =  DoCloseAll (-1) editor (CloseWindows [HelpWdID] io);

DoCloseAll	:: EditWdId Editor IO -> EdIO;
DoCloseAll id editor io
	| not windows || id == wdid =  (editor, io1);
	=  DoCloseAll wdid editor` io`;
	where {
	(windows,wdid,io1)=: GetActiveWindow io;
	(editor`,io`)		=: CloseWindow "closing" wdid editor io1;
	};


/*	Misc. function(s) */

eq_PRFX	:: String String -> Bool;
eq_PRFX prefix string
	| prefixlen >  size string  =  False;
	=  prefix ==  string % (0, dec prefixlen) ;
		where {
		prefixlen=: size prefix;
		};

StripNewline	:: String -> String;
StripNewline ""     =  "";
StripNewline string
	|  string.[last]  <> '\n' =  string;
	=  string % (0, dec last);
		where {
		last=: dec (size string);
		};

MaximumInList	:: Int [Int] -> Int;
MaximumInList max [x:xs] | max >= x =  MaximumInList max xs;
	                         =  MaximumInList x xs;
MaximumInList max []     =  max;
