begin
	require 'uconv'

	module REXML
		module Encoding
			def encode(content)
				Uconv::u8tosjis(content)
			end

			def decode(str)
				Uconv::sjistou8(str)
			end
		end
	end
rescue LoadError
  begin
	require 'iconv'
	module REXML
		module Encoding
			def decode(str)
				return Iconv::iconv("utf-8", "shift_jis", str).join('')
			end

			def encode(content)
				return Iconv::iconv("shift_jis", "utf-8", content).join('')
			end
		end
	end
  rescue LoadError
	raise "uconv or iconv is required for Japanese encoding support."
  end

end
