IMPLEMENTATION MODULE MetrGClass;

FROM YaflGC                IMPORT YaflGC;
FROM Conversions           IMPORT IntConversions;
IMPORT SYSTEM;

  CLASS MetrClassImplCodeGenerator;
    INHERITS ClassImplCodeGenerator(CGcContext);

    METHOD Output: YaflGC;
      BEGIN
      RESULT := Ctx.Output;
      END Output;

    REDEFINE METHOD GenerateCode;
      VAR
        Line, Sep: ARRAY OF CHAR;
         DefLineCount: INTEGER;
        
      METHOD Int (i: INTEGER): ARRAY OF CHAR;
        BEGIN
        RESULT := IntConversions.IntToString (i, 0);
        END Int;
        
      BEGIN
      Sep := SYSTEM.STRI(SYSTEM.Tab);
      IF Obj.Definition <> VOID THEN
        DefLineCount := Obj.Definition.LineCount;
        END;
      Line := "C" + Sep + 
              Obj.ModuleName + Sep + 
              Obj.Id.Data + Sep +
              Int(Obj.CyclomaticComplexity) + Sep + 
              Int(Obj.InheritanceDepth) + Sep +
              Int(Obj.LineCount) + Sep +
              Int(DefLineCount);
      Output.WriteLine (Line);
      FOR i := 0 TO Obj.Methods.Size - 1 DO
        Obj.Methods.Get(i).Gc.GenerateCode;
        END;
      END GenerateCode;

  END MetrClassImplCodeGenerator; 
           
   
END MetrGClass;



