IMPLEMENTATION MODULE MetrGModules;

FROM YaflModules           IMPORT CompilationUnit, 
                                  ImplementationModule,
                                  DefinitionModule,
                                  ModuleSet;
FROM YaflCfg               IMPORT CurrentSpot, YaflCfg;
FROM YaflCreator           IMPORT Creators;
FROM Streams               IMPORT StdOut,
                                  Stream;
FROM YaflClImplementation  IMPORT ClassImplementation;
FROM YaflClDefinition      IMPORT ClassDefinition;
FROM YaflClasses           IMPORT ClassDeclaration;
FROM YaflNTList            IMPORT DeclList, 
                                  MultiDeclList,
                                  ClassList,
                                  NTSet;
FROM YaflPredefined        IMPORT PredefItems;
FROM YaflMethods           IMPORT MethodDeclaration;
FROM YaflParser            IMPORT NonTerminal, Walker;
FROM YaflStatements        IMPORT Statement;
FROM String                IMPORT String;
FROM Conversions           IMPORT IntConversions;

FROM YaflCfg IMPORT YaflCfg;
FROM YaflController IMPORT Controller;

IMPORT SYSTEM;

  CLASS MetrImplModuleCodeGenerator;
    INHERITS CImplModuleCodeGenerator;
   
    REDEFINE METHOD GenerateCode;
      VAR
        TheOutput: YaflGC;
        Sep: ARRAY OF CHAR;
        ClList: DeclList(ClassImplementation);
         DefClasses: INTEGER;
        
      METHOD Int(i: INTEGER): ARRAY OF CHAR;
        BEGIN
        RESULT := IntConversions.IntToString (i, 0);
        END Int;
        
      BEGIN
      YaflCfg.GetController.Capture (Controller.GenerateMetrics);
      TheOutput.CREATE;
      TheOutput.OpenMetricsFile (Obj);
      IF TheOutput.ErrorCode = TheOutput.NoError THEN
        TheOutput.NoCut;
        Sep := SYSTEM.STRI (SYSTEM.Tab);
        ClList := Obj.Classes;
        DefClasses := Obj.DefModule.Classes.Size;
        IF ClList.Size > 0 THEN
          TheOutput.WriteLine ("M" + Sep + 
                          Obj.Id.Data + Sep + 
                          Int (Obj.LineCount) + Sep +
                          Int (Obj.DefModule.LineCount) + Sep +
                          Int (Obj.CommentsCount) + Sep +
                          Int (Obj.DefModule.CommentsCount) + Sep +
                          Int (ClList.Size) + Sep +
                          Int (DefClasses));
          Ctx.SetOutput(TheOutput);
          FOR i := 0 TO ClList.Size - 1 DO
            ClList.Get(i).Gc.GenerateCode;
            END;
          END;                        
        TheOutput.Close;
        Ctx.SetOutput(VOID);
        END;
      END GenerateCode;
      
  END MetrImplModuleCodeGenerator;
   
END MetrGModules;



