IMPLEMENTATION MODULE YaflGStatements;

FROM YaflStatements        IMPORT Statement;
FROM YaflGC                IMPORT YaflGC;
FROM YaflExpressions       IMPORT Expression;
FROM YaflCfg               IMPORT YaflCfg, CurrentSpot;
FROM Linked                IMPORT LinkedList, StringLinkable;
FROM String                IMPORT String;
FROM YaflPredefined        IMPORT PredefItems;
FROM YaflMetImplementation IMPORT MethodImplementation;
FROM YaflDeclarations      IMPORT SingleDataItem;
FROM YaflLiteral           IMPORT IntegerLiteral;
FROM Streams               IMPORT StdOut;
FROM YaflNTList            IMPORT NTList;
FROM YaflClasses           IMPORT ClassDeclaration;
FROM YaflParamClasses      IMPORT ClassActual, ClassFormal;
FROM List IMPORT List;
IMPORT SYSTEM;

   CLASS StatementCodeGenerator(ObjType IN Statement, CtxType IN GcContext);
     INHERITS GC(ObjType, CtxType);
     
   END StatementCodeGenerator;
      
--------------------------------------------------------
   
   CLASS DummyStatCodeGenerator(CtxType IN GcContext);
     INHERITS StatementCodeGenerator(Statement, CtxType);
     
   END DummyStatCodeGenerator;

--------------------------------------------------------

   CLASS NopStatementCodeGenerator(CtxType IN GcContext);
     INHERITS StatementCodeGenerator(NopStatement, CtxType);
     
   END NopStatementCodeGenerator;
   
--------------------------------------------------------

   CLASS AssignmentCodeGenerator(CtxType IN GcContext);
     INHERITS StatementCodeGenerator(Assignment, CtxType);
     
   END AssignmentCodeGenerator;
   
------------------------------------------------------------

   CLASS MethInvStatCodeGenerator(CtxType IN GcContext);
     INHERITS StatementCodeGenerator(MethodInvStatement, CtxType);
     
   END MethInvStatCodeGenerator;
   
--------------------------------------------------------

   CLASS DebugStatCodeGenerator(CtxType IN GcContext);
     INHERITS StatementCodeGenerator(DebugStatement, CtxType);
     
   END DebugStatCodeGenerator;

--------------------------------------------------------

   CLASS AssertStatCodeGenerator(CtxType IN GcContext);
     INHERITS StatementCodeGenerator(AssertStatement, CtxType);
     
   END AssertStatCodeGenerator;

--------------------------------------------------------

   CLASS InLineStatCodeGenerator(CtxType IN GcContext);
     INHERITS StatementCodeGenerator(InLineStatement, CtxType);
     
   END InLineStatCodeGenerator;

--------------------------------------------------------

   CLASS LoopStatCodeGenerator(CtxType IN GcContext);
     INHERITS StatementCodeGenerator(LoopStatement, CtxType);
     
   END LoopStatCodeGenerator;

--------------------------------------------------------

   CLASS IfStatCodeGenerator(CtxType IN GcContext);
     INHERITS StatementCodeGenerator(IfStatement, CtxType);
     
   END IfStatCodeGenerator;

--------------------------------------------------------

   CLASS ElsIfCodeGenerator(CtxType IN GcContext);
     INHERITS GC(IfAlt, CtxType);
     
   END ElsIfCodeGenerator;

--------------------------------------------------------

   CLASS CaseStatCodeGenerator(CtxType IN GcContext);
     INHERITS StatementCodeGenerator(CaseStatement, CtxType);
     
   END CaseStatCodeGenerator;

--------------------------------------------------------

   CLASS CaseAltCodeGenerator(CtxType IN GcContext);
     INHERITS GC(CaseAlt, CtxType);
     
   END CaseAltCodeGenerator;

--------------------------------------------------------

   CLASS CaseTagCodeGenerator(CtxType IN GcContext);
     INHERITS GC(CaseTag, CtxType);
     
   END CaseTagCodeGenerator;

--------------------------------------------------------

   CLASS WhatStatCodeGenerator(CtxType IN GcContext);
     INHERITS StatementCodeGenerator(WhatStatement, CtxType);
     
   END WhatStatCodeGenerator;

--------------------------------------------------------

   CLASS WhatAltCodeGenerator(CtxType IN GcContext);
     INHERITS GC(WhatAlt, CtxType);
     
   END WhatAltCodeGenerator;

--------------------------------------------------------

   CLASS WhatTagCodeGenerator(CtxType IN GcContext);
     INHERITS GC(WhatTag, CtxType);
     
   END WhatTagCodeGenerator;

--------------------------------------------------------

   CLASS StatListCodeGenerator(CtxType IN GcContext);
     INHERITS GC(StatementList, CtxType);
     
   END StatListCodeGenerator;
      
END YaflGStatements;
