IMPLEMENTATION MODULE YaflGType; 

FROM YaflType         IMPORT TypedNonTerminal;
FROM YaflPredefined   IMPORT PredefMethod,
                             PredefItems, 
                             PredefClass,
                             ThisDataItem;
FROM YaflClasses      IMPORT ClassDeclaration;
FROM YaflDeclarations IMPORT SingleDataItem, ConstDeclaration;
FROM YaflDictionary   IMPORT MethodReference, EntryReference,
                             CallReference,
                             CallDictionary;
FROM YaflParser       IMPORT NonTerminal, Walker, LimitedWalker;
FROM Streams          IMPORT StdOut;
FROM YaflLex          IMPORT LexicalAnalyzer;
FROM YaflParamClasses IMPORT ClassActual;
FROM YaflCfg          IMPORT CurrentSpot, YaflCfg;
FROM YaflError        IMPORT WarningHandler;
FROM YaflMetImplementation IMPORT MethodImplementation;
FROM YaflSystem IMPORT SystemMethod;
FROM YaflClImplementation IMPORT ClassImplementation;


  CLASS TypedNTCodeGenerator(ObjType IN TypedNonTerminal, CtxType IN GcContext);
    INHERITS GC(ObjType, CtxType);
    
  END TypedNTCodeGenerator;
  
----------------------------------------------------

  CLASS LiteralCodeGenerator(ObjType IN Literal, CtxType IN GcContext);
    INHERITS TypedNTCodeGenerator(ObjType, CtxType);
    
  END LiteralCodeGenerator;
  
----------------------------------------------------

  CLASS IntLiteralCodeGenerator(CtxType IN GcContext);
    INHERITS LiteralCodeGenerator(IntegerLiteral, CtxType);
    
  END IntLiteralCodeGenerator;
  
----------------------------------------------------

  CLASS RealLiteralCodeGenerator(CtxType IN GcContext);
    INHERITS LiteralCodeGenerator(RealLiteral, CtxType);
    
  END RealLiteralCodeGenerator;
  
----------------------------------------------------

  CLASS StringLiteralCodeGenerator(CtxType IN GcContext);
    INHERITS LiteralCodeGenerator(StringLiteral, CtxType);
    
  END StringLiteralCodeGenerator;
  
----------------------------------------------------

  CLASS BooleanLiteralCodeGenerator(CtxType IN GcContext);
    INHERITS LiteralCodeGenerator(BooleanLiteral, CtxType);
  
  END BooleanLiteralCodeGenerator;  
----------------------------------------------------

  CLASS VoidLitCodeGenerator(CtxType IN GcContext);
    INHERITS LiteralCodeGenerator(Void, CtxType);
    
  END VoidLitCodeGenerator;

----------------------------------------------------
  
  CLASS ExpressionCodeGenerator(CtxType IN GcContext);
    INHERITS TypedNTCodeGenerator(Expression, CtxType);
    
  END ExpressionCodeGenerator;
----------------------------------------------------
  
  CLASS QuantifierCodeGenerator(CtxType IN GcContext);
    INHERITS TypedNTCodeGenerator(Quantifier, CtxType);
    
  END QuantifierCodeGenerator;
----------------------------------------------------

  CLASS ActualCodeGenerator(CtxType IN GcContext);
    INHERITS GC(Actual, CtxType);
    
  END ActualCodeGenerator;

----------------------------------------------------

  CLASS TypeCodeGenerator(ObjType IN Type, CtxType IN GcContext);
    INHERITS GC(ObjType, CtxType);

  END TypeCodeGenerator;
  
----------------------------------------------------

  CLASS InstTypeCodeGenerator(CtxType IN GcContext);
    INHERITS TypeCodeGenerator(InstType, CtxType);
    
  END InstTypeCodeGenerator;
  
----------------------------------------------------

  CLASS DesigElementCodeGenerator(CtxType IN GcContext);
    INHERITS TypedNTCodeGenerator(DesigElement, CtxType);
    
  END DesigElementCodeGenerator;
  
----------------------------------------------------

  CLASS DesigCodeGenerator(CtxType IN GcContext);
    INHERITS TypedNTCodeGenerator(Desig, CtxType);
    
  END DesigCodeGenerator;
  
  
END YaflGType;

