#include <string.h>
#include <stdlib.h>
#include <yafl_rnt.h>

/*********************************************************/
void fail_assert YPARAMS4(char *, module, int, line)
{
  char a[200];
  
  yafl_err(YERR_ASSERT);
  sprintf (a, "Program assert failed in module '%s', line %d",
              module, line);
  emit_stdout (a);
  dump_trace();
  exit(1);
}
/*********************************************************/
void fail_void_obj YPARAMS6(char *, module, char *, class, char *, method)
{
  char a[200];
  
  yafl_err(YERR_VOID_OBJ);
  emit_stdout ("Void object method invocation:");
  sprintf (a, "\n\tmodule\t%s\n\tclass\t%s\n\tmethod\t%s\n", module, 
              class, method);
  emit_stdout(a);              
  dump_trace();
  exit(1);
}
/*********************************************************/
void fail_bad_class YPARAMS6(char *, module, 
			    char *, class, 
			    char *, method)
{
  char a[200];
  
  yafl_err(YERR_BAD_CLAS);
  emit_stdout ("Wrong class object:");
  sprintf (a, "\n\tmodule\t%s\n\tclass\t%s\n\tmethod\t%s\n", module, 
           class, method);
  emit_stdout(a);           
  dump_trace();
  exit(1);
}
/*********************************************************/
void fail_void_mth YPARAMS8(char*, module,
                           char*, class,
                           char*, method,
                           obj_ptr, p)
{
  char a[200];
  
  yafl_err(YERR_VOID_MTH);
  emit_stdout ("Void method pointer invocation:");
  sprintf (a, "\n\tmodule\t%s\n\tclass\t%s\n\tmethod\t%s\n", 
                module, class, method);
  emit_stdout(a);                
  sprintf (a, "\tin class %s\n", DUAL_OF(p)->class_name);
  emit_stdout(a);                
  dump_trace();
  exit(1);
}
/*********************************************************/
void fail_void_array YPARAMS0
{
  yafl_err(YERR_VOID_ARR);
  emit_stdout ("Void array reference\n");
  dump_trace();
  exit (1);
}
/*********************************************************/
void fail_for_step YPARAMS4(char*, module, int, line_nr)
{
  char a[200];
  
  yafl_err(YERR_FOR_STEP);
  sprintf (a, "For's step null in '%s', line %d\n", module, line_nr);
  emit_stdout(a);
  dump_trace();
  exit (1);
}
/*********************************************************/
void fail_idx_array YPARAMS4(YINT, max, YINT, got)
{
  char a[200];
  
  yafl_err(YERR_IDX_ARR);
  sprintf (a, "Index out of range: %d (%d)\n", got, max);
  emit_stdout(a);
  dump_trace();
  exit (1);
}
/*********************************************************/
void fail_version YPARAMS4(char *, importing,
                           minimal_dual*, dual)
{
  char a[200];
  
  yafl_err(YERR_VERSION);
  sprintf (a, "Version mismatch when importing %s.%s in %s\n", 
                                                     dual->module_name,
                                                     dual->class_name,
                                                     importing);
  emit_stdout(a);
/*
  dump_trace();
  exit (1);
*/
}
/*********************************************************/
void fail_what YPARAMS6(char*, module, int, line_nr, obj_ptr, weapon)
{
  char a[200];
  
  if (!weapon)
    {
      yafl_err(YERR_VOID_WHAT);
      sprintf (a, "void WHAT in module '%s', line %d\n", module, line_nr);
    }  
   else
    {
      yafl_err(YERR_BAD_WHAT);
      sprintf (a, "WHAT error in module '%s', line %d. Actual class is '%s'\n",
        module, line_nr, DUAL_OF(weapon)->class_name);
    }	
  emit_stdout(a);
  dump_trace();
  exit(1);
}
/*********************************************************/
void fail_case YPARAMS6(char*, module, int, line_nr, YINT, weapon)
{
  char a[200];
  
  yafl_err(YERR_BAD_CASE);
  sprintf (a, "CASE error in module '%s', line %d. Value of tag is %ld\n",
          module, line_nr, weapon);
  emit_stdout(a);          
  dump_trace();
  exit(1);
}
/*********************************************************/
void fail_dual_overflow YPARAMS6(char*, module, char*, class, char*, method)
{
  char a[200];
  
  yafl_err(YERR_DUAL_OVFL);
  emit_stdout ("Dual stack overflow");
  sprintf (a, "\n\tmodule\t%s\n\tclass\t%s\n\tmethod\t%s\n", module, 
                                                     class, method);
  emit_stdout(a);                                                     
  dump_trace();
  exit(1);
}
/*********************************************************/
void fail_prec YPARAMS0
{
  char a[200];
  
  yafl_err(YERR_PREC);
  sprintf (a, "Program precondition failed");
  emit_stdout (a);
  dump_trace();
  exit(1);
}
/*********************************************************/
void fail_post YPARAMS0
{
  char a[200];
  
  yafl_err(YERR_POST);
  sprintf (a, "Program postcondition failed");
  emit_stdout (a);
  dump_trace();
  exit(1);
}
/**/
