#ifndef DBX_BREAKPOINT_H
#define DBX_BREAKPOINT_H 1

#define BP_IGNORE 0
#define BP_BREAK 1
#define BP_LOG 2

typedef struct dbx_breakpoint
               {
                 dbx_method *method;
                 unsigned line;
                 unsigned counter;
                 unsigned step;
                 int action;
                 char *string;
               } dbx_breakpoint;

dbx_method *breakpoint_method YARGS((dbx_breakpoint * pb));
dbx_class *breakpoint_class YARGS((dbx_breakpoint *pb));
dbx_module *breakpoint_module YARGS((dbx_breakpoint *pb));
unsigned breakpoint_line YARGS((dbx_breakpoint * pb));
unsigned breakpoint_counter YARGS((dbx_breakpoint * pb));
unsigned breakpoint_step YARGS((dbx_breakpoint * pb));
int breakpoint_action YARGS((dbx_breakpoint * pb));
char *breakpoint_string YARGS((dbx_breakpoint * pb));
void inc_counter YARGS((dbx_breakpoint * pb));
void reset_counter YARGS((dbx_breakpoint * pb));
int breakpoint_evaluate YARGS((dbx_breakpoint * pb));
void add_breakpoint YARGS((dbx_method *pm,
                           unsigned line,
			   unsigned step,
			   int action,
			   char *string));
void sub_breakpoint YARGS((dbx_method *pm,unsigned line));
void sub2_breakpoint YARGS((unsigned number));
dbx_breakpoint *find_breakpoint YARGS((dbx_method *pm,unsigned line));
dbx_breakpoint *find2_breakpoint YARGS((unsigned number));
int search_breakpoint YARGS((dbx_module *pm,unsigned line));
dbx_breakpoint *current_breakpoint YARGS((void));

#endif
