#ifndef DBX_FIELD_H
#define DBX_FIELD_H 1

#ifdef XXX

typedef struct dbx_field
        {
          char *name;
          dbx_type *type;/* in fact this information does not really belong */
	                 /* to the debugger; dbx_type is an alias for minimal_*/
			 /* dual but we shouldn't see this at the interface */
			 /* level */
	                 /* there is a dual for each class or base type */
          unsigned level;
          struct dbx_field *next,*prev;
          dbx_class *class;
          VOID *once; /* NULL iif non-once field */
          unsigned offset; /* of the field in the class structure */
        } dbx_field;

#endif

/* 
typedef FIELD_INFO dbx_field;
*/

        
dbx_field *dbx_new_field YARGS((void));
char *field_name YARGS((dbx_field * pf));
int once_field YARGS((dbx_field * pf));
dbx_type *dbx_field_type YARGS((dbx_field * pf)); 
unsigned field_level YARGS((dbx_field * pf));
dbx_field *next_field YARGS((dbx_field * pf)); /* _of_class */
dbx_field *prev_field YARGS((dbx_field * pf)); /* _of_class */
dbx_class *field_class YARGS((dbx_field * pf));
VOID *field_data YARGS((dbx_field * pf));
VOID *get_fdata YARGS((dbx_field * pf,obj_ptr po));

dbx_field *find_next_field YARGS((dbx_field *pf,char *pattern));
dbx_field *find_prev_field YARGS((dbx_field *pf,char *pattern));

#ifdef XDEBUG
void dump_fields YARGS((void));
#endif

#endif
