IMPLEMENTATION MODULE Collection;

  CLASS Collection (Element);
  END Collection;
--------------------------------------------
  CLASS Cursor (Element);
  END Cursor;
--------------------------------------------
  CLASS SequentialCollection (Element);
    INHERITS Collection (Element);

    REDEFINE METHOD Row: ARRAY OF Element;
      VAR
        Curs: Cursor(Element);
      BEGIN
      RESULT.CREATE (Size);
      Curs := Start;
      FOR i := 0 TO RESULT.SIZE -1 DO
        RESULT [i] := Curs.Get;
        VOID := Curs.Next;
        END;
      END Row;

  END SequentialCollection;
--------------------------------------------
  CLASS RandomCollection (Element);
    INHERITS Collection (Element);

    REDEFINE METHOD Row: ARRAY OF Element;
      BEGIN
      RESULT.CREATE (Size);
      FOR i := 0 TO RESULT.SIZE -1 DO
        RESULT [i] := Get(i);
        END;
      END Row;
      
    METHOD Index (El: Element): INTEGER;
      BEGIN
      RESULT := -1;
      FOR i := 0 TO Size - 1 WHILE RESULT < 0 DO 
        IF Get(i) = El THEN
          RESULT := i;
          END;
        END;
      END Index;
      
    METHOD First: Element;
      BEGIN
      RESULT := Get(0);
      END First;

    METHOD Last: Element;
      BEGIN
      RESULT := Get(Size - 1);
      END Last;

  END RandomCollection;

END Collection;