IMPLEMENTATION MODULE Stack;

FROM List IMPORT List;

  CLASS Stack(Element);
    VAR
      TheList: List(Element);
      
    REDEFINE METHOD CREATE;
      BEGIN
      TheList.CREATE;
      END CREATE;
      
    METHOD Push(El: Element);
      BEGIN
      TheList.Append (El);
      END Push;
      
    METHOD Pop: Element;  
      BEGIN
      RESULT := Top;
      Drop;
      END Pop;
      
    METHOD Top: Element;
      BEGIN  
      ASSERT Depth > 0;
      RESULT := TheList.Get(TheList.Size - 1);
      END Top;
      
    METHOD Drop;
      BEGIN
      ASSERT Depth > 0;
      TheList.Delete (TheList.Size - 1);
      END Drop;
      
    METHOD Dup;
      BEGIN
      Push(Top);
      END Dup;
      
    METHOD Swap;
      VAR
        One, Two: Element;
      BEGIN
      ASSERT Depth > 1;
      One := Pop;
      Two := Pop;
      Push(One);
      Push(Two);
      END Swap;
      
    METHOD Purge;
      BEGIN
      TheList.Purge;
      END Purge;

    METHOD Depth: INTEGER;
      BEGIN
      RESULT := TheList.Size;
      END Depth;
      
  END Stack;

END Stack;
