//FILE: WINSOCK2.INC
//VERSION: 1.0
(*$W44- *)
(*$W53- *)

(*$I winbase.inc *)

type
	u_char = char;
	u_short = shortint;
	u_int = word;
	u_long = word;

	SOCKET = u_int;

const
	FD_SETSIZE = 64;
	FD_SETLAST = 63;

	MAXIMUM_WAIT_OBJECTS = 64;

	(* Commands for the ioctlsocket function *)
	FIONREAD   = $4004667F;
	FIONBIO    = $8004667E;
	FIOASYNC   = $8004667D;	(* not supported by ioctlsocket *)
	SIOCSHIWAT = $80047300;	(* not supported by ioctlsocket *)
	SIOCGHIWAT = $40047301;	(* not supported by ioctlsocket *)
	SIOCSLOWAT = $80047302;	(* not supported by ioctlsocket *)
	SIOCGLOWAT = $40047303;	(* not supported by ioctlsocket *)
	SIOCATMARK = $40047307;

type
	fd_set = packed record
		fd_count : u_int;							(* Number of sockets in the array *)
		fd_array : array[0..FD_SETLAST] of SOCKET;	(* array of sockets *)
	end;

	timeval = packed record
		tv_sec : integer;	(* seconds *)
		tv_usec : integer;	(* and micro-seconds (i.e. 1/1,000,000 of a second) *)
	end;

const
    IOCPARM_MASK = $7f;
    IOC_VOID = $20000000;
    IOC_OUT = $40000000;
    IOC_IN = $80000000;
    IOC_INOUT = $B0000000;

type
	hostent = packed record
		h_name : address;
		h_aliases : address;
		h_addrtype : shortint;
		h_length : shortint;
		h_addr_list : address;
	end;

	p_hostent = ^hostent;

	netent = packed record
		n_name : address;
		n_alises : address;
		n_addrtype : shortint;
		n_net : u_long;
	end;

	servent = packed record
		s_name : address;
		s_alises : address;
		s_port : shortint;
		s_proto : address;
	end;
	protoent = packed record
		p_name : address;
		p_aliases : address;
		p_proto : shortint;
	end;

const
    IPPROTO_IP = 0;
    IPPROTO_ICMP = 1;
    IPPROTO_IGMP = 2;
    IPPROTO_GGP = 3;
    IPPROTO_TCP = 6;
    IPPROTO_PUP = 12;
    IPPROTO_UDP = 17;
    IPPROTO_IDP = 22;
    IPPROTO_ND = 77;
    IPPROTO_RAW = 255;
    IPPROTO_MAX = 256;

    IPPORT_ECHO = 7;
    IPPORT_DISCARD = 9;
    IPPORT_SYSTAT = 11;
    IPPORT_DAYTIME = 13;
    IPPORT_NETSTAT = 15;
    IPPORT_FTP = 21;
    IPPORT_TELNET = 23;
    IPPORT_SMTP = 25;
    IPPORT_TIMESERVER = 37;
    IPPORT_NAMESERVER = 42;
    IPPORT_WHOIS = 43;
    IPPORT_MTP = 57;

    IPPORT_TFTP = 69;
    IPPORT_RJE = 77;
    IPPORT_FINGER = 79;
    IPPORT_TTYLINK = 87;
    IPPORT_SUPDUP = 95;

    IPPORT_EXECSERVER = 512;
    IPPORT_LOGINSERVER = 513;
    IPPORT_CMDSERVER = 514;
    IPPORT_EFSSERVER = 520;

    IPPORT_BIFFUDP = 512;
    IPPORT_WHOSERVER = 513;
    IPPORT_ROUTESERVER = 520;

	IPPORT_RESERVED = 1024;

    IMPLINK_IP = 155;
    IMPLINK_LOWEXPER = 156;
    IMPLINK_HIGHEXPER = 158;

type
	in_addr = u_long;

const
    IN_CLASSA_NET = $ff000000;
    IN_CLASSA_NSHIFT = 24;
    IN_CLASSA_HOST = $00ffffff;
    IN_CLASSA_MAX = 128;

    IN_CLASSB_NET = $ffff0000;
    IN_CLASSB_NSHIFT = 16;
    IN_CLASSB_HOST = $0000ffff;
    IN_CLASSB_MAX = 65536;

    IN_CLASSC_NET = $ffffff00;
    IN_CLASSC_NSHIFT = 8;
    IN_CLASSC_HOST = $000000ff;

    IN_CLASSD_NET = $f0000000;
    IN_CLASSD_NSHIFT = 28;
    IN_CLASSD_HOST = $0fffffff;

    INADDR_ANY = $00000000;
    INADDR_LOOPBACK = $7f000001;
    INADDR_BROADCAST = $ffffffff;
    INADDR_NONE = $ffffffff;
    ADDR_ANY = INADDR_ANY;

type
	sockaddr_in = packed record
		sin_family : shortint;
		sin_port : u_short;
		sin_addr : in_addr;
		sin_zero : packed array[1..8] of char;
	end;

const
    WSADESCRIPTION_LEN = 256;
    WSASYS_STATUS_LEN = 128;

type
	WSADATA = packed record
        wVersion : shortword;
        wHighVersion : shortword;
        szDescription : cstring[WSADESCRIPTION_LEN];
        szSystemStatus : cstring[WSASYS_STATUS_LEN];
        iMaxSockets : shortword;
        iMaxUdpDg : shortword;
        lpVendorInfo : address;
	end;

const
    INVALID_SOCKET = $ffffffff;
    SOCKET_ERROR = -1;

	FROM_PROTOCOL_INFO = -1;

    SOCK_STREAM = 1;
    SOCK_DGRAM = 2;
    SOCK_RAW = 3;
    SOCK_RDM = 4;
    SOCK_SEQPACKET = 5;

    SO_DEBUG = $0001;
    SO_ACCEPTCONN = $0002;
    SO_REUSEADDR = $0004;
    SO_KEEPALIVE = $0008;
    SO_DONTROUTE = $0010;
    SO_BROADCAST = $0020;
    SO_USELOOPBACK = $0040;
    SO_LINGER = $0080;
    SO_OOBINLINE = $0100;

	SO_DONTLINGER = $FFFFFF7F;

    SO_SNDBUF = $1001;
    SO_RCVBUF = $1002;
    SO_SNDLOWAT = $1003;
    SO_RCVLOWAT = $1004;
    SO_SNDTIMEO = $1005;
    SO_RCVTIMEO = $1006;
    SO_ERROR = $1007;
    SO_TYPE = $1008;

    SO_GROUP_ID = $2001;
    SO_GROUP_PRIORITY = $2002;
    SO_MAX_MSG_SIZE = $2003;
    SO_PROTOCOL_INFOA = $2004;
    SO_PROTOCOL_INFOW = $2005;
    SO_PROTOCOL_INFO = SO_PROTOCOL_INFOA;
    PVD_CONFIG = $3001;

	TCP_NODELAY = $0001;

	AF_UNSPEC = 0;
    AF_UNIX = 1;
    AF_INET = 2;
    AF_IMPLINK = 3;
    AF_PUP = 4;
    AF_CHAOS = 5;
    AF_NS = 6;
    AF_IPX = AF_NS;
    AF_ISO = 7;
    AF_OSI = AF_ISO;
    AF_ECMA = 8;
    AF_DATAKIT = 9;
    AF_CCITT = 10;
    AF_SNA = 11;
    AF_DECnet = 12;
    AF_DLI = 13;
    AF_LAT = 14;
    AF_HYLINK = 15;
    AF_APPLETALK = 16;
    AF_NETBIOS = 17;
    AF_VOICEVIEW = 18;
    AF_FIREFOX = 19;
    AF_UNKNOWN1 = 20;
    AF_BAN = 21;
    AF_ATM = 22;
    AF_INET6 = 23;
    AF_MAX = 24;

type
	sockaddr = packed record
		sa_family : u_short;
		sa_data : array[0..13] of char;
	end;

	sockproto = packed record
		sa_family : u_short;
		sp_protocol : u_short;
	end;

const
    PF_UNSPEC = AF_UNSPEC;
    PF_UNIX = AF_UNIX;
    PF_INET = AF_INET;
    PF_IMPLINK = AF_IMPLINK;
    PF_PUP = AF_PUP;
    PF_CHAOS = AF_CHAOS;
    PF_NS = AF_NS;
    PF_IPX = AF_IPX;
    PF_ISO = AF_ISO;
    PF_OSI = AF_OSI;
    PF_ECMA = AF_ECMA;
    PF_DATAKIT = AF_DATAKIT;
    PF_CCITT = AF_CCITT;
    PF_SNA = AF_SNA;
    PF_DECnet = AF_DECnet;
    PF_DLI = AF_DLI;
    PF_LAT = AF_LAT;
    PF_HYLINK = AF_HYLINK;
    PF_APPLETALK = AF_APPLETALK;
    PF_VOICEVIEW = AF_VOICEVIEW;
    PF_FIREFOX = AF_FIREFOX;
    PF_UNKNOWN1 = AF_UNKNOWN1;
    PF_BAN = AF_BAN;
    PF_ATM = AF_ATM;
    PF_INET6 = AF_INET6;
    PF_MAX = AF_MAX;

type
	linger = packed record
		l_onoff : u_short;
		l_linger : u_short;
	end;

const
	SOL_SOCKET = $ffff;

    SOMAXCONN = $7fffffff;

    MSG_OOB = $1;
    MSG_PEEK = $2;
    MSG_DONTROUTE = $4;
    MSG_PARTIAL = $8000;

    MSG_INTERRUPT = $10;
    MSG_MAXIOVLEN = 16;
    MAXGETHOSTSTRUCT = 1024;

    FD_READ_BIT = 0;
    FD_READ = 1;
    FD_WRITE_BIT = 1;
    FD_WRITE = 2;
    FD_OOB_BIT = 2;
    FD_OOB = 4;
    FD_ACCEPT_BIT = 3;
    FD_ACCEPT = 8;
    FD_CONNECT_BIT = 4;
    FD_CONNECT = 16;
    FD_CLOSE_BIT = 5;
    FD_CLOSE = 32;
    FD_QOS_BIT = 6;
    FD_QOS = 64;
    FD_GROUP_QOS_BIT = 7;
    FD_GROUP_QOS = 128;
    FD_MAX_EVENTS = 8;
    FD_LAST_EVENT = 7;
    FD_ALL_EVENTS = 255;

    WSABASEERR = 10000;
    WSAEINTR = 10004;
    WSAEBADF = 10009;
    WSAEACCES = 10013;
    WSAEFAULT = 10014;
    WSAEINVAL = 10022;
    WSAEMFILE = 10024;

    WSAEWOULDBLOCK = 10035;
    WSAEINPROGRESS = 10036;
    WSAEALREADY = 10037;
    WSAENOTSOCK = 10038;
    WSAEDESTADDRREQ = 10039;
    WSAEMSGSIZE = 10040;
    WSAEPROTOTYPE = 10041;
    WSAENOPROTOOPT = 10042;
    WSAEPROTONOSUPPORT = 10043;
    WSAESOCKTNOSUPPORT = 10044;
    WSAEOPNOTSUPP = 10045;
    WSAEPFNOSUPPORT = 10046;
    WSAEAFNOSUPPORT = 10047;
    WSAEADDRINUSE = 10048;
    WSAEADDRNOTAVAIL = 10049;
    WSAENETDOWN = 10050;
    WSAENETUNREACH = 10051;
    WSAENETRESET = 10052;
    WSAECONNABORTED = 10053;
    WSAECONNRESET = 10054;
    WSAENOBUFS = 10055;
    WSAEISCONN = 10056;
    WSAENOTCONN = 10057;
    WSAESHUTDOWN = 10058;
    WSAETOOMANYREFS = 10059;
    WSAETIMEDOUT = 10060;
    WSAECONNREFUSED = 10061;
    WSAELOOP = 10062;
    WSAENAMETOOLONG = 10063;
    WSAEHOSTDOWN = 10064;
    WSAEHOSTUNREACH = 10065;
    WSAENOTEMPTY = 10066;
    WSAEPROCLIM = 10067;
    WSAEUSERS = 10068;
    WSAEDQUOT = 10069;
    WSAESTALE = 10070;
    WSAEREMOTE = 10071;

    WSASYSNOTREADY = 10091;
    WSAVERNOTSUPPORTED = 10092;
    WSANOTINITIALISED = 10093;
    WSAEDISCON = 10101;
    WSAENOMORE = 10102;
    WSAECANCELLED = 10103;
    WSAEINVALIDPROCTABLE = 10104;
    WSAEINVALIDPROVIDER = 10105;
    WSAEPROVIDERFAILEDINIT = 10106;
    WSASYSCALLFAILURE = 10107;
    WSASERVICE_NOT_FOUND = 10108;
    WSATYPE_NOT_FOUND = 10109;
    WSA_E_NO_MORE = 10110;
    WSA_E_CANCELLED = 10111;
    WSAEREFUSED = 10112;

    WSAHOST_NOT_FOUND = 11001;
    HOST_NOT_FOUND = WSAHOST_NOT_FOUND;
    WSATRY_AGAIN = 11002;
    TRY_AGAIN = WSATRY_AGAIN;
    WSANO_RECOVERY = 11003;
    NO_RECOVERY = WSANO_RECOVERY;
    WSANO_DATA = 11004;
    NO_DATA = WSANO_DATA;
    WSANO_ADDRESS = WSANO_DATA;
    NO_ADDRESS = WSANO_ADDRESS;

    EWOULDBLOCK = WSAEWOULDBLOCK;
    EINPROGRESS = WSAEINPROGRESS;
    EALREADY = WSAEALREADY;
    ENOTSOCK = WSAENOTSOCK;
    EDESTADDRREQ = WSAEDESTADDRREQ;
    EMSGSIZE = WSAEMSGSIZE;
    EPROTOTYPE = WSAEPROTOTYPE;
    ENOPROTOOPT = WSAENOPROTOOPT;
    EPROTONOSUPPORT = WSAEPROTONOSUPPORT;
    ESOCKTNOSUPPORT = WSAESOCKTNOSUPPORT;
    EOPNOTSUPP = WSAEOPNOTSUPP;
    EPFNOSUPPORT = WSAEPFNOSUPPORT;
    EAFNOSUPPORT = WSAEAFNOSUPPORT;
    EADDRINUSE = WSAEADDRINUSE;
    EADDRNOTAVAIL = WSAEADDRNOTAVAIL;
    ENETDOWN = WSAENETDOWN;
    ENETUNREACH = WSAENETUNREACH;
    ENETRESET = WSAENETRESET;
    ECONNABORTED = WSAECONNABORTED;
    ECONNRESET = WSAECONNRESET;
    ENOBUFS = WSAENOBUFS;
    EISCONN = WSAEISCONN;
    ENOTCONN = WSAENOTCONN;
    ESHUTDOWN = WSAESHUTDOWN;
    ETOOMANYREFS = WSAETOOMANYREFS;
    ETIMEDOUT = WSAETIMEDOUT;
    ECONNREFUSED = WSAECONNREFUSED;
    ELOOP = WSAELOOP;
    ENAMETOOLONG = WSAENAMETOOLONG;
    EHOSTDOWN = WSAEHOSTDOWN;
    EHOSTUNREACH = WSAEHOSTUNREACH;
    ENOTEMPTY = WSAENOTEMPTY;
    EPROCLIM = WSAEPROCLIM;
    EUSERS = WSAEUSERS;
    EDQUOT = WSAEDQUOT;
    ESTALE = WSAESTALE;
    EREMOTE = WSAEREMOTE;

type
	WSAEVENT = HANDLE;
	LPWSAEVENT = address;
	WSAOVERLAPPED = OVERLAPPED;
	LPWSAOVERLAPPED = address;

const
    WSA_IO_PENDING = ERROR_IO_PENDING;
    WSA_IO_INCOMPLETE = ERROR_IO_INCOMPLETE;
    WSA_INVALID_HANDLE = ERROR_INVALID_HANDLE;
    WSA_INVALID_PARAMETER = ERROR_INVALID_PARAMETER;
    WSA_NOT_ENOUGH_MEMORY = ERROR_NOT_ENOUGH_MEMORY;
    WSA_OPERATION_ABORTED = ERROR_OPERATION_ABORTED;

    WSA_INVALID_EVENT = 0;
    WSA_MAXIMUM_WAIT_EVENTS = MAXIMUM_WAIT_OBJECTS;
    WSA_WAIT_FAILED = -1;
    WSA_WAIT_EVENT_0 = WAIT_OBJECT_0;
    WSA_WAIT_IO_COMPLETION = WAIT_IO_COMPLETION;
    WSA_WAIT_TIMEOUT = WAIT_TIMEOUT;
    WSA_INFINITE = INFINITE;

type
	WSABUF = packed record
		len : u_long;
		buf : address;
	end;

	GUARANTEE = (
		BestEffortService,
		ControlledLoadService,
		PredictiveService,
		GuaranteedDelayService,
    	GuaranteedService
    );


	int32 = integer;

	FLOWSPEC = packed record
	    TokenRate : int32;
    	TokenBucketSize : int32;
	    PeakBandwidth : int32;
    	Latency : int32;
	    DelayVariation : int32;
    	LevelOfGuarantee : GUARANTEE;
	    CostOfCall : int32;
    	NetworkAvailability : int32;
	end;
	
	QOS = packed record
	    SendingFlowspec : FLOWSPEC;
    	ReceivingFlowspec : FLOWSPEC;
	    ProviderSpecific : WSABUF;
	end;

const
    CF_ACCEPT = $0000;
    CF_REJECT = $0001;
    CF_DEFER = $0002;

    SD_RECEIVE = $00;
    SD_SEND = $01;
    SD_BOTH = $02;

type
	GROUP = word;

const
    SG_UNCONSTRAINED_GROUP = $01;
    SG_CONSTRAINED_GROUP = $02;

type
	WSANETWORKEVENTS = packed record
    	lNetworkEvents : integer;
    	iErrorCode : array[0..FD_LAST_EVENT] of integer;
	end;

const
    MAX_PROTOCOL_CHAIN = 7;
    BASE_PROTOCOL = 1;
    LAYERED_PROTOCOL = 0;

type
	WSAPROTOCOLCHAIN = packed record
		ChainLen : integer;
		ChainEntries : array[0..6] of DWORD;
	end;

const
	WSAPROTOCOL_LEN = 255;

type
	WSAPROTOCOL_INFO = packed record
	    dwServiceFlags1 : DWORD;
    	dwServiceFlags2 : DWORD;
	    dwServiceFlags3 : DWORD;
    	dwServiceFlags4 : DWORD;
	    dwProviderFlags : DWORD;
    	ProviderId : GUID;
	    dwCatalogEntryId : DWORD;
    	ProtocolChain : WSAPROTOCOLCHAIN;
	    iVersion : integer;
    	iAddressFamily : integer;
	    iMaxSockAddr : integer;
    	iMinSockAddr : integer;
	    iSocketType : integer;
    	iProtocol : integer;
	    iProtocolMaxOffset : integer;
    	iNetworkByteOrder : integer;
	    iSecurityScheme : integer;
    	dwMessageSize : DWORD;
	    dwProviderReserved : DWORD;
    	szProtocol : cstring[WSAPROTOCOL_LEN];
	end;

const
    PFL_MULTIPLE_PROTO_ENTRIES = $00000001;
    PFL_RECOMMENDED_PROTO_ENTRY = $00000002;
    PFL_HIDDEN = $00000004;
    PFL_MATCHES_PROTOCOL_ZERO = $00000008;

    XP1_CONNECTIONLESS = $00000001;
    XP1_GUARANTEED_DELIVERY = $00000002;
    XP1_GUARANTEED_ORDER = $00000004;
    XP1_MESSAGE_ORIENTED = $00000008;
    XP1_PSEUDO_STREAM = $00000010;
    XP1_GRACEFUL_CLOSE = $00000020;
    XP1_EXPEDITED_DATA = $00000040;
    XP1_CONNECT_DATA = $00000080;
    XP1_DISCONNECT_DATA = $00000100;
    XP1_SUPPORT_BROADCAST = $00000200;
    XP1_SUPPORT_MULTIPOINT = $00000400;
    XP1_MULTIPOINT_CONTROL_PLANE = $00000800;
    XP1_MULTIPOINT_DATA_PLANE = $00001000;
    XP1_QOS_SUPPORTED = $00002000;
    XP1_INTERRUPT = $00004000;
    XP1_UNI_SEND = $00008000;
    XP1_UNI_RECV = $00010000;
    XP1_IFS_HANDLES = $00020000;
    XP1_PARTIAL_MESSAGE = $00040000;

    BIGENDIAN = $0000;
    LITTLEENDIAN = $0001;

	SECURITY_PROTOCOL_NONE = $0000;

    JL_SENDER_ONLY = $01;
    JL_RECEIVER_ONLY = $02;
    JL_BOTH = $04;

    WSA_FLAG_OVERLAPPED = $01;
    WSA_FLAG_MULTIPOINT_C_ROOT = $02;
    WSA_FLAG_MULTIPOINT_C_LEAF = $04;
    WSA_FLAG_MULTIPOINT_D_ROOT = $08;
    WSA_FLAG_MULTIPOINT_D_LEAF = $10;

    IOC_UNIX = $00000000;
    IOC_WS2 = $08000000;
    IOC_PROTOCOL = $10000000;
    IOC_VENDOR = $18000000;

    TH_NETDEV = $00000001;
    TH_TAPI = $00000002;

type
	BLOB = packed record
		cbSize : ULONG;
		pBlobData : address;
	end;
	_LPBLOB = address;
	
const
	SERVICE_MULTIPLE = $00000001;

    NS_ALL = 0;
    NS_SAP = 1;
    NS_NDS = 2;
    NS_PEER_BROWSE = 3;
    NS_TCPIP_LOCAL = 10;
    NS_TCPIP_HOSTS = 11;
    NS_DNS = 12;
    NS_NETBT = 13;
    NS_WINS = 14;
    NS_NBP = 20;
    NS_MS = 30;
    NS_STDA = 31;
    NS_NTDS = 32;
    NS_X500 = 40;
    NS_NIS = 41;
    NS_NISPLUS = 42;
    NS_WRQ = 50;

    RES_UNUSED_1 = $00000001;
    RES_FLUSH_CACHE = $00000002;
    RES_SERVICE = $00000004;

    SERVICE_TYPE_VALUE_IPXPORTA = "IpxSocket";
    SERVICE_TYPE_VALUE_SAPIDA = "SapId";
    SERVICE_TYPE_VALUE_TCPPORTA = "TcpPort";
    SERVICE_TYPE_VALUE_UDPPORTA = "UdpPort";
    SERVICE_TYPE_VALUE_OBJECTIDA = "ObjectId";

    SERVICE_TYPE_VALUE_SAPID = SERVICE_TYPE_VALUE_SAPIDA;
    SERVICE_TYPE_VALUE_TCPPORT = SERVICE_TYPE_VALUE_TCPPORTA;
    SERVICE_TYPE_VALUE_UDPPORT = SERVICE_TYPE_VALUE_UDPPORTA;
    SERVICE_TYPE_VALUE_OBJECTID = SERVICE_TYPE_VALUE_OBJECTIDA;

type
	SOCKET_ADDRESS = packed record
	    lpSockaddr : address;
    	iSockaddrLength : integer;
	end;

	CSADDR_INFO = packed record
	    LocalAddr : SOCKET_ADDRESS;
    	RemoteAddr : SOCKET_ADDRESS;
	    iSocketType : integer;
    	iProtocol : integer;
	end;
	LPCSADDR_INFO = address;

	AFPROTOCOLS = packed record
	    iAddressFamily : integer;
    	iProtocol : integer;
	end;
	_LPAFPROTOCOLS = address;

	WSAECOMPARATOR = (COMP_EQUAL, COM_NOTLESS);

	WSAVERSION = packed record
		dwVersion : DWORD;
    	ecHow : WSAECOMPARATOR;
	end;
	LPWSAVERSION = address;

	WSAQUERYSET = packed record
	    dwSize : DWORD;
    	lpszServiceInstanceName : LPSTR;
	    lpServiceClassId : LPGUID;
    	lpVersion : LPWSAVERSION;
	    lpszComment : LPSTR;
    	dwNameSpace : DWORD;
	    lpNSProviderId : LPGUID;
    	lpszContext : LPSTR;
	    dwNumberOfProtocols : DWORD;
    	lpafpProtocols : _LPAFPROTOCOLS;
	    lpszQueryString : LPSTR;
    	dwNumberOfCsAddrs : DWORD;
	    lpcsaBuffer : LPCSADDR_INFO;
    	dwOutputFlags : DWORD;
	    lpBlob : _LPBLOB;
	end;

const
    LUP_DEEP = $0001;
    LUP_CONTAINERS = $0002;
    LUP_NOCONTAINERS = $0004;
    LUP_NEAREST = $0008;
    LUP_RETURN_NAME = $0010;
    LUP_RETURN_TYPE = $0020;
    LUP_RETURN_VERSION = $0040;
    LUP_RETURN_COMMENT = $0080;
    LUP_RETURN_ADDR = $0100;
    LUP_RETURN_BLOB = $0200;
    LUP_RETURN_ALIASES = $0400;
    LUP_RETURN_QUERY_STRING = $0800;
    LUP_RETURN_ALL = $0FF0;
    LUP_RES_SERVICE = $8000;
    LUP_FLUSHCACHE = $1000;
    LUP_FLUSHPREVIOUS = $2000;

	RESULT_IS_ALIAS = $0001;

type
	WSAESETSERVICEOP = (RNRSERVICE_REGISTER, RNRSERVICE_DEREGISTER, RNRSERVICE_DELETE);

	WSANSCLASSINFO = packed record
	    lpszName : LPSTR;
    	dwNameSpace : DWORD;
	    dwValueType : DWORD;
    	dwValueSize : DWORD;
	    lpValue : LPVOID;
	end;

	WSASERVICECLASSINFO = packed record
	    lpServiceClassId : LPGUID;
    	lpszServiceClassName : LPSTR;
	    dwCount : DWORD;
    	lpClassInfos : address;
	end;

	WSANAMESPACE_INFO = packed record
	    NSProviderId : GUID;
    	dwNameSpace : DWORD;
	    fActive : BOOL;
    	dwVersion : DWORD;
	    lpszIdentifier : LPSTR;
	end;

	function accept(s : SOCKET; addr : address; var addrlen : integer) : SOCKET;
		external dll='ws2_32.dll';
	function bind(s : SOCKET; name : address; namelen : integer) : integer;
		external dll='ws2_32.dll';
	function closesocket(s : SOCKET) : integer;
		external dll='ws2_32.dll';
	function connect(s : SOCKET; name : address; namelen : integer) : integer;
		external dll='ws2_32.dll';
	function ioctlsocket(s : SOCKET; cmd : integer; var argp : u_long) : integer;
		external dll='ws2_32.dll';
	function getpeername(s : SOCKET; name : address; var namelen : integer) : integer;
		external dll='wsock32.dll';
	function getsockname(s : SOCKET; name : address; var namelen : integer) : integer;
		external dll='wsock32.dll';
	function getsockopt(s : SOCKET; level, optname : integer; optval : address; var optlen : integer) : integer;
		external dll='ws2_32.dll';
	function htonl(hostlong : u_long) : u_long;
		external dll='ws2_32.dll';
	function htons(hostshort : u_short) : u_short;
		external dll='ws2_32.dll';
	function inet_addr(cp : address) : u_long;
		external dll='ws2_32.dll';
	function inet_ntoa(inaddr : in_addr) : address;
		external dll='ws2_32.dll';
	function listen(s : SOCKET; backlog : integer) : integer;
		external dll='ws2_32.dll';
	function ntohl(netlong : u_long) : u_long;
		external dll='ws2_32.dll';
	function ntohs(netshort : u_short) : u_short;
		external dll='ws2_32.dll';
	function recv(s : SOCKET; buf : address; len, flags : integer) : integer;
		external dll='ws2_32.dll';
	function recvfrom(s : SOCKET; buf : address; len, flags : integer;
						from : address; var fromlen : integer) : integer;
		external dll='ws2_32.dll';
	function select(nfds : integer; var readfds, writefds, exceptfds : fd_set;
					var tmeout : timeval) : integer;
		external dll='ws2_32.dll';
	function send(s : SOCKET; buf : address; len, flags : integer) : integer;
		external dll='ws2_32.dll';
	function sendto(s : SOCKET; buf : address; len, flags : integer;
					toaddr : address; tolen : integer) : integer;
		external dll='ws2_32.dll';
	function setsockopt(s : SOCKET; level, optname : integer; optval : address; optlen : integer) : integer;
		external dll='ws2_32.dll';
	function shutdown(s : SOCKET; how : integer) : integer;
		external dll='ws2_32.dll';
	function createsocket(af, typ, protocol : integer) : SOCKET;
		external dll='ws2_32.dll' name='socket';
	function gethostbyaddr(addr : address; len, typ : integer) : address;
		external dll='ws2_32.dll';
	function gethostbyname(name : address) : p_hostent;
		external dll='ws2_32.dll';
	function gethostname(name : address; namelen : integer) : integer;
		external dll='ws2_32.dll';
	function getservbyport(port : integer; proto : address) : address;
		external dll='ws2_32.dll';
	function getservbyname(name, proto : address) : address;
		external dll='ws2_32.dll';
	function getprotobynumber(number : integer) : address;
		external dll='ws2_32.dll';
	function getprotobyname(name : address) : address;
		external dll='ws2_32.dll';

	function WSAStartup(wVersionRequested : shortword; var lpWSAData : WSADATA) : integer;
		external dll='ws2_32.dll';
	function WSACleanup : integer;
		external dll='ws2_32.dll';
	procedure WSASetLastError(iError : integer);
		external dll='ws2_32.dll';
	function WSAGetLastError : integer;
		external dll='ws2_32.dll';
	function WSAIsBlocking : BOOL;
		external dll='wsock32.dll';
	function WSAUnhookBlockingHook : integer;
		external dll='wsock32.dll';
	function WSASetBlockingHook(lpBlockFunc : PROC) : PROC;
		external dll='wsock32.dll';
	function WSACancelBlockingCall : integer;
		external dll='wsock32.dll';
	function WSAAsyncGetServByName(hWnd : _HWND; wMsg : u_int; name, proto : address;
									buf : address; buflen : integer) : HANDLE;
		external dll='ws2_32.dll';
	function WSAAsyncGetServByPort(hWnd : _HWND; wMsg : u_int; port : integer; proto : address;
									buf : address; buflen : integer) : HANDLE;
		external dll='ws2_32.dll';
	function WSAAsyncGetProtoByName(hWnd : _HWND; wMsg : u_int; name : address;
									buf : address; buflen : integer) : HANDLE;
		external dll='ws2_32.dll';
	function WSAAsyncGetProtoByNumber(hWnd : _HWND; wMsg : u_int; number : integer;
									buf : address; buflen : integer) : HANDLE;
		external dll='ws2_32.dll';
	function WSAAsyncGetHostByName(hWnd : _HWND; wMsg : u_int; name : address;
									buf : address; buflen : integer) : HANDLE;
		external dll='ws2_32.dll';
	function WSAAsyncGetHostByAddr(hWnd : _HWND; wMsg : u_int; addr : address; len, typ : integer;
									buf : address; buflen : integer) : HANDLE;
		external dll='ws2_32.dll';
	function WSACancelAsyncRequest(hAsyncTaskHandle : HANDLE) : integer;
		external dll='ws2_32.dll';
	function WSAAsyncSelect(s : SOCKET; hWnd : _HWND; wMsg : u_int; lEvent : integer) : integer;
		external dll='ws2_32.dll';
	function WSACloseEvent(hEvent : WSAEVENT) : BOOL;
		external dll='ws2_32.dll';
	function WSAConnect(s : SOCKET; name : address; namelen : integer;
						var lpCallerData, lpCalleeData : WSABUF; lpSQOS, lpGQOS : QOS) : integer;
		external dll='ws2_32.dll';
	function WSACreateEvent : WSAEVENT;
		external dll='ws2_32.dll';
	function WSADuplicateSocket(s : SOCKET; dwProcessId : DWORD;
								var lpProtocolInfo : WSAPROTOCOL_INFO) : integer;
		external dll='ws2_32.dll' name='WSADuplicateSocketA';
	function WSAEnumNetworkEvents(s : SOCKET; hEventObject : WSAEVENT; var lpNetworkEvents : WSANETWORKEVENTS) : integer;
		external dll='ws2_32.dll';
	function WSAEnumProtocols(lpiProtocols : address; var lpProtocolBuffer : address;
								lpdwBufferLength : DWORD) : integer;
		external dll='ws2_32.dll' name='WSAEnumProtocolsA';
	function WSAEventSelect(s : SOCKET; hEventObj : WSAEVENT; lNetworkEvents : integer) : integer;
		external dll='ws2_32.dll';
	function WSAGetOverlappedResult(s : SOCKET; var lpOverlapped : WSAOVERLAPPED) : BOOL;
		external dll='ws2_32.dll';
	function WSAGetQOSByName(s : SOCKET; var lpQOSName : WSABUF; var lpQOS : QOS) : BOOL;
		external dll='ws2_32.dll';
	function WSAHtonl(s : SOCKET; hostlong : u_long; var lpnetlong : u_long) : integer;
		external dll='ws2_32.dll';
	function WSAHtons(s : SOCKET; hostshort : u_short; var lpnetshort : u_short) : integer;
		external dll='ws2_32.dll';
	function WSAIoctl(s : SOCKET; dwIoControlCode : DWORD; lpvInBuffer : LPVOID;
						cbInBuffer : DWORD; lpvOutBuffer : LPVOID;
						cbOutBuffer : DWORD; var lpcbBytesReturned : DWORD;
						var lpOverlapped : WSAOVERLAPPED; lpCompletionRoutine : PROC) : integer;
		external dll='ws2_32.dll';
	function WSAJoinLeaf(s : SOCKET; name : address; namelen : integer;
						var lpCallerData, lpCalleeData : WSABUF;
						var lpSQOS, lpGQOS : QOS; dwFlags : DWORD) : SOCKET;
		external dll='ws2_32.dll';
	function WSANtohl(s : SOCKET; netlong : u_long; var lphostlong : u_long) : integer;
		external dll='ws2_32.dll';
	function WSANtohs(s : SOCKET; netshort : u_short; var lphostshort : u_short) : integer;
		external dll='ws2_32.dll';
	function WSARecv(s : SOCKET; lpBuffers : address; dwBufferCount : DWORD; var lpNumberOfBytesRecvd : DWORD;
					var lpFlags : DWORD; var lpOverlapped : WSAOVERLAPPED;
					lpCompletionRoutine : PROC) : integer;
		external dll='ws2_32.dll';
	function WSARecvDisconnect(s : SOCKET; var lpInboundDisconnectData : WSABUF) : integer;
		external dll='ws2_32.dll';
	function WSARecvFrom(s : SOCKET; lpBuffers : address; dwBufferCount : DWORD;  var lpNumberOfBytesRecvd : DWORD;
						var lpFlags : DWORD; lpFrom : address; var lpFromLen : integer;
						var lpOverlapped : WSAOVERLAPPED; lpCompletionRoutine : PROC) : integer;
		external dll='ws2_32.dll';
	function WSAResetEvent(hEvent : WSAEVENT) : BOOL;
		external dll='ws2_32.dll';
	function WSASend(s : SOCKET; lpBuffers : address; dwBufferCount : DWORD; var lpNumberOfBytesRecvd : DWORD;
					dwFlags : DWORD; var lpOverlapped : WSAOVERLAPPED; lpCompletionRoutine : PROC) : integer;
		external dll='ws2_32.dll';
	function WSASendDisconnect(s : SOCKET; var lpInboundDisconnectData : WSABUF) : integer;
		external dll='ws2_32.dll';
	function WSASendTo(s : SOCKET; lpBuffers : address; dwBufferCount : DWORD; var lpNumberOfBytesRecvd : DWORD;
						dwFlags : DWORD; lpTo : address; iTolen : integer;
						var lpOverlapped : WSAOVERLAPPED; lpCompletionRoutine : PROC) : integer;
		external dll='ws2_32.dll';
	function WSASetEvent(hEvent : WSAEVENT) : BOOL;
		external dll='ws2_32.dll';
	function WSASocket(af, typ, protocol : integer; var lpProtocolInfo : WSAPROTOCOL_INFO;
						g : GROUP; dwFlags : DWORD) : SOCKET;
		external dll='ws2_32.dll' name='WSASocketA';
	function WSAWaitForMultipleEvents(cEvents : DWORD; lphEvents : address; fWaitAll : BOOL;
										dwTimeout : DWORD; fAlertable : BOOL) : DWORD;
		external dll='ws2_32.dll';
	function WSAAddressToString(lpszAddress : address; dwAddressLength : DWORD;
								var lpProtocolInfo : WSAPROTOCOL_INFO;
								lpszAddressString : address; var lpdwAddressStringLength : DWORD) : integer;
		external dll='ws2_32.dll' name='WSAAddressToStringA';
	function WSAStringToAddress(AddressString : address; AddressFamily : integer;
								var lpProtocolInfo : WSAPROTOCOL_INFO; lpAddress : address;
								var lpAddressLength : integer) : integer;
		external dll='ws2_32.dll' name='WSAStringToAddressA';
	function WSALookupServiceBegin(var lpqsRestrictions : WSAQUERYSET; dwControlFlags : DWORD;
									var lphLookup : HANDLE) : integer;
		external dll='ws2_32.dll' name='WSALookupServiceBeginA';
	function WSALookupServiceNext(hLookup : HANDLE; dwControlFlags : DWORD; var lpdwBufferLength : DWORD;
									var lpqsResults : WSAQUERYSET) : integer;
		external dll='ws2_32.dll' name='WSALookupServiceNextA';
	function WSALookupServiceEnd(hLookup : HANDLE) : integer;
		external dll='ws2_32.dll';
	function WSAInstallServiceClass(var lpServiceClassInfo : WSASERVICECLASSINFO) : integer;
		external dll='ws2_32.dll' name='WSAInstallServiceClassA';
	function WSARemoveServiceClass(var lpServiceClassId : GUID) : integer;
		external dll='ws2_32.dll';
	function WSAGetServiceClassInfo(var lpProviderId, lpServiceClassId : GUID;
									var lpdwBufSize : DWORD; var lpServiceClassInfo : WSASERVICECLASSINFO) : integer;
		external dll='ws2_32.dll' name='WSAGetServiceClassInfoA';
	function WSAEnumNameSpaceProviders(var lpdwBufferLength : DWORD; lpnspBuffer : address) : integer;
		external dll='ws2_32.dll' name='WSAEnumNameSpaceProvidersA';
	function WSAGetServiceClassNameByClassId(var lpServiceClassId : GUID;
											lpszServiceClassName : address;
											var lpdwBufferLength : DWORD) : integer;
		external dll='ws2_32.dll' name='WSAGetServiceClassNameByClassIdA';
	function WSASetService(var lpqsRegInfo : WSAQUERYSET; essoperation : WSAESETSERVICEOP;
							dwControlFlags : DWORD) : integer;
		external dll='ws2_32.dll' name='WSASetServiceA';

(*$W53. *)
(*$W44. *)
