//FILE: WINUSER.INC
//VERSION: 1.0

(*$W44- *)
(*$W53- *)

(*$I winbase.inc *)
(*$I commdlg.inc *)
(*$I wingdi.inc *)

type
	HDWP = HANDLE;

const
	//Predefined Resource Types
	RT_CURSOR = 1;
	RT_BITMAP = 2;
	RT_ICON = 3;
	RT_MENU = 4;
	RT_DIALOG = 5;
	RT_STRING = 6;
	RT_FONTDIR = 7;
	RT_FONT = 8;
	RT_ACCELERATOR = 9;
	RT_RCDATA = 10;
	RT_MESSAGETABLE = 11;

	DIFFERENCE = 11;
	RT_GROUP_CURSOR = 12;
	RT_GROUP_ICON = 14;
	RT_VERSION = 16;
	RT_DLGINCLUDE = 17;
	RT_PLUGPLAY = 19;
	RT_VXD = 20;
	RT_ANICURSOR = 21;
	RT_ANIICON = 22;

	//
 	// Scroll Bar Constants
 	//
	SB_HORZ = 0;
	SB_VERT = 1;
	SB_CTL = 2;
	SB_BOTH = 3;

	//
	// Scroll Bar Commands
	//
	SB_LINEUP = 0;
	SB_LINELEFT = 0;
	SB_LINEDOWN = 1;
	SB_LINERIGHT = 1;
	SB_PAGEUP = 2;
	SB_PAGELEFT = 2;
	SB_PAGEDOWN = 3;
	SB_PAGERIGHT = 3;
	SB_THUMBPOSITION = 4;
	SB_THUMBTRACK = 5;
	SB_TOP = 6;
	SB_LEFT = 6;
	SB_BOTTOM = 7;
	SB_RIGHT = 7;
	SB_ENDSCROLL = 8;

	//
	// ShowWindow() Commands
	//
	SW_HIDE = 0;
	SW_SHOWNORMAL = 1;
	SW_NORMAL = 1;
	SW_SHOWMINIMIZED = 2;
	SW_SHOWMAXIMIZED = 3;
	SW_MAXIMIZE = 3;
	SW_SHOWNOACTIVATE = 4;
	SW_SHOW = 5;
	SW_MINIMIZE = 6;
	SW_SHOWMINNOACTIVE = 7;
	SW_SHOWNA = 8;
	SW_RESTORE = 9;
	SW_SHOWDEFAULT = 10;
	SW_MAX = 10;

	//
	// Old ShowWindow() Commands
	//
	HIDE_WINDOW         = 0;
	SHOW_OPENWINDOW     = 1;
	SHOW_ICONWINDOW     = 2;
	SHOW_FULLSCREEN     = 3;
	SHOW_OPENNOACTIVATE = 4;

	//
	// Identifiers for the WM_SHOWWINDOW message
	//
	SW_PARENTCLOSING = 1;
	SW_OTHERZOOM     = 2;
	SW_PARENTOPENING = 3;
	SW_OTHERUNZOOM   = 4;

	//
	// WM_KEYUP/DOWN/CHAR HIWORD(lParam) flags
	//
	KF_EXTENDED = $0100;
	KF_DLGMODE  = $0800;
	KF_MENUMODE = $1000;
	KF_ALTDOWN  = $2000;
	KF_REPEAT   = $4000;
	KF_UP       = $8000;

	//
	// Virtual Keys, Standard Set
	//
	VK_LBUTTON  = $01;
	VK_RBUTTON  = $02;
	VK_CANCEL   = $03;
	VK_MBUTTON  = $04;
	VK_BACK     = $08;
	VK_TAB      = $09;
	VK_CLEAR    = $0C;
	VK_RETURN   = $0D;
	VK_SHIFT    = $10;
	VK_CONTROL  = $11;
	VK_MENU     = $12;
	VK_PAUSE    = $13;
	VK_CAPITAL  = $14;
	VK_ESCAPE   = $1B;
	VK_SPACE    = $20;
	VK_PRIOR    = $21;
	VK_NEXT     = $22;
	VK_END      = $23;
	VK_HOME     = $24;
	VK_LEFT     = $25;
	VK_UP       = $26;
	VK_RIGHT    = $27;
	VK_DOWN     = $28;
	VK_SELECT   = $29;
	VK_PRINT    = $2A;
	VK_EXECUTE  = $2B;
	VK_SNAPSHOT = $2C;
	VK_INSERT   = $2D;
	VK_DELETE   = $2E;
	VK_HELP     = $2F;

	// VK_0 thru VK_9 are the same as ASCII '0' thru '9' (0x30 - 0x39)
	// VK_A thru VK_Z are the same as ASCII 'A' thru 'Z' (0x41 - 0x5A)

	VK_LWIN        = $5B;
	VK_RWIN        = $5C;
	VK_APPS        = $5D;

	VK_NUMPAD0     = $60;
	VK_NUMPAD1     = $61;
	VK_NUMPAD2     = $62;
	VK_NUMPAD3     = $63;
	VK_NUMPAD4     = $64;
	VK_NUMPAD5     = $65;
	VK_NUMPAD6     = $66;
	VK_NUMPAD7     = $67;
	VK_NUMPAD8     = $68;
	VK_NUMPAD9     = $69;
	VK_MULTIPLY    = $6A;	
	VK_ADD         = $6B;
	VK_SEPARATOR   = $6C;
	VK_SUBTRACT    = $6D;
	VK_DECIMAL     = $6E;
	VK_DIVIDE      = $6F;
	VK_F1          = $70;	
	VK_F2          = $71;
	VK_F3          = $72;
	VK_F4          = $73;
	VK_F5          = $74;
	VK_F6          = $75;
	VK_F7          = $76;
	VK_F8          = $77;
	VK_F9          = $78;
	VK_F10         = $79;
	VK_F11         = $7A;
	VK_F12         = $7B;
	VK_F13         = $7C;
	VK_F14         = $7D;
	VK_F15         = $7E;
	VK_F16         = $7F;
	VK_F17         = $80;
	VK_F18         = $81;
	VK_F19         = $82;
	VK_F20         = $83;
	VK_F21         = $84;
	VK_F22         = $85;
	VK_F23         = $86;
	VK_F24         = $87;

	VK_NUMLOCK     = $90;
	VK_SCROLL      = $91;

	VK_LSHIFT      = $A0;
	VK_RSHIFT      = $A1;
	VK_LCONTROL    = $A2;
	VK_RCONTROL    = $A3;
	VK_LMENU       = $A4;
	VK_RMENU       = $A5;

	VK_PROCESSKEY  = $E5;

	VK_ATTN        = $F6;
	VK_CRSEL       = $F7;
	VK_EXSEL       = $F8;
	VK_EREOF       = $F9;
	VK_PLAY        = $FA;
	VK_ZOOM        = $FB;
	VK_NONAME      = $FC;
	VK_PA1         = $FD;
	VK_OEM_CLEAR   = $FE;

	//
	// SetWindowsHook() codes
	//
	WH_MIN              = -1;
	WH_MSGFILTER        = -1;
	WH_JOURNALRECORD    = 0;
	WH_JOURNALPLAYBACK  = 1;
	WH_KEYBOARD         = 2;
	WH_GETMESSAGE       = 3;
	WH_CALLWNDPROC      = 4;
	WH_CBT              = 5;
	WH_SYSMSGFILTER     = 6;
	WH_MOUSE            = 7;
	WH_HARDWARE         = 8;
	WH_DEBUG            = 9;
	WH_SHELL            = 10;
	WH_FOREGROUNDIDLE   = 11;
	WH_CALLWNDPROCRET   = 12;
	WH_MAX              = 12;
	WH_MINHOOK          = WH_MIN;
	WH_MAXHOOK          = WH_MAX;

	//
	// Hook Codes
	//
	HC_ACTION           = 0;
	HC_GETNEXT          = 1;
	HC_SKIP             = 2;
	HC_NOREMOVE         = 3;
	HC_NOREM            = HC_NOREMOVE;
	HC_SYSMODALON       = 4;
	HC_SYSMODALOFF      = 5;

	//
	// CBT Hook Codes
	//
	HCBT_MOVESIZE       = 0;
	HCBT_MINMAX         = 1;
	HCBT_QS             = 2;
	HCBT_CREATEWND      = 3;
	HCBT_DESTROYWND     = 4;
	HCBT_ACTIVATE       = 5;
	HCBT_CLICKSKIPPED   = 6;
	HCBT_KEYSKIPPED     = 7;
	HCBT_SYSCOMMAND     = 8;
	HCBT_SETFOCUS       = 9;

type
	CBT_CREATEWND = packed record
		lpcs : address;
		hwndInsertAfter : HWND;
	end;

	CBTACTIVATESTRUCT = packed record
		fMouse : BOOL;
		hWndActive : HWND;
	end;

const
	//
	// WH_MSGFILTER Filter Proc Codes
	//
	MSGF_DIALOGBOX     = 0;
	MSGF_MESSAGEBOX    = 1;
	MSGF_MENU          = 2;
	MSGF_MOVE          = 3;
	MSGF_SIZE          = 4;
	MSGF_SCROLLBAR     = 5;
	MSGF_NEXTWINDOW    = 6;
	MSGF_MAINLOOP      = 8;
	MSGF_MAX           = 8;
	MSGF_USER          = 4096;

	//
	// Shell support
	//
	HSHELL_WINDOWCREATED       = 1;
	HSHELL_WINDOWDESTROYED     = 2;
	HSHELL_ACTIVATESHELLWINDOW = 3;

	HSHELL_WINDOWACTIVATED     = 4;
	HSHELL_GETMINRECT          = 5;
	HSHELL_REDRAW              = 6;
	HSHELL_TASKMAN             = 7;
	HSHELL_LANGUAGE            = 8;

type
	EVENTMSG = packed record
    	message : UINT;
    	paramL : UINT;
    	paramH : UINT;
    	time : DWORD;
    	hwnd : _HWND;
	end;

	CWPSTRUCT = packed record
    	lParam : _LPARAM;
    	wParam : _WPARAM;
    	message : UINT;
    	hwnd : _HWND;
	end;

	CWPRETSTRUCT = packed record
    	lResult : _LRESULT;
    	lParam : _LPARAM;
    	wParam : _WPARAM;
    	message : UINT;
    	hwnd : _HWND;
	end;

	DEBUGHOOKINFO = packed record
    	idThread : DWORD;
    	idThreadInstaller : DWORD;
    	lParam : _LPARAM;
    	wParam : _WPARAM;
    	code : integer;
	end;

	MOUSEHOOKSTRUCT = packed record
		pt : POINT;
		hwnd : _HWND;
		wHitTestCode : UINT;
		dwExtraInfo : DWORD;
	end;

	HARDWAREHOOKSTRUCT = packed record
		hwnd : _HWND;
    	message : UINT;
    	wParam : _WPARAM;
    	lParam : _LPARAM;
	end;

const
	//
	// Keyboard Layout API
	//
	HKL_PREV  = 0;
	HKL_NEXT  = 1;


	KLF_ACTIVATE        = $00000001;
	KLF_SUBSTITUTE_OK   = $00000002;
	KLF_UNLOADPREVIOUS  = $00000004;
	KLF_REORDER         = $00000008;
	KLF_REPLACELANG     = $00000010;
	KLF_NOTELLSHELL     = $00000080;

	KL_NAMELENGTH       = 9;

	function LoadKeyboardLayout(pwszKLID : address; Flags : UINT) : HKL;
    	external dll='user32.dll' name='LoadKeyboardLayoutA' stdcall;

	function ActivateKeyboardLayout(hkl : _HKL; Flags : UINT) : _HKL;
    	external dll='user32.dll' name='ActivateKeyboardLayout' stdcall;

	function ToUnicodeEx(wVirtKey, wScanCode : UINT; var lpKeyState : BYTE;
							pwsaBuff : address; cchBuff : integer;
							wFlags : UINT; dwhkl : HKL) : integer;
    	external dll='user32.dll' name='ToUnicodeEx' stdcall;

	function UnloadKeyboardLayout(hkl : _HKL) : BOOL;
    	external dll='user32.dll' name='UnloadKeyboardLayout' stdcall;

	function GetKeyboardLayoutName(pwszKLID : address) : BOOL;
    	external dll='user32.dll' name='GetKeyboardLayoutNameA' stdcall;

	function GetKeyboardLayoutList(nBuff : integer; lpList : address) : integer;
    	external dll='user32.dll' name='GetKeyboardLayoutList' stdcall;

	function GetKeyboardLayout(dwLayout : DWORD) : HKL;
    	external dll='user32.dll' name='GetKeyboardLayout' stdcall;

const
	//
	// Desktop-specific access flags
	//
	DESKTOP_READOBJECTS        = $0001;
	DESKTOP_CREATEWINDOW       = $0002;
	DESKTOP_CREATEMENU         = $0004;
	DESKTOP_HOOKCONTROL        = $0008;
	DESKTOP_JOURNALRECORD      = $0010;
	DESKTOP_JOURNALPLAYBACK    = $0020;
	DESKTOP_ENUMERATE          = $0040;
	DESKTOP_WRITEOBJECTS       = $0080;
	DESKTOP_SWITCHDESKTOP      = $0100;

	//
	// Desktop-specific control flags
	//
	DF_ALLOWOTHERACCOUNTHOOK   = $0001;

	function CreateDesktop(lpszDesktop, lpszDevice : address;
							var pDevMode : DEVMODE;
							dwFlags, dwDesiredAccess : DWORD;
							var lpsz : SECURITY_ATTRIBUTES) : HDESK;
    	external dll='user32.dll' name='CreateDesktopA' stdcall;

	function OpenDesktop(lpszDesktop : address; dwFlags : DWORD; fInherit : BOOL;
							dwDesiredAccess : DWORD) : HDESK;
    	external dll='user32.dll' name='OpenDesktopA' stdcall;

	function OpenInputDesktop(dwFlags : DWORD; fInherit : BOOL; dwDesiredAccess : DWORD) : HDESK;
    	external dll='user32.dll' name='OpenInputDesktop' stdcall;

	function EnumDesktops(hwinsta : _HWINSTA; lpEnumFunc : PROC; lParam : _LPARAM) : BOOL;
    	external dll='user32.dll' name='EnumDesktopsA' stdcall;

	function EnumDesktopWindows(hDesktop : HDESK; lpfn : PROC; lParam : _LPARAM) : BOOL;
    	external dll='user32.dll' name='EnumDesktopWindows' stdcall;

	function SwitchDesktop(hDesktop : HDESK) : BOOL;
    	external dll='user32.dll' name='SwitchDesktop' stdcall;

	function SetThreadDesktop(hDesktop : HDESK) : BOOL;
    	external dll='user32.dll' name='SetThreadDesktop' stdcall;

	function CloseDesktop(hDesktop : HDESK) : BOOL;
    	external dll='user32.dll' name='CloseDesktop' stdcall;

	function GetThreadDesktop(dwThreadId : DWORD) : HDESK;
    	external dll='user32.dll' name='GetThreadDesktop' stdcall;

const
	//
	// Windowstation-specific access flags
	//
	WINSTA_ENUMDESKTOPS        = $0001;	
	WINSTA_READATTRIBUTES      = $0002;	
	WINSTA_ACCESSCLIPBOARD     = $0004;
	WINSTA_CREATEDESKTOP       = $0008;
	WINSTA_WRITEATTRIBUTES     = $0010;
	WINSTA_ACCESSGLOBALATOMS   = $0020;	
	WINSTA_EXITWINDOWS         = $0040;
	WINSTA_ENUMERATE           = $0100;
	WINSTA_READSCREEN          = $0200;

	//
	// Windowstation-specific attribute flags
	//
	WSF_VISIBLE                = $0001;

	function CreateWindowStation(lpwinsta : address; dwReserved : DWORD;
									dwDesiredAccess : DWORD;
									var lpsa : SECURITY_ATTRIBUTES) : HWINSTA;
    	external dll='user32.dll' name='CreateWindowStationA' stdcall;


	function OpenWindowStation(lpszWinSta : address; fInherit : BOOL;
								dwDesiredAccess : DWORD) : HWINSTA;
    	external dll='user32.dll' name='OpenWindowStationA' stdcall;

	function EnumWindowStations(lpEnumFunc : PROC; lParam : _LPARAM) : BOOL;
    	external dll='user32.dll' name='EnumWindowStationsA' stdcall;

	function CloseWindowStation(hWinSta : _HWINSTA) : BOOL;
    	external dll='user32.dll' name='CloseWindowStation' stdcall;

	function SetProcessWindowStation(hWinSta : _HWINSTA) : BOOL;
    	external dll='user32.dll' name='SetProcessWindowStation' stdcall;

	function GetProcessWindowStation : HWINSTA;
    	external dll='user32.dll' name='GetProcessWindowStation' stdcall;

	function SetUserObjectSecurity(hObj : HANDLE; var pSIRequested : SECURITY_INFORMATION;
									var pSID : SECURITY_DESCRIPTOR) : BOOL;
    	external dll='user32.dll' name='SetUserObjectSecurity' stdcall;

	function GetUserObjectSecurity(hObj : HANDLE; var pSIRequested : SECURITY_INFORMATION;
									var pSID : SECURITY_DESCRIPTOR; nLength : DWORD;
									var lpnLengthNeeded : DWORD) : BOOL;
    	external dll='user32.dll' name='GetUserObjectSecurity' stdcall;

const
	UOI_FLAGS      = 1;
	UOI_NAME       = 2;
	UOI_TYPE       = 3;
	UOI_USER_SID   = 4;

type
	USEROBJECTFLAGS = packed record
		fInherit : BOOL;
		fReserved : BOOL;
		dwFlags : DWORD;
	end;

	function GetUserObjectInformation(hObj : HANDLE; nIndex : integer; pvInfo : PVOID;
										nLength : DWORD; var lpnLengthNeeded : DWORD) : BOOL;
    	external dll='user32.dll' name='GetUserObjectInformationA' stdcall;

	function SetUserObjectInformationA(hObj : HANDLE; nIndex : integer; pvInfo : PVOID; nLength : DWORD) : BOOL;
    	external dll='user32.dll' name='SetUserObjectInformationA' stdcall;

type
	WNDCLASSEX = packed record
		cbSize : UINT;
		style : UINT;
		lpfnWndProc : PROC;
		cbClsExtra : integer;
		cbWndExtra : integer;
		hInstance : _HINSTANCE;
		hIcon : _HICON;
		hCursor : _HCURSOR;
		hbrBackground : HBRUSH;
		lpszMenuName : address;
		lpszClassName : address;
		hIconSm : _HICON;
	end;

	WNDCLASS = packed record
		style : UINT;
		lpfnWndProc : PROC;
		cbClsExtra : integer;
		cbWndExtra : integer;
		hInstance : _HINSTANCE;
		hIcon : _HICON;
		hCursor : _HCURSOR;
		hbrBackground : HBRUSH;
		lpszMenuName : address;
		lpszClassName : address;
	end;

	// Message structure
	MSG = packed record
		hwnd : _HWND;
		message : UINT;
		wParam : _WPARAM;
		lParam : _LPARAM;
		time : DWORD;
		pt : POINT;
	end;

const
	GWL_WNDPROC        = -4;
	GWL_HINSTANCE      = -6;
	GWL_HWNDPARENT     = -8;
	GWL_STYLE          = -16;
	GWL_EXSTYLE        = -20;
	GWL_USERDATA       = -21;
	GWL_ID             = -12;

	GCL_MENUNAME       = -8;
	GCL_HBRBACKGROUND  = -10;
	GCL_HCURSOR        = -12;	
	GCL_HICON          = -14;
	GCL_HMODULE        = -16;
	GCL_CBWNDEXTRA     = -18;
	GCL_CBCLSEXTRA     = -20;
	GCL_WNDPROC        = -24;
	GCL_STYLE          = -26;
	GCW_ATOM           = -32;
	GCL_HICONSM        = -34;

	//
	// Window Messages
	//
	WM_NULL            = $0000;
	WM_CREATE          = $0001;
	WM_DESTROY         = $0002;
	WM_MOVE            = $0003;
	WM_SIZE            = $0005;
	WM_ACTIVATE        = $0006;

	//
	// WM_ACTIVATE state values
	//
	WA_INACTIVE     = 0;
	WA_ACTIVE       = 1;
	WA_CLICKACTIVE  = 2;

	WM_SETFOCUS        = $0007;
	WM_KILLFOCUS       = $0008;
	WM_ENABLE          = $000A;
	WM_SETREDRAW       = $000B;
	WM_SETTEXT         = $000C;
	WM_GETTEXT         = $000D;
	WM_GETTEXTLENGTH   = $000E;
	WM_PAINT           = $000F;
	WM_CLOSE           = $0010;
	WM_QUERYENDSESSION = $0011;
	WM_QUIT            = $0012;
	WM_QUERYOPEN       = $0013;
	WM_ERASEBKGND      = $0014;
	WM_SYSCOLORCHANGE  = $0015;	
	WM_ENDSESSION      = $0016;
	WM_SHOWWINDOW      = $0018;
	WM_WININICHANGE    = $001A;
	WM_SETTINGCHANGE   = WM_WININICHANGE;

	WM_DEVMODECHANGE   = $001B;
	WM_ACTIVATEAPP     = $001C;
	WM_FONTCHANGE      = $001D;
	WM_TIMECHANGE      = $001E;
	WM_CANCELMODE      = $001F;
	WM_SETCURSOR       = $0020;
	WM_MOUSEACTIVATE   = $0021;
	WM_CHILDACTIVATE   = $0022;
	WM_QUEUESYNC       = $0023;
	WM_GETMINMAXINFO   = $0024;

type
	//
	// Struct pointed to by WM_GETMINMAXINFO lParam
	//
	MINMAXINFO = packed record
    	ptReserved : POINT;
    	ptMaxSize : POINT;
    	ptMaxPosition : POINT;
    	ptMinTrackSize : POINT;
    	ptMaxTrackSize : POINT;
	end;

const
	WM_PAINTICON          = $0026;
	WM_ICONERASEBKGND     = $0027;
	WM_NEXTDLGCTL         = $0028;
	WM_SPOOLERSTATUS      = $002A;
	WM_DRAWITEM           = $002B;
	WM_MEASUREITEM        = $002C;	
	WM_DELETEITEM         = $002D;
	WM_VKEYTOITEM         = $002E;
	WM_CHARTOITEM         = $002F;
	WM_SETFONT            = $0030;
	WM_GETFONT            = $0031;
	WM_SETHOTKEY          = $0032;
	WM_GETHOTKEY          = $0033;
	WM_QUERYDRAGICON      = $0037;
	WM_COMPAREITEM        = $0039;

    WM_COMPACTING = $0041;
    WM_COMMNOTIFY = $0044;
    WM_WINDOWPOSCHANGING = $0046;
    WM_WINDOWPOSCHANGED = $0047;

	WM_POWER = $0048;

    PWR_OK = 1;
    PWR_FAIL = -1;
    PWR_SUSPENDREQUEST = 1;
    PWR_SUSPENDRESUME = 2;
    PWR_CRITICALRESUME = 3;
    WM_COPYDATA = $004a;
    WM_CANCELJOURNAL = $004b;

type
	COPYDATASTRUCT = packed record
		dwData : DWORD;
		cbData : DWORD;
		lpData : PVOID;
	end;
const
    WM_NOTIFY = $004e;
    WM_INPUTLANGCHANGEREQUEST = $0050;
    WM_INPUTLANGCHANGE = $0051;
    WM_TCARD = $0052;
    WM_HELP = $0053;
    WM_USERCHANGED = $0054;
    WM_NOTIFYFORMAT = $0055;
    NFR_ANSI = 1;
    NFR_UNICODE = 2;
    NF_QUERY = 3;
    NF_REQUERY = 4;
    WM_CONTEXTMENU = $007b;
    WM_STYLECHANGING = $007c;
    WM_STYLECHANGED = $007d;
    WM_DISPLAYCHANGE = $007e;
    WM_GETICON = $007f;
    WM_SETICON = $0080;

    WM_NCCREATE = $0081;
    WM_NCDESTROY = $0082;
    WM_NCCALCSIZE = $0083;
    WM_NCHITTEST = $0084;
    WM_NCPAINT = $0085;
    WM_NCACTIVATE = $0086;
    WM_GETDLGCODE = $0087;
    WM_NCMOUSEMOVE = $00a0;
    WM_NCLBUTTONDOWN = $00a1;
    WM_NCLBUTTONUP = $00a2;
    WM_NCLBUTTONDBLCLK = $00a3;
    WM_NCRBUTTONDOWN = $00a4;
    WM_NCRBUTTONUP = $00a5;
    WM_NCRBUTTONDBLCLK = $00a6;
    WM_NCMBUTTONDOWN = $00a7;
    WM_NCMBUTTONUP = $00a8;
    WM_NCMBUTTONDBLCLK = $00a9;
    WM_KEYFIRST = $0100;
    WM_KEYDOWN = $0100;
    WM_KEYUP = $0101;
    WM_CHAR = $0102;
    WM_DEADCHAR = $0103;
    WM_SYSKEYDOWN = $0104;
    WM_SYSKEYUP = $0105;
    WM_SYSCHAR = $0106;
    WM_SYSDEADCHAR = $0107;
    WM_KEYLAST = $0108;

    WM_IME_STARTCOMPOSITION = $010d;
    WM_IME_ENDCOMPOSITION = $010e;
    WM_IME_COMPOSITION = $010f;
    WM_IME_KEYLAST = $010f;
    WM_INITDIALOG = $0110;
    WM_COMMAND = $0111;
    WM_SYSCOMMAND = $0112;
    WM_TIMER = $0113;
    WM_HSCROLL = $0114;
    WM_VSCROLL = $0115;
    WM_INITMENU = $0116;
    WM_INITMENUPOPUP = $0117;
    WM_MENUSELECT = $011f;
    WM_MENUCHAR = $0120;
    WM_ENTERIDLE = $0121;
    WM_CTLCOLORMSGBOX = $0132;
    WM_CTLCOLOREDIT = $0133;
    WM_CTLCOLORLISTBOX = $0134;
    WM_CTLCOLORBTN = $0135;
    WM_CTLCOLORDLG = $0136;
    WM_CTLCOLORSCROLLBAR = $0137;
    WM_CTLCOLORSTATIC = $0138;
    WM_MOUSEFIRST = $0200;
    WM_MOUSEMOVE = $0200;
    WM_LBUTTONDOWN = $0201;
    WM_LBUTTONUP = $0202;
    WM_LBUTTONDBLCLK = $0203;
    WM_RBUTTONDOWN = $0204;
    WM_RBUTTONUP = $0205;
    WM_RBUTTONDBLCLK = $0206;
    WM_MBUTTONDOWN = $0207;
    WM_MBUTTONUP = $0208;
    WM_MBUTTONDBLCLK = $0209;
    WM_MOUSEWHEEL = $020a;
    WM_MOUSELAST = $020a;

    WHEEL_DELTA = 120;
    WHEEL_PAGESCROLL = maxword;
    WM_PARENTNOTIFY = $0210;
    MENULOOP_WINDOW = 0;
    MENULOOP_POPUP = 1;
    WM_ENTERMENULOOP = $0211;
    WM_EXITMENULOOP = $0212;
    WM_NEXTMENU = $0213;

type
	MDINEXTMENU = packed record
		hmenuIn : HMENU;
		hmenuNext : HMENU;
		hwndNext : HWND;
	end;

const
    WM_SIZING = $0214;
    WM_CAPTURECHANGED = $0215;
    WM_MOVING = $0216;
    WM_POWERBROADCAST = $0218;
    WM_DEVICECHANGE = $0219;
    WM_IME_SETCONTEXT = $0281;
    WM_IME_NOTIFY = $0282;
    WM_IME_CONTROL = $0283;
    WM_IME_COMPOSITIONFULL = $0284;
    WM_IME_SELECT = $0285;
    WM_IME_CHAR = $0286;
    WM_IME_KEYDOWN = $0290;
    WM_IME_KEYUP = $0291;
    WM_MDICREATE = $0220;
    WM_MDIDESTROY = $0221;
    WM_MDIACTIVATE = $0222;
    WM_MDIRESTORE = $0223;
    WM_MDINEXT = $0224;
    WM_MDIMAXIMIZE = $0225;
    WM_MDITILE = $0226;
    WM_MDICASCADE = $0227;
    WM_MDIICONARRANGE = $0228;
    WM_MDIGETACTIVE = $0229;
    WM_MDISETMENU = $0230;
    WM_ENTERSIZEMOVE = $0231;
    WM_EXITSIZEMOVE = $0232;
    WM_DROPFILES = $0233;
    WM_MDIREFRESHMENU = $0234;

    WM_MOUSEHOVER = $02A1;
    WM_MOUSELEAVE = $02A3;
    WM_CUT = $0300;
    WM_COPY = $0301;
    WM_PASTE = $0302;
    WM_CLEAR = $0303;
    WM_UNDO = $0304;
    WM_RENDERFORMAT = $0305;
    WM_RENDERALLFORMATS = $0306;
    WM_DESTROYCLIPBOARD = $0307;
    WM_DRAWCLIPBOARD = $0308;
    WM_PAINTCLIPBOARD = $0309;
    WM_VSCROLLCLIPBOARD = $030A;
    WM_SIZECLIPBOARD = $030B;
    WM_ASKCBFORMATNAME = $030C;
    WM_CHANGECBCHAIN = $030D;
    WM_HSCROLLCLIPBOARD = $030E;
    WM_QUERYNEWPALETTE = $030F;
    WM_PALETTEISCHANGING = $0310;
    WM_PALETTECHANGED = $0311;
    WM_HOTKEY = $0312;

    WM_PRINT = $0317;
    WM_PRINTCLIENT = $0318;
    WM_HANDHELDFIRST = $0358;
    WM_HANDHELDLAST = $035F;
    WM_AFXFIRST = $0360;
    WM_AFXLAST = $037F;
    WM_PENWINFIRST = $0380;
    WM_PENWINLAST = $038F;
    WM_APP = $8000;

	WM_USER = $0400;

    WMSZ_LEFT = 1;
    WMSZ_RIGHT = 2;
    WMSZ_TOP = 3;
    WMSZ_TOPLEFT = 4;
    WMSZ_TOPRIGHT = 5;
    WMSZ_BOTTOM = 6;
    WMSZ_BOTTOMLEFT = 7;
    WMSZ_BOTTOMRIGHT = 8;

    ST_BEGINSWP = 0;
    ST_ENDSWP = 1;

    HTERROR = -2;
    HTTRANSPARENT = -1;
    HTNOWHERE = 0;
    HTCLIENT = 1;
    HTCAPTION = 2;
    HTSYSMENU = 3;
    HTGROWBOX = 4;
    HTSIZE = HTGROWBOX;
    HTMENU = 5;
    HTHSCROLL = 6;
    HTVSCROLL = 7;
    HTMINBUTTON = 8;
    HTMAXBUTTON = 9;
    HTLEFT = 10;
    HTRIGHT = 11;
    HTTOP = 12;
    HTTOPLEFT = 13;
    HTTOPRIGHT = 14;
    HTBOTTOM = 15;
    HTBOTTOMLEFT = 16;
    HTBOTTOMRIGHT = 17;
    HTBORDER = 18;
    HTREDUCE = HTMINBUTTON;
    HTZOOM = HTMAXBUTTON;
    HTSIZEFIRST = HTLEFT;
    HTSIZELAST = HTBOTTOMRIGHT;
    HTOBJECT = 19;
    HTCLOSE = 20;
    HTHELP = 21;

    SMTO_NORMAL = $0000;
    SMTO_BLOCK = $0001;
    SMTO_ABORTIFHUNG = $0002;

    MA_ACTIVATE = 1;
    MA_ACTIVATEANDEAT = 2;
    MA_NOACTIVATE = 3;
    MA_NOACTIVATEANDEAT = 4;

    ICON_SMALL = 0;
    ICON_BIG = 1;

	function RegisterWindowMessage(lpString : address) : UINT;
    	external dll='user32.dll' name='RegisterWindowMessageA' stdcall;

const
    SIZE_RESTORED = 0;
    SIZE_MINIMIZED = 1;
    SIZE_MAXIMIZED = 2;
    SIZE_MAXSHOW = 3;
    SIZE_MAXHIDE = 4;
    SIZENORMAL = SIZE_RESTORED;
    SIZEICONIC = SIZE_MINIMIZED;
    SIZEFULLSCREEN = SIZE_MAXIMIZED;
    SIZEZOOMSHOW = SIZE_MAXSHOW;
    SIZEZOOMHIDE = SIZE_MAXHIDE;

type
	WINDOWPOS = packed record
    	hwnd : _HWND;
    	hwndInsertAfter : _HWND;
    	x : integer;
    	y : integer;
    	cx : integer;
    	cy : integer;
    	flags : UINT;
	end;

	NCCALCSIZE_PARAMS = packed record
		rgrc : array[0..2] of RECT;
		lppos : address;
	end;

const
    WVR_ALIGNTOP = $0010;
    WVR_ALIGNLEFT = $0020;
    WVR_ALIGNBOTTOM = $0040;
    WVR_ALIGNRIGHT = $0080;
    WVR_HREDRAW = $0100;
    WVR_VREDRAW = $0200;
    WVR_REDRAW = $0300;
    WVR_VALIDRECTS = $0400;

    MK_LBUTTON = $0001;
    MK_RBUTTON = $0002;
    MK_SHIFT = $0004;
    MK_CONTROL = $0008;
    MK_MBUTTON = $0010;

    TME_HOVER = $00000001;
    TME_LEAVE = $00000002;
    TME_QUERY = $40000000;
    TME_CANCEL = $80000000;
    HOVER_DEFAULT = $FFFFFFFF;

type
	TRACK_MOUSE_EVENT = packed record
		cbSize : DWORD;
		dwFlags : DWORD;
		hwndTrack : HWND;
		dwHoverTime : DWORD;
	end;

	function TrackMouseEvent(var lpEventTrack : TRACK_MOUSE_EVENT) : BOOL;
    	external dll='user32.dll';

const
    WS_OVERLAPPED = $00000000;
    WS_POPUP = $80000000;
    WS_CHILD = $40000000;
    WS_MINIMIZE = $20000000;
    WS_VISIBLE = $10000000;
    WS_DISABLED = $08000000;
    WS_CLIPSIBLINGS = $04000000;
    WS_CLIPCHILDREN = $02000000;
    WS_MAXIMIZE = $01000000;
    WS_CAPTION = $00C00000;
    WS_BORDER = $00800000;
    WS_DLGFRAME = $00400000;
    WS_VSCROLL = $00200000;
    WS_HSCROLL = $00100000;
    WS_SYSMENU = $00080000;
    WS_THICKFRAME = $00040000;
    WS_GROUP = $00020000;
    WS_TABSTOP = $00010000;
    WS_MINIMIZEBOX = $00020000;
    WS_MAXIMIZEBOX = $00010000;
    WS_TILED = WS_OVERLAPPED;
    WS_ICONIC = WS_MINIMIZE;
    WS_SIZEBOX = WS_THICKFRAME;
	WS_OVERLAPPEDWINDOW = $00CF0000;
    WS_TILEDWINDOW = WS_OVERLAPPEDWINDOW;

	WS_POPUPWINDOW = $80880000;

    WS_CHILDWINDOW = WS_CHILD;
    WS_EX_DLGMODALFRAME = $00000001;
    WS_EX_NOPARENTNOTIFY = $00000004;
    WS_EX_TOPMOST = $00000008;
    WS_EX_ACCEPTFILES = $00000010;
    WS_EX_TRANSPARENT = $00000020;
    WS_EX_MDICHILD = $00000040;
    WS_EX_TOOLWINDOW = $00000080;
    WS_EX_WINDOWEDGE = $00000100;
    WS_EX_CLIENTEDGE = $00000200;
    WS_EX_CONTEXTHELP = $00000400;
    WS_EX_RIGHT = $00001000;
    WS_EX_LEFT = $00000000;
    WS_EX_RTLREADING = $00002000;
    WS_EX_LTRREADING = $00000000;
    WS_EX_LEFTSCROLLBAR = $00004000;
    WS_EX_RIGHTSCROLLBAR = $00000000;
    WS_EX_CONTROLPARENT = $00010000;
    WS_EX_STATICEDGE = $00020000;
    WS_EX_APPWINDOW = $00040000;

    WS_EX_OVERLAPPEDWINDOW = $00000300;
    WS_EX_PALETTEWINDOW = $00000188;
    CS_VREDRAW = $0001;
    CS_HREDRAW = $0002;
    CS_KEYCVTWINDOW = $0004;
    CS_DBLCLKS = $0008;
    CS_OWNDC = $0020;
    CS_CLASSDC = $0040;
    CS_PARENTDC = $0080;
    CS_NOKEYCVT = $0100;
    CS_NOCLOSE = $0200;
    CS_SAVEBITS = $0800;
    CS_BYTEALIGNCLIENT = $1000;
    CS_BYTEALIGNWINDOW = $2000;
    CS_GLOBALCLASS = $4000;
    CS_IME = $00010000;

    PRF_CHECKVISIBLE = $00000001;
    PRF_NONCLIENT = $00000002;
    PRF_CLIENT = $00000004;
    PRF_ERASEBKGND = $00000008;
    PRF_CHILDREN = $00000010;
    PRF_OWNED = $00000020;
    BDR_RAISEDOUTER = $0001;
    BDR_SUNKENOUTER = $0002;
    BDR_RAISEDINNER = $0004;
    BDR_SUNKENINNER = $0008;
    BDR_OUTER = $0003;
    BDR_INNER = $000c;
    BDR_RAISED = $0005;
    BDR_SUNKEN = $000a;

    EDGE_RAISED = $0005;
    EDGE_SUNKEN = $000A;
    EDGE_ETCHED = $0006;
    EDGE_BUMP = $0009;
    BF_LEFT = $0001;
    BF_TOP = $0002;
    BF_RIGHT = $0004;
    BF_BOTTOM = $0008;

    BF_TOPLEFT = $0003;
    BF_TOPRIGHT = $0006;
    BF_BOTTOMLEFT = $0009;
    BF_BOTTOMRIGHT = $000C;
    BF_RECT = $000F;
    BF_DIAGONAL = $0010;
    BF_DIAGONAL_ENDTOPRIGHT = $0016;
    BF_DIAGONAL_ENDTOPLEFT = $0013;
    BF_DIAGONAL_ENDBOTTOMLEFT = $0019;
    BF_DIAGONAL_ENDBOTTOMRIGHT = $001C;
    BF_MIDDLE = $0800;
    BF_SOFT = $1000;
    BF_ADJUST = $2000;
    BF_FLAT = $4000;
    BF_MONO = $8000;

	function DrawEdge(hdc : _HDC; var qrc : RECT; edge, grfFlags : UINT) : BOOL;
    	external dll='user32.dll';

const
    DFC_CAPTION = 1;
    DFC_MENU = 2;
    DFC_SCROLL = 3;
    DFC_BUTTON = 4;
    DFCS_CAPTIONCLOSE = $0000;
    DFCS_CAPTIONMIN = $0001;
    DFCS_CAPTIONMAX = $0002;
    DFCS_CAPTIONRESTORE = $0003;
    DFCS_CAPTIONHELP = $0004;
    DFCS_MENUARROW = $0000;
    DFCS_MENUCHECK = $0001;
    DFCS_MENUBULLET = $0002;
    DFCS_MENUARROWRIGHT = $0004;
    DFCS_SCROLLUP = $0000;
    DFCS_SCROLLDOWN = $0001;
    DFCS_SCROLLLEFT = $0002;
    DFCS_SCROLLRIGHT = $0003;
    DFCS_SCROLLCOMBOBOX = $0005;
    DFCS_SCROLLSIZEGRIP = $0008;
    DFCS_SCROLLSIZEGRIPRIGHT = $0010;
    DFCS_BUTTONCHECK = $0000;
    DFCS_BUTTONRADIOIMAGE = $0001;
    DFCS_BUTTONRADIOMASK = $0002;
    DFCS_BUTTONRADIO = $0004;
    DFCS_BUTTON3STATE = $0008;
    DFCS_BUTTONPUSH = $0010;
    DFCS_INACTIVE = $0100;
    DFCS_PUSHED = $0200;
    DFCS_CHECKED = $0400;
    DFCS_ADJUSTRECT = $2000;
    DFCS_FLAT = $4000;
    DFCS_MONO = $8000;

	function DrawFrameControl(hdc : _HDC; var lprc : RECT; uType, uState : UINT) : BOOL;
    	external dll='user32.dll';

const
    DC_ACTIVE = $0001;
    DC_SMALLCAP = $0002;
    DC_ICON = $0004;
    DC_TEXT = $0008;
    DC_INBUTTON = $0010;

	function DrawCaption(hwnd : _HWND; hdc : _HDC; var lprc : RECT; flags : UINT) : BOOL;
    	external dll='user32.dll';

const
    IDANI_OPEN = 1;
    IDANI_CLOSE = 2;
    IDANI_CAPTION = 3;

	function DrawAnimatedRecs(hwnd : _HWND; idAni : integer; var lprcFrom, lprecTo : RECT) : BOOL;
    	external dll='user32.dll';

const
    CF_TEXT = 1;
    CF_BITMAP = 2;
    CF_METAFILEPICT = 3;
    CF_SYLK = 4;
    CF_DIF = 5;
    CF_TIFF = 6;
    CF_OEMTEXT = 7;
    CF_DIB = 8;
    CF_PALETTE = 9;
    CF_PENDATA = 10;
    CF_RIFF = 11;
    CF_WAVE = 12;
    CF_UNICODETEXT = 13;
    CF_ENHMETAFILE = 14;
    CF_HDROP = 15;
    CF_LOCALE = 16;
    CF_MAX = 17;
    CF_OWNERDISPLAY = $0080;
    CF_DSPTEXT = $0081;
    CF_DSPBITMAP = $0082;
    CF_DSPMETAFILEPICT = $0083;
    CF_DSPENHMETAFILE = $008E;

    CF_PRIVATEFIRST = $0200;
    CF_PRIVATELAST = $02FF;
    CF_GDIOBJFIRST = $0300;
    CF_GDIOBJLAST = $03FF;

    FVIRTKEY = TRUE;
    FNOINVERT = $02;
    FSHIFT = $04;
    FCONTROL = $08;
    FALT = $10;

type
	ACCEL = packed record
		fVirt : BYTE;
		key : USHORT;
		cmd : USHORT;
	end;

	PAINTSTRUCT = packed record
		hdc : _HDC;
		fErase : BOOL;
		rcPaint : RECT;
		fRestore : BOOL;
		fIncUpdate : BOOL;
		rgbReserved : array[0..31] of BYTE;
	end;

	CREATESTRUCT = packed record
		lpCreateParams : LPVOID;
		hInstance : _HINSTANCE;
		hMenu : _HMENU;
		hwndParent : HWND;
		cy : integer;
		cx : integer;
		y : integer;
		x : integer;
		style : LONG;
		lpszName : LPCSTR;
		lpszClass : LPCSTR;
		dwExStyle : DWORD;
	end;

	WINDOWPLACEMENT = packed record
		length : UINT;
		flags : UINT;
		showCmd : UINT;
		ptMinPosition : POINT;
		ptMaxPosition : POINT;
		rcNormalPosition : RECT;
	end;

const
    WPF_SETMINPOSITION = $0001;
    WPF_RESTORETOMAXIMIZED = $0002;

type
	NMHDR = packed record
		hwndFrom : HWND;
		idFrom : UINT;
		code : UINT;
	end;

	STYLESTRUCT = packed record
		styleOld : DWORD;
		styleNew : DWORD;
	end;

const
    ODT_MENU = 1;
    ODT_LISTBOX = 2;
    ODT_COMBOBOX = 3;
    ODT_BUTTON = 4;
    ODT_STATIC = 5;
    ODA_DRAWENTIRE = $0001;
    ODA_SELECT = $0002;
    ODA_FOCUS = $0004;
    ODS_SELECTED = $0001;
    ODS_GRAYED = $0002;
    ODS_DISABLED = $0004;
    ODS_CHECKED = $0008;
    ODS_FOCUS = $0010;
    ODS_DEFAULT = $0020;
    ODS_COMBOBOXEDIT = $1000;

type
	MEASUREITEMSTRUCT = packed record
		CtlType : UINT;
		CtlID : UINT;
		itemID : UINT;
		itemWidth : UINT;
		itemHeight : UINT;
		itemData : DWORD;
	end;

	DRAWITEMSTRUCT = packed record
		CtlType : UINT;
		CtlID : UINT;
		itemID : UINT;
		itemAction : UINT;
		itemState : UINT;
		hwndItem : HWND;
		hDC : _HDC;
		rcItem : RECT;
		itemData : DWORD;
	end;

	DELETEITEMSTRUCT = packed record
		CtlType : UINT;
		CtlID : UINT;
		itemID : UINT;
		hwndItem : HWND;
		itemData : DWORD;
	end;

	COMPAREITEMSTRUCT = packed record
		CtlType : UINT;
		CtlID : UINT;
		hwndItem : HWND;
		itemID1 : UINT;
		itemData1 : DWORD;
		itemID2 : UINT;
		itemData2 : DWORD;
		dwLocaleId : DWORD;
	end;

	function GetMessage(var lpMsg : MSG; hWnd : _HWND; wMsgFilterMin, wMsgFilterMax : UINT) : BOOL;
    	external dll='user32.dll' name='GetMessageA' stdcall;

	function TranslateMessage(var lpMsg : MSG) : BOOL;
    	external dll='user32.dll';

	function DispatchMessage(var lpMsg : MSG) : BOOL;
    	external dll='user32.dll' name='DispatchMessageA' stdcall;

	function SetMessageQueue(cMessageMax : integer) : BOOL;
    	external dll='user32.dll';

	function PeekMessage(var lpMsg : MSG; hwnd : _HWND; wMsgFilterMin, wMsgFilterMax, wRemoveMsg : UINT) : BOOL;
    	external dll='user32.dll' name='PeekMessageA' stdcall;

const
    PM_NOREMOVE = $0000;
    PM_REMOVE = $0001;
    PM_NOYIELD = $0002;

	function RegisterHotKey(hWnd : _HWND; id : integer; fsModifiers, vk : UINT) : BOOL;
    	external dll='user32.dll';

	function UnregisterHotKey(hWnd : _HWND; id : integer) : BOOL;
    	external dll='user32.dll';

const
    MOD_ALT = $0001;
    MOD_CONTROL = $0002;
    MOD_SHIFT = $0004;
    MOD_WIN = $0008;
    IDHOT_SNAPWINDOW = -1;
    IDHOT_SNAPDESKTOP = -2;

    EW_RESTARTWINDOWS = $0042;
    EW_REBOOTSYSTEM = $0043;
    EW_EXITANDEXECAPP = $0044;
    ENDSESSION_LOGOFF = $80000000;
    EWX_LOGOFF = 0;
    EWX_SHUTDOWN = 1;
    EWX_REBOOT = 2;
    EWX_FORCE = 4;
    EWX_POWEROFF = 8;

	function ExitWindowsEx(uFlags : UINT; dwReserved : DWORD) : BOOL;
    	external dll='user32.dll';

	function SwapMouseButton(fSwap : BOOL) : BOOL;
    	external dll='user32.dll';

	function GetMessagePos : DWORD;
    	external dll='user32.dll';

	function GetMessageTime : LONG;
    	external dll='user32.dll';

	function GetMessageExtraInfo : LONG;
    	external dll='user32.dll';

	function SetMessageExtraInfo(lParam : _LPARAM) : _LPARAM;
    	external dll='user32.dll';

	function SendMessage(hWnd : _HWND; Msg : UINT; wParam : _WPARAM; lParam : _LPARAM) : LRESULT;
    	external dll='user32.dll' name='SendMessageA' stdcall;

	function SendMessageTimeout(hWnd : _HWND; Msg : UINT; wParam : _WPARAM; lParam : _LPARAM;
								fuFlags, uTimeout : UINT; var lpdwResult : DWORD) : LRESULT;
    	external dll='user32.dll' name='SendMessageTimeoutA' stdcall;

	function SendNotifyMessage(hWnd : _HWND; Msg : UINT; wParam : _WPARAM; lParam : _LPARAM) : LRESULT;
    	external dll='user32.dll' name='SendNotifyMessageA' stdcall;

	function SendMessageCallback(hWnd : _HWND; Msg : UINT; wParam : _WPARAM; lParam : _LPARAM;
								lpResultCAllBack : PROC; dwData : DWORD) : LRESULT;
    	external dll='user32.dll' name='SendMessageCallbackA' stdcall;

	function BroadcastSystemMessage(dwFlags : DWORD; var lpdwRecipients : DWORD;
									uiMessage : UINT; wParam : _WPARAM; lParam : _LPARAM) : integer;
    	external dll='user32.dll' name='BroadcastSystemMessageA' stdcall;

const
    BSM_ALLCOMPONENTS = $00000000;
    BSM_VXDS = $00000001;
    BSM_NETDRIVER = $00000002;
    BSM_INSTALLABLEDRIVERS = $00000004;
    BSM_APPLICATIONS = $00000008;
    BSM_ALLDESKTOPS = $00000010;
    BSF_QUERY = $00000001;
    BSF_IGNORECURRENTTASK = $00000002;
    BSF_FLUSHDISK = $00000004;
    BSF_NOHANG = $00000008;
    BSF_POSTMESSAGE = $00000010;
    BSF_FORCEIFHUNG = $00000020;
    BSF_NOTIMEOUTIFNOTHUNG = $00000040;

type
	BROADCASTSYSMSG = packed record
		uiMessage : UINT;
		wParam : _WPARAM;
		lParam : _LPARAM;
	end;

const
    BROADCAST_QUERY_DENY = $424D5144;

	function PostMessage(hWnd : _HWND; Msg : UINT; wParam : _WPARAM; lParam : _LPARAM) : LRESULT;
    	external dll='user32.dll' name='PostMessageA' stdcall;

	function PostThreadMessage(idThread : DWORD; hWnd : _HWND; Msg : UINT; wParam : _WPARAM; lParam : _LPARAM) : LRESULT;
    	external dll='user32.dll' name='PostThreadMessageA' stdcall;

const
	HWND_BROADCAST = $FFFF;

	function AttachThreadInput(idAttach, idAttachTo : DWORD; fAttach : BOOL) : BOOL;
    	external dll='user32.dll';

	function ReplyMessage(lResult : _LRESULT) : BOOL;
    	external dll='user32.dll';

	function WaitMessage : BOOL;
    	external dll='user32.dll';

	function WaitForInputIdle(hProcess : HANDLE; dwMilliseconds : DWORD) : DWORD;
    	external dll='user32.dll';

	function DefWindowProc(hWnd : _HWND; Msg : UINT; wParam : _WPARAM; lParam : _LPARAM) : LRESULT;
    	external dll='user32.dll' name='DefWindowProcA' stdcall;

	procedure PostQuitMessage(nExitCode : integer);
    	external dll='user32.dll';

	function CallWindowProc(lpPrevWndFunc : PROC; hWnd : _HWND; Msg : UINT; wParam : _WPARAM; lParam : _LPARAM) : LRESULT;
    	external dll='user32.dll' name='CallWindowProcA' stdcall;

	function InSendMessage : BOOL;
    	external dll='user32.dll';

	function GetDoubleClickTime : UINT;
    	external dll='user32.dll';

	function SetDoubleClickTime(uInterval : UINT) : BOOL;
    	external dll='user32.dll';

	function RegisterClass(var lpWndClass : WNDCLASS) : ATOM;
    	external dll='user32.dll' name='RegisterClassA' stdcall;

	function UnregisterClass(lpClassName : address; hInstance : _HINSTANCE) : BOOL;
    	external dll='user32.dll' name='UnregisterClassA' stdcall;

	function GetClassInfo(hInstance : _HINSTANCE; lpClassName : address; var lpWndClass : WNDCLASS) : BOOL;
    	external dll='user32.dll' name='GetClassInfoA' stdcall;

	function RegisterClassEx(var lpWndClass : WNDCLASSEX) : ATOM;
    	external dll='user32.dll' name='RegisterClassExA' stdcall;

	function GetClassInfoEx(hInstance : _HINSTANCE; lpClassName : address; var lpWndClassEx : WNDCLASSEX) : BOOL;
    	external dll='user32.dll' name='GetClassInfoExA' stdcall;

const
    CW_USEDEFAULT = $80000000;
    HWND_DESKTOP = 0;

	function CreateWindowEx(dwExStyle : DWORD; lpClassName, lpWindowName : address;
							dwStyle : DWORD; x, y, nWidth, nHeight : integer;
							hWndParent : HWND; hMenu : _HMENU; hInstance : _HINSTANCE;
							lpParam : LPVOID) : HWND;
    	external dll='user32.dll' name='CreateWindowExA' stdcall;


	function IsWindow(hwnd : _HWND) : BOOL;
    	external dll='user32.dll';

	function IsMenu(hMenu : _HMENU) : BOOL;
    	external dll='user32.dll';

	function IsChild(hWndParent, hwnd : _HWND) : BOOL;
    	external dll='user32.dll';

	function DestroyWindow(hwnd : _HWND) : BOOL;
    	external dll='user32.dll';

	function ShowWindow(hWnd : _HWND; nCmdShow : integer) : BOOL;
    	external dll='user32.dll';

	function ShowWindowAsync(hWnd : _HWND; nCmdShow : integer) : BOOL;
    	external dll='user32.dll';

	function FlashWindow(hwnd : _HWND; bInvert : BOOL) : BOOL;
    	external dll='user32.dll';

	function ShowOwnedPopups(hwnd : _HWND; fShow : BOOL) : BOOL;
    	external dll='user32.dll';

	function OpenIcon(hwnd : _HWND) : BOOL;
    	external dll='user32.dll';

	function CloseWindow(hwnd : _HWND) : BOOL;
    	external dll='user32.dll';

	function MoveWindow(hwnd : _HWND; x, y, nWidth, nHeight : integer; bRepaint : BOOL) : BOOL;
    	external dll='user32.dll';

	function SetWindowPos(hwnd, hWndInsertAfter : _HWND; x, y, cx, cy : integer; uFlags : UINT) : BOOL;
    	external dll='user32.dll';

	function GetWindowPlacement(hWnd : _HWND; var lpwndpl : WINDOWPLACEMENT) : BOOL;
    	external dll='user32.dll';

	function SetWindowPlacement(hWnd : _HWND; var lpwndpl : WINDOWPLACEMENT) : BOOL;
    	external dll='user32.dll';

	function BeginDeferWindowPos(nNumWindows : integer) : BOOL;
    	external dll='user32.dll';

	function DeferWindowPos(WinPosInfo : HDWP; hwnd, hWndInsertAfter : _HWND; x, y, cx, cy : integer; uFlags : UINT) : HDWP;
    	external dll='user32.dll';

	function EndDeferWindowPos(hWinPosInfo : HDWP) : BOOL;
    	external dll='user32.dll';

	function IsWindowVisible(hwnd : _HWND) : BOOL;
    	external dll='user32.dll';

	function IsIconic(hwnd : _HWND) : BOOL;
    	external dll='user32.dll';

	function AnyPopup : BOOL;
    	external dll='user32.dll';

	function BringWindowToTop(hwnd : _HWND) : BOOL;
    	external dll='user32.dll';

	function IsZoomed(hwnd : _HWND) : BOOL;
    	external dll='user32.dll';

const
    SWP_NOSIZE = $0001;
    SWP_NOMOVE = $0002;
    SWP_NOZORDER = $0004;
    SWP_NOREDRAW = $0008;
    SWP_NOACTIVATE = $0010;
    SWP_FRAMECHANGED = $0020;
    SWP_SHOWWINDOW = $0040;
    SWP_HIDEWINDOW = $0080;
    SWP_NOCOPYBITS = $0100;
    SWP_NOOWNERZORDER = $0200;
    SWP_NOSENDCHANGING = $0400;
    SWP_DRAWFRAME = SWP_FRAMECHANGED;
    SWP_NOREPOSITION = SWP_NOOWNERZORDER;
    SWP_DEFERERASE = $2000;
    SWP_ASYNCWINDOWPOS = $4000;
    HWND_TOP = 0;
    HWND_BOTTOM = 1;
    HWND_TOPMOST = -1;
    HWND_NOTOPMOST = -2;

type
	DLGTEMPLATE = packed record
		style : DWORD;
		dwExtenededSytle : DWORD;
		cdit : shortword;
		x : SHORT;
		y : SHORT;
		cx : SHORT;
		cy : SHORT;
	end;

	DLGITEMTEMPLATE = packed record
		style : DWORD;
		dwExtenededSytle : DWORD;
		x : SHORT;
		y : SHORT;
		cx : SHORT;
		cy : SHORT;
		id : shortword;
	end;

	function CreateDialogParam(hInstance : _HINSTANCE; lpTemplateName : address;
								hWndParent : HWND; lpDialogFunc : PROC;
								dwInitParam : LPARAM) : HWND;
    	external dll='user32.dll' name='CreateDialogParamA' stdcall;

	function CreateDialogIndirectParam(hInstance : _HINSTANCE; var lpTemplate : DLGTEMPLATE;
								hWndParent : HWND; lpDialogFunc : PROC;
								dwInitParam : LPARAM) : HWND;
    	external dll='user32.dll' name='CreateDialogIndirectParamA' stdcall;

	function DialogBoxParam(hInstance : _HINSTANCE; lpTemplateName : address;
								hWndParent : HWND; lpDialogFunc : PROC;
								dwInitParam : LPARAM) : HWND;
    	external dll='user32.dll' name='DialogBoxParamA' stdcall;

	function DialogBoxIndirectParam(hInstance : _HINSTANCE; var hDialogTemplate : DLGTEMPLATE;
								hWndParent : HWND; lpDialogFunc : PROC;
								dwInitParam : LPARAM) : HWND;
    	external dll='user32.dll' name='DialogBoxIndirectParamA' stdcall;

	function EndDialog(hDlg : HWND; nResult : integer) : BOOL;
    	external dll='user32.dll';

	function GetDlgItem(hDlg : HWND; nIDDlgItem : integer) : HWND;
    	external dll='user32.dll';

	function SetDlgItemInt(hDlg : HWND; nIDDlgItem : integer; uValue : UINT; bSigned : BOOL) : BOOL;
    	external dll='user32.dll';

	function GetDlgItemInt(hDlg : HWND; nIDDlgItem : integer; var lpTranslated : BOOL; bSigned : BOOL) : UINT;
    	external dll='user32.dll';

	function SetDlgItemText(hDlg : HWND; nIDDlgItem : integer; lpString : address) : BOOL;
    	external dll='user32.dll' name='SetDlgItemTextA' stdcall;

	function GetDlgItemText(hDlg : HWND; nIDDlgItem : integer; lpString : address; nMaxCount : integer) : UINT;
    	external dll='user32.dll' name='GetDlgItemTextA' stdcall;

	function CheckDlgButton(hDlg : HWND; nIDButton : integer; uCheck : UINT) : BOOL;
    	external dll='user32.dll';

	function CheckRadioButton(hDlg : HWND; nIDFirstButton, nIDLastButton, nIDCheckButton : integer) : BOOL;
    	external dll='user32.dll';

	function IsDlgButtonChecked(hDlg : HWND; nIDButton : integer) : UINT;
    	external dll='user32.dll';

	function SendDlgItemMessage(hDlg : HWND; nIDDlgItem : integer; Msg : UINT; wParam : _WPARAM; lParam : _LPARAM) : LONG;
    	external dll='user32.dll' name='SendDlgItemMessageA' stdcall;

	function GetNextDlgGroupItem(hDlg, hCtl : HWND; bPrevious : BOOL) : HWND;
    	external dll='user32.dll';

	function GetNextDlgTabItem(hDlg, hCtl : HWND; bPrevious : BOOL) : HWND;
    	external dll='user32.dll';

     function GetDlgCtrlID(hWnd : _HWND) : integer;
    	external dll='user32.dll';

	function GetDialogBaseUnits : integer;
    	external dll='user32.dll';

	function DefDlgProc(hDlg : HWND; Msg : UINT; wParam : _WPARAM; lParam : _LPARAM) : LRESULT;
    	external dll='user32.dll' name='DefDlgProcA' stdcall;

const
	DLGWINDOWEXTRA = 30;

	function CallMsgFilter(var lpMsg : MSG; nCode : integer) : BOOL;
    	external dll='user32.dll' name='CallMsgFilterA' stdcall;

	function OpenClipboard(hWndNewOwner : HWND) : BOOL;
    	external dll='user32.dll';

	function CloseClipboard : BOOL;
    	external dll='user32.dll';

	function SetClipboardData(uFormat : UINT; hMem : HANDLE) : HANDLE;
    	external dll='user32.dll';

	function GetClipboardData(uFormat : UINT) : HANDLE;
    	external dll='user32.dll';

	function EmptyClipboard : BOOL;
    	external dll='user32.dll';

	function GetClipboardOwner : HWND;
    	external dll='user32.dll';

	function SetClipboardViewer(hWndNewViewer : HWND) : HWND;
    	external dll='user32.dll';

	function GetClipboardViewer : HWND;
    	external dll='user32.dll';

	function ChangeClipboardChain(hWndRemove, hWndNewNext : HWND) : BOOL;
    	external dll='user32.dll';

	function RegisterClipboardFormat(lpszFormat : address) : UINT;
    	external dll='user32.dll' name='RegisterClipboardFormatA' stdcall;

	function CountClipboardFormats : integer;
    	external dll='user32.dll';

	function EnumClipboardFormats(format : UINT) : UINT;
    	external dll='user32.dll';

	function GetClipboardFormatName(format : UINT; lpszFormatName : address; cchMaxCount : integer) : integer;
    	external dll='user32.dll' name='GetClipboardFormatNameA' stdcall;

	function IsClipboardFormatAvailable(format : UINT) : BOOL;
    	external dll='user32.dll';

	function GetPriorityClipboardFormat(paFormatPriorityList : address; cFormats : integer) : integer;
    	external dll='user32.dll';

	function GetOpenClipboardWindow : HWND;
    	external dll='user32.dll';

	function CharToOem(lpszSrc, lpszDst : LPSTR) : BOOL;
    	external dll='user32.dll' name='CharToOemA' stdcall;

	function OemToChar(lpszSrc, lpszDst : LPSTR) : BOOL;
    	external dll='user32.dll' name='OemToCharA' stdcall;

	function CharToOemBuff(lpszSrc, lpszDst : LPSTR; cchDstLength : DWORD) : BOOL;
    	external dll='user32.dll' name='CharToOemBuffA' stdcall;

	function OemToCharBuff(lpszSrc, lpszDst : LPSTR; cchDstLength : DWORD) : BOOL;
    	external dll='user32.dll' name='OemToCharBuffA' stdcall;

	function CharUpper(lpsz : LPSTR) : LPSTR;
    	external dll='user32.dll' name='CharUpperA' stdcall;

	function CharUpperBuff(lpsz : LPSTR; cchLength : DWORD) : DWORD;
    	external dll='user32.dll' name='CharUpperBuffA' stdcall;

	function CharLower(lpsz : LPSTR) : LPSTR;
    	external dll='user32.dll' name='CharLowerA' stdcall;

	function CharLowerBuff(lpsz : LPSTR; cchLength : DWORD) : DWORD;
    	external dll='user32.dll' name='CharLowerBuffA' stdcall;

	function CharNext(lpsz : LPSTR) : LPSTR;
    	external dll='user32.dll' name='CharNextA' stdcall;

	function CharPrev(lpszStart, lpszCurrent : LPSTR) : LPSTR;
    	external dll='user32.dll' name='CharPrevA' stdcall;

	function CharNextEx(CodePage : shortword; lpCurrentChar : address; dwFlags : DWORD) : LPSTR;
    	external dll='user32.dll' name='CharNextExA' stdcall;

	function CharPrevEx(CodePage : shortword; lpCurrentChar : address; dwFlags : DWORD) : LPSTR;
    	external dll='user32.dll' name='CharPrevExA' stdcall;

	function IsCharAlpha(ch : CHAR) : BOOL;
    	external dll='user32.dll' name='IsCharAlphaA' stdcall;

	function IsCharAlphaNumeric(ch : CHAR) : BOOL;
    	external dll='user32.dll' name='IsCharAlphaNumericA' stdcall;

	function IsCharUpper(ch : CHAR) : BOOL;
    	external dll='user32.dll' name='IsCharUpperA' stdcall;

	function IsCharLower(ch : CHAR) : BOOL;
    	external dll='user32.dll' name='IsCharLowerA' stdcall;

	function SetFocus(hWnd : _HWND) : _HWND;
    	external dll='user32.dll';

	function GetActiveWindow : HWND;
    	external dll='user32.dll';

	function GetFocus : HWND;
    	external dll='user32.dll';

	function GetKBCodePage : UINT;
    	external dll='user32.dll';

	function GetKeyState(nVirtKey : integer) : SHORT;
    	external dll='user32.dll';

	function GetAsyncKeyState(vKey : integer) : SHORT;
    	external dll='user32.dll';

	function GetKeyboardState(var lpKeyState : BYTE) : BOOL;
    	external dll='user32.dll';

	function SetKeyboardState(var lpKeyState : BYTE) : BOOL;
    	external dll='user32.dll';

	function GetKeyNameText(lParam : _LPARAM; lpString : address; nSize : integer) : integer;
    	external dll='user32.dll' name='GetKeyNameTextA' stdcall;

	function GetKeyboardType(nTypeFlag : integer) : integer;
    	external dll='user32.dll';

	function ToAscii(uVirtKey, uScanCode : UINT; var lpKeyState : BYTE; var lpChar : shortword;
						uFlags : UINT) : integer;
    	external dll='user32.dll';

	function ToAsciiEx(uVirtKey, uScanCode : UINT; var lpKeyState : BYTE; var lpChar : shortword;
						uFlags : UINT; dwhkl : HKL) : integer;
    	external dll='user32.dll';

	function ToUnicode(wVirtKey, wScanCode : UINT; var lpKeyState : BYTE; pwszBuff : address;
						cchBuff : integer; wFlags : UINT) : integer;
    	external dll='user32.dll';

	function OemKeyScan(wOemChar : shortword) : DWORD;
    	external dll='user32.dll';

	function VkKeyScan(ch : CHAR) : SHORT;
    	external dll='user32.dll' name='VkKeyScanA' stdcall;

	function VkKeyScanEx(ch : CHAR; dwhkl : HKL) : SHORT;
    	external dll='user32.dll' name='VkKeyScanExA' stdcall;

const
    KEYEVENTF_EXTENDEDKEY = $0001;
    KEYEVENTF_KEYUP = $0002;

	procedure keybd_event(bVk, bScan : BYTE; dwFlags, dwExtraInfo : DWORD);
    	external dll='user32.dll';

const
    MOUSEEVENTF_MOVE = $0001;
    MOUSEEVENTF_LEFTDOWN = $0002;
    MOUSEEVENTF_LEFTUP = $0004;
    MOUSEEVENTF_RIGHTDOWN = $0008;
    MOUSEEVENTF_RIGHTUP = $0010;
    MOUSEEVENTF_MIDDLEDOWN = $0020;
    MOUSEEVENTF_MIDDLEUP = $0040;
    MOUSEEVENTF_WHEEL = $0800;
    MOUSEEVENTF_ABSOLUTE = $8000;

	procedure mouse_event(dwFlags : DWORD; dx, dy : DWORD; dwData, dwExtraInfo : DWORD);
    	external dll='user32.dll';

	function MapVirtualKey(uCode : UINT; uMapType : UINT) : UINT;
    	external dll='user32.dll' name='MapVirtualKeyA' stdcall;

	function MapVirtualKeyEx(uCode : UINT; uMapType : UINT; dwhkl : HKL) : UINT;
    	external dll='user32.dll' name='MapVirtualKeyExA' stdcall;

	function GetInputState : BOOL;
    	external dll='user32.dll';

	function GetQueueStatus(flags : UINT) : DWORD;
    	external dll='user32.dll';

	function GetCapture : HWND;
    	external dll='user32.dll';

	function SetCapture(hWnd : _HWND) : _HWND;
    	external dll='user32.dll';

	function ReleaseCapture : BOOL;
    	external dll='user32.dll';

	function MsgWaitForMultipleObjects(nCount : DWORD; pHandles : address; fWaitAll : BOOL;
										dwMilliseconds, dwWakeMask : DWORD) : DWORD;
    	external dll='user32.dll';

	function MsgWaitForMultipleObjectsEx(nCount : DWORD; pHandles : address;
										dwMilliseconds, dwWakeMask, dwFlags : DWORD) : DWORD;
    	external dll='user32.dll';

const
    MWMO_WAITALL = $0001;
    MWMO_ALERTABLE = $0002;
    QS_KEY = $0001;
    QS_MOUSEMOVE = $0002;
    QS_MOUSEBUTTON = $0004;
    QS_POSTMESSAGE = $0008;
    QS_TIMER = $0010;
    QS_PAINT = $0020;
    QS_SENDMESSAGE = $0040;
    QS_HOTKEY = $0080;
    QS_ALLPOSTMESSAGE = $0100;
    QS_MOUSE = $0006;
    QS_INPUT = $0007;
    QS_ALLEVENTS = $00BF;
    QS_ALLINPUT = $00FF;

	function SetTimer(hWnd : _HWND; nIDEvent, uElapse : UINT; lpTimerFunc : PROC) : UINT;
    	external dll='user32.dll';

	function KillTimer(hWnd : _HWND; uIDEvent : UINT) : BOOL;
    	external dll='user32.dll';

	function IsWindowUnicode(hWnd : _HWND) : BOOL;
    	external dll='user32.dll';

	function EnableWindow(hWnd : _HWND; nEnable : BOOL) : BOOL;
    	external dll='user32.dll';

	function IsWindowEnabled(hWnd : _HWND) : BOOL;
    	external dll='user32.dll';

	function LoadAccelerators(hInstance : _HINSTANCE; lpTableName : address) : HACCEL;
    	external dll='user32.dll' name='LoadAcceleratorsA' stdcall;

	function CreateAcceleratorTable(lpaccl : address; cEntries : integer) : HACCEL;
    	external dll='user32.dll' name='CreateAcceleratorTableA' stdcall;

	function DestroyAcceleratorTable(hAccel : _HACCEL) : BOOL;
    	external dll='user32.dll';

	function CopyAcceleratorTable(hAccelSrc : HACCEL; lpAccelDst : address;
									cAccelEntries : address) : integer;
    	external dll='user32.dll' name='CopyAcceleratorTableA' stdcall;

	function TranslateAccelerator(hWnd : _HWND; hAccelTable : HACCEL; var lpMsg : MSG) : integer;
    	external dll='user32.dll' name='TranslateAcceleratorA' stdcall;

const
    SM_CXSCREEN = 0;
    SM_CYSCREEN = 1;
    SM_CXVSCROLL = 2;
    SM_CYHSCROLL = 3;
    SM_CYCAPTION = 4;
    SM_CXBORDER = 5;
    SM_CYBORDER = 6;
    SM_CXDLGFRAME = 7;
    SM_CYDLGFRAME = 8;
    SM_CYVTHUMB = 9;
    SM_CXHTHUMB = 10;
    SM_CXICON = 11;
    SM_CYICON = 12;
    SM_CXCURSOR = 13;
    SM_CYCURSOR = 14;
    SM_CYMENU = 15;
    SM_CXFULLSCREEN = 16;
    SM_CYFULLSCREEN = 17;
    SM_CYKANJIWINDOW = 18;
    SM_MOUSEPRESENT = 19;
    SM_CYVSCROLL = 20;
    SM_CXHSCROLL = 21;
    SM_DEBUG = 22;
    SM_SWAPBUTTON = 23;
    SM_RESERVED1 = 24;
    SM_RESERVED2 = 25;
    SM_RESERVED3 = 26;
    SM_RESERVED4 = 27;
    SM_CXMIN = 28;
    SM_CYMIN = 29;
    SM_CXSIZE = 30;
    SM_CYSIZE = 31;
    SM_CXFRAME = 32;
    SM_CYFRAME = 33;
    SM_CXMINTRACK = 34;
    SM_CYMINTRACK = 35;
    SM_CXDOUBLECLK = 36;
    SM_CYDOUBLECLK = 37;
    SM_CXICONSPACING = 38;
    SM_CYICONSPACING = 39;
    SM_MENUDROPALIGNMENT = 40;
    SM_PENWINDOWS = 41;
    SM_DBCSENABLED = 42;
    SM_CMOUSEBUTTONS = 43;
    SM_CXFIXEDFRAME = SM_CXDLGFRAME;
    SM_CYFIXEDFRAME = SM_CYDLGFRAME;
    SM_CXSIZEFRAME = SM_CXFRAME;
    SM_CYSIZEFRAME = SM_CYFRAME;
    SM_SECURE = 44;
    SM_CXEDGE = 45;
    SM_CYEDGE = 46;
    SM_CXMINSPACING = 47;
    SM_CYMINSPACING = 48;
    SM_CXSMICON = 49;
    SM_CYSMICON = 50;
    SM_CYSMCAPTION = 51;
    SM_CXSMSIZE = 52;
    SM_CYSMSIZE = 53;
    SM_CXMENUSIZE = 54;
    SM_CYMENUSIZE = 55;
    SM_ARRANGE = 56;
    SM_CXMINIMIZED = 57;
    SM_CYMINIMIZED = 58;
    SM_CXMAXTRACK = 59;
    SM_CYMAXTRACK = 60;
    SM_CXMAXIMIZED = 61;
    SM_CYMAXIMIZED = 62;
    SM_NETWORK = 63;
    SM_CLEANBOOT = 67;
    SM_CXDRAG = 68;
    SM_CYDRAG = 69;
    SM_SHOWSOUNDS = 70;
    SM_CXMENUCHECK = 71;
    SM_CYMENUCHECK = 72;
    SM_SLOWMACHINE = 73;
    SM_MIDEASTENABLED = 74;
    SM_MOUSEWHEELPRESENT = 75;
    SM_CMETRICS = 76;

	function GetSystemMetrics(nIndex : integer) : integer;
    	external dll='user32.dll';

	function LoadMenu(hInstance : _HINSTANCE; lpMenuName : address) : HMENU;
    	external dll='user32.dll' name='LoadMenuA' stdcall;

	function LoadMenuIndirect(lpMenuTemplate : address) : HMENU;
    	external dll='user32.dll' name='LoadMenuIndirectA' stdcall;

	function GetMenu(hWnd : _HWND) : HMENU;
    	external dll='user32.dll';

	function SetMenu(hWnd : _HWND; hMenu : _HMENU) : BOOL;
    	external dll='user32.dll';

	function ChangeMenu(hMenu : _HMENU; cmd : UINT; lpszNewItem : address;
						cmdInsert, flags : UINT) : BOOL;
    	external dll='user32.dll' name='ChangeMenuA' stdcall;

	function HiliteMenuItem(hWnd : _HWND; hMenu : _HMENU; uIDHiliteItem, uHilite : UINT) : BOOL;
    	external dll='user32.dll';

	function GetMenuString(hMenu : _HMENU; uIDItem : UINT; lpString : address;
							nMaxCount : integer; uFlag : UINT) : integer;
    	external dll='user32.dll' name='GetMenuStringA' stdcall;

	function GetMenuState(hMenu : _HMENU; uId, uFlags : UINT) : UINT;
    	external dll='user32.dll';

	function DrawMenuBar(hWnd : _HWND) : BOOL;
    	external dll='user32.dll';

	function GetSystemMenu(hWnd : _HWND; bRevert : BOOL) : HMENU;
    	external dll='user32.dll';

	function CreateMenu : HMENU;
    	external dll='user32.dll';

	function CreatePopupMenu : HMENU;
    	external dll='user32.dll';

	function DestroyMenu(hMenu : _HMENU) : BOOL;
    	external dll='user32.dll';

	function CheckMenuItem(hMenu : _HMENU; uIDCheckItem, uCheck : UINT) : DWORD;
    	external dll='user32.dll';

	function EnableMenuItem(hMenu : _HMENU; uIDEnableItem, uEnable : UINT) : BOOL;
    	external dll='user32.dll';

	function GetSubMenu(hMenu : _HMENU; nPos : integer) : _HMENU;
    	external dll='user32.dll';

	function GetMenuItemID(hMenu : _HMENU; nPos : integer) : UINT;
    	external dll='user32.dll';

	function GetMenuItemCount(hMenu : _HMENU) : integer;
    	external dll='user32.dll';

	function InsertMenu(hMenu : _HMENU; uPosition, uFlags, uIDNewItem : UINT; lpNewItem : address) : BOOL;
    	external dll='user32.dll' name='InsertMenuA' stdcall;

	function AppendMenu(hMenu : _HMENU; uFlags, uIDNewItem : UINT; lpNewItem : address) : BOOL;
    	external dll='user32.dll' name='AppendMenuA' stdcall;

	function ModifyMenu(hMenu : _HMENU; uPosition, uFlags, uIDNewItem : UINT; lpNewItem : address) : BOOL;
    	external dll='user32.dll' name='ModifyMenuA' stdcall;

	function RemoveMenu(hMenu : _HMENU; uPosition, uFlags : UINT) : BOOL;
    	external dll='user32.dll';

	function DeleteMenu(hMenu : _HMENU; uPosition, uFlags : UINT) : BOOL;
    	external dll='user32.dll';

	function SetMenuItemBitmaps(hMenu : _HMENU; uPosition, uFlags : UINT;
									hBitmapUnchecked, hBitmapChecked : HBITMAP) : BOOL;
    	external dll='user32.dll';

	function GetMenuCheckMarkDimensions : LONG;
    	external dll='user32.dll';

	function TrackPopupMenu(hMenu : _HMENU; uFlags : UINT; x, y, nReserved : integer;
							hWnd : _HWND; var prcRect : RECT) : BOOL;
    	external dll='user32.dll';

const
    MNC_IGNORE = 0;
    MNC_CLOSE = 1;
    MNC_EXECUTE = 2;
    MNC_SELECT = 3;

type
	TPMPARAMS = packed record
		cbSize : UINT;
		rcExclude : RECT;
	end;

	function TrackPopupMenuEx(hMenu : _HMENU; fuFlags : UINT; x, y : integer;
							hWnd : _HWND; var prcRect : RECT;
							var lptpm : TPMPARAMS) : BOOL;
    	external dll='user32.dll';

const
    MIIM_STATE = $00000001;
    MIIM_ID = $00000002;
    MIIM_SUBMENU = $00000004;
    MIIM_CHECKMARKS = $00000008;
    MIIM_TYPE = $00000010;
    MIIM_DATA = $00000020;

type
	MENUITEMINFO = packed record
		cbSize : UINT;
		fMask : UINT;
		fType : UINT;
		fState : UINT;
		wID : UINT;
		hSubMenu : HMENU;
		hbmpChecked : HBITMAP;
		hbmpUnchecked : HBITMAP;
		dwItemData : DWORD;
		dwTypeData : LPSTR;
		cch : UINT;
	end;

	function InsertMenuItem(hMenu : _HMENU; uItem : UINT; fByPosition : BOOL; var lpmii : MENUITEMINFO) : BOOL;
    	external dll='user32.dll' name='InsertMenuItemA' stdcall;

	function GetMenuItemInfo(hMenu : _HMENU; uItem : UINT; fByPosition : BOOL; var lpmii : MENUITEMINFO) : BOOL;
    	external dll='user32.dll' name='GetMenuItemInfoA' stdcall;

	function SetMenuItemInfo(hMenu : _HMENU; uItem : UINT; fByPosition : BOOL; var lpmii : MENUITEMINFO) : BOOL;
    	external dll='user32.dll' name='SetMenuItemInfoA' stdcall;

const
    GMDI_USEDISABLED = $0001;
    GMDI_GOINTOPOPUPS = $0002;

	function GetMenuDefaultItem(hMenu : _HMENU; fByPos, gmdiFlags : UINT) : UINT;
    	external dll='user32.dll';
 
	function SetMenuDefaultItem(hMenu : _HMENU; uItem, fByPos : UINT) : BOOL;
    	external dll='user32.dll';
 
	function GetMenuItemRect(hWnd : _HWND; hMenu : _HMENU; uItem : UINT; var lprcItem : RECT) : BOOL;
    	external dll='user32.dll';
	function MenuItemFromPoint(hWnd : _HWND; hMenu : _HMENU; ptScreen : POINT) : integer;
    	external dll='user32.dll';

const
    TPM_LEFTBUTTON = $0000;
    TPM_RIGHTBUTTON = $0002;
    TPM_LEFTALIGN = $0000;
    TPM_CENTERALIGN = $0004;
    TPM_RIGHTALIGN = $0008;
    TPM_TOPALIGN = $0000;
    TPM_VCENTERALIGN = $0010;
    TPM_BOTTOMALIGN = $0020;
    TPM_HORIZONTAL = $0000;
    TPM_VERTICAL = $0040;
    TPM_NONOTIFY = $0080;
    TPM_RETURNCMD = $0100;

	function DrawIcon(hDC : _HDC; x, y : integer; hIcon : _HICON) : BOOL;
    	external dll='user32.dll';

const
    DT_TOP = $00000000;
    DT_LEFT = $00000000;
    DT_CENTER = $00000001;
    DT_RIGHT = $00000002;
    DT_VCENTER = $00000004;
    DT_BOTTOM = $00000008;
    DT_WORDBREAK = $00000010;
    DT_SINGLELINE = $00000020;
    DT_EXPANDTABS = $00000040;
    DT_TABSTOP = $00000080;
    DT_NOCLIP = $00000100;
    DT_EXTERNALLEADING = $00000200;
    DT_CALCRECT = $00000400;
    DT_NOPREFIX = $00000800;
    DT_INTERNAL = $00001000;
    DT_EDITCONTROL = $00002000;
    DT_PATH_ELLIPSIS = $00004000;
    DT_END_ELLIPSIS = $00008000;
    DT_MODIFYSTRING = $00010000;
    DT_RTLREADING = $00020000;
    DT_WORD_ELLIPSIS = $00040000;

type
	DRAWTEXTPARAMS = packed record
		cbSize : UINT;
		iTabLength : integer;
		iLeftMargin : integer;
		iRightMargin : integer;
		uiLengthDrawn : UINT;
	end;

	function DrawText(hDC : _HDC; lpString : LPSTR; nCount : integer;
						var lpRect : RECT; uFormat : UINT) : integer;
    	external dll='user32.dll' name='DrawTextA' stdcall;

	function DrawTextEx(hDC : _HDC; lpchText : LPSTR; cchText : integer;
						var lpRect : RECT; uFormat : UINT;
						var lpDTParams : DRAWTEXTPARAMS) : integer;
    	external dll='user32.dll' name='DrawTextExA' stdcall;

	function GrayString(hDC : _HDC; hBrush : _HBRUSH; lpOutputFunc : PROC;
						nCount, x, y, nWidth, nHeight : integer) : BOOL;
    	external dll='user32.dll' name='GrayStringA' stdcall;

const
    DST_COMPLEX = $0000;
    DST_TEXT = $0001;
    DST_PREFIXTEXT = $0002;
    DST_ICON = $0003;
    DST_BITMAP = $0004;
    DSS_NORMAL = $0000;
    DSS_UNION = $0010;
    DSS_DISABLED = $0020;
    DSS_MONO = $0080;
    DSS_RIGHT = $8000;

	function DrawState(hDC : _HDC; hbr : HBRUSH; lpOutputFunc : PROC;
						lParam : _LPARAM; wParam : _WPARAM;
						x, y, cx, cy : integer; fuFlags : UINT) : BOOL;
    	external dll='user32.dll' name='DrawStateA' stdcall;

	function TabbedTextOut(hDC : _HDC; x, y : integer; lpString : LPSTR;
							nCount, nTabPositions : integer; lpnTabStopPositions : address;
							nTabOrigin : integer) : LONG;
    	external dll='user32.dll' name='TabbedTextOutA' stdcall;

	function GetTabbedTextExtent(hDC : _HDC; lpString : LPSTR;
									nCount, nTabPositions : integer;
									lpnTabStopPositions : address) : DWORD;
    	external dll='user32.dll' name='GetTabbedTextExtentA' stdcall;

	function UpdateWindow(hWnd : _HWND) : BOOL;
    	external dll='user32.dll';

	function SetActiveWindow(hWnd : _HWND) : BOOL;
    	external dll='user32.dll';

	function GetForegroundWindow : HWND;
    	external dll='user32.dll';

	function PaintDesktop(hdc : _HDC) : BOOL;
    	external dll='user32.dll';

	function SetForegroundWindow(hWnd : _HWND) : BOOL;
    	external dll='user32.dll';

	function WindowFromDC(hdc : _HDC) : HWND;
    	external dll='user32.dll';

	function GetDC(hWnd : _HWND) : HDC;
    	external dll='user32.dll';

	function GetDCEx(hWnd : _HWND; hrgnClip : HRGN; flags : DWORD) : HDC;
    	external dll='user32.dll';

const
    DCX_WINDOW = $00000001;
    DCX_CACHE = $00000002;
    DCX_NORESETATTRS = $00000004;
    DCX_CLIPCHILDREN = $00000008;
    DCX_CLIPSIBLINGS = $00000010;
    DCX_PARENTCLIP = $00000020;
    DCX_EXCLUDERGN = $00000040;
    DCX_INTERSECTRGN = $00000080;
    DCX_EXCLUDEUPDATE = $00000100;
    DCX_INTERSECTUPDATE = $00000200;
    DCX_LOCKWINDOWUPDATE = $00000400;
    DCX_VALIDATE = $00200000;

	function GetWindowDC(hWnd : _HWND) : HDC;
    	external dll='user32.dll';

	function ReleaseDC(hWnd : _HWND; hDC : _HDC) : integer;
    	external dll='user32.dll';

	function BeginPaint(hWnd : _HWND; var lpPaint : PAINTSTRUCT) : HDC;
    	external dll='user32.dll';

	function EndPaint(hWnd : _HWND; var lpPaint : PAINTSTRUCT) : BOOL;
    	external dll='user32.dll';

	function GetUpdateRect(hWnd : _HWND; var lpRect : RECT; bErase : BOOL) : BOOL;
    	external dll='user32.dll';

	function GetUpdateRgn(hWnd : _HWND; hRgn : _HRGN; bErase : BOOL) : integer;
    	external dll='user32.dll';

	function SetWindowRgn(hWnd : _HWND; hRgn : _HRGN; bRedraw : BOOL) : integer;
    	external dll='user32.dll';

	function GetWindowRgn(hWnd : _HWND; hRgn : _HRGN) : integer;
    	external dll='user32.dll';

	function ExcludeUpdateRgn(hDC : _HDC; hWnd : _HWND) : integer;
    	external dll='user32.dll';

	function InvalidateRect(hWnd : _HWND; var lpRect : RECT; bErase : BOOL) : BOOL;
    	external dll='user32.dll';

	function ValidateRect(hWnd : _HWND; var lpRect : RECT) : BOOL;
    	external dll='user32.dll';

	function InvalidateRgn(hWnd : _HWND; hRgn : _HRGN; bErase : BOOL) : integer;
    	external dll='user32.dll';

	function ValidateRgn(hWnd : _HWND; hRgn : _HRGN) : integer;
    	external dll='user32.dll';

	function RedrawWindow(hWnd : _HWND; var lprcUpdate : RECT; hrgnUpdate : HRGN; flags : UINT) : BOOL;
    	external dll='user32.dll';

const
    RDW_INVALIDATE = $0001;
    RDW_INTERNALPAINT = $0002;
    RDW_ERASE = $0004;
    RDW_VALIDATE = $0008;
    RDW_NOINTERNALPAINT = $0010;
    RDW_NOERASE = $0020;
    RDW_NOCHILDREN = $0040;
    RDW_ALLCHILDREN = $0080;
    RDW_UPDATENOW = $0100;
    RDW_ERASENOW = $0200;
    RDW_FRAME = $0400;
    RDW_NOFRAME = $0800;

	function LockWindowUpdate(hWndLock : HWND) : BOOL;
    	external dll='user32.dll';

	function ScrollWindow(hWnd : _HWND; XAmount, YAmount : integer;
							var lpRect, lpClipRect : RECT) : BOOL;
    	external dll='user32.dll';

	function ScrollDC(hDC : _HDC; dx, dy : integer;
						var lprcScroll, lprcClip : RECT;
						hrgnUpdate : HRGN; var lprcUpdate : RECT) : BOOL;
    	external dll='user32.dll';

	function ScrollWindowEx(hWnd : _HWND; dx, dy : integer;
						var lprcScroll, lprcClip : RECT;
						hrgnUpdate : HRGN; var lprcUpdate : RECT;
						flags : UINT) : integer;
    	external dll='user32.dll';

const
    SW_SCROLLCHILDREN = $0001;
    SW_INVALIDATE = $0002;
    SW_ERASE = $0004;

	function SetScrollPos(hWnd : _HWND; nBar, nPos : integer; bRedraw : BOOL) : integer;
    	external dll='user32.dll';

	function GetScrollPos(hWnd : _HWND; nBar : integer) : integer;
    	external dll='user32.dll';

	function SetScrollRange(hWnd : _HWND; nBar, nMinPos, nMaxPos : integer; bRedraw : BOOL) : integer;
    	external dll='user32.dll';

	function GetScrollRange(hWnd : _HWND; nBar : integer; var lpMinPos, lpMaxPos : integer) : BOOL;
    	external dll='user32.dll';

	function ShowScrollBar(hWnd : _HWND; wBar : integer; bShow : BOOL) : BOOL;
    	external dll='user32.dll';

	function EnableScrollBar(hWnd : _HWND; uSBflags, wArrows : UINT) : BOOL;
    	external dll='user32.dll';

const
    ESB_ENABLE_BOTH = $0000;
    ESB_DISABLE_BOTH = $0003;
    ESB_DISABLE_LEFT = $0001;
    ESB_DISABLE_RIGHT = $0002;
    ESB_DISABLE_UP = $0001;
    ESB_DISABLE_DOWN = $0002;
    ESB_DISABLE_LTUP = ESB_DISABLE_LEFT;
    ESB_DISABLE_RTDN = ESB_DISABLE_RIGHT;

	function SetProp(hWnd : _HWND; lpString : LPSTR; hData : HANDLE) : BOOL;
	    external dll='user32.dll' name='SetPropA' stdcall;

	function GetProp(hWnd : _HWND; lpString : LPSTR) : HANDLE;
	    external dll='user32.dll' name='GetPropA' stdcall;

	function RemoveProp(hWnd : _HWND; lpString : LPSTR) : HANDLE;
	    external dll='user32.dll' name='RemovePropA' stdcall;

	function EnumPropsEx(hWnd : _HWND; lpEnumFunc : PROC; lParam : _LPARAM) : integer;
	    external dll='user32.dll' name='EnumPropsExA' stdcall;

	function EnumProps(hWnd : _HWND; lpEnumFunc : PROC) : integer;
	    external dll='user32.dll' name='EnumPropsA' stdcall;

	function SetWindowText(hWnd : _HWND; lpString : LPSTR) : BOOL;
	    external dll='user32.dll' name='SetWindowTextA' stdcall;

	function GetWindowText(hWnd : _HWND; lpString : LPSTR; nMaxCount : integer) : integer;
	    external dll='user32.dll' name='GetWindowTextA' stdcall;

	function GetWindowTextLength(hWnd : _HWND) : integer;
	    external dll='user32.dll' name='GetWindowTextLengthA' stdcall;

	function GetClientRect(hWnd : _HWND; var lpRect : RECT) : BOOL;
	    external dll='user32.dll';

	function GetWindowRect(hWnd : _HWND; var lpRect : RECT) : BOOL;
	    external dll='user32.dll';

	function AdjustWindowRect(var lpRect : RECT; dwStyle : DWORD; bMenu : BOOL) : BOOL;
	    external dll='user32.dll';

	function AdjustWindowRectEx(var lpRect : RECT; dwStyle : DWORD; bMenu : BOOL;
								dwExStyle : DWORD) : BOOL;
	    external dll='user32.dll';

const
    HELPINFO_WINDOW = $0001;
    HELPINFO_MENUITEM = $0002;

type
	HELPINFO = packed record
		cbSize : UINT;
		iContextType : integer;
		iCtrlId : integer;
		hItemHandle : HANDLE;
		dwContextId : DWORD;
		MousePos : POINT;
	end;

	function SetWindowContextHelpId(hWnd : _HWND; dwContextId : DWORD) : BOOL;
	    external dll='user32.dll';
	function GetWindowContextHelpId(hWnd : _HWND) : DWORD;
	    external dll='user32.dll';
	function SetMenuContextHelpId(hMenu : _HMENU; dwContextId : DWORD) : BOOL;
	    external dll='user32.dll';
	function GetMenuContextHelpId(hMenu : _HMENU) : DWORD;
	    external dll='user32.dll';

const
    MB_OK = $00000000;
    MB_OKCANCEL = $00000001;
    MB_ABORTRETRYIGNORE = $00000002;
    MB_YESNOCANCEL = $00000003;
    MB_YESNO = $00000004;
    MB_RETRYCANCEL = $00000005;
    MB_ICONHAND = $00000010;
    MB_ICONQUESTION = $00000020;
    MB_ICONEXCLAMATION = $00000030;
    MB_ICONASTERISK = $00000040;
    MB_USERICON = $00000080;
    MB_ICONWARNING = MB_ICONEXCLAMATION;
    MB_ICONERROR = MB_ICONHAND;
    MB_ICONINFORMATION = MB_ICONASTERISK;
    MB_ICONSTOP = MB_ICONHAND;
    MB_DEFBUTTON1 = $00000000;
    MB_DEFBUTTON2 = $00000100;
    MB_DEFBUTTON3 = $00000200;
    MB_DEFBUTTON4 = $00000300;
    MB_APPLMODAL = $00000000;
    MB_SYSTEMMODAL = $00001000;
    MB_TASKMODAL = $00002000;
    MB_HELP = $00004000;
    MB_NOFOCUS = $00008000;
    MB_SETFOREGROUND = $00010000;
    MB_DEFAULT_DESKTOP_ONLY = $00020000;
    MB_TOPMOST = $00040000;
    MB_RIGHT = $00080000;
    MB_RTLREADING = $00100000;
    MB_SERVICE_NOTIFICATION = $00200000;
    MB_SERVICE_NOTIFICATION_NT3X = $00040000;
    MB_TYPEMASK = $0000000F;
    MB_ICONMASK = $000000F0;
    MB_DEFMASK = $00000F00;
    MB_MODEMASK = $00003000;
    MB_MISCMASK = $0000C000;

	function MessageBox(hWnd : _HWND; lpText, lpCaption : LPSTR; uType : UINT) : integer;
	    external dll='user32.dll' name='MessageBoxA' stdcall;

	function MessageBoxEx(hWnd : _HWND; lpText, lpCaption : LPSTR; uType : UINT;
							wLanguageId : shortword) : integer;
	    external dll='user32.dll' name='MessageBoxExA' stdcall;

type
	MSGBOXPARAMS = packed record
		cbSize : UINT;
		hwndOwner : HWND;
		hInstance : _HINSTANCE;
		lpszText : LPCSTR;
		lpszCaption : LPCSTR;
		dwStyle : DWORD;
		lpszIcon : LPCSTR;
		dwContextHelpId : DWORD;
		lpfnMsgBoxCallback : PROC;
		dwLanguageId : DWORD;
	end;

	function MessageBoxIndirect(var lp : MSGBOXPARAMS) : integer;
	    external dll='user32.dll';

	function MessageBeep(uType : UINT) : BOOL;
	    external dll='user32.dll';

	function ShowCursor(bShow : BOOL) : integer;
	    external dll='user32.dll';

	function SetCursorPos(x, y : integer) : BOOL;
	    external dll='user32.dll';

	function SetCursor(hCursor : _HCURSOR) : _HCURSOR;
	    external dll='user32.dll';

	function GetCursorPos(var lpPoint : POINT) : BOOL;
	    external dll='user32.dll';

	function ClipCursor(var lpRect : RECT) : BOOL;
	    external dll='user32.dll';

	function GetClipCursor(var lpRect : RECT) : BOOL;
	    external dll='user32.dll';

	function GetCursor : HCURSOR;
	    external dll='user32.dll';

	function CreateCaret(hWnd : _HWND; hbmp : HBITMAP; nWidth, nHeight : integer) : BOOL;
	    external dll='user32.dll';

	function GetCaretBlinkTime : UINT;
	    external dll='user32.dll';

	function SetCaretBlinkTime(umsecs : UINT) : BOOL;
	    external dll='user32.dll';

	function DestroyCaret : BOOL;
	    external dll='user32.dll';

	function HideCaret(hWnd : _HWND) : BOOL;
	    external dll='user32.dll';

	function ShowCaret(hWnd : _HWND) : BOOL;
	    external dll='user32.dll';

	function SetCaretPos(x, y : integer) : BOOL;
	    external dll='user32.dll';

	function GetCaretPos(var lpPoint : POINT) : BOOL;
	    external dll='user32.dll';

	function ClientToScreen(hWnd : _HWND; var lpPoint : POINT) : BOOL;
	    external dll='user32.dll';
	function ScreenToClient(hWnd : _HWND; var lpPoint : POINT) : BOOL;
	    external dll='user32.dll';

	function MapWindowPoints(hWndFrom, hWndTo : HWND; lpPoints : address; cPoints : UINT) : integer;
	    external dll='user32.dll';

	function WindowFromPoint(pt : POINT) : HWND;
	    external dll='user32.dll';

	function ChildWindowFromPoint(hWndParent : HWND; pt : POINT) : HWND;
	    external dll='user32.dll';

const
    CWP_ALL = $0000;
    CWP_SKIPINVISIBLE = $0001;
    CWP_SKIPDISABLED = $0002;
    CWP_SKIPTRANSPARENT = $0004;

	function ChildWindowFromPointEx(hWndParent : HWND; pt : POINT; uFlags : UINT) : HWND;
	    external dll='user32.dll';

const
    CTLCOLOR_MSGBOX = 0;
    CTLCOLOR_EDIT = 1;
    CTLCOLOR_LISTBOX = 2;
    CTLCOLOR_BTN = 3;
    CTLCOLOR_DLG = 4;
    CTLCOLOR_SCROLLBAR = 5;
    CTLCOLOR_STATIC = 6;
    CTLCOLOR_MAX = 7;
    COLOR_SCROLLBAR = 0;
    COLOR_BACKGROUND = 1;
    COLOR_ACTIVECAPTION = 2;
    COLOR_INACTIVECAPTION = 3;
    COLOR_MENU = 4;
    COLOR_WINDOW = 5;
    COLOR_WINDOWFRAME = 6;
    COLOR_MENUTEXT = 7;
    COLOR_WINDOWTEXT = 8;
    COLOR_CAPTIONTEXT = 9;
    COLOR_ACTIVEBORDER = 10;
    COLOR_INACTIVEBORDER = 11;
    COLOR_APPWORKSPACE = 12;
    COLOR_HIGHLIGHT = 13;
    COLOR_HIGHLIGHTTEXT = 14;
    COLOR_BTNFACE = 15;
    COLOR_BTNSHADOW = 16;
    COLOR_GRAYTEXT = 17;
    COLOR_BTNTEXT = 18;
    COLOR_INACTIVECAPTIONTEXT = 19;
    COLOR_BTNHIGHLIGHT = 20;
    COLOR_3DDKSHADOW = 21;
    COLOR_3DLIGHT = 22;
    COLOR_INFOTEXT = 23;
    COLOR_INFOBK = 24;
    COLOR_DESKTOP = COLOR_BACKGROUND;
    COLOR_3DFACE = COLOR_BTNFACE;
    COLOR_3DSHADOW = COLOR_BTNSHADOW;
    COLOR_3DHIGHLIGHT = COLOR_BTNHIGHLIGHT;
    COLOR_3DHILIGHT = COLOR_BTNHIGHLIGHT;
    COLOR_BTNHILIGHT = COLOR_BTNHIGHLIGHT;

	function GetSysColor(nIndex : integer) : DWORD;
	    external dll='user32.dll';
	function GetSysColorBrush(nIndex : integer) : HBRUSH;
	    external dll='user32.dll';
	function SetSysColors(cElements : integer; lpaElements : address; lpaRgbValues : address) : BOOL;
	    external dll='user32.dll';

	function DrawFocusRect(hDC : _HDC; var lprc : RECT) : BOOL;
	    external dll='user32.dll';
	function FillRect(hDC : _HDC; var lprc : RECT; hbr : HBRUSH) : integer;
	    external dll='user32.dll';
	function FrameRect(hDC : _HDC; var lprc : RECT; hbr : HBRUSH) : integer;
	    external dll='user32.dll';
	function InvertRect(hDC : _HDC; var lprc : RECT) : BOOL;
	    external dll='user32.dll';
	function SetRect(var lprc : RECT; xLeft, yTop, xRight, yBottom : integer) : BOOL;
	    external dll='user32.dll';
	function SetRectEmpty(var lprc : RECT) : BOOL;
	    external dll='user32.dll';
	function CopyRect(var lprcDst, lprcSrc : RECT) : BOOL;
	    external dll='user32.dll';
	function InflateRect(var lprc : RECT; dx, dy : integer) : BOOL;
	    external dll='user32.dll';
	function IntersectRect(var lprcDst, lprcSrc1, lprcSrc2 : RECT) : BOOL;
	    external dll='user32.dll';
	function UnionRect(var lprcDst, lprcSrc1, lprcSrc2 : RECT) : BOOL;
	    external dll='user32.dll';
	function SubtractRect(var lprcDst, lprcSrc1, lprcSrc2 : RECT) : BOOL;
	    external dll='user32.dll';
	function OffsetRect(var lprc : RECT; dx, dy : integer) : BOOL;
	    external dll='user32.dll';
	function IsRectEmpty(var lprc : RECT) : BOOL;
	    external dll='user32.dll';
	function EqualRect(var lprc1, lprc2 : RECT) : BOOL;
	    external dll='user32.dll';
	function PtInRect(var lprc : RECT; pt : POINT) : BOOL;
	    external dll='user32.dll';

	function GetWindowWord(hWnd : _HWND; nIndex : integer) : shortword;
	    external dll='user32.dll';
	function SetWindowWord(hWnd : _HWND; nIndex : integer; wNewWord : shortword) : shortword;
	    external dll='user32.dll';
	function GetWindowLong(hWnd : _HWND; nIndex : integer) : LONG;
	    external dll='user32.dll' name='GetWindowLongA' stdcall;
	function SetWindowLong(hWnd : _HWND; nIndex : integer; dwNewLong : LONG) : LONG;
	    external dll='user32.dll' name='SetWindowLongA' stdcall;
	function GetClassWord(hWnd : _HWND; nIndex : integer) : shortword;
	    external dll='user32.dll';
	function SetClassWord(hWnd : _HWND; nIndex : integer; wNewWord : shortword) : shortword;
	    external dll='user32.dll';
	function GetClassLong(hWnd : _HWND; nIndex : integer) : DWORD;
	    external dll='user32.dll' name='GetClassLongA' stdcall;
	function SetClassLong(hWnd : _HWND; nIndex : integer; dwNewLong : LONG) : DWORD;
	    external dll='user32.dll' name='SetClassLongA' stdcall;

	function GetDesktopWindow : HWND;
	    external dll='user32.dll';
	function GetParent(hWnd : _HWND) : _HWND;
	    external dll='user32.dll';
	function SetParent(hWndChild, hWndNewParent : HWND) : HWND;
	    external dll='user32.dll';
	function EnumChildWindows(hWndParent : HWND; lpEnumFunc : PROC; lParam : _LPARAM) : BOOL;
	    external dll='user32.dll';
	function FindWindow(lpClassName, lpWindowName : LPSTR) : HWND;
	    external dll='user32.dll' name='FindWindowA' stdcall;
	function FindWindowEx(hWndParent, hWndChild : HWND; lpClassName, lpWindowName : LPSTR) : HWND;
	    external dll='user32.dll' name='FindWindowExA' stdcall;
	function EnumWindows(lpEnumFunc : PROC; lParam : _LPARAM) : BOOL;
	    external dll='user32.dll';
	function EnumThreadWindows(dwThreadId : DWORD; lpfn : PROC; lParam : _LPARAM) : BOOL;
	    external dll='user32.dll';
	function GetClassName(hWnd : _HWND; lpClassName : LPSTR; nMaxCount : integer) : integer;
	    external dll='user32.dll' name='GetClassNameA' stdcall;
	function GetTopWindow(hWnd : _HWND) : _HWND;
	    external dll='user32.dll';
	function GetWindowThreadProcessId(hWnd : _HWND; var lpdwProcessId : DWORD) : DWORD;
	    external dll='user32.dll';
	function GetLastActivePopup(hWnd : _HWND) : _HWND;
	    external dll='user32.dll';

const
    GW_HWNDFIRST = 0;
    GW_HWNDLAST = 1;
    GW_HWNDNEXT = 2;
    GW_HWNDPREV = 3;
    GW_OWNER = 4;
    GW_CHILD = 5;
    GW_MAX = 5;

	function GetWindow(hWnd : _HWND; uCmd : UINT) : _HWND;
	    external dll='user32.dll';

	function SetWindowsHook(nFilterType : integer; pfnFilterProc : PROC) : HHOOK;
	    external dll='user32.dll' name='SetWindowsHookA' stdcall;
	function UnhookWindowsHook(nCode : integer; pfnFilterProc : PROC) : BOOL;
	    external dll='user32.dll';
	function SetWindowsHookEx(nidHook : integer; lpfn : PROC; hmod : HINSTANCE; dwThreadId : DWORD) : HHOOK;
	    external dll='user32.dll' name='SetWindowsHookExA' stdcall;
	function UnhookWindowsHookEx(hhk : HHOOK) : BOOL;
	    external dll='user32.dll';
	function CallNextHookEx(hhk : HHOOK; nCode : integer; wParam : _WPARAM; lParam : _LPARAM) : LRESULT;
	    external dll='user32.dll';

const
    MF_INSERT = $00000000;
    MF_CHANGE = $00000080;
    MF_APPEND = $00000100;
    MF_DELETE = $00000200;
    MF_REMOVE = $00001000;
    MF_BYCOMMAND = $00000000;
    MF_BYPOSITION = $00000400;
    MF_SEPARATOR = $00000800;
    MF_ENABLED = $00000000;
    MF_GRAYED = $00000001;
    MF_DISABLED = $00000002;
    MF_UNCHECKED = $00000000;
    MF_CHECKED = $00000008;
    MF_USECHECKBITMAPS = $00000200;
    MF_STRING = $00000000;
    MF_BITMAP = $00000004;
    MF_OWNERDRAW = $00000100;
    MF_POPUP = $00000010;
    MF_MENUBARBREAK = $00000020;
    MF_MENUBREAK = $00000040;
    MF_UNHILITE = $00000000;
    MF_HILITE = $00000080;
    MF_DEFAULT = $00001000;
    MF_SYSMENU = $00002000;
    MF_HELP = $00004000;
    MF_RIGHTJUSTIFY = $00004000;
    MF_MOUSESELECT = $00008000;
    MF_END = $00000080;
    MFT_STRING = MF_STRING;
    MFT_BITMAP = MF_BITMAP;
    MFT_MENUBARBREAK = MF_MENUBARBREAK;
    MFT_MENUBREAK = MF_MENUBREAK;
    MFT_OWNERDRAW = MF_OWNERDRAW;
    MFT_RADIOCHECK = $00000200;
    MFT_SEPARATOR = MF_SEPARATOR;
    MFT_RIGHTORDER = $00002000;
    MFT_RIGHTJUSTIFY = MF_RIGHTJUSTIFY;
    MFS_GRAYED = $00000003;
    MFS_DISABLED = MFS_GRAYED;
    MFS_CHECKED = MF_CHECKED;
    MFS_HILITE = MF_HILITE;
    MFS_ENABLED = MF_ENABLED;
    MFS_UNCHECKED = MF_UNCHECKED;
    MFS_UNHILITE = MF_UNHILITE;
    MFS_DEFAULT = MF_DEFAULT;

	function CheckMenuRadioItem(hMenu : _HMENU; idFirst, idLast, idCheck, uFlags : UINT) : BOOL;
	    external dll='user32.dll';

type
	MENUITEMTEMPLATEHEADER = packed record
		versionNumber : shortword;
		offset : shortword;
	end;

	MENUITEMTEMPLATE = packed record
		mtOption : shortword;
		mtID : shortword;
		mtString : array[1..1] of WCHAR;
	end;

const
    SC_SIZE = $F000;
    SC_MOVE = $F010;
    SC_MINIMIZE = $F020;
    SC_MAXIMIZE = $F030;
    SC_NEXTWINDOW = $F040;
    SC_PREVWINDOW = $F050;
    SC_CLOSE = $F060;
    SC_VSCROLL = $F070;
    SC_HSCROLL = $F080;
    SC_MOUSEMENU = $F090;
    SC_KEYMENU = $F100;
    SC_ARRANGE = $F110;
    SC_RESTORE = $F120;
    SC_TASKLIST = $F130;
    SC_SCREENSAVE = $F140;
    SC_HOTKEY = $F150;
    SC_DEFAULT = $F160;
    SC_MONITORPOWER = $F170;
    SC_CONTEXTHELP = $F180;
    SC_SEPARATOR = $F00F;
    SC_ICON = SC_MINIMIZE;
    SC_ZOOM = SC_MAXIMIZE;

	function LoadBitmap(hInstance : _HINSTANCE; lpBitmapName : LPSTR) : HBITMAP;
	    external dll='user32.dll' name='LoadBitmapA' stdcall;
	function LoadCursor(hInstance : _HINSTANCE; lpCursorName : LPSTR) : HCURSOR;
	    external dll='user32.dll' name='LoadCursorA' stdcall;
	function LoadCursorFromFile(lpFileName : LPSTR) : HCURSOR;
	    external dll='user32.dll' name='LoadCursorFromFileA' stdcall;
	function CreateCursor(hInst : HINSTANCE; xHotSpot, yHotSpot, nWidth, nHeight : integer;
							pvANDPlance, pvXORPlace : address) : HCURSOR;
	    external dll='user32.dll';
	function DestroyCursor(hCursor : _HCURSOR) : BOOL;
	    external dll='user32.dll';

const
    IDC_ARROW = 32512;
    IDC_IBEAM = 32513;
    IDC_WAIT = 32514;
    IDC_CROSS = 32515;
    IDC_UPARROW = 32516;
    IDC_SIZE = 32640;
    IDC_ICON = 32641;
    IDC_SIZENWSE = 32642;
    IDC_SIZENESW = 32643;
    IDC_SIZEWE = 32644;
    IDC_SIZENS = 32645;
    IDC_SIZEALL = 32646;
    IDC_NO = 32648;
    IDC_APPSTARTING = 32650;
    IDC_HELP = 32651;

	function SetSystemCursor(hcur : HCURSOR; id : DWORD) : BOOL;
	    external dll='user32.dll';

type
	ICONINFO = packed record
		fIcon : BOOL;
		xHotSpot : DWORD;
		yHotSpot : DWORD;
		hbmpMask : HBITMAP;
		hbmpColor : HBITMAP;
	end;

	function LoadIcon(hInstance : _HINSTANCE; lpIconName : LPSTR) : HICON;
	    external dll='user32.dll' name='LoadIconA' stdcall;
	function CreateIcon(hInst : HINSTANCE; nWidth, nHeight : integer;
							cPlanes, cBitsPixel : BYTE;
							lpbANDbits, lpbXORbits : address) : HICON;
	    external dll='user32.dll';
	function DestroyIcon(hIcon : _HICON) : BOOL;
	    external dll='user32.dll';
	function LookupIconIdFromDirectory(presbits : address; fIcon : BOOL) : integer;
	    external dll='user32.dll';
	function LookupIconIdFromDirectoryEx(presbits : address; fIcon : BOOL;
											cxDesired, cyDesired : integer;
											Flags : UINT) : integer;
	    external dll='user32.dll';
	function CreateIconFromResource(presbits : address; dwResSize : DWORD;
									fIcon : BOOL; dwVer : DWORD) : HICON;
	    external dll='user32.dll';
	function CreateIconFromResourceEx(presbits : address; dwResSize : DWORD;
									fIcon : BOOL; dwVer : DWORD;
									cxDesired, cyDesired : integer;
									Flags : UINT) : HICON;
	    external dll='user32.dll';

type
	CURSORSHAPE = packed record
		xHotSpot : integer;
		yHotSpot : integer;
		cx : integer;
		cy : integer;
		cbWidth : integer;
		Planes : BYTE;
		BitsPixel : BYTE;
	end;

const
    IMAGE_BITMAP = 0;
    IMAGE_ICON = 1;
    IMAGE_CURSOR = 2;
    IMAGE_ENHMETAFILE = 3;
    LR_DEFAULTCOLOR = $0000;
    LR_MONOCHROME = $0001;
    LR_COLOR = $0002;
    LR_COPYRETURNORG = $0004;
    LR_COPYDELETEORG = $0008;
    LR_LOADFROMFILE = $0010;
    LR_LOADTRANSPARENT = $0020;
    LR_DEFAULTSIZE = $0040;
    LR_VGACOLOR = $0080;
    LR_LOADMAP3DCOLORS = $1000;
    LR_CREATEDIBSECTION = $2000;
    LR_COPYFROMRESOURCE = $4000;
    LR_SHARED = $8000;

	function LoadImage(hinst : HINSTANCE; lpszName : LPSTR; uType : UINT;
						cxDesired, cyDesired : integer; fuLoad : UINT) : HANDLE;
	    external dll='user32.dll' name='LoadImageA' stdcall;
	function CopyImage(hImage : HANDLE; uType : UINT; cxDesired, cyDesired : integer;
						fuFlags : UINT) : HANDLE;
	    external dll='user32.dll';

const
    DI_MASK = $0001;
    DI_IMAGE = $0002;
    DI_NORMAL = $0003;
    DI_COMPAT = $0004;
    DI_DEFAULTSIZE = $0008;

	function DrawIconEx(hdc : _HDC; xLeft, yTop : integer; hIcon : _HICON;
						cxWidth, cyWidth : integer; istepIfAniCur : UINT;
						hbrFlickerFreeDraw : HBRUSH; diFlags : UINT) : BOOL;
	    external dll='user32.dll';
	function CreateIconIndirect(var piconinfo : ICONINFO) : HICON;
	    external dll='user32.dll';
	function CopyIcon(hIcom : _HICON) : _HICON;
	    external dll='user32.dll';
	function GetIconInfo(hIcon : _HICON; var piconinfo : ICONINFO) : BOOL;
	    external dll='user32.dll';

const
    RES_ICON = 1;
    RES_CURSOR = 2;

    OBM_CLOSE = 32754;
    OBM_UPARROW = 32753;
    OBM_DNARROW = 32752;
    OBM_RGARROW = 32751;
    OBM_LFARROW = 32750;
    OBM_REDUCE = 32749;
    OBM_ZOOM = 32748;
    OBM_RESTORE = 32747;
    OBM_REDUCED = 32746;
    OBM_ZOOMD = 32745;
    OBM_RESTORED = 32744;
    OBM_UPARROWD = 32743;
    OBM_DNARROWD = 32742;
    OBM_RGARROWD = 32741;
    OBM_LFARROWD = 32740;
    OBM_MNARROW = 32739;
    OBM_COMBO = 32738;
    OBM_UPARROWI = 32737;
    OBM_DNARROWI = 32736;
    OBM_RGARROWI = 32735;
    OBM_LFARROWI = 32734;
    OBM_OLD_CLOSE = 32767;
    OBM_SIZE = 32766;
    OBM_OLD_UPARROW = 32765;
    OBM_OLD_DNARROW = 32764;
    OBM_OLD_RGARROW = 32763;
    OBM_OLD_LFARROW = 32762;
    OBM_BTSIZE = 32761;
    OBM_CHECK = 32760;
    OBM_CHECKBOXES = 32759;
    OBM_BTNCORNERS = 32758;
    OBM_OLD_REDUCE = 32757;
    OBM_OLD_ZOOM = 32756;
    OBM_OLD_RESTORE = 32755;
    OCR_NORMAL = 32512;
    OCR_IBEAM = 32513;
    OCR_WAIT = 32514;
    OCR_CROSS = 32515;
    OCR_UP = 32516;
    OCR_SIZE = 32640;
    OCR_ICON = 32641;
    OCR_SIZENWSE = 32642;
    OCR_SIZENESW = 32643;
    OCR_SIZEWE = 32644;
    OCR_SIZENS = 32645;
    OCR_SIZEALL = 32646;
    OCR_ICOCUR = 32647;
    OCR_NO = 32648;
    OCR_APPSTARTING = 32650;
    OIC_SAMPLE = 32512;
    OIC_HAND = 32513;
    OIC_QUES = 32514;
    OIC_BANG = 32515;
    OIC_NOTE = 32516;
    OIC_WINLOGO = 32517;
    OIC_WARNING = OIC_BANG;
    OIC_ERROR = OIC_HAND;
    OIC_INFORMATION = OIC_NOTE;

	ORD_LANGDRIVER = 1;

    IDI_APPLICATION = 32512;
    IDI_HAND = 32513;
    IDI_QUESTION = 32514;
    IDI_EXCLAMATION = 32515;
    IDI_ASTERISK = 32516;
    IDI_WINLOGO = 32517;
    IDI_WARNING = IDI_EXCLAMATION;
    IDI_ERROR = IDI_HAND;
    IDI_INFORMATION = IDI_ASTERISK;

	function LoadString(hInstance : _HINSTANCE; uID : UINT; lpBuffer : address; nBufferMax : integer) : integer;
	    external dll='user32.dll' name='LoadStringA' stdcall;

const
    IDOK = 1;
    IDCANCEL = 2;
    IDABORT = 3;
    IDRETRY = 4;
    IDIGNORE = 5;
    IDYES = 6;
    IDNO = 7;
    IDCLOSE = 8;
    IDHELP = 9;

    ES_LEFT = $0000;
    ES_CENTER = $0001;
    ES_RIGHT = $0002;
    ES_MULTILINE = $0004;
    ES_UPPERCASE = $0008;
    ES_LOWERCASE = $0010;
    ES_PASSWORD = $0020;
    ES_AUTOVSCROLL = $0040;
    ES_AUTOHSCROLL = $0080;
    ES_NOHIDESEL = $0100;
    ES_OEMCONVERT = $0400;
    ES_READONLY = $0800;
    ES_WANTRETURN = $1000;
    ES_NUMBER = $2000;

    EN_SETFOCUS = $0100;
    EN_KILLFOCUS = $0200;
    EN_CHANGE = $0300;
    EN_UPDATE = $0400;
    EN_ERRSPACE = $0500;
    EN_MAXTEXT = $0501;
    EN_HSCROLL = $0601;
    EN_VSCROLL = $0602;
    EC_LEFTMARGIN = $0001;
    EC_RIGHTMARGIN = $0002;
    EC_USEFONTINFO = $ffff;

    EM_GETSEL = $00B0;
    EM_SETSEL = $00B1;
    EM_GETRECT = $00B2;
    EM_SETRECT = $00B3;
    EM_SETRECTNP = $00B4;
    EM_SCROLL = $00B5;
    EM_LINESCROLL = $00B6;
    EM_SCROLLCARET = $00B7;
    EM_GETMODIFY = $00B8;
    EM_SETMODIFY = $00B9;
    EM_GETLINECOUNT = $00BA;
    EM_LINEINDEX = $00BB;
    EM_SETHANDLE = $00BC;
    EM_GETHANDLE = $00BD;
    EM_GETTHUMB = $00BE;
    EM_LINELENGTH = $00C1;
    EM_REPLACESEL = $00C2;
    EM_GETLINE = $00C4;
    EM_LIMITTEXT = $00C5;
    EM_CANUNDO = $00C6;
    EM_UNDO = $00C7;
    EM_FMTLINES = $00C8;
    EM_LINEFROMCHAR = $00C9;
    EM_SETTABSTOPS = $00CB;
    EM_SETPASSWORDCHAR = $00CC;
    EM_EMPTYUNDOBUFFER = $00CD;
    EM_GETFIRSTVISIBLELINE = $00CE;
    EM_SETREADONLY = $00CF;
    EM_SETWORDBREAKPROC = $00D0;
    EM_GETWORDBREAKPROC = $00D1;
    EM_GETPASSWORDCHAR = $00D2;
    EM_SETMARGINS = $00D3;
    EM_GETMARGINS = $00D4;
    EM_SETLIMITTEXT = EM_LIMITTEXT;
    EM_GETLIMITTEXT = $00D5;
    EM_POSFROMCHAR = $00D6;
    EM_CHARFROMPOS = $00D7;

    WB_LEFT = 0;
    WB_RIGHT = 1;
    WB_ISDELIMITER = 2;

    BS_PUSHBUTTON = $00000000;
    BS_DEFPUSHBUTTON = $00000001;
    BS_CHECKBOX = $00000002;
    BS_AUTOCHECKBOX = $00000003;
    BS_RADIOBUTTON = $00000004;
    BS_3STATE = $00000005;
    BS_AUTO3STATE = $00000006;
    BS_GROUPBOX = $00000007;
    BS_USERBUTTON = $00000008;
    BS_AUTORADIOBUTTON = $00000009;
    BS_OWNERDRAW = $0000000B;
    BS_LEFTTEXT = $00000020;
    BS_TEXT = $00000000;
    BS_ICON = $00000040;
    BS_BITMAP = $00000080;
    BS_LEFT = $00000100;
    BS_RIGHT = $00000200;
    BS_CENTER = $00000300;
    BS_TOP = $00000400;
    BS_BOTTOM = $00000800;
    BS_VCENTER = $00000C00;
    BS_PUSHLIKE = $00001000;
    BS_MULTILINE = $00002000;
    BS_NOTIFY = $00004000;
    BS_FLAT = $00008000;
    BS_RIGHTBUTTON = BS_LEFTTEXT;

    BN_CLICKED = 0;
    BN_PAINT = 1;
    BN_HILITE = 2;
    BN_UNHILITE = 3;
    BN_DISABLE = 4;
    BN_DOUBLECLICKED = 5;
    BN_PUSHED = BN_HILITE;
    BN_UNPUSHED = BN_UNHILITE;
    BN_DBLCLK = BN_DOUBLECLICKED;
    BN_SETFOCUS = 6;
    BN_KILLFOCUS = 7;

    BM_GETCHECK = $00F0;
    BM_SETCHECK = $00F1;
    BM_GETSTATE = $00F2;
    BM_SETSTATE = $00F3;
    BM_SETSTYLE = $00F4;
    BM_CLICK = $00F5;
    BM_GETIMAGE = $00F6;
    BM_SETIMAGE = $00F7;
    BST_UNCHECKED = $0000;
    BST_CHECKED = $0001;
    BST_INDETERMINATE = $0002;
    BST_PUSHED = $0004;
    BST_FOCUS = $0008;

    SS_LEFT = $00000000;
    SS_CENTER = $00000001;
    SS_RIGHT = $00000002;
    SS_ICON = $00000003;
    SS_BLACKRECT = $00000004;
    SS_GRAYRECT = $00000005;
    SS_WHITERECT = $00000006;
    SS_BLACKFRAME = $00000007;
    SS_GRAYFRAME = $00000008;
    SS_WHITEFRAME = $00000009;
    SS_USERITEM = $0000000A;
    SS_SIMPLE = $0000000B;
    SS_LEFTNOWORDWRAP = $0000000C;
    SS_OWNERDRAW = $0000000D;
    SS_BITMAP = $0000000E;
    SS_ENHMETAFILE = $0000000F;
    SS_ETCHEDHORZ = $00000010;
    SS_ETCHEDVERT = $00000011;
    SS_ETCHEDFRAME = $00000012;
    SS_TYPEMASK = $0000001F;
    SS_NOPREFIX = $00000080;
    SS_NOTIFY = $00000100;
    SS_CENTERIMAGE = $00000200;
    SS_RIGHTJUST = $00000400;
    SS_REALSIZEIMAGE = $00000800;
    SS_SUNKEN = $00001000;
    SS_ENDELLIPSIS = $00004000;
    SS_PATHELLIPSIS = $00008000;
    SS_WORDELLIPSIS = $0000C000;
    SS_ELLIPSISMASK = $0000C000;

    STM_SETICON = $0170;
    STM_GETICON = $0171;
    STM_SETIMAGE = $0172;
    STM_GETIMAGE = $0173;
    STN_CLICKED = 0;
    STN_DBLCLK = 1;
    STN_ENABLE = 2;
    STN_DISABLE = 3;
    STM_MSGMAX = $0174;

	WC_DIALOG = $8002;

    DWL_MSGRESULT = 0;
    DWL_DLGPROC = 4;
    DWL_USER = 8;

	function IsDialogMessage(hDlg : HWND; var lpMsg : MSG) : BOOL;
	    external dll='user32.dll' name='IsDialogMessageA' stdcall;

	function MapDialogRect(hDlg : HWND; var lpRect : RECT) : BOOL;
	    external dll='user32.dll';
	function DlgDirList(hDlg : HWND; lpPathSpec : LPSTR; nIDListBox, nIDStaticPath : integer;
						uFileType : UINT) : integer;
	    external dll='user32.dll' name='DlgDirListA' stdcall;

const
    DDL_READWRITE = $0000;
    DDL_READONLY = $0001;
    DDL_HIDDEN = $0002;
    DDL_SYSTEM = $0004;
    DDL_DIRECTORY = $0010;
    DDL_ARCHIVE = $0020;
    DDL_POSTMSGS = $2000;
    DDL_DRIVES = $4000;
    DDL_EXCLUSIVE = $8000;

	function DlgDirSelectEx(hDlg : HWND; lpString : LPSTR; nCount, nIDListBox : integer) : BOOL;
	    external dll='user32.dll' name='DlgDirSelectExA' stdcall;
	function DlgDirListComboBox(hDlg : HWND; lpPathSpec : LPSTR; nIDComboBox, nIDStaticPath : integer;
						uFileType : UINT) : integer;
	    external dll='user32.dll' name='DlgDirListComboBoxA' stdcall;
	function DlgDirSelectComboBoxEx(hDlg : HWND; lpString : LPSTR; nCount, nIDComboBox : integer) : BOOL;
	    external dll='user32.dll' name='DlgDirSelectComboBoxExA' stdcall;

const
    DS_ABSALIGN = $01;
    DS_SYSMODAL = $02;
    DS_LOCALEDIT = $20;
    DS_SETFONT = $40;
    DS_MODALFRAME = $80;
    DS_NOIDLEMSG = $100;
    DS_SETFOREGROUND = $200;
    DS_3DLOOK = $0004;
    DS_FIXEDSYS = $0008;
    DS_NOFAILCREATE = $0010;
    DS_CONTROL = $0400;
    DS_CENTER = $0800;
    DS_CENTERMOUSE = $1000;
    DS_CONTEXTHELP = $2000;

    DM_GETDEFID = $0400;
    DM_SETDEFID = $0401;
    DM_REPOSITION = $0402;
    PSM_PAGEINFO = $0464;
    PSM_SHEETINFO = $0465;
    PSI_SETACTIVE = $0001;
    PSI_KILLACTIVE = $0002;
    PSI_APPLY = $0003;
    PSI_RESET = $0004;
    PSI_HASHELP = $0005;
    PSI_HELP = $0006;
    PSI_CHANGED = $0001;
    PSI_GUISTART = $0002;
    PSI_REBOOT = $0003;
    PSI_GETSIBLINGS = $0004;
	DC_HASDEFID = $534B;

    DLGC_WANTARROWS = $0001;
    DLGC_WANTTAB = $0002;
    DLGC_WANTALLKEYS = $0004;
    DLGC_WANTMESSAGE = $0004;
    DLGC_HASSETSEL = $0008;
    DLGC_DEFPUSHBUTTON = $0010;
    DLGC_UNDEFPUSHBUTTON = $0020;
    DLGC_RADIOBUTTON = $0040;
    DLGC_WANTCHARS = $0080;
    DLGC_STATIC = $0100;
    DLGC_BUTTON = $2000;
    LB_CTLCODE = 0;

    LB_OKAY = 0;
    LB_ERR = -1;
    LB_ERRSPACE = -2;

    LBN_ERRSPACE = -2;
    LBN_SELCHANGE = 1;
    LBN_DBLCLK = 2;
    LBN_SELCANCEL = 3;
    LBN_SETFOCUS = 4;
    LBN_KILLFOCUS = 5;

    LB_ADDSTRING = $0180;
    LB_INSERTSTRING = $0181;
    LB_DELETESTRING = $0182;
    LB_SELITEMRANGEEX = $0183;
    LB_RESETCONTENT = $0184;
    LB_SETSEL = $0185;
    LB_SETCURSEL = $0186;
    LB_GETSEL = $0187;
    LB_GETCURSEL = $0188;
    LB_GETTEXT = $0189;
    LB_GETTEXTLEN = $018A;
    LB_GETCOUNT = $018B;
    LB_SELECTSTRING = $018C;
    LB_DIR = $018D;
    LB_GETTOPINDEX = $018E;
    LB_FINDSTRING = $018F;
    LB_GETSELCOUNT = $0190;
    LB_GETSELITEMS = $0191;
    LB_SETTABSTOPS = $0192;
    LB_GETHORIZONTALEXTENT = $0193;
    LB_SETHORIZONTALEXTENT = $0194;
    LB_SETCOLUMNWIDTH = $0195;
    LB_ADDFILE = $0196;
    LB_SETTOPINDEX = $0197;
    LB_GETITEMRECT = $0198;
    LB_GETITEMDATA = $0199;
    LB_SETITEMDATA = $019A;
    LB_SELITEMRANGE = $019B;
    LB_SETANCHORINDEX = $019C;
    LB_GETANCHORINDEX = $019D;
    LB_SETCARETINDEX = $019E;
    LB_GETCARETINDEX = $019F;
    LB_SETITEMHEIGHT = $01A0;
    LB_GETITEMHEIGHT = $01A1;
    LB_FINDSTRINGEXACT = $01A2;
    LB_SETLOCALE = $01A5;
    LB_GETLOCALE = $01A6;
    LB_SETCOUNT = $01A7;
    LB_INITSTORAGE = $01A8;
    LB_ITEMFROMPOINT = $01A9;
    LB_MSGMAX = $01B0;

    LBS_NOTIFY = $0001;
    LBS_SORT = $0002;
    LBS_NOREDRAW = $0004;
    LBS_MULTIPLESEL = $0008;
    LBS_OWNERDRAWFIXED = $0010;
    LBS_OWNERDRAWVARIABLE = $0020;
    LBS_HASSTRINGS = $0040;
    LBS_USETABSTOPS = $0080;
    LBS_NOINTEGRALHEIGHT = $0100;
    LBS_MULTICOLUMN = $0200;
    LBS_WANTKEYBOARDINPUT = $0400;
    LBS_EXTENDEDSEL = $0800;
    LBS_DISABLENOSCROLL = $1000;
    LBS_NODATA = $2000;
    LBS_NOSEL = $4000;
    LBS_STANDARD = $00A00003;

    CB_OKAY = 0;
    CB_ERR = -1;
    CB_ERRSPACE = -2;

    CBN_ERRSPACE = -1;
    CBN_SELCHANGE = 1;
    CBN_DBLCLK = 2;
    CBN_SETFOCUS = 3;
    CBN_KILLFOCUS = 4;
    CBN_EDITCHANGE = 5;
    CBN_EDITUPDATE = 6;
    CBN_DROPDOWN = 7;
    CBN_CLOSEUP = 8;
    CBN_SELENDOK = 9;
    CBN_SELENDCANCEL = 10;

    CBS_SIMPLE = $0001;
    CBS_DROPDOWN = $0002;
    CBS_DROPDOWNLIST = $0003;
    CBS_OWNERDRAWFIXED = $0010;
    CBS_OWNERDRAWVARIABLE = $0020;
    CBS_AUTOHSCROLL = $0040;
    CBS_OEMCONVERT = $0080;
    CBS_SORT = $0100;
    CBS_HASSTRINGS = $0200;
    CBS_NOINTEGRALHEIGHT = $0400;
    CBS_DISABLENOSCROLL = $0800;
    CBS_UPPERCASE = $2000;
    CBS_LOWERCASE = $4000;

    CB_GETEDITSEL = $0140;
    CB_LIMITTEXT = $0141;
    CB_SETEDITSEL = $0142;
    CB_ADDSTRING = $0143;
    CB_DELETESTRING = $0144;
    CB_DIR = $0145;
    CB_GETCOUNT = $0146;
    CB_GETCURSEL = $0147;
    CB_GETLBTEXT = $0148;
    CB_GETLBTEXTLEN = $0149;
    CB_INSERTSTRING = $014A;
    CB_RESETCONTENT = $014B;
    CB_FINDSTRING = $014C;
    CB_SELECTSTRING = $014D;
    CB_SETCURSEL = $014E;
    CB_SHOWDROPDOWN = $014F;
    CB_GETITEMDATA = $0150;
    CB_SETITEMDATA = $0151;
    CB_GETDROPPEDCONTROLRECT = $0152;
    CB_SETITEMHEIGHT = $0153;
    CB_GETITEMHEIGHT = $0154;
    CB_SETEXTENDEDUI = $0155;
    CB_GETEXTENDEDUI = $0156;
    CB_GETDROPPEDSTATE = $0157;
    CB_FINDSTRINGEXACT = $0158;
    CB_SETLOCALE = $0159;
    CB_GETLOCALE = $015A;
    CB_GETTOPINDEX = $015b;
    CB_SETTOPINDEX = $015c;
    CB_GETHORIZONTALEXTENT = $015d;
    CB_SETHORIZONTALEXTENT = $015e;
    CB_GETDROPPEDWIDTH = $015f;
    CB_SETDROPPEDWIDTH = $0160;
    CB_INITSTORAGE = $0161;
    CB_MSGMAX = $0162;

    SBS_HORZ = $0000;
    SBS_VERT = $0001;
    SBS_TOPALIGN = $0002;
    SBS_LEFTALIGN = $0002;
    SBS_BOTTOMALIGN = $0004;
    SBS_RIGHTALIGN = $0004;
    SBS_SIZEBOXTOPLEFTALIGN = $0002;
    SBS_SIZEBOXBOTTOMRIGHTALIGN = $0004;
    SBS_SIZEBOX = $0008;
    SBS_SIZEGRIP = $0010;

    SBM_SETPOS = $00E0;
    SBM_GETPOS = $00E1;
    SBM_SETRANGE = $00E2;
    SBM_SETRANGEREDRAW = $00E6;
    SBM_GETRANGE = $00E3;
    SBM_ENABLE_ARROWS = $00E4;
    SBM_SETSCROLLINFO = $00E9;
    SBM_GETSCROLLINFO = $00EA;
    SIF_RANGE = $0001;
    SIF_PAGE = $0002;
    SIF_POS = $0004;
    SIF_DISABLENOSCROLL = $0008;
    SIF_TRACKPOS = $0010;
    SIF_ALL = $0017;

type
	SCROLLINFO = packed record
		cbSize : UINT;
		fMask : UINT;
		nMin : integer;
		nMax : integer;
		nPage : UINT;
		nPos : integer;
		nTrackPos : integer;
	end;

	function SetScrollInfo(hWnd : _HWND; fnBar : integer; var p : SCROLLINFO;
							fRedraw : BOOL) : integer;
	    external dll='user32.dll';
	function GetScrollInfo(hWnd : _HWND; fnBar : integer; var p : SCROLLINFO) : integer;
	    external dll='user32.dll';

const
    MDIS_ALLCHILDSTYLES = $0001;
    MDITILE_VERTICAL = $0000;
    MDITILE_HORIZONTAL = $0001;
    MDITILE_SKIPDISABLED = $0002;

type
	MDICREATESTRUCT = packed record
		szClass : LPCSTR;
		szTitle : LPCSTR;
		hOwner : HANDLE;
		x : integer;
		y : integer;
		cx : integer;
		cy : integer;
		style : DWORD;
		lParam : _LPARAM;
	end;

	CLIENTCREATESTRUCT = packed record
		hWindowMenu : HANDLE;
		idFirstChild : UINT;
	end;

	function DefFrameProc(hWnd : _HWND; hWndMDIClient : _HWND; uMsg : UINT;
							wParam : _WPARAM; lParam : _LPARAM) : LRESULT;
	    external dll='user32.dll' name='DefFrameProcA' stdcall;
	function DefMDIChildProc(hWnd : _HWND; uMsg : UINT; wParam : _WPARAM; lParam : _LPARAM) : LRESULT;
	    external dll='user32.dll' name='DefMDIChildProcA' stdcall;
	function TranslateMDISysAccel(hWndClient : HWND; var lpMsg : MSG) : BOOL;
	    external dll='user32.dll';
	function ArrangeIconicWindows(hWnd : _HWND) : UINT;
	    external dll='user32.dll';
	function CreateMDIWindow(lpClassName, lpWindowName : LPSTR; dwStyle : DWORD;
								x, y, nWidth, nHwight : integer;
								hWndParent : HWND; hInstance : _HINSTANCE;
								lParam : _LPARAM) : HWND;
	    external dll='user32.dll' name='CreateMDIWindowA' stdcall;
	function TileWindows(hwndParent : HWND; wHow : UINT; var lpRect : RECT;
							cKids : UINT; lpKids : address) : shortword;
	    external dll='user32.dll';
	function CascadeWindows(hwndParent : HWND; wHow : UINT; var lpRect : RECT;
							cKids : UINT; lpKids : address) : shortword;
	    external dll='user32.dll';

type
	HELPPOLY = DWORD;

	MULTIKEYHELP = packed record
		mkSize : DWORD;
		mkKeyList : char;
		szKeyphrase : array[1..1] of char;
	end;

	HELPWININFO = packed record
		wStructSize : integer;
		x : integer;
		y : integer;
		dx : integer;
		dy : integer;
		wMax : integer;
		rgchMember : array[0..1] of char;
	end;

const
    HELP_CONTEXT = $0001;
    HELP_QUIT = $0002;
    HELP_INDEX = $0003;
    HELP_CONTENTS = $0003;
    HELP_HELPONHELP = $0004;
    HELP_SETINDEX = $0005;
    HELP_SETCONTENTS = $0005;
    HELP_CONTEXTPOPUP = $0008;
    HELP_FORCEFILE = $0009;
    HELP_KEY = $0101;
    HELP_COMMAND = $0102;
    HELP_PARTIALKEY = $0105;
    HELP_MULTIKEY = $0201;
    HELP_SETWINPOS = $0203;
    HELP_CONTEXTMENU = $000a;
    HELP_FINDER = $000b;
    HELP_WM_HELP = $000c;
    HELP_SETPOPUP_POS = $000d;
    HELP_TCARD = $8000;
    HELP_TCARD_DATA = $0010;
    HELP_TCARD_OTHER_CALLER = $0011;
    IDH_NO_HELP = 28440;
    IDH_MISSING_CONTEXT = 28441;
    IDH_GENERIC_HELP_BUTTON = 28442;
    IDH_OK = 28443;
    IDH_CANCEL = 28444;
    IDH_HELP = 28445;

	function WinHelp(hWndMain : HWND; lpszHelp : LPSTR; uCommand : UINT; dwData : DWORD) : BOOL;
	    external dll='user32.dll' name='WinHelpA' stdcall;

const
    SPI_GETBEEP = 1;
    SPI_SETBEEP = 2;
    SPI_GETMOUSE = 3;
    SPI_SETMOUSE = 4;
    SPI_GETBORDER = 5;
    SPI_SETBORDER = 6;
    SPI_GETKEYBOARDSPEED = 10;
    SPI_SETKEYBOARDSPEED = 11;
    SPI_LANGDRIVER = 12;
    SPI_ICONHORIZONTALSPACING = 13;
    SPI_GETSCREENSAVETIMEOUT = 14;
    SPI_SETSCREENSAVETIMEOUT = 15;
    SPI_GETSCREENSAVEACTIVE = 16;
    SPI_SETSCREENSAVEACTIVE = 17;
    SPI_GETGRIDGRANULARITY = 18;
    SPI_SETGRIDGRANULARITY = 19;
    SPI_SETDESKWALLPAPER = 20;
    SPI_SETDESKPATTERN = 21;
    SPI_GETKEYBOARDDELAY = 22;
    SPI_SETKEYBOARDDELAY = 23;
    SPI_ICONVERTICALSPACING = 24;
    SPI_GETICONTITLEWRAP = 25;
    SPI_SETICONTITLEWRAP = 26;
    SPI_GETMENUDROPALIGNMENT = 27;
    SPI_SETMENUDROPALIGNMENT = 28;
    SPI_SETDOUBLECLKWIDTH = 29;
    SPI_SETDOUBLECLKHEIGHT = 30;
    SPI_GETICONTITLELOGFONT = 31;
    SPI_SETDOUBLECLICKTIME = 32;
    SPI_SETMOUSEBUTTONSWAP = 33;
    SPI_SETICONTITLELOGFONT = 34;
    SPI_GETFASTTASKSWITCH = 35;
    SPI_SETFASTTASKSWITCH = 36;
    SPI_SETDRAGFULLWINDOWS = 37;
    SPI_GETDRAGFULLWINDOWS = 38;
    SPI_GETNONCLIENTMETRICS = 41;
    SPI_SETNONCLIENTMETRICS = 42;
    SPI_GETMINIMIZEDMETRICS = 43;
    SPI_SETMINIMIZEDMETRICS = 44;
    SPI_GETICONMETRICS = 45;
    SPI_SETICONMETRICS = 46;
    SPI_SETWORKAREA = 47;
    SPI_GETWORKAREA = 48;
    SPI_SETPENWINDOWS = 49;
    SPI_GETHIGHCONTRAST = 66;
    SPI_SETHIGHCONTRAST = 67;
    SPI_GETKEYBOARDPREF = 68;
    SPI_SETKEYBOARDPREF = 69;
    SPI_GETSCREENREADER = 70;
    SPI_SETSCREENREADER = 71;
    SPI_GETANIMATION = 72;
    SPI_SETANIMATION = 73;
    SPI_GETFONTSMOOTHING = 74;
    SPI_SETFONTSMOOTHING = 75;
    SPI_SETDRAGWIDTH = 76;
    SPI_SETDRAGHEIGHT = 77;
    SPI_SETHANDHELD = 78;
    SPI_GETLOWPOWERTIMEOUT = 79;
    SPI_GETPOWEROFFTIMEOUT = 80;
    SPI_SETLOWPOWERTIMEOUT = 81;
    SPI_SETPOWEROFFTIMEOUT = 82;
    SPI_GETLOWPOWERACTIVE = 83;
    SPI_GETPOWEROFFACTIVE = 84;
    SPI_SETLOWPOWERACTIVE = 85;
    SPI_SETPOWEROFFACTIVE = 86;
    SPI_SETCURSORS = 87;
    SPI_SETICONS = 88;
    SPI_GETDEFAULTINPUTLANG = 89;
    SPI_SETDEFAULTINPUTLANG = 90;
    SPI_SETLANGTOGGLE = 91;
    SPI_GETWINDOWSEXTENSION = 92;
    SPI_SETMOUSETRAILS = 93;
    SPI_GETMOUSETRAILS = 94;
    SPI_SCREENSAVERRUNNING = 97;
    SPI_GETFILTERKEYS = 50;
    SPI_SETFILTERKEYS = 51;
    SPI_GETTOGGLEKEYS = 52;
    SPI_SETTOGGLEKEYS = 53;
    SPI_GETMOUSEKEYS = 54;
    SPI_SETMOUSEKEYS = 55;
    SPI_GETSHOWSOUNDS = 56;
    SPI_SETSHOWSOUNDS = 57;
    SPI_GETSTICKYKEYS = 58;
    SPI_SETSTICKYKEYS = 59;
    SPI_GETACCESSTIMEOUT = 60;
    SPI_SETACCESSTIMEOUT = 61;
    SPI_GETSERIALKEYS = 62;
    SPI_SETSERIALKEYS = 63;
    SPI_GETSOUNDSENTRY = 64;
    SPI_SETSOUNDSENTRY = 65;
    SPI_GETSNAPTODEFBUTTON = 95;
    SPI_SETSNAPTODEFBUTTON = 96;
    SPI_GETMOUSEHOVERWIDTH = 98;
    SPI_SETMOUSEHOVERWIDTH = 99;
    SPI_GETMOUSEHOVERHEIGHT = 100;
    SPI_SETMOUSEHOVERHEIGHT = 101;
    SPI_GETMOUSEHOVERTIME = 102;
    SPI_SETMOUSEHOVERTIME = 103;
    SPI_GETWHEELSCROLLLINES = 104;
    SPI_SETWHEELSCROLLLINES = 105;

    SPIF_UPDATEINIFILE = $0001;
    SPIF_SENDWININICHANGE = $0002;
    SPIF_SENDCHANGE = SPIF_SENDWININICHANGE;

	METRICS_USEDEFAULT = -1;

type
	NONCLIENTMETRICS = packed record
		cbSize : UINT;
		iBorderWidth : integer;
		iScrollWidth : integer;
		iScrollHeight : integer;
		iCaptionWidth : integer;
		iCaptionHeight : integer;
		lfCaptionFont : LOGFONT;
		iSmCaptionWidth : integer;
		iSmCaptionHeight : integer;
		lfSmCaptionFont : LOGFONT;
		iMenuWidth : integer;
		iMenuHeight : integer;
		lfMenuFont : LOGFONT;
		lfStatusFont : LOGFONT;
		lfMessageFont : LOGFONT;
	end;

const
    ARW_BOTTOMLEFT = $0000;
    ARW_BOTTOMRIGHT = $0001;
    ARW_TOPLEFT = $0002;
    ARW_TOPRIGHT = $0003;
    ARW_STARTMASK = $0003;
    ARW_STARTRIGHT = $0001;
    ARW_STARTTOP = $0002;
    ARW_LEFT = $0000;
    ARW_RIGHT = $0000;
    ARW_UP = $0004;
    ARW_DOWN = $0004;
    ARW_HIDE = $0008;
    ARW_VALID = $000F;

type
	MINIMIZEDMETRICS = packed record
		cbSize : UINT;
		iWidth : integer;
		iHorzGap : integer;
		iVertGap : integer;
		iArrange : integer;
	end;

	ICONMETRICS = packed record
		cbSize : UINT;
		iHorzSpacing : integer;
		iVertSpacing : integer;
		iTitleWrap : integer;
		lfFont : LOGFONT;
	end;

	ANIMATIONINFO = packed record
		cbSize : UINT;
		iMinAnimate : integer;
	end;

	SERIALKEYS = packed record
		cbSize : UINT;
		dwFlags : DWORD;
		lpszActivePort : LPSTR;
		lpszPort : LPSTR;
		iBaudRate : UINT;
		iPortState : UINT;
		iActive : UINT;
	end;

const
    SERKF_SERIALKEYSON = $00000001;
    SERKF_AVAILABLE = $00000002;
    SERKF_INDICATOR = $00000004;

type
	HIGHCONTRAST = packed record
		cbSize : UINT;
		dwFlags : DWORD;
		lpszDefaultScheme : address;
	end;

const
    HCF_HIGHCONTRASTON = $00000001;
    HCF_AVAILABLE = $00000002;
    HCF_HOTKEYACTIVE = $00000004;
    HCF_CONFIRMHOTKEY = $00000008;
    HCF_HOTKEYSOUND = $00000010;
    HCF_INDICATOR = $00000020;
    HCF_HOTKEYAVAILABLE = $00000040;
    CDS_UPDATEREGISTRY = $00000001;
    CDS_TEST = $00000002;
    CDS_FULLSCREEN = $00000004;
    CDS_GLOBAL = $00000008;
    CDS_SET_PRIMARY = $00000010;
    CDS_RESET = $40000000;
    CDS_SETRECT = $20000000;
    CDS_NORESET = $10000000;
    DISP_CHANGE_SUCCESSFUL = 0;
    DISP_CHANGE_RESTART = 1;
    DISP_CHANGE_FAILED = -1;
    DISP_CHANGE_BADMODE = -2;
    DISP_CHANGE_NOTUPDATED = -3;
    DISP_CHANGE_BADFLAGS = -4;
    DISP_CHANGE_BADPARAM = -5;

	function ChangeDisplaySettings(var lpDevMode : DEVMODE; dwFlags : DWORD) : LONG;
	    external dll='user32.dll' name='ChangeDisplaySettingsA' stdcall;
	function ChangeDisplaySettingsEx(lpszDeviceName : LPSTR; var lpDevMode : DEVMODE;
										hWnd : _HWND; dwFlags : DWORD;
										lParam : _LPARAM) : LONG;
	    external dll='user32.dll' name='ChangeDisplaySettingsExA' stdcall;

const
    ENUM_CURRENT_SETTINGS = -1;
    ENUM_REGISTRY_SETTINGS = -2;

	function EnumDisplaySettings(lpszDeviceName : LPSTR; iModeNum : DWORD;
									var lpDevMode : DEVMODE) : BOOL;
	    external dll='user32.dll' name='EnumDisplaySettingsA' stdcall;
	function SystemParametersInfo(uiAction, uiParam : UINT; pvParam : address; fWinIni : UINT) : BOOL;
	    external dll='user32.dll' name='SystemParametersInfoA' stdcall;

type
	FILTERKEYS = packed record
		cbSize : UINT;
		dwFlags : DWORD;
		iWaitMsec : DWORD;
		iDelayMsec : DWORD;
		iRepeatMSec : DWORD;
		iBounceMSec : DWORD;
	end;

const
    FKF_FILTERKEYSON = $00000001;
    FKF_AVAILABLE = $00000002;
    FKF_HOTKEYACTIVE = $00000004;
    FKF_CONFIRMHOTKEY = $00000008;
    FKF_HOTKEYSOUND = $00000010;
    FKF_INDICATOR = $00000020;
    FKF_CLICKON = $00000040;

type
	STICKYKEYS = packed record
		cbSize : UINT;
		dwFlags : DWORD;
	end;

const
    SKF_STICKYKEYSON = $00000001;
    SKF_AVAILABLE = $00000002;
    SKF_HOTKEYACTIVE = $00000004;
    SKF_CONFIRMHOTKEY = $00000008;
    SKF_HOTKEYSOUND = $00000010;
    SKF_INDICATOR = $00000020;
    SKF_AUDIBLEFEEDBACK = $00000040;
    SKF_TRISTATE = $00000080;
    SKF_TWOKEYSOFF = $00000100;

type
	MOUSEKEYS = packed record
		cbSize : UINT;
		dwFlags : DWORD;
		iMaxSpeed : DWORD;
		iTimeToMaxSpeed : DWORD;
		iCtrlSpeed : DWORD;
		dwReserved1 : DWORD;
		dwReserved2 : DWORD;
	end;

const
    MKF_MOUSEKEYSON = $00000001;
    MKF_AVAILABLE = $00000002;
    MKF_HOTKEYACTIVE = $00000004;
    MKF_CONFIRMHOTKEY = $00000008;
    MKF_HOTKEYSOUND = $00000010;
    MKF_INDICATOR = $00000020;
    MKF_MODIFIERS = $00000040;
    MKF_REPLACENUMBERS = $00000080;

type
	ACCESSTIMEOUT = packed record
		cbSize : UINT;
		dwFlags : DWORD;
		iTimeOutMSec : DWORD;
	end;

const
    ATF_TIMEOUTON = $00000001;
    ATF_ONOFFFEEDBACK = $00000002;
    SSGF_NONE = 0;
    SSGF_DISPLAY = 3;
    SSTF_NONE = 0;
    SSTF_CHARS = 1;
    SSTF_BORDER = 2;
    SSTF_DISPLAY = 3;
    SSWF_NONE = 0;
    SSWF_TITLE = 1;
    SSWF_WINDOW = 2;
    SSWF_DISPLAY = 3;
    SSWF_CUSTOM = 4;

type
	SOUNDSENTRY = packed record
		cbSize : UINT;
		dwFlags : DWORD;
    	iFSTextEffect : DWORD;
    	iFSTextEffectMSec : DWORD;
    	iFSTextEffectColorBits : DWORD;
    	iFSGrafEffect : DWORD;
    	iFSGrafEffectMSec : DWORD;
    	iFSGrafEffectColor : DWORD;
    	iWindowsEffect : DWORD;
    	iWindowsEffectMSec : DWORD;
    	lpszWindowsEffectDLL : LPSTR;
    	iWindowsEffectOrdinal : DWORD;
	end;

const
    SSF_SOUNDSENTRYON = $00000001;
    SSF_AVAILABLE = $00000002;
    SSF_INDICATOR = $00000004;

type
	TOGGLEKEYS = packed record
		cbSize : UINT;
		dwFlags : DWORD;
	end;

const
    TKF_TOGGLEKEYSON = $00000001;
    TKF_AVAILABLE = $00000002;
    TKF_HOTKEYACTIVE = $00000004;
    TKF_CONFIRMHOTKEY = $00000008;
    TKF_HOTKEYSOUND = $00000010;
    TKF_INDICATOR = $00000020;

	procedure SetDebugErrorLevel(dwLevel : DWORD);
	    external dll='user32.dll';

const
    SLE_ERROR = $00000001;
    SLE_MINORERROR = $00000002;
    SLE_WARNING = $00000003;

	procedure SetLastErrorEx(dwErrCode : DWORD; dwType : DWORD);
	    external dll='user32.dll';

(*$W53. *)
(*$W44. *)
