#!/usr/bin/env python
#############################################################################
# Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1997, 1998, 1999
# All Rights Reserved.
#
# The software contained on this media is the property of the DSTC Pty
# Ltd.  Use of this software is strictly in accordance with the
# license agreement in the accompanying LICENSE.HTML file.  If your
# distribution of this software does not contain a LICENSE.HTML file
# then you have no rights to use this software in any manner and
# should contact DSTC at the address below to determine an appropriate
# licensing arrangement.
# 
#      DSTC Pty Ltd
#      Level 7, GP South
#      Staff House Road
#      University of Queensland
#      St Lucia, 4072
#      Australia
#      Tel: +61 7 3365 4310
#      Fax: +61 7 3365 4311
#      Email: enquiries@dstc.edu.au
# 
# This software is being provided "AS IS" without warranty of any
# kind.  In no event shall DSTC Pty Ltd be liable for damage of any
# kind arising out of or in connection with the use or performance of
# this software.
#
# Project:      Fnorb
# File:         $Source: /units/arch/src/Fnorb/orb/RCS/Reactor.py,v $
# Version:      @(#)$RCSfile: Reactor.py,v $ $Revision: 1.10 $
#
#############################################################################
""" Abstract Reactor class (part of the Reactor pattern). """


# Event masks.
READ      = 0x1
WRITE     = 0x2
EXCEPTION = 0x4
ALL       = 0xf


def Reactor_init():
    """ Initialise the Reactor.

    There can only be one instance of any concrete reactor class per process.

    """
    # The default reactor is the 'SelectReactor'.
    try:
	import SelectReactor; reactor = SelectReactor.SelectReactor()

    except Reactor, reactor:
	pass

    return reactor


class Reactor:
    """ Abstract Reactor class (part of the Reactor pattern). """

    # There can only be one instance of any *concrete* reactor class per
    # process.
    _instance = None

    def create_acceptor(self, host, port):
	""" Factory method to create the 'Acceptor' used by this Reactor. """

	pass

    def register_handler(self, handler, mask):
	""" Register an event handler. """

	pass

    def unregister_handler(self, handler, mask):
	""" Withdraw a handler's registration. """

	pass

    def start_event_loop(self):
	""" Start the event loop. """

	pass

    def stop_event_loop(self):
	""" Stop the event loop. """

	pass

    def do_one_event(self):
	""" Dispatch a single event. """

	pass

    def handles(self):
	""" Return the handles for all registered handlers. """

	pass

    def handle_one_event(self, handle, mask):
	""" Handle a single event. """

	pass

#############################################################################
