extproc python -x %PYTHONHOME%\fnfeed.cmd
#############################################################################
# Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1997, 1998, 1999
# All Rights Reserved.
#
# The software contained on this media is the property of the DSTC Pty
# Ltd.  Use of this software is strictly in accordance with the
# license agreement in the accompanying LICENSE.HTML file.  If your
# distribution of this software does not contain a LICENSE.HTML file
# then you have no rights to use this software in any manner and
# should contact DSTC at the address below to determine an appropriate
# licensing arrangement.
# 
#      DSTC Pty Ltd
#      Level 7, GP South
#      Staff House Road
#      University of Queensland
#      St Lucia, 4072
#      Australia
#      Tel: +61 7 3365 4310
#      Fax: +61 7 3365 4311
#      Email: enquiries@dstc.edu.au
# 
# This software is being provided "AS IS" without warranty of any
# kind.  In no event shall DSTC Pty Ltd be liable for damage of any
# kind arising out of or in connection with the use or performance of
# this software.
#
# Project:      Distributed Environment
# File:         $Source: /units/arch/src/Fnorb/script/RCS/fnfeed,v $
# Version:      @(#)$RCSfile: fnfeed,v $ $Revision: 1.5 $
#
#############################################################################
""" Parse IDL and feed the definitions into an Interface Repository. """


# Standard/built-in modules.
import commands, os, string, sys

# Fnorb modules.
from Fnorb.orb    import CORBA
from Fnorb.parser import IDLParser
from Fnorb.script import cpp


def main(argv):
    """ Do it! """

    # Initialise the ORB.
    orb = CORBA.ORB_init(argv, CORBA.ORB_ID)

    # Get a reference to the IFR.
    ifr = orb.resolve_initial_references('InterfaceRepository')

    # We separate arguments for the pre-processor from IDL files.
    cpp_flags = []
    idl_files = []

    for arg in argv[1:]:
	# CPP flags.
	if arg[0] == '-':
	    cpp_flags.append(arg)

	# IDL files.
	elif arg[-4:] == '.idl':
	    idl_files.append(arg)

	# Ignore anything else (including the spurious last argument '\n' on
	# Windoows 95 ;^).
	else:
	    pass

    # If no files were specified on the command line, then parse from stdin!
    if len(idl_files) == 0:
	result = main_interactive(ifr)

    else:
	result = main_batch(ifr, cpp_flags, idl_files)

    return result


def main_interactive(ifr):
    """ Parse IDL from stdin! """

    # Create the parser.
    parser = IDLParser.IDLParser()

    # Do the parsing!
    print 'Enter IDL (Ctrl-D to finish)...\n'
    (result, contents) = parser.parse(ifr, 'stdin', sys.stdin)

    return result


def main_batch(ifr, cpp_flags, idl_files):
    """ Parse IDL from files! """

    # Create the parser.
    parser = IDLParser.IDLParser()

    # Parse each file.
    for idl_file in idl_files:
	# Format the command to run the C/C++ pre-processor.
	cmd = cpp.COMMAND % (string.join(cpp_flags), idl_file)

	# Run the pre-processor and use its output as the lexer's input stream.
	yyin = os.popen(cmd, 'r')

	# Do the parsing!
	(result, contents) = parser.parse(ifr, idl_file, yyin)

	# Close the pipe.
	yyin.close()

    return result

#############################################################################

if __name__ == '__main__':
    # Do it!
    sys.exit(main(sys.argv[1:]))

#############################################################################
