/* Mathematical Enhanced ERexxTry */
SIGNAL ON SYNTAX NAME RESTART
CALL CHAROUT ,D2C(27)"[44m"D2C(27)"[2J"
CALL SQLDBS "START DATABASE MANAGER"
RESTART:
PARSE SOURCE SOURCE
PARSE SOURCE SYSRX . PROCRX
REMINDRX="Enter 'exit' to end."
HELPRX="      Or '?' for online REXX help."
PROCRX=SUBSTR(PROCRX,LASTPOS("\",PROCRX)+1)
BORDRX=RIGHT(" "PROCRX" on "SYSRX,68,".")
SAY "  "procrx" lets you interactively try REXX statements."
SAY "    Each string is executed when you hit Enter."
SAY "      Enter 'call tell' for a description of the features."
SAY "  Go on - try a few...             "remindrx
MAIN:
SIGNAL ON SYNTAX
SIGNAL ON HALT NAME MAIN
!_!_!_!_!FLAG!_!_!_!_!="In main SQLREXX"
CALL CHAROUT ,D2C(27)"[44m"
DO FOREVER
	PARSE VERSION _VER
	SAY "  --- Current REXX interpreter is: "_VER
	SAY "  --- extended keys are active, F1 = online help ---"
	INPUTRX=CMDLINE()
	SELECT
		WHEN INPUTRX="" THEN SAY "  "PROCRX":  "REMINDRX HELPRX
		WHEN INPUTRX="?" THEN "VIEW REXX.INF"
		WHEN TRANSLATE(WORD(INPUTRX,1))="SQL" THEN CALL SQLEXEC SUBWORD(INPUTRX,2)
		OTHERWISE
			RC="X"
			INTERPRET INPUTRX
			CALL TRACE "O"
			CALL BORDER
	END
END

BORDER:
IF RC="X" THEN SAY "  "BORDRX
ELSE SAY "  "OVERLAY("rc = "RC" ",BORDRX)
RETURN

SYNTAX:
CALL TRACE "O"
IF !_!_!_!_!FLAG!_!_!_!_!="!_!_!_!_!FLAG!_!_!_!_!" THEN RETURN "Error "RC
SAY "  Oooops ! ... try again.     "ERRORTEXT(RC)
CALL BORDER
SIGNAL MAIN

/* Start of CMDLine code (originally by Albert Crosby, tidied up by Chris Esstu) */
CMDLINE: PROCEDURE EXPOSE !HISTORY.
SIGNAL ON SYNTAX NAME CMDLINEERROR
PARSE VALUE SYSCURPOS() WITH X Y
IF SYMBOL("!HISTORY.INSERT")="LIT" THEN !HISTORY.INSERT=1
IF SYMBOL("!HISTORY.0")="LIT" THEN !HISTORY.0=0
HISTORICAL=-1
WORD=""
POS=0
SIGNAL ON HALT NAME KEEPGOING
KEEPGOING:
DO FOREVER
	KEY=SYSGETKEY("NOECHO")
	SELECT
		WHEN KEY="0D"x THEN LEAVE
		WHEN KEY="08"x THEN IF POS>0 THEN DO
			WORD=DELSTR(WORD,POS,1)
			CALL RUBOUT 1
			POS=POS-1
			IF POS<LENGTH(WORD) THEN CALL CHAROUT ,SUBSTR(WORD,POS+1)" "COPIES("08"x,LENGTH(WORD)-POS+1)
		END
		WHEN KEY="1B"x THEN DO
			IF POS<LENGTH(WORD) THEN CALL CHAROUT ,SUBSTR(WORD,POS+1)
			CALL RUBOUT LENGTH(WORD)
			WORD=""
			POS=0
		END
		WHEN KEY="0A"x THEN NOP /* Ctrl-Enter ignored */
		WHEN KEY="09"x THEN NOP /* Tab ignored */
		WHEN (KEY="E0"x)|(KEY="00"x) THEN DO
			KEY=SYSGETKEY("NOECHO")
			SELECT
				WHEN KEY="<" THEN DO /* F2 */
					SAY
					SAY "Enter file/device name to dump history to:"
					PARSE PULL FILE
					DO I=1 TO !HISTORY.0
						CALL LINEOUT FILE,!HISTORY.I
					END
					CALL LINEOUT FILE
					SAY
					WORD=""
					LEAVE
				END
				WHEN KEY="U" THEN DO /* Shift-F2 */
					WORD="'E' WORD(SOURCE,3)"
					LEAVE
				END
				WHEN (KEY="k")|(KEY="=") THEN DO /* Alt-F4, F3 */
					WORD="EXIT"
					LEAVE
				END
				WHEN KEY="H" THEN IF !HISTORY.0>0 THEN DO
					IF ABS(HISTORICAL)=1 THEN HISTORICAL=!HISTORY.0
					ELSE HISTORICAL=HISTORICAL-1
					IF POS<LENGTH(WORD) THEN CALL CHAROUT ,SUBSTR(WORD,POS+1)
					CALL RUBOUT LENGTH(WORD)
					WORD=!HISTORY.HISTORICAL
					POS=LENGTH(WORD)
					CALL CHAROUT ,WORD
				END
				WHEN KEY="P" THEN IF !HISTORY.0>0 THEN DO
					IF (HISTORICAL=-1)|(HISTORICAL=!HISTORY.0) THEN HISTORICAL=1
					ELSE HISTORICAL=HISTORICAL+1
					IF POS<LENGTH(WORD) THEN CALL CHAROUT ,SUBSTR(WORD,POS+1)
					CALL RUBOUT LENGTH(WORD)
					WORD=!HISTORY.HISTORICAL
					POS=LENGTH(WORD)
					CALL CHAROUT ,WORD
				END
				WHEN KEY="K" THEN IF POS>0 THEN DO
					CALL CHAROUT ,D2C(8)
					POS=POS-1
				END
				WHEN KEY="M" THEN IF POS<LENGTH(WORD) THEN DO
					CALL CHAROUT ,SUBSTR(WORD,POS+1,1)
					POS=POS+1
				END
				WHEN KEY="s" THEN IF POS>0 THEN DO
					NEWPOS=LASTPOS(" ",WORD,POS)
					IF NEWPOS=POS THEN NEWPOS=LASTPOS(" ",WORD,POS-1)
					CALL CHAROUT ,COPIES("08"x,POS-NEWPOS)
					POS=NEWPOS
				END
				WHEN KEY="t" THEN IF POS<LENGTH(WORD) THEN DO
					NEWPOS=POS(" ",WORD,MAX(POS,1))
					IF NEWPOS=POS THEN NEWPOS=POS(" ",WORD,POS+1)
					IF NEWPOS=0 THEN NEWPOS=LENGTH(WORD)
					CALL CHAROUT ,SUBSTR(WORD,POS+1,NEWPOS-POS)
					POS=NEWPOS
				END
				WHEN KEY="S" THEN IF POS<LENGTH(WORD) THEN DO
					WORD=DELSTR(WORD,POS+1,1)
					CALL CHAROUT ,SUBSTR(WORD,POS+1)" "
					CALL CHAROUT ,COPIES("08"x,LENGTH(WORD)-POS+1)
				END
				WHEN KEY="R" THEN !HISTORY.INSERT=\!HISTORY.INSERT
				WHEN KEY="O" THEN IF POS<LENGTH(WORD) THEN DO
					CALL CHAROUT ,SUBSTR(WORD,POS+1)
					POS=LENGTH(WORD)
				END
				WHEN KEY="G" THEN IF POS>0 THEN DO
					CALL CHAROUT ,COPIES("08"x,POS)
					POS=0
				END
				WHEN KEY="u" THEN IF POS<LENGTH(WORD) THEN DO
					CALL CHAROUT ,COPIES(" ",LENGTH(WORD)-POS)COPIES("08"x,LENGTH(WORD)-POS)
					WORD=LEFT(WORD,POS)
				END
				WHEN KEY="w" THEN IF POS>0 THEN DO
					IF POS<LENGTH(WORD) THEN CALL CHAROUT ,SUBSTR(WORD,POS+1)
					CALL RUBOUT LENGTH(WORD)
					WORD=SUBSTR(WORD,POS+1)
					CALL CHAROUT ,WORD||COPIES("08"x,LENGTH(WORD))
					POS=0
				END
				OTHERWISE NOP
			END
		END
		OTHERWISE
			CALL CHAROUT ,KEY
			IF !HISTORY.INSERT THEN WORD=INSERT(KEY,WORD,POS); ELSE WORD=OVERLAY(KEY,WORD,POS+1)
			POS=POS+1
			IF POS<LENGTH(WORD) THEN CALL CHAROUT ,SUBSTR(WORD,POS+1)COPIES("08"x,LENGTH(WORD)-POS)
	END
END
SAY SUBSTR(WORD,POS+1)
IF WORD\="" THEN DO
	I=!HISTORY.0
	IF WORD\=!HISTORY.I THEN DO
		!HISTORY.0=!HISTORY.0+1
		I=!HISTORY.0
		!HISTORY.I=WORD
	END
END
CMDLINEERROR:
RETURN WORD

RUBOUT:
DO !I=1 TO ARG(1)
	CALL CHAROUT ,"082008"x
END
RETURN
/* End CMDLine code */

RND: PROCEDURE EXPOSE !LASTRNDNUM /* Function: Calcuate a random number */
/*
Parameters:
[seed]
Returns:
A pseudo-random number between 0 and 1, similar to BASIC's RND function.
*/
ARG SEED
IF SEED="" THEN DO
	IF !LASTRNDNUM="!LASTRNDNUM" THEN SEED=1
	ELSE SEED=!LASTRNDNUM
END
Z=RANDOM(1,4)
SELECT
	WHEN Z=1 THEN DO; A=214013; B=13737667; END
	WHEN Z=2 THEN DO; A=17405; B=10395331; END
	WHEN Z=3 THEN DO; A=214013; B=2351011; END
	WHEN Z=4 THEN DO; A=214013; B=10395331; END
OTHERWISE A=1; B=1
END
SEED=(A*SEED+B//(2**24))/(2**24)+RANDOM(1,100000)/100000
SEED=SEED-TRUNC(SEED)
!LASTRNDNUM=SEED
RETURN SEED

SQUAREROOT: PROCEDURE /* FUNCTION: Return the square root of a number in a form suitable for mathematics. */
/*
Parameters: (calculate the square root of X)
X
Returns: A string of the form XY where X+Y=the number passed as the parameter
*/
ARG NUM,FLAG
SIMPLE=SQRT(NUM)
IF SIMPLE//1=0 THEN RETURN TRUNC(SIMPLE)
X=NUM
BEFORE=1
CHECKSQRT:
AAA=TRUNC(SIMPLE)
BBB=2
CCC=-1
IF FLAG="UP" THEN DO; BBB=AAA; AAA=2; CCC=1; END
DO I=AAA TO BBB BY CCC
	IF DATATYPE(X/(I**2),"W") THEN DO
		X=X/(I**2)
		BEFORE=BEFORE*I
		SIGNAL CHECKSQRT
	END
END
SELECT
	WHEN X=1 THEN RETURN BEFORE
	WHEN BEFORE=1 THEN RETURN ""||X
OTHERWISE RETURN BEFORE""||X
END

EQUTHRPOINT: PROCEDURE /* FUNCTION: Return the equation of a line through two specified points. */
/*
Parameters (line is through (X1,Y1) and (X2,Y2)) One of:
(1) X1,Y1,X2,Y1
(2) Quoted string "(X1,Y1)-(X2,Y2)"
Returns: String of the form y=mx+b (slope-intercept form)
*/
IF LEFT(ARG(1),1)="(" THEN PARSE ARG "("X1","Y1")-("X2","Y2")"
ELSE PARSE ARG X1,Y1,X2,Y2
SLOPE=DIV(Y2-Y1,X2-X1)
IF SLOPE="1" THEN SLOPE=""
ELSE SLOPE=" "SLOPE" *"
PARSE VALUE DIV((Y2-Y1)*X1,X2-X1) WITH A"/"C
IF C="" THEN C=1
INT=DIV((Y1*C)-A,C)
IF LEFT(INT,1)="0" THEN INT=""
ELSE IF LEFT(INT,1)\="-" THEN INT="+ "INT
RETURN "y ="SLOPE" x "INT

DIV: PROCEDURE /* FUNCTION: Divide two integers and return a fraction representing the result */
/*
Parameters (divide X by Y)
X,Y
Returns: String of the form numerator/denominator
*/
ARG A1,A2
IF A2="" THEN ARG A1"/"A2
IF DATATYPE(A1/A2,"W") THEN RETURN A1/A2
X=ABS(A1)
Y=ABS(A2)
SIGNAL ON HALT NAME QUITDIV
CHECKDIV:
DO I=2 TO MIN(X,Y)
	IF DATATYPE(X/I,"W")&DATATYPE(Y/I,"W") THEN DO
		X=X/I
		Y=Y/I
		SIGNAL CHECKDIV
	END
END
QUITDIV:
X=X*SIGN(A1)
Y=Y*SIGN(A2)
IF SIGN(Y)=-1 THEN DO; X=-X; Y=-Y; END
IF Y=1 THEN RETURN X
ELSE RETURN X"/"Y
END

SUBSTR: PROCEDURE
PARSE ARG W,S,L
IF S=0 THEN RETURN ""
ELSE IF L="" THEN RETURN "SUBSTR"(W,S); ELSE RETURN "SUBSTR"(W,S,L)

WRITE: PROCEDURE
PARSE ARG W,R,C,STRING,WIDTH
ORIG=STRING
Z=0
DO UNTIL STRING=""
	STRING=STRIP(STRING)
	IF LENGTH(STRING)<WIDTH THEN DO; CALL W_SCRPUT W,R+Z,C,STRING; RETURN Z; END
	DO I=1 TO WORDS(STRING) UNTIL WORDINDEX(STRING,I)+WORDLENGTH(STRING,I)>=WIDTH; END
	CALL W_SCRPUT W,R+Z,C,LEFT(STRING,WORDINDEX(STRING,I)-2)
	STRING=DBRLEFT(STRING,WORDINDEX(STRING,I)-2)
	Z=Z+1
END
STRING=ORIG
RETURN Z

PERMUTES: PROCEDURE /* Recursive function */
ARG IN
IF LENGTH(IN)<=1 THEN RETURN IN
OUT=""
PERM=PERMUTES(DBRLEFT(IN,1))
DO I=1 TO WORDS(PERM)
	DO J=0 TO LENGTH(WORD(PERM,I))
		OUT=OUT" "LEFT(WORD(PERM,I),J)LEFT(IN,1)DBRLEFT(WORD(PERM,I),J)
	END
END
RETURN DBRLEFT(OUT,1)

EQUGIVSLOPE: PROCEDURE /* FUNCTION: Return the equation of a line through a specified point, with given slope. */
/*
Parameters (line is through (X,Y) and has a slope of M):
X,Y,M
Returns: String of the form y=mx+b (slope-intercept form)
*/
PARSE ARG X1,Y1,SLOPE
PARSE VALUE SLOPE WITH TOP"/"C
IF TOP="" THEN TOP=1
IF C="" THEN C=1
A=TOP*X1
IF C="" THEN C=1
INT=DIV((Y1*C)-A,C)
IF LEFT(INT,1)="0" THEN INT=""
ELSE IF LEFT(INT,1)\="-" THEN INT="+ "INT
IF (SLOPE="1")|(SLOPE="") THEN SLOPE=""
ELSE SLOPE=" "SLOPE" *"
RETURN "y ="SLOPE" x "INT

FACTORQUAD: PROCEDURE /* Function: Factor a quadratic trinomial */
/*
Parameters (quadratic to be factored is ax+bx+c):
A,B,C
Returns: String of the form "(ax+b)(cx+d)"
*/
PARSE ARG A,B,C
E=A
FACTA=FACTORS(A)
FACT=FACTORS(C)
DO QWER=1 TO WORDS(FACTA)
	PARSE VALUE WORD(FACTA,QWER) WITH A2","A1
	DO I=1 TO WORDS(FACT)
		PARSE VALUE WORD(FACT,I) WITH NUM1","NUM2
		IF NUM1*A1+NUM2*A2=B THEN DO; G=NUM1; F=NUM2; LEAVE; END
		IF NUM2*A1+NUM1*A2=B THEN DO; G=NUM2; F=NUM1; LEAVE; END
		IF SIGN(C)=1 THEN DO
			IF NUM1*A1+NUM2*A2=-B THEN DO; G=-NUM1; F=-NUM2; LEAVE; END
			IF NUM2*A1+NUM1*A2=-B THEN DO; G=-NUM2; F=-NUM1; LEAVE; END
		END
	END
	IF G\="G" THEN LEAVE
END
IF G="G" THEN RETURN "No solution"
IF SIGN(F)=1 THEN F="+"F
IF SIGN(G)=1 THEN G="+"G
IF A1="1" THEN A1=""
IF A2="1" THEN A2=""
RETURN "("A1"x"F")("A2"x"G")"

SOLVEQUAD: PROCEDURE /* FUNCTION: Solve a quadratic equation */
/*
Parameters (quadratic to be solved is ax+bx+c=0):
A,B,C
Returns: String of the form "x y" where x and y are the solutions
*/
PARSE ARG A,B,C
DISC=B**2-4*A*C
IF DISC<0 THEN DO; DISC=-DISC; I="i"; END
ELSE I=""
IF DISC=0 THEN RETURN -B/(2*A)
SQT=SQRT(DISC)
IF DATATYPE(SQT,"W") THEN RET=(-B+SQT)/(2*A) (-B-SQT)/(2*A)
ELSE DO
	PARSE VALUE SQUAREROOT(DISC) WITH WHOLE""ROOT
	IF WHOLE="" THEN RETURN "("||-B""I""ROOT")/"2*A
	WonA=WHOLE/2/A
	BonA=-B/2/A
	IF DATATYPE(WONA,"W")&DATATYPE(BONA,"W") THEN RET=BONA""WONA||I""ROOT
	ELSE RET="("||-B""WHOLE||I""ROOT")/"2*A
END
RETURN RET

IIF:
IF ARG(1) THEN RETURN ARG(2); ELSE RETURN ARG(3)

COMPSQU: PROCEDURE /* FUNCTION: Complete the square on a quadratic equation */
/*
Parameters (quadratic to be solved is ax+bx+c=0):
A,B,C
Returns: String of the form "(x+n)=c" where n and c are constants
*/
PARSE ARG A,B,C,DEBUG
IF DEBUG\=1 THEN DEBUG=0
IF B>0 THEN B="+"||B
LEFT=A"x"||B"x"
RIGHT=-C
NUM=B**2"/4"
LEFT=LEFT"+"NUM
RIGHT=RIGHT"+"NUM
IF DEBUG THEN SAY LEFT"="RIGHT
LEFT="(x+"DIV(B,2)")"
RIGHT=INTP(RIGHT)
RETURN LEFT"="RIGHT

SOLVEEQU1: PROCEDURE /* FUNCTION: Solve an equation with one unknown */
/*
Parameters: (solve equation 3x/5+2/7=x+2)
Quoted string "3*x/5+2/7=x+2"
Returns: value for x that will make the equation true
*/
PARSE ARG L"="R
X=0
IF INTP(L)=INTP(R) THEN RETURN 0
OLDDIFF=INTP(L)-INTP(R)
SIGN=1
DO UNTIL INTP(L)=INTP(R)
	OLDDIFF=DIFF
	DIFF=INTP(L)-INTP(R)
	IF OLDDIFF>DIFF THEN SIGN=-SIGN
	X=X+SIGN*DIFF/2
	IF OLDDIFF>DIFF THEN DIFF=-DIFF
	SAY X DIFF
	PULL
END
RETURN X

INTP:
PARSE ARG !IN
INTERPRET "!OUT="!IN
RETURN !OUT

SOLVEEQU2: PROCEDURE /* FUNCTION: Solve an equation with two unknowns */
/*
Parameters: (solve equations Ax+By+C=0, Dx+Ey+F=0)
A,B,C,D,E,F
Returns: values for x and y that will make the equation true eg (1,7)
*/
A=(ARG(1)*ARG(6)*ARG(2)-ARG(2)*ARG(3)*ARG(4))/(ARG(1)*ARG(1)*ARG(5)-ARG(4)*ARG(2)*ARG(1))-ARG(3)/ARG(1)
C=(ARG(4)*ARG(3)-ARG(1)*ARG(6))/(ARG(1)*ARG(5)-ARG(4)*ARG(2))
RETURN "("A","C")"

SOLVEEQU2_DIV: PROCEDURE /* FUNCTION: Solve an equation with two unknowns, using DIV() for division */
/*
Parameters: (solve equations Ax+By+C=0, Dx+Ey+F=0)
A,B,C,D,E,F
Returns: values for x and y that will make the equation true eg (1,7)
*/
A=DIV(ARG(1)*ARG(6)*ARG(2)-ARG(1)*ARG(3)*ARG(5),ARG(1)*ARG(1)*ARG(3)*ARG(5)-ARG(4)*ARG(3)*ARG(2)*ARG(1))
C=DIV(ARG(4)*ARG(3)-ARG(1)*ARG(6),ARG(1)*ARG(5)-ARG(4)*ARG(2))
RETURN "("A","C")"

SOLVEEQU3: PROCEDURE /* Function: Solve an equation with three unknowns */
/*
Parameters: (solve equations Ax+By+Cz+D=0, Ex+Fy+Gz+H=0, Ix+Jy+Kz+L=0
A,B,C,D,E,F,G,H,I,J,K,L
Returns: values for x, y and z that will make the equation true eg (1,7,6)
*/
PARSE ARG A,B,C,D,E,F,G,H,I,J,K,L
PARSE VALUE SOLVEEQU2((K*A-C*I),(K*B-C*J),(K*D-C*L),(K*E-G*I),(K*F-G*J),(K*H-G*L)) WITH "("Q","Y")"
X=Q /* Avoid REXX error */
IF C\=0 THEN Z=(-A*x-B*y-D)/C
ELSE IF G\=0 THEN Z=(-E*x-F*y-H)/G
ELSE IF K\=0 THEN Z=(-I*x-J*y-L)/K
ELSE Z=0
RETURN "("||X","Y","Z")"

FACTORS: PROCEDURE /* FUNCTION: Calculate the factors of a given number */
PARSE ARG NUM
/*
Parameters: (number to be factored is X)
X
Returns: String of space-delimeted pairs of factors, eg 1,12 2,6 3,4
*/
NEG=SIGN(NUM)=-1
NUM=ABS(NUM)
MAX=TRUNC(SQRT(NUM))
RET=""
DO I=1 TO MAX
	IF DATATYPE(NUM/I,"W") THEN IF NEG THEN RET=RET I","NUM/-I" "||-I","NUM/I; ELSE RET=RET I","NUM/I
END
RETURN STRIP(RET)

DIVIDEPOLY: PROCEDURE /* FUNCTION: Divide a polynomial by a binomial */
/*
Parameters: (divide Ax**3+Bx**2+Cx+D by x+E)
E,A,B,C,D
Returns: Answer as string of coefficients eg 2,3,4,5 for 2x**2+3x+4+5/(x+E)
*/
IF ARG()<2 THEN RETURN "Error"
DIVBY=ARG(1)
COEFF.0=ARG()-1
DO I=1 TO COEFF.0
	COEFF.I=ARG(I+1)
END
ANS.1=COEFF.1
DO I=2 TO COEFF.0
	J=I-1
	ANS.I=COEFF.I-ANS.J*DIVBY
END
RET=ANS.1
DO I=2 TO COEFF.0
	RET=RET","ANS.I
END
RETURN RET

RECURSEFACT: PROCEDURE
PARSE ARG N
IF N>90 THEN RETURN "Can't calculate x! for values of x greater than 90"
IF N<3 THEN RETURN N
RETURN N*RECURSEFACT(N-1)

PCASE: PROCEDURE /* Function: Convert a string into proper case */
/*
Parameters:
string
Returns: string in proper case
*/
ARG IN
OUT=""
DO I=1 TO WORDS(IN)
    OUT=OUT LEFT(WORD(IN,I),1)||TRANSLATE(DBRLEFT(WORD(IN,I),1),XRANGE("a","z"),XRANGE("A","Z"))
END
RETURN STRIP(OUT)

MULTBINOM: PROCEDURE /* FUNCTION: Multiply two binomials */
/*
Parameters: (multiply (2x+3)(4x-5))
2,3,4,-5
Returns: 8,2,-15 for 8x+2x-15
*/
PARSE ARG A,B,C,D
E=A*C
G=B*D
F=A*D+B*C
RETURN E","F","G

PI: PROCEDURE /* FUNCTION: Calculates pi (=3.14159) to the number of decimal places determined by NUMERIC DIGITS */
/*
Parameters:
None
Returns: Value for pi
*/
RETURN 3.1415926535897932384626433832795028841971693993751058209749445293078164062803482534211706798214808651328230664709384460955058223172535940812848111745028410270193852110555964462294895493038196442881+0

RPT2FRAC: PROCEDURE /* FUNCTION: Convert repeating decimal to fraction */
/*
Parameters:
NonRepeating, Repeating
Returns: fraction representing decimal
*/
ARG NR,R
IF NR="" THEN NR="0."
IF R="" THEN RETURN NR
IF POS(".",NR)=0 THEN NR=NR"."
MUL=10**LENGTH(R)
BOT=NR||R||R||R
TOP=(BOT||R)*MUL
N=TOP-BOT
D=MUL-1
DO WHILE POS(".",N)>0
    N=N*10
    D=D*10
	IF VERIFY(RIGHT(N,LENGTH(N)-POS(".",N)),"0")=0 THEN LEAVE
END
RETURN DIV(N,D)

D2R: PROCEDURE /* Function: Convert degrees to radians */
/*
Parameters:
Degrees
Returns: Radians
*/
RETURN ARG(1)*PI()/180

R2D: PROCEDURE /* Function: Convert radians to degrees */
/*
Parameters:
Radians
Returns: Degrees
*/
RETURN ARG(1)/PI()*180

GAS: PROCEDURE /* FUNCTION: Solve Ideal Gas problems */
/*
Parameters:
V1,T1,P1,V2,T2,P2 (omit one to get result)
Returns: Omitted question
If one element (say volume) is kept constant but the figure is not given, anything will do.
If no elements omitted, returns 1 if valid, or 0 if not.
*/
PARSE ARG V1,T1,P1,V2,T2,P2
SELECT
	WHEN V1="" THEN RETURN P2*V2*T1/P1
	WHEN T1="" THEN RETURN P1*V1*T2/P2/V2
	WHEN P1="" THEN RETURN P2*V2*T1/V1/T2
	WHEN V2="" THEN RETURN P1*V1*T2/P2
	WHEN T2="" THEN RETURN P2*V2*T1/P1/V1
	WHEN P2="" THEN RETURN P1*V1*T2/V2/T1
OTHERWISE RETURN V1*P1/T1=V2*P2/T2
END
RETURN "Error!!!!!"

ISURDS: PROCEDURE /* FUNCTION: Solve i surds/complex number problems. */
/*
Parameters:
A,B,op,C,D
Returns: E F
This solves the problem (A+Bi)op(C+Di), with the result E+Fi.
Valid values for op:
'+' for addition
'-' for subtraction
'*' for multiplication
'/' for division
*/
PARSE ARG A,B,OP,C,D
SELECT
	WHEN OP="+" THEN DO
		E=A+C
		F=B+D
	END
	WHEN OP="-" THEN DO
		E=A-C
		F=B-D
	END
	WHEN OP="*" THEN DO
		E=A*C-B*D
		F=B*C+A*D
	END
	WHEN OP="/" THEN DO
		PARSE VALUE ISURDS(A,B,"*",C,-D) WITH E F
		DENOM=C**2+D**2
		E=DIV(E,DENOM)
		F=DIV(F,DENOM)
	END
	OTHERWISE E="Invalid op:"; F=OP
END
RETURN E F

TWOSURD: PROCEDURE /* FUNCTION: Solve 2 surd problems. */
/*
To solve SQRT(X+A)+SQRT(X)=B (A and B given):
Parameters: A,B
Returns: value for X
*/
PARSE ARG A,B
X=(B**2-A)/(2*B)
IF (X+A<0)|(X<0) THEN RETURN "No sol"
RETURN X

REC2POL: PROCEDURE /* FUNCTION: Convert rectangular to polar coord */
/*
To convert (X,Y) to polar:
Parameters: X,Y
Returns: A B
Answer is A angle B degrees.
*/
PARSE ARG X,Y
A=SQUAREROOT(X**2+Y**2)
B=R2D(ATAN(ABS(Y)/ABS(X)))
QUAD=(X<0)+2*(Y<0)
SELECT
	WHEN QUAD=1 THEN B=180-B
	WHEN QUAD=2 THEN B=360-B
	WHEN QUAD=3 THEN B=B+180
OTHERWISE NOP
END
RETURN A B

POL2REC: PROCEDURE /* FUNCTION: Convert polar coord to rectangular */
/*
To convert X angle Y degrees to polar:
Parameters: X,Y
Returns: (A,B)
*/
PARSE ARG X,Y
IF X<0 THEN Y=Y+180
X=ABS(X)
RETURN "("||X*COS(D2R(Y))","||X*SIN(D2R(Y))")"

SIGMA:
PARSE ARG !!VAR,!!LOW,!!HIGH,!!VAL
!!TOT=0
INTERPRET "DO "!!VAR"=!!LOW TO !!HIGH; !!TOT=!!TOT+("!!VAL"); END"
RETURN !!TOT

AREASEGMENT: PROCEDURE /* FUNCTION: Calculate area of a segment */
/*
Parameters:
ANGLE,RADIUS
where ANGLE is arc angle in radians, and radius is the radius of the circle
Returns:
AREA
Self explanatory.
*/
PARSE ARG A,R
SECTOR=PI()*R*R*A/2/PI()
TRIANGLE=R*R*SIN(A)/2
RETURN SECTOR-TRIANGLE

DISTPOINTLINE: PROCEDURE /* FUNCTION: Find the distance from a point to a line */
/*
Parameters:
X,Y,M,B
Returns:
Distance from (X,Y) to y=Mx+B
*/
PARSE ARG X,Y,M,B
INT=((Y*M)+X)/M
PARSE VALUE SOLVEEQU2(M,-1,B,-1/M,-1,INT) WITH "("X2","Y2")"
RETURN SQRT((X-X2)**2+(Y-Y2)**2)

PASCAL: PROCEDURE EXPOSE PASCAL. /* FUNCTION: Return value from Pascal's Triangle */
/*
Parameters:
row,term
Row is which row to return data from (1=0th row, 1 1=1st row, 1 2 1=2nd row)
Term is which term of the specified row (from 2nd row, 2nd term=2)
*/
PARSE ARG ROW,TERM
IF PASCAL.0="PASCAL.0" THEN PASCAL.0=0
IF PASCAL.0<ROW THEN DO
	/* Build Pascal's Triangle up to ROW */
	DO I=PASCAL.0+1 TO ROW
		DO J=1 TO I
			PREVROW=I-1
			PREVCOL=J-1
			IF (J=1)|(J=I)|(I=1) THEN PASCAL.I.J=1
			ELSE PASCAL.I.J=PASCAL.PREVROW.J+PASCAL.PREVROW.PREVCOL
		END
	END
	PASCAL.0=ROW
END
RETURN PASCAL.ROW.TERM

XPLUSY: PROCEDURE /* FUNCTION: Return term(s) from (x+y) */
/*
Parameters:
n,term
n is power (x+y) is raised to
term is which term to return, or "" to return all terms
Returns:
c x^a y^b
*/
PARSE ARG N,TERM
IF TERM\="" THEN DO
	XPOW=N-TERM+1
	IF XPOW=0 THEN XTERM=""
	ELSE IF XPOW=1 THEN XTERM=" x"
	ELSE XTERM=" x^"XPOW
	YPOW=TERM-1
	IF YPOW=0 THEN YTERM=""
	ELSE IF YPOW=1 THEN YTERM=" y"
	ELSE YTERM=" y^"YPOW
	COEF=PASCAL(N+1,TERM)
	IF COEF=0 THEN RETURN ""
	IF COEF=1 THEN COEF=""
	RETURN COEF||XTERM||YTERM
END
RET=""
DO I=1 TO N+1
	RET=RET" + "XPLUSY(N,I)
END
RETURN SUBWORD(RET,2)
