/*
 * Decompiled with CFR 0.152.
 */
package org.netrexx.process;

import netrexx.lang.NoOtherwiseException;
import netrexx.lang.Rexx;
import org.netrexx.process.RxField;
import org.netrexx.process.RxToken;
import org.netrexx.process.RxType;

public class RxVariable {
    private static final Rexx $01 = Rexx.toRexx("static");
    private static final Rexx $02 = Rexx.toRexx("transient");
    private static final Rexx $03 = Rexx.toRexx("volatile");
    private static final String $0 = "RxVariable.nrx";
    public static final int VAR_ARG = 1;
    public static final int VAR_LOCAL = 2;
    public static final int VAR_PROP = 4;
    public static final int VAR_PUBLIC = 16;
    public static final int VAR_INHERIT = 32;
    public static final int VAR_PRIVATE = 64;
    public static final int VAR_INDIRECT = 128;
    public static final int VAR_SHARED = 8192;
    public static final int VAR_CONSTANT = 256;
    public static final int VAR_STATIC = 512;
    public static final int VAR_TRANSIENT = 1024;
    public static final int VAR_VOLATILE = 2048;
    public static final int VAR_DEPRECATED = 4096;
    public static final int VAR_OPTIONAL = 16384;
    public static final int VAR_READONLY = 32768;
    public static final int VAR_UNUSED = 65536;
    public static final int VAR_LIT = 131072;
    public Rexx varname;
    public Rexx varspell;
    public RxToken vartoken;
    public int varatts;
    public RxType vartype;
    public Rexx varctype;
    public RxField varfield;
    public StringBuffer varrefs;
    public boolean varabstract;
    public boolean varseen = false;
    public boolean varmain = false;
    public Object varvalue;

    public RxVariable(Rexx rexx, Rexx rexx2, RxToken rxToken, int n, RxType rxType, boolean bl) {
        this.varname = rexx;
        this.varspell = rexx2;
        this.vartoken = rxToken;
        this.varatts = n;
        this.vartype = rxType;
        this.varabstract = bl;
    }

    public boolean islocal() {
        return this.varatts == 2;
    }

    public boolean isargument() {
        return (this.varatts & 1) != 0;
    }

    public boolean isabstractargument() {
        return (this.varatts & 1) != 0 && this.varabstract;
    }

    public boolean isproperty() {
        return (this.varatts & 4) != 0;
    }

    public boolean isindirect() {
        return (this.varatts & 0x80) != 0;
    }

    public boolean isreadonly() {
        return (this.varatts & 0x8000) != 0;
    }

    public boolean isunused() {
        return (this.varatts & 0x10000) != 0;
    }

    public boolean isconstant() {
        return (this.varatts & 0x100) != 0;
    }

    public boolean islit() {
        return (this.varatts & 0x20000) != 0;
    }

    public boolean isprivateprop() {
        return (this.varatts & 0x40) != 0 && (this.varatts & 4) != 0;
    }

    public boolean isstaticprop() {
        return (this.varatts & 4) != 0 && (this.varatts & 0x300) != 0;
    }

    public boolean isnonstaticprop() {
        return this.isproperty() & !this.isstaticprop();
    }

    public boolean isarray() {
        return this.vartype.isarray();
    }

    public boolean isdeprecated() {
        return (this.varatts & 0x1000) != 0;
    }

    public void setlit() {
        this.varatts |= 0x20000;
    }

    public char tracetag() {
        if ((this.varatts & 2) != 0) {
            return 'v';
        }
        if ((this.varatts & 1) != 0) {
            return 'a';
        }
        return 'p';
    }

    public Rexx javamodifiers() {
        Rexx rexx = null;
        if (!this.isproperty()) {
            return Rexx.toRexx("");
        }
        if ((this.varatts & 0x10) != 0) {
            rexx = Rexx.toRexx("public");
        } else if ((this.varatts & 0x20) != 0) {
            rexx = Rexx.toRexx("protected");
        } else if ((this.varatts & 0x2000) != 0) {
            rexx = Rexx.toRexx("");
        } else if ((this.varatts & 0x40) != 0) {
            rexx = Rexx.toRexx("private");
        } else if ((this.varatts & 0x80) != 0) {
            rexx = Rexx.toRexx("private");
        } else {
            throw new NoOtherwiseException();
        }
        if ((this.varatts & 0x100) != 0) {
            rexx = rexx.OpCcblank(null, Rexx.toRexx("static final"));
        } else if ((this.varatts & 0x200) != 0) {
            rexx = rexx.OpCcblank(null, $01);
        } else if ((this.varatts & 0x400) != 0) {
            rexx = rexx.OpCcblank(null, $02);
        } else if ((this.varatts & 0x800) != 0) {
            rexx = rexx.OpCcblank(null, $03);
        }
        return rexx.space();
    }

    public int visibility() {
        int n = 0;
        if (!this.isproperty()) {
            return 0;
        }
        if ((this.varatts & 0x10) != 0) {
            n = 1;
        } else if ((this.varatts & 0x20) != 0) {
            n = 2;
        } else if ((this.varatts & 0x2000) != 0) {
            n = 3;
        } else if ((this.varatts & 0x40) != 0) {
            n = 4;
        } else if ((this.varatts & 0x80) != 0) {
            n = 4;
        } else {
            throw new NoOtherwiseException();
        }
        return n;
    }

    public int attributes() {
        int n = 0;
        if (!this.isproperty()) {
            return 0;
        }
        if ((this.varatts & 0x100) != 0) {
            n = 3;
        } else if ((this.varatts & 0x200) != 0) {
            n = 1;
        } else if ((this.varatts & 0x400) != 0) {
            n = 64;
        } else if ((this.varatts & 0x800) != 0) {
            n = 32;
        }
        return n;
    }

    public RxVariable copy() {
        RxVariable rxVariable = new RxVariable(this.varname, this.varspell, this.vartoken, this.varatts, this.vartype, this.varabstract);
        rxVariable.varmain = this.varmain;
        return rxVariable;
    }
}

