/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.EmptyStatement;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.codegen.BranchLabel;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.LoopingFlowContext;
import org.eclipse.jdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class WhileStatement
extends Statement {
    public Expression condition;
    public Statement action;
    private BranchLabel breakLabel;
    private BranchLabel continueLabel;
    int preCondInitStateIndex = -1;
    int condIfTrueInitStateIndex = -1;
    int mergedInitStateIndex = -1;

    public WhileStatement(Expression expression, Statement statement, int n, int n2) {
        this.condition = expression;
        this.action = statement;
        if (statement instanceof EmptyStatement) {
            statement.bits |= 1;
        }
        this.sourceStart = n;
        this.sourceEnd = n2;
    }

    @Override
    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        FlowInfo flowInfo2;
        this.breakLabel = new BranchLabel();
        this.continueLabel = new BranchLabel();
        int n = (flowInfo.reachMode() & 3) != 0 ? 1 : 0;
        Constant constant = this.condition.constant;
        boolean bl = constant != Constant.NotAConstant && constant.booleanValue();
        boolean bl2 = constant != Constant.NotAConstant && !constant.booleanValue();
        constant = this.condition.optimizedBooleanConstant();
        boolean bl3 = constant != Constant.NotAConstant && constant.booleanValue();
        boolean bl4 = constant != Constant.NotAConstant && !constant.booleanValue();
        this.preCondInitStateIndex = blockScope.methodScope().recordInitializationStates(flowInfo);
        FlowInfo flowInfo3 = flowInfo.nullInfoLessUnconditionalCopy();
        LoopingFlowContext loopingFlowContext = new LoopingFlowContext(flowContext, flowInfo, this, null, null, blockScope, true);
        flowInfo3 = this.condition.analyseCode(blockScope, loopingFlowContext, flowInfo3);
        this.condition.checkNPEbyUnboxing(blockScope, flowContext, flowInfo);
        if (this.action == null || this.action.isEmptyBlock() && blockScope.compilerOptions().complianceLevel <= 0x2F0000L) {
            loopingFlowContext.complainOnDeferredFinalChecks(blockScope, flowInfo3);
            loopingFlowContext.complainOnDeferredNullChecks(blockScope, flowInfo3.unconditionalInits());
            if (bl) {
                return FlowInfo.DEAD_END;
            }
            FlowInfo flowInfo4 = flowInfo.copy().addInitializationsFrom(flowInfo3.initsWhenFalse());
            if (bl3) {
                flowInfo4.setReachMode(1);
            }
            this.mergedInitStateIndex = blockScope.methodScope().recordInitializationStates(flowInfo4);
            return flowInfo4;
        }
        LoopingFlowContext loopingFlowContext2 = new LoopingFlowContext(flowContext, flowInfo, this, this.breakLabel, this.continueLabel, blockScope, true);
        loopingFlowContext2.copyNullCheckedFieldsFrom(loopingFlowContext);
        if (bl2) {
            flowInfo2 = FlowInfo.DEAD_END;
        } else {
            flowInfo2 = flowInfo3.initsWhenTrue().copy();
            if (bl4) {
                flowInfo2.setReachMode(1);
            }
        }
        this.condIfTrueInitStateIndex = blockScope.methodScope().recordInitializationStates(flowInfo3.initsWhenTrue());
        if (this.action.complainIfUnreachable(flowInfo2, blockScope, n, true) < 2) {
            this.condition.updateFlowOnBooleanResult(flowInfo2, true);
            flowInfo2 = this.action.analyseCode(blockScope, loopingFlowContext2, flowInfo2);
        }
        FlowInfo flowInfo5 = flowInfo.copy();
        int n2 = flowInfo2.tagBits & loopingFlowContext2.initsOnContinue.tagBits;
        if ((n2 & 3) != 0) {
            if ((n2 & 1) != 0) {
                this.continueLabel = null;
            }
            flowInfo5.addInitializationsFrom(flowInfo3.initsWhenFalse());
            flowInfo2 = flowInfo2.mergedWith(loopingFlowContext2.initsOnContinue.unconditionalInits());
            loopingFlowContext.complainOnDeferredNullChecks(blockScope, flowInfo2, false);
            loopingFlowContext2.complainOnDeferredNullChecks(blockScope, flowInfo2, false);
        } else {
            loopingFlowContext.complainOnDeferredFinalChecks(blockScope, flowInfo3);
            flowInfo2 = flowInfo2.mergedWith(loopingFlowContext2.initsOnContinue.unconditionalInits());
            loopingFlowContext.complainOnDeferredNullChecks(blockScope, flowInfo2);
            loopingFlowContext2.complainOnDeferredFinalChecks(blockScope, flowInfo2);
            loopingFlowContext2.complainOnDeferredNullChecks(blockScope, flowInfo2);
            flowInfo5.addPotentialInitializationsFrom(flowInfo2.unconditionalInits()).addInitializationsFrom(flowInfo3.initsWhenFalse());
        }
        if (loopingFlowContext2.hasEscapingExceptions()) {
            FlowInfo flowInfo6 = flowInfo.copy();
            if (this.continueLabel != null) {
                flowInfo6 = flowInfo6.mergedWith(flowInfo6.unconditionalCopy().addNullInfoFrom(flowInfo2).unconditionalInits());
            }
            loopingFlowContext2.simulateThrowAfterLoopBack(flowInfo6);
        }
        UnconditionalFlowInfo unconditionalFlowInfo = FlowInfo.mergedOptimizedBranches((loopingFlowContext2.initsOnBreak.tagBits & 3) != 0 ? loopingFlowContext2.initsOnBreak : flowInfo.addInitializationsFrom(loopingFlowContext2.initsOnBreak), bl3, flowInfo5, bl4, !bl);
        this.mergedInitStateIndex = blockScope.methodScope().recordInitializationStates(unconditionalFlowInfo);
        this.condition.updateFlowOnBooleanResult(unconditionalFlowInfo, false);
        return unconditionalFlowInfo;
    }

    @Override
    public void generateCode(BlockScope blockScope, CodeStream codeStream) {
        boolean bl;
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        if (this.condition != null && this.condition.containsPatternVariable()) {
            this.condition.addPatternVariables(blockScope, codeStream);
        }
        int n = codeStream.position;
        Constant constant = this.condition.optimizedBooleanConstant();
        boolean bl2 = bl = constant != Constant.NotAConstant && !constant.booleanValue();
        if (bl) {
            this.condition.generateCode(blockScope, codeStream, false);
            if (this.mergedInitStateIndex != -1) {
                codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.mergedInitStateIndex);
                codeStream.addDefinitelyAssignedVariables(blockScope, this.mergedInitStateIndex);
            }
            codeStream.recordPositionsFrom(n, this.sourceStart);
            return;
        }
        this.breakLabel.initialize(codeStream);
        if (this.continueLabel == null) {
            if (this.condition.constant == Constant.NotAConstant) {
                this.condition.generateOptimizedBoolean(blockScope, codeStream, null, this.breakLabel, true);
            }
        } else {
            this.continueLabel.initialize(codeStream);
            if (!(this.condition.constant != Constant.NotAConstant && this.condition.constant.booleanValue() || this.action == null || this.action.isEmptyBlock())) {
                int n2 = codeStream.position;
                codeStream.goto_(this.continueLabel);
                codeStream.recordPositionsFrom(n2, this.condition.sourceStart);
            }
        }
        BranchLabel branchLabel = new BranchLabel(codeStream);
        if (this.action != null) {
            branchLabel.tagBits |= 2;
            if (this.condIfTrueInitStateIndex != -1) {
                codeStream.addDefinitelyAssignedVariables(blockScope, this.condIfTrueInitStateIndex);
            }
            branchLabel.place();
            this.action.generateCode(blockScope, codeStream);
            if (this.preCondInitStateIndex != -1) {
                codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.preCondInitStateIndex);
            }
        } else {
            branchLabel.place();
        }
        if (this.continueLabel != null) {
            this.continueLabel.place();
            this.condition.generateOptimizedBoolean(blockScope, codeStream, branchLabel, null, true);
        }
        if (this.mergedInitStateIndex != -1) {
            codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.mergedInitStateIndex);
            codeStream.addDefinitelyAssignedVariables(blockScope, this.mergedInitStateIndex);
        }
        this.breakLabel.place();
        codeStream.recordPositionsFrom(n, this.sourceStart);
    }

    @Override
    public void resolve(BlockScope blockScope) {
        if (this.condition.containsPatternVariable()) {
            this.condition.collectPatternVariablesToScope(null, blockScope);
            LocalVariableBinding[] localVariableBindingArray = this.condition.getPatternVariablesWhenTrue();
            LocalVariableBinding[] localVariableBindingArray2 = this.condition.getPatternVariablesWhenFalse();
            TypeBinding typeBinding = this.condition.resolveTypeExpecting(blockScope, TypeBinding.BOOLEAN);
            this.condition.computeConversion(blockScope, typeBinding, typeBinding);
            if (this.action != null) {
                this.action.resolveWithPatternVariablesInScope(localVariableBindingArray, blockScope);
                this.action.promotePatternVariablesIfApplicable(localVariableBindingArray2, () -> !this.action.breaksOut(null));
            }
        } else {
            TypeBinding typeBinding = this.condition.resolveTypeExpecting(blockScope, TypeBinding.BOOLEAN);
            this.condition.computeConversion(blockScope, typeBinding, typeBinding);
            if (this.action != null) {
                this.action.resolve(blockScope);
            }
        }
    }

    @Override
    public StringBuffer printStatement(int n, StringBuffer stringBuffer) {
        WhileStatement.printIndent(n, stringBuffer).append("while (");
        this.condition.printExpression(0, stringBuffer).append(')');
        if (this.action == null) {
            stringBuffer.append(';');
        } else {
            this.action.printStatement(n + 1, stringBuffer);
        }
        return stringBuffer;
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            this.condition.traverse(aSTVisitor, blockScope);
            if (this.action != null) {
                this.action.traverse(aSTVisitor, blockScope);
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }

    @Override
    public boolean doesNotCompleteNormally() {
        Constant constant = this.condition.constant;
        boolean bl = constant == null || constant != Constant.NotAConstant && constant.booleanValue();
        constant = this.condition.optimizedBooleanConstant();
        boolean bl2 = constant == null ? true : constant != Constant.NotAConstant && constant.booleanValue();
        return !(!bl && !bl2 || this.action != null && this.action.breaksOut(null));
    }

    @Override
    public boolean completesByContinue() {
        return this.action.continuesAtOuterLabel();
    }

    @Override
    public boolean canCompleteNormally() {
        boolean bl;
        Constant constant = this.condition.constant;
        boolean bl2 = constant == null || constant != Constant.NotAConstant && constant.booleanValue();
        constant = this.condition.optimizedBooleanConstant();
        boolean bl3 = constant == null ? true : (bl = constant != Constant.NotAConstant && constant.booleanValue());
        if (!bl2 && !bl) {
            return true;
        }
        return this.action != null && this.action.breaksOut(null);
    }

    @Override
    public boolean continueCompletes() {
        return this.action.continuesAtOuterLabel();
    }
}

