/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.env;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.util.SimpleSetOfCharArray;

public interface IUpdatableModule {
    public char[] name();

    public void addReads(char[] var1);

    public void addExports(char[] var1, char[][] var2);

    public void setMainClassName(char[] var1);

    public void setPackageNames(SimpleSetOfCharArray var1);

    public static class UpdatesByKind {
        List<Consumer<IUpdatableModule>> moduleUpdates = Collections.emptyList();
        List<Consumer<IUpdatableModule>> packageUpdates = Collections.emptyList();

        public List<Consumer<IUpdatableModule>> getList(UpdateKind updateKind, boolean bl) {
            switch (updateKind) {
                case MODULE: {
                    if (this.moduleUpdates == Collections.EMPTY_LIST && bl) {
                        this.moduleUpdates = new ArrayList<Consumer<IUpdatableModule>>();
                    }
                    return this.moduleUpdates;
                }
                case PACKAGE: {
                    if (this.packageUpdates == Collections.EMPTY_LIST && bl) {
                        this.packageUpdates = new ArrayList<Consumer<IUpdatableModule>>();
                    }
                    return this.packageUpdates;
                }
            }
            throw new IllegalArgumentException("Unknown enum value " + (Object)((Object)updateKind));
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            for (Consumer<IUpdatableModule> consumer : this.moduleUpdates) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append("\n");
                }
                stringBuilder.append(consumer);
            }
            for (Consumer<IUpdatableModule> consumer : this.packageUpdates) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append("\n");
                }
                stringBuilder.append(consumer);
            }
            return stringBuilder.toString();
        }
    }

    public static class AddReads
    implements Consumer<IUpdatableModule> {
        char[] targetModule;

        public AddReads(char[] cArray) {
            this.targetModule = cArray;
        }

        @Override
        public void accept(IUpdatableModule iUpdatableModule) {
            iUpdatableModule.addReads(this.targetModule);
        }

        public char[] getTarget() {
            return this.targetModule;
        }

        public UpdateKind getKind() {
            return UpdateKind.MODULE;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof AddReads)) {
                return false;
            }
            AddReads addReads = (AddReads)object;
            return CharOperation.equals(this.targetModule, addReads.targetModule);
        }

        public int hashCode() {
            return CharOperation.hashCode(this.targetModule);
        }

        public String toString() {
            return "add-read " + CharOperation.charToString(this.targetModule);
        }
    }

    public static class AddExports
    implements Consumer<IUpdatableModule> {
        char[] name;
        char[][] targets;

        public AddExports(char[] cArray, char[][] cArray2) {
            this.name = cArray;
            this.targets = cArray2;
        }

        @Override
        public void accept(IUpdatableModule iUpdatableModule) {
            iUpdatableModule.addExports(this.name, this.targets);
        }

        public char[] getName() {
            return this.name;
        }

        public char[][] getTargetModules() {
            return this.targets;
        }

        public UpdateKind getKind() {
            return UpdateKind.PACKAGE;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof AddExports)) {
                return false;
            }
            AddExports addExports = (AddExports)object;
            if (!CharOperation.equals(this.name, addExports.name)) {
                return false;
            }
            return CharOperation.equals(this.targets, addExports.targets);
        }

        public int hashCode() {
            int n = CharOperation.hashCode(this.name);
            if (this.targets != null) {
                for (int i = 0; i < this.targets.length; ++i) {
                    n += 17 * CharOperation.hashCode(this.targets[i]);
                }
            }
            return n;
        }

        public String toString() {
            return "add-exports " + CharOperation.charToString(this.name) + "=" + CharOperation.charToString(CharOperation.concatWith(this.targets, ','));
        }
    }

    public static enum UpdateKind {
        MODULE,
        PACKAGE;

    }
}

