/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.parser;

import java.util.List;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.IJavadocTypeReference;
import org.eclipse.jdt.internal.compiler.ast.Javadoc;
import org.eclipse.jdt.internal.compiler.ast.JavadocAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.JavadocArgumentExpression;
import org.eclipse.jdt.internal.compiler.ast.JavadocArrayQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.JavadocArraySingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.JavadocFieldReference;
import org.eclipse.jdt.internal.compiler.ast.JavadocImplicitTypeReference;
import org.eclipse.jdt.internal.compiler.ast.JavadocMessageSend;
import org.eclipse.jdt.internal.compiler.ast.JavadocModuleReference;
import org.eclipse.jdt.internal.compiler.ast.JavadocQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.JavadocReturnStatement;
import org.eclipse.jdt.internal.compiler.ast.JavadocSingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.JavadocSingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.parser.AbstractCommentParser;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.parser.Scanner;
import org.eclipse.jdt.internal.compiler.parser.ScannerHelper;
import org.eclipse.jdt.internal.compiler.util.Util;

public class JavadocParser
extends AbstractCommentParser {
    private static final JavadocSingleNameReference[] NO_SINGLE_NAME_REFERENCE = new JavadocSingleNameReference[0];
    private static final JavadocSingleTypeReference[] NO_SINGLE_TYPE_REFERENCE = new JavadocSingleTypeReference[0];
    private static final JavadocQualifiedTypeReference[] NO_QUALIFIED_TYPE_REFERENCE = new JavadocQualifiedTypeReference[0];
    private static final TypeReference[] NO_TYPE_REFERENCE = new TypeReference[0];
    private static final Expression[] NO_EXPRESSION = new Expression[0];
    public Javadoc docComment;
    private int invalidParamReferencesPtr = -1;
    private ASTNode[] invalidParamReferencesStack;
    private long validValuePositions;
    private long invalidValuePositions;
    public boolean shouldReportProblems = true;
    private int tagWaitingForDescription;

    public JavadocParser(Parser parser) {
        super(parser);
        this.kind = 513;
        if (parser != null && parser.options != null) {
            this.setJavadocPositions = parser.options.processAnnotations;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkDeprecation(int n) {
        block18: {
            this.javadocStart = this.sourceParser.scanner.commentStarts[n];
            this.javadocEnd = this.sourceParser.scanner.commentStops[n] - 1;
            this.firstTagPosition = this.sourceParser.scanner.commentTagStarts[n];
            this.validValuePositions = -1L;
            this.invalidValuePositions = -1L;
            this.tagWaitingForDescription = 0;
            if (this.checkDocComment) {
                this.docComment = new Javadoc(this.javadocStart, this.javadocEnd);
            } else if (this.setJavadocPositions) {
                this.docComment = new Javadoc(this.javadocStart, this.javadocEnd);
                this.docComment.bits &= 0xFFFEFFFF;
            } else {
                this.docComment = null;
            }
            if (this.firstTagPosition == 0) {
                switch (this.kind & 0xFF) {
                    case 1: 
                    case 16: {
                        return false;
                    }
                }
            }
            try {
                int n2;
                this.source = this.sourceParser.scanner.source;
                this.scanner.setSource(this.source);
                if (this.checkDocComment) {
                    this.scanner.lineEnds = this.sourceParser.scanner.lineEnds;
                    this.scanner.linePtr = this.sourceParser.scanner.linePtr;
                    this.lineEnds = this.scanner.lineEnds;
                    this.commentParse();
                    break block18;
                }
                Scanner scanner = this.sourceParser.scanner;
                int n3 = Util.getLineNumber(this.javadocStart, scanner.lineEnds, 0, scanner.linePtr);
                int n4 = Util.getLineNumber(this.javadocEnd, scanner.lineEnds, 0, scanner.linePtr);
                this.index = this.javadocStart + 3;
                this.deprecated = false;
                block10: for (n2 = n3; n2 <= n4; ++n2) {
                    int n5;
                    this.index = n5 = n2 == n3 ? this.javadocStart + 3 : this.sourceParser.scanner.getLineStart(n2);
                    int n6 = this.lineEnd = n2 == n4 ? this.javadocEnd - 2 : this.sourceParser.scanner.getLineEnd(n2);
                    block11: while (this.index < this.lineEnd) {
                        char c = this.readChar();
                        switch (c) {
                            case '\t': 
                            case '\n': 
                            case '\f': 
                            case '\r': 
                            case ' ': 
                            case '*': {
                                continue block11;
                            }
                            case '@': {
                                this.parseSimpleTag();
                                if (this.tagValue == 1 && this.abort) continue block10;
                            }
                            default: {
                                continue block10;
                            }
                        }
                    }
                }
                n2 = this.deprecated ? 1 : 0;
                return n2 != 0;
            }
            finally {
                this.source = null;
                this.scanner.setSource((char[])null);
            }
        }
        return this.deprecated;
    }

    @Override
    protected Object createArgumentReference(char[] cArray, int n, boolean bl, Object object, long[] lArray, long l) throws InvalidInputException {
        try {
            TypeReference typeReference = (TypeReference)object;
            if (n > 0) {
                long l2 = ((long)typeReference.sourceStart << 32) + (long)typeReference.sourceEnd;
                if (object instanceof JavadocSingleTypeReference) {
                    JavadocSingleTypeReference javadocSingleTypeReference = (JavadocSingleTypeReference)object;
                    typeReference = new JavadocArraySingleTypeReference(javadocSingleTypeReference.token, n, l2);
                } else {
                    JavadocQualifiedTypeReference javadocQualifiedTypeReference = (JavadocQualifiedTypeReference)object;
                    typeReference = new JavadocArrayQualifiedTypeReference(javadocQualifiedTypeReference, n);
                }
            }
            int n2 = typeReference.sourceEnd;
            if (n > 0) {
                n2 = (int)lArray[n - 1];
                if (bl) {
                    typeReference.bits |= 0x4000;
                }
            }
            if (l >= 0L) {
                n2 = (int)l;
            }
            return new JavadocArgumentExpression(cArray, typeReference.sourceStart, n2, typeReference);
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException();
        }
    }

    @Override
    protected Object createFieldReference(Object object) throws InvalidInputException {
        try {
            Object object2;
            TypeReference typeReference = null;
            boolean bl = false;
            if (object instanceof JavadocModuleReference) {
                object2 = (JavadocModuleReference)object;
                if (((JavadocModuleReference)object2).typeReference != null) {
                    typeReference = ((JavadocModuleReference)object2).typeReference;
                    bl = true;
                }
            } else {
                typeReference = (TypeReference)object;
            }
            if (typeReference == null) {
                object2 = this.sourceParser.compilationUnit.getMainTypeName();
                typeReference = new JavadocImplicitTypeReference((char[])object2, this.memberStart);
            }
            object2 = new JavadocFieldReference(this.identifierStack[0], this.identifierPositionStack[0]);
            ((JavadocFieldReference)object2).receiver = bl ? (Expression)object : typeReference;
            ((JavadocFieldReference)object2).tagSourceStart = this.tagSourceStart;
            ((JavadocFieldReference)object2).tagSourceEnd = this.tagSourceEnd;
            ((JavadocFieldReference)object2).tagValue = this.tagValue;
            return object2;
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException();
        }
    }

    @Override
    protected Object createMethodReference(Object object, List list) throws InvalidInputException {
        try {
            Statement statement;
            Object object2;
            TypeReference typeReference = null;
            if (object instanceof JavadocModuleReference) {
                JavadocModuleReference javadocModuleReference = (JavadocModuleReference)object;
                if (javadocModuleReference.typeReference != null) {
                    typeReference = javadocModuleReference.typeReference;
                }
            } else {
                typeReference = (TypeReference)object;
            }
            boolean bl = false;
            int n = this.identifierLengthStack[0];
            if (typeReference == null) {
                object2 = this.sourceParser.compilationUnit.getMainTypeName();
                statement = this.getParsedTypeDeclaration();
                if (statement != null) {
                    object2 = statement.name;
                }
                bl = CharOperation.equals(this.identifierStack[n - 1], object2);
                typeReference = new JavadocImplicitTypeReference((char[])object2, this.memberStart);
            } else if (typeReference instanceof JavadocSingleTypeReference) {
                object2 = ((JavadocSingleTypeReference)typeReference).token;
                bl = CharOperation.equals(this.identifierStack[n - 1], object2);
            } else if (typeReference instanceof JavadocQualifiedTypeReference) {
                object2 = ((JavadocQualifiedTypeReference)typeReference).tokens;
                int n2 = ((char[])object2).length - 1;
                bl = CharOperation.equals(this.identifierStack[n - 1], (char[])object2[n2]);
                if (bl) {
                    boolean bl2 = true;
                    if (bl2) {
                        for (int i = 0; i < n - 1 && bl2; ++i) {
                            bl2 = CharOperation.equals(this.identifierStack[i], (char[])object2[i]);
                        }
                    }
                    if (!bl2) {
                        if (this.reportProblems) {
                            this.sourceParser.problemReporter().javadocInvalidMemberTypeQualification((int)(this.identifierPositionStack[0] >>> 32), (int)this.identifierPositionStack[n - 1], -1);
                        }
                        return null;
                    }
                }
            } else {
                throw new InvalidInputException();
            }
            if (list == null) {
                if (bl) {
                    object2 = new JavadocAllocationExpression(this.identifierPositionStack[n - 1]);
                    object2.type = typeReference;
                    object2.tagValue = this.tagValue;
                    object2.sourceEnd = this.scanner.getCurrentTokenEndPosition();
                    if (n == 1) {
                        object2.qualification = new char[][]{this.identifierStack[0]};
                    } else {
                        char[][] cArrayArray = new char[n][];
                        object2.qualification = cArrayArray;
                        System.arraycopy(this.identifierStack, 0, cArrayArray, 0, n);
                        object2.sourceStart = (int)(this.identifierPositionStack[0] >>> 32);
                    }
                    object2.memberStart = this.memberStart;
                    return object2;
                }
                object2 = new JavadocMessageSend(this.identifierStack[n - 1], this.identifierPositionStack[n - 1]);
                object2.receiver = typeReference;
                object2.tagValue = this.tagValue;
                object2.sourceEnd = this.scanner.getCurrentTokenEndPosition();
                return object2;
            }
            object2 = new JavadocArgumentExpression[list.size()];
            list.toArray((T[])object2);
            if (bl) {
                statement = new JavadocAllocationExpression(this.identifierPositionStack[n - 1]);
                ((JavadocAllocationExpression)statement).arguments = (Expression[])object2;
                ((JavadocAllocationExpression)statement).type = typeReference;
                ((JavadocAllocationExpression)statement).tagValue = this.tagValue;
                ((JavadocAllocationExpression)statement).sourceEnd = this.scanner.getCurrentTokenEndPosition();
                if (n == 1) {
                    ((JavadocAllocationExpression)statement).qualification = new char[][]{this.identifierStack[0]};
                } else {
                    char[][] cArrayArray = new char[n][];
                    ((JavadocAllocationExpression)statement).qualification = cArrayArray;
                    System.arraycopy(this.identifierStack, 0, cArrayArray, 0, n);
                    ((JavadocAllocationExpression)statement).sourceStart = (int)(this.identifierPositionStack[0] >>> 32);
                }
                ((JavadocAllocationExpression)statement).memberStart = this.memberStart;
                return statement;
            }
            statement = new JavadocMessageSend(this.identifierStack[n - 1], this.identifierPositionStack[n - 1], (JavadocArgumentExpression[])object2);
            ((JavadocMessageSend)statement).receiver = typeReference;
            ((JavadocMessageSend)statement).tagValue = this.tagValue;
            ((JavadocMessageSend)statement).sourceEnd = this.scanner.getCurrentTokenEndPosition();
            return statement;
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException();
        }
    }

    @Override
    protected Object createReturnStatement() {
        return new JavadocReturnStatement(this.scanner.getCurrentTokenStartPosition(), this.scanner.getCurrentTokenEndPosition());
    }

    @Override
    protected void createTag() {
        this.tagValue = 100;
    }

    @Override
    protected Object createTypeReference(int n) {
        TypeReference typeReference = null;
        int n2 = this.identifierLengthStack[this.identifierLengthPtr];
        if (n2 == 1) {
            typeReference = new JavadocSingleTypeReference(this.identifierStack[this.identifierPtr], this.identifierPositionStack[this.identifierPtr], this.tagSourceStart, this.tagSourceEnd);
        } else if (n2 > 1) {
            char[][] cArrayArray = new char[n2][];
            System.arraycopy(this.identifierStack, this.identifierPtr - n2 + 1, cArrayArray, 0, n2);
            long[] lArray = new long[n2];
            System.arraycopy(this.identifierPositionStack, this.identifierPtr - n2 + 1, lArray, 0, n2);
            typeReference = new JavadocQualifiedTypeReference(cArrayArray, lArray, this.tagSourceStart, this.tagSourceEnd);
        }
        return typeReference;
    }

    protected JavadocModuleReference createModuleReference(int n) {
        JavadocModuleReference javadocModuleReference = null;
        char[][] cArrayArray = new char[n][];
        System.arraycopy(this.identifierStack, 0, cArrayArray, 0, n);
        long[] lArray = new long[n];
        System.arraycopy(this.identifierPositionStack, 0, lArray, 0, n);
        javadocModuleReference = new JavadocModuleReference(cArrayArray, lArray, this.tagSourceStart, this.tagSourceEnd);
        return javadocModuleReference;
    }

    @Override
    protected Object createModuleTypeReference(int n, int n2) {
        JavadocModuleReference javadocModuleReference = this.createModuleReference(n2);
        TypeReference typeReference = null;
        int n3 = this.identifierLengthStack[this.identifierLengthPtr];
        int n4 = n3 - n2;
        if (n4 == 1) {
            typeReference = new JavadocSingleTypeReference(this.identifierStack[this.identifierPtr], this.identifierPositionStack[this.identifierPtr], this.tagSourceStart, this.tagSourceEnd);
        } else if (n4 > 1) {
            char[][] cArrayArray = new char[n4][];
            System.arraycopy(this.identifierStack, this.identifierPtr - n4 + 1, cArrayArray, 0, n4);
            long[] lArray = new long[n4];
            System.arraycopy(this.identifierPositionStack, this.identifierPtr - n4 + 1, lArray, 0, n4);
            typeReference = new JavadocQualifiedTypeReference(cArrayArray, lArray, this.tagSourceStart, this.tagSourceEnd);
        } else {
            ++this.lastIdentifierEndPosition;
        }
        javadocModuleReference.setTypeReference(typeReference);
        return javadocModuleReference;
    }

    protected TypeDeclaration getParsedTypeDeclaration() {
        for (int i = this.sourceParser.astPtr; i >= 0; --i) {
            ASTNode aSTNode = this.sourceParser.astStack[i];
            if (!(aSTNode instanceof TypeDeclaration)) continue;
            TypeDeclaration typeDeclaration = (TypeDeclaration)aSTNode;
            if (typeDeclaration.bodyEnd != 0) continue;
            return typeDeclaration;
        }
        return null;
    }

    @Override
    protected boolean parseThrows() {
        boolean bl = super.parseThrows();
        this.tagWaitingForDescription = bl && this.reportProblems ? 4 : 0;
        return bl;
    }

    protected boolean parseReturn() {
        if (this.returnStatement == null) {
            this.returnStatement = this.createReturnStatement();
            return true;
        }
        if (this.reportProblems) {
            this.sourceParser.problemReporter().javadocDuplicatedReturnTag(this.scanner.getCurrentTokenStartPosition(), this.scanner.getCurrentTokenEndPosition());
        }
        return false;
    }

    protected void parseSimpleTag() {
        char c;
        char c2;
        if ((c2 = this.source[this.index++]) == '\\' && this.source[this.index] == 'u') {
            int n;
            int n2;
            int n3;
            int n4 = this.index++;
            while (this.source[this.index] == 'u') {
                ++this.index;
            }
            if ((c = ScannerHelper.getHexadecimalValue(this.source[this.index++])) <= '\u000f' && c >= '\u0000' && (n3 = ScannerHelper.getHexadecimalValue(this.source[this.index++])) <= 15 && n3 >= 0 && (n2 = ScannerHelper.getHexadecimalValue(this.source[this.index++])) <= 15 && n2 >= 0 && (n = ScannerHelper.getHexadecimalValue(this.source[this.index++])) <= 15 && n >= 0) {
                c2 = (char)(((c * 16 + n3) * 16 + n2) * 16 + n);
            } else {
                this.index = n4;
            }
        }
        switch (c2) {
            case 'd': {
                if (this.readChar() != 'e' || this.readChar() != 'p' || this.readChar() != 'r' || this.readChar() != 'e' || this.readChar() != 'c' || this.readChar() != 'a' || this.readChar() != 't' || this.readChar() != 'e' || this.readChar() != 'd' || !ScannerHelper.isWhitespace(c = (char)this.readChar()) && c != '*') break;
                this.abort = true;
                this.deprecated = true;
                this.tagValue = 1;
            }
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    protected boolean parseTag(int var1_1) throws InvalidInputException {
        switch (this.tagWaitingForDescription) {
            case 2: 
            case 4: {
                if (this.inlineTagStarted) break;
                var2_2 = (int)(this.identifierPositionStack[0] >>> 32);
                var3_3 = (int)this.identifierPositionStack[this.identifierPtr];
                this.sourceParser.problemReporter().javadocMissingTagDescriptionAfterReference(var2_2, var3_3, this.sourceParser.modifiers);
                break;
            }
            case 0: {
                break;
            }
            default: {
                if (this.inlineTagStarted) break;
                this.sourceParser.problemReporter().javadocMissingTagDescription(JavadocParser.TAG_NAMES[this.tagWaitingForDescription], this.tagSourceStart, this.tagSourceEnd, this.sourceParser.modifiers);
            }
        }
        this.tagWaitingForDescription = 0;
        this.tagSourceStart = this.index;
        this.tagSourceEnd = var1_1;
        this.scanner.startPosition = this.index;
        var2_2 = this.index;
        var3_3 = this.readChar();
        switch (var3_3) {
            case ' ': 
            case '#': 
            case '*': 
            case '}': {
                if (this.reportProblems) {
                    this.sourceParser.problemReporter().javadocInvalidTag(var1_1, var2_2);
                }
                if (this.textStart == -1) {
                    this.textStart = var2_2;
                }
                this.scanner.currentCharacter = var3_3;
                return false;
            }
        }
        if (ScannerHelper.isWhitespace(var3_3)) {
            if (this.reportProblems) {
                this.sourceParser.problemReporter().javadocInvalidTag(var1_1, var2_2);
            }
            if (this.textStart == -1) {
                this.textStart = var2_2;
            }
            this.scanner.currentCharacter = var3_3;
            return false;
        }
        var4_4 = new char[32];
        var5_5 = 0;
        var6_6 = var3_3;
        var7_7 = var4_4.length;
        var8_8 = true;
        block29: while (true) {
            if (var5_5 == var7_7) {
                v0 = var4_4;
                var4_4 = new char[var7_7 + 32];
                System.arraycopy(v0, 0, var4_4, 0, var7_7);
                var7_7 = var4_4.length;
            }
            var4_4[var5_5++] = var6_6;
            var2_2 = this.index;
            var6_6 = this.readChar();
            switch (var6_6) {
                case ' ': 
                case '*': 
                case '}': {
                    break block29;
                }
                case '#': {
                    var8_8 = false;
                    continue block29;
                }
                default: {
                    if (ScannerHelper.isWhitespace(var6_6)) ** break;
                    continue block29;
                    break block29;
                }
            }
            break;
        }
        this.tagSourceEnd = var2_2 - 1;
        this.scanner.currentCharacter = var6_6;
        this.scanner.currentPosition = var2_2;
        this.index = this.tagSourceEnd + 1;
        if (!var8_8) {
            if (this.reportProblems) {
                this.sourceParser.problemReporter().javadocInvalidTag(this.tagSourceStart, this.tagSourceEnd);
            }
            if (this.textStart == -1) {
                this.textStart = this.index;
            }
            this.scanner.currentCharacter = var6_6;
            return false;
        }
        this.tagValue = 100;
        var9_9 = false;
        switch (var3_3) {
            case 'a': {
                if (var5_5 == JavadocParser.TAG_AUTHOR_LENGTH && CharOperation.equals(JavadocParser.TAG_AUTHOR, var4_4, 0, var5_5)) {
                    this.tagWaitingForDescription = this.tagValue = 12;
                    break;
                }
                if (var5_5 != JavadocParser.TAG_API_NOTE_LENGTH || !CharOperation.equals(JavadocParser.TAG_API_NOTE, var4_4, 0, var5_5)) break;
                this.tagWaitingForDescription = this.tagValue = 27;
                break;
            }
            case 'c': {
                if (var5_5 == JavadocParser.TAG_CATEGORY_LENGTH && CharOperation.equals(JavadocParser.TAG_CATEGORY, var4_4, 0, var5_5)) {
                    this.tagValue = 11;
                    if (this.inlineTagStarted) break;
                    var9_9 = this.parseIdentifierTag(false);
                    break;
                }
                if (var5_5 != JavadocParser.TAG_CODE_LENGTH || !this.inlineTagStarted || !CharOperation.equals(JavadocParser.TAG_CODE, var4_4, 0, var5_5)) break;
                this.tagWaitingForDescription = this.tagValue = 18;
                break;
            }
            case 'd': {
                if (var5_5 == JavadocParser.TAG_DEPRECATED_LENGTH && CharOperation.equals(JavadocParser.TAG_DEPRECATED, var4_4, 0, var5_5)) {
                    this.deprecated = true;
                    var9_9 = true;
                    this.tagWaitingForDescription = this.tagValue = 1;
                    break;
                }
                if (var5_5 != JavadocParser.TAG_DOC_ROOT_LENGTH || !CharOperation.equals(JavadocParser.TAG_DOC_ROOT, var4_4, 0, var5_5)) break;
                var9_9 = true;
                this.tagValue = 20;
                break;
            }
            case 'e': {
                if (var5_5 != JavadocParser.TAG_EXCEPTION_LENGTH || !CharOperation.equals(JavadocParser.TAG_EXCEPTION, var4_4, 0, var5_5)) break;
                this.tagValue = 5;
                if (this.inlineTagStarted) break;
                var9_9 = this.parseThrows();
                break;
            }
            case 'h': {
                if (var5_5 != JavadocParser.TAG_HIDDEN_LENGTH || !CharOperation.equals(JavadocParser.TAG_HIDDEN, var4_4, 0, var5_5)) break;
                var9_9 = true;
                this.tagValue = 24;
                break;
            }
            case 'i': {
                if (var5_5 == JavadocParser.TAG_INDEX_LENGTH && CharOperation.equals(JavadocParser.TAG_INDEX, var4_4, 0, var5_5)) {
                    var9_9 = true;
                    this.tagWaitingForDescription = this.tagValue = 25;
                    break;
                }
                if (var5_5 == JavadocParser.TAG_INHERITDOC_LENGTH && CharOperation.equals(JavadocParser.TAG_INHERITDOC, var4_4, 0, var5_5)) {
                    switch (this.lastBlockTagValue) {
                        case 0: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: {
                            var9_9 = true;
                            if (this.reportProblems) {
                                this.recordInheritedPosition(((long)this.tagSourceStart << 32) + (long)this.tagSourceEnd);
                            }
                            if (!this.inlineTagStarted) break;
                            this.parseInheritDocTag();
                            break;
                        }
                        default: {
                            var9_9 = false;
                            if (!this.reportProblems) break;
                            this.sourceParser.problemReporter().javadocUnexpectedTag(this.tagSourceStart, this.tagSourceEnd);
                        }
                    }
                    this.tagValue = 9;
                    break;
                }
                if (var5_5 == JavadocParser.TAG_IMPL_SPEC_LENGTH && CharOperation.equals(JavadocParser.TAG_IMPL_SPEC, var4_4, 0, var5_5)) {
                    this.tagWaitingForDescription = this.tagValue = 28;
                    break;
                }
                if (var5_5 != JavadocParser.TAG_IMPL_NOTE_LENGTH || !CharOperation.equals(JavadocParser.TAG_IMPL_NOTE, var4_4, 0, var5_5)) break;
                this.tagWaitingForDescription = this.tagValue = 29;
                break;
            }
            case 'l': {
                if (var5_5 == JavadocParser.TAG_LINK_LENGTH && CharOperation.equals(JavadocParser.TAG_LINK, var4_4, 0, var5_5)) {
                    this.tagValue = 7;
                    if (!this.inlineTagStarted && (this.kind & 8) == 0) break;
                    var9_9 = this.parseReference(true);
                    break;
                }
                if (var5_5 == JavadocParser.TAG_LINKPLAIN_LENGTH && CharOperation.equals(JavadocParser.TAG_LINKPLAIN, var4_4, 0, var5_5)) {
                    this.tagValue = 8;
                    if (!this.inlineTagStarted) break;
                    var9_9 = this.parseReference(true);
                    break;
                }
                if (var5_5 != JavadocParser.TAG_LITERAL_LENGTH || !this.inlineTagStarted || !CharOperation.equals(JavadocParser.TAG_LITERAL, var4_4, 0, var5_5)) break;
                this.tagWaitingForDescription = this.tagValue = 19;
                break;
            }
            case 'p': {
                if (var5_5 == JavadocParser.TAG_PARAM_LENGTH && CharOperation.equals(JavadocParser.TAG_PARAM, var4_4, 0, var5_5)) {
                    this.tagValue = 2;
                    if (this.inlineTagStarted) break;
                    var9_9 = this.parseParam();
                    break;
                }
                if (var5_5 != JavadocParser.TAG_PROVIDES_LENGTH || !CharOperation.equals(JavadocParser.TAG_PROVIDES, var4_4, 0, var5_5)) break;
                this.tagValue = 23;
                if (this.inlineTagStarted) break;
                var9_9 = this.parseProvidesReference();
                break;
            }
            case 'r': {
                if (var5_5 != JavadocParser.TAG_RETURN_LENGTH || !CharOperation.equals(JavadocParser.TAG_RETURN, var4_4, 0, var5_5)) break;
                this.tagValue = 3;
                if (this.inlineTagStarted) break;
                var9_9 = this.parseReturn();
                break;
            }
            case 's': {
                if (var5_5 == JavadocParser.TAG_SEE_LENGTH && CharOperation.equals(JavadocParser.TAG_SEE, var4_4, 0, var5_5)) {
                    this.tagValue = 6;
                    if (this.inlineTagStarted) break;
                    var9_9 = this.parseReference(true);
                    break;
                }
                if (var5_5 == JavadocParser.TAG_SERIAL_LENGTH && CharOperation.equals(JavadocParser.TAG_SERIAL, var4_4, 0, var5_5)) {
                    this.tagWaitingForDescription = this.tagValue = 13;
                    break;
                }
                if (var5_5 == JavadocParser.TAG_SERIAL_DATA_LENGTH && CharOperation.equals(JavadocParser.TAG_SERIAL_DATA, var4_4, 0, var5_5)) {
                    this.tagWaitingForDescription = this.tagValue = 14;
                    break;
                }
                if (var5_5 == JavadocParser.TAG_SERIAL_FIELD_LENGTH && CharOperation.equals(JavadocParser.TAG_SERIAL_FIELD, var4_4, 0, var5_5)) {
                    this.tagWaitingForDescription = this.tagValue = 15;
                    break;
                }
                if (var5_5 == JavadocParser.TAG_SINCE_LENGTH && CharOperation.equals(JavadocParser.TAG_SINCE, var4_4, 0, var5_5)) {
                    this.tagWaitingForDescription = this.tagValue = 16;
                    break;
                }
                if (var5_5 == JavadocParser.TAG_SYSTEM_PROPERTY_LENGTH && CharOperation.equals(JavadocParser.TAG_SYSTEM_PROPERTY, var4_4, 0, var5_5)) {
                    this.tagWaitingForDescription = this.tagValue = 21;
                    break;
                }
                if (var5_5 != JavadocParser.TAG_SUMMARY_LENGTH || !CharOperation.equals(JavadocParser.TAG_SUMMARY, var4_4, 0, var5_5)) break;
                this.tagWaitingForDescription = this.tagValue = 26;
                break;
            }
            case 't': {
                if (var5_5 != JavadocParser.TAG_THROWS_LENGTH || !CharOperation.equals(JavadocParser.TAG_THROWS, var4_4, 0, var5_5)) break;
                this.tagValue = 4;
                if (this.inlineTagStarted) break;
                var9_9 = this.parseThrows();
                break;
            }
            case 'u': {
                if (var5_5 != JavadocParser.TAG_USES_LENGTH || !CharOperation.equals(JavadocParser.TAG_USES, var4_4, 0, var5_5)) break;
                this.tagValue = 22;
                if (this.inlineTagStarted) break;
                var9_9 = this.parseUsesReference();
                break;
            }
            case 'v': {
                if (var5_5 == JavadocParser.TAG_VALUE_LENGTH && CharOperation.equals(JavadocParser.TAG_VALUE, var4_4, 0, var5_5)) {
                    this.tagValue = 10;
                    if (this.sourceLevel >= 0x310000L) {
                        if (!this.inlineTagStarted) break;
                        var9_9 = this.parseReference();
                        break;
                    }
                    if (this.validValuePositions == -1L) {
                        if (this.invalidValuePositions != -1L && this.reportProblems) {
                            this.sourceParser.problemReporter().javadocUnexpectedTag((int)(this.invalidValuePositions >>> 32), (int)this.invalidValuePositions);
                        }
                        if (var9_9) {
                            this.validValuePositions = ((long)this.tagSourceStart << 32) + (long)this.tagSourceEnd;
                            this.invalidValuePositions = -1L;
                            break;
                        }
                        this.invalidValuePositions = ((long)this.tagSourceStart << 32) + (long)this.tagSourceEnd;
                        break;
                    }
                    if (!this.reportProblems) break;
                    this.sourceParser.problemReporter().javadocUnexpectedTag(this.tagSourceStart, this.tagSourceEnd);
                    break;
                }
                if (var5_5 == JavadocParser.TAG_VERSION_LENGTH && CharOperation.equals(JavadocParser.TAG_VERSION, var4_4, 0, var5_5)) {
                    this.tagWaitingForDescription = this.tagValue = 17;
                    break;
                }
                this.createTag();
                break;
            }
            default: {
                this.createTag();
            }
        }
        this.textStart = this.index;
        if (this.tagValue != 100) {
            if (!this.inlineTagStarted) {
                this.lastBlockTagValue = this.tagValue;
            }
            if (this.inlineTagStarted && JavadocParser.JAVADOC_TAG_TYPE[this.tagValue] == 2 || !this.inlineTagStarted && JavadocParser.JAVADOC_TAG_TYPE[this.tagValue] == 1) {
                var9_9 = false;
                this.tagValue = 100;
                this.tagWaitingForDescription = 0;
                if (this.reportProblems) {
                    this.sourceParser.problemReporter().javadocUnexpectedTag(this.tagSourceStart, this.tagSourceEnd);
                }
            }
        }
        return var9_9;
    }

    protected void parseInheritDocTag() {
    }

    @Override
    protected boolean parseParam() throws InvalidInputException {
        boolean bl = super.parseParam();
        this.tagWaitingForDescription = bl && this.reportProblems ? 2 : 0;
        return bl;
    }

    @Override
    protected boolean pushParamName(boolean bl) {
        Expression expression;
        Expression expression2 = null;
        expression2 = bl ? (expression = new JavadocSingleTypeReference(this.identifierStack[1], this.identifierPositionStack[1], this.tagSourceStart, this.tagSourceEnd)) : (expression = new JavadocSingleNameReference(this.identifierStack[0], this.identifierPositionStack[0], this.tagSourceStart, this.tagSourceEnd));
        if (this.astLengthPtr == -1) {
            this.pushOnAstStack(expression2, true);
        } else {
            if (!bl) {
                for (int i = 1; i <= this.astLengthPtr; i += 3) {
                    int n;
                    if (this.astLengthStack[i] == 0) continue;
                    if (this.reportProblems) {
                        this.sourceParser.problemReporter().javadocUnexpectedTag(this.tagSourceStart, this.tagSourceEnd);
                    }
                    if ((long)this.invalidParamReferencesPtr == -1L) {
                        this.invalidParamReferencesStack = new JavadocSingleNameReference[10];
                    }
                    if (++this.invalidParamReferencesPtr >= (n = this.invalidParamReferencesStack.length)) {
                        this.invalidParamReferencesStack = new JavadocSingleNameReference[n + 10];
                        System.arraycopy(this.invalidParamReferencesStack, 0, this.invalidParamReferencesStack, 0, n);
                    }
                    this.invalidParamReferencesStack[this.invalidParamReferencesPtr] = expression2;
                    return false;
                }
            }
            switch (this.astLengthPtr % 3) {
                case 0: {
                    this.pushOnAstStack(expression2, false);
                    break;
                }
                case 2: {
                    this.pushOnAstStack(expression2, true);
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    protected boolean pushSeeRef(Object object) {
        if (this.astLengthPtr == -1) {
            this.pushOnAstStack(null, true);
            this.pushOnAstStack(null, true);
            this.pushOnAstStack(object, true);
        } else {
            switch (this.astLengthPtr % 3) {
                case 0: {
                    this.pushOnAstStack(null, true);
                    this.pushOnAstStack(object, true);
                    break;
                }
                case 1: {
                    this.pushOnAstStack(object, true);
                    break;
                }
                case 2: {
                    this.pushOnAstStack(object, false);
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    protected void pushText(int n, int n2) {
        this.tagWaitingForDescription = 0;
    }

    @Override
    protected boolean pushThrowName(Object object) {
        if (this.astLengthPtr == -1) {
            this.pushOnAstStack(null, true);
            this.pushOnAstStack(object, true);
        } else {
            switch (this.astLengthPtr % 3) {
                case 0: {
                    this.pushOnAstStack(object, true);
                    break;
                }
                case 1: {
                    this.pushOnAstStack(object, false);
                    break;
                }
                case 2: {
                    this.pushOnAstStack(null, true);
                    this.pushOnAstStack(object, true);
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    protected void refreshInlineTagPosition(int n) {
        if (this.tagWaitingForDescription != 0) {
            this.sourceParser.problemReporter().javadocMissingTagDescription(TAG_NAMES[this.tagWaitingForDescription], this.tagSourceStart, this.tagSourceEnd, this.sourceParser.modifiers);
            this.tagWaitingForDescription = 0;
        }
    }

    @Override
    protected void refreshReturnStatement() {
        ((JavadocReturnStatement)this.returnStatement).bits &= 0xFFFBFFFF;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("check javadoc: ").append(this.checkDocComment).append("\n");
        stringBuffer.append("javadoc: ").append(this.docComment).append("\n");
        stringBuffer.append(super.toString());
        return stringBuffer.toString();
    }

    @Override
    protected void updateDocComment() {
        int n;
        int n2;
        int n3;
        switch (this.tagWaitingForDescription) {
            case 2: 
            case 4: {
                if (this.inlineTagStarted) break;
                n3 = (int)(this.identifierPositionStack[0] >>> 32);
                n2 = (int)this.identifierPositionStack[this.identifierPtr];
                this.sourceParser.problemReporter().javadocMissingTagDescriptionAfterReference(n3, n2, this.sourceParser.modifiers);
                break;
            }
            case 0: {
                break;
            }
            default: {
                if (this.inlineTagStarted) break;
                this.sourceParser.problemReporter().javadocMissingTagDescription(TAG_NAMES[this.tagWaitingForDescription], this.tagSourceStart, this.tagSourceEnd, this.sourceParser.modifiers);
            }
        }
        this.tagWaitingForDescription = 0;
        if (this.inheritedPositions != null && this.inheritedPositionsPtr != this.inheritedPositions.length) {
            this.inheritedPositions = new long[this.inheritedPositionsPtr];
            System.arraycopy(this.inheritedPositions, 0, this.inheritedPositions, 0, this.inheritedPositionsPtr);
        }
        this.docComment.inheritedPositions = this.inheritedPositions;
        long l = this.docComment.valuePositions = this.validValuePositions != -1L ? this.validValuePositions : this.invalidValuePositions;
        if (this.returnStatement != null) {
            this.docComment.returnStatement = (JavadocReturnStatement)this.returnStatement;
        }
        if (this.invalidParamReferencesPtr >= 0) {
            this.docComment.invalidParameters = new JavadocSingleNameReference[this.invalidParamReferencesPtr + 1];
            System.arraycopy(this.invalidParamReferencesStack, 0, this.docComment.invalidParameters, 0, this.invalidParamReferencesPtr + 1);
        }
        this.docComment.usesReferences = this.usesReferencesPtr >= 0 ? new IJavadocTypeReference[this.usesReferencesPtr + 1] : NO_QUALIFIED_TYPE_REFERENCE;
        for (n3 = 0; n3 <= this.usesReferencesPtr; ++n3) {
            TypeReference typeReference = this.usesReferencesStack[n3];
            this.docComment.usesReferences[n3] = (IJavadocTypeReference)((Object)typeReference);
        }
        this.docComment.providesReferences = this.providesReferencesPtr >= 0 ? new IJavadocTypeReference[this.providesReferencesPtr + 1] : NO_QUALIFIED_TYPE_REFERENCE;
        for (n3 = 0; n3 <= this.providesReferencesPtr; ++n3) {
            TypeReference typeReference = this.providesReferencesStack[n3];
            this.docComment.providesReferences[n3] = (IJavadocTypeReference)((Object)typeReference);
        }
        if (this.astLengthPtr == -1) {
            return;
        }
        int[] nArray = new int[3];
        for (n2 = 0; n2 <= this.astLengthPtr; ++n2) {
            int n4 = n2 % 3;
            nArray[n4] = nArray[n4] + this.astLengthStack[n2];
        }
        this.docComment.seeReferences = nArray[2] > 0 ? new Expression[nArray[2]] : NO_EXPRESSION;
        this.docComment.exceptionReferences = nArray[1] > 0 ? new TypeReference[nArray[1]] : NO_TYPE_REFERENCE;
        n2 = nArray[0];
        this.docComment.paramReferences = n2 > 0 ? new JavadocSingleNameReference[n2] : NO_SINGLE_NAME_REFERENCE;
        int n5 = nArray[0];
        JavadocSingleTypeReference[] javadocSingleTypeReferenceArray = this.docComment.paramTypeParameters = n5 > 0 ? new JavadocSingleTypeReference[n5] : NO_SINGLE_TYPE_REFERENCE;
        block12: while (this.astLengthPtr >= 0) {
            n = this.astLengthPtr % 3;
            switch (n) {
                case 2: {
                    int n6;
                    int n7 = this.astLengthStack[this.astLengthPtr--];
                    for (n6 = 0; n6 < n7; ++n6) {
                        int n8 = n;
                        int n9 = nArray[n8] - 1;
                        nArray[n8] = n9;
                        this.docComment.seeReferences[n9] = (Expression)this.astStack[this.astPtr--];
                    }
                    continue block12;
                }
                case 1: {
                    int n6;
                    int n7 = this.astLengthStack[this.astLengthPtr--];
                    for (n6 = 0; n6 < n7; ++n6) {
                        int n10 = n;
                        int n11 = nArray[n10] - 1;
                        nArray[n10] = n11;
                        this.docComment.exceptionReferences[n11] = (TypeReference)this.astStack[this.astPtr--];
                    }
                    continue block12;
                }
                case 0: {
                    int n6;
                    int n7 = this.astLengthStack[this.astLengthPtr--];
                    for (n6 = 0; n6 < n7; ++n6) {
                        Expression expression;
                        if ((expression = (Expression)this.astStack[this.astPtr--]) instanceof JavadocSingleNameReference) {
                            this.docComment.paramReferences[--n2] = (JavadocSingleNameReference)expression;
                            continue;
                        }
                        if (!(expression instanceof JavadocSingleTypeReference)) continue;
                        this.docComment.paramTypeParameters[--n5] = (JavadocSingleTypeReference)expression;
                    }
                    break;
                }
            }
        }
        if (n2 == 0) {
            this.docComment.paramTypeParameters = null;
        } else if (n5 == 0) {
            this.docComment.paramReferences = null;
        } else {
            n = nArray[0];
            this.docComment.paramReferences = new JavadocSingleNameReference[n - n2];
            System.arraycopy(this.docComment.paramReferences, n2, this.docComment.paramReferences, 0, n - n2);
            this.docComment.paramTypeParameters = new JavadocSingleTypeReference[n - n5];
            System.arraycopy(this.docComment.paramTypeParameters, n5, this.docComment.paramTypeParameters, 0, n - n5);
        }
    }

    protected boolean parseUsesReference() {
        block5: {
            int n = this.scanner.currentPosition;
            try {
                Object object = this.parseQualifiedName(true);
                if (this.abort) {
                    return false;
                }
                if (object == null) {
                    if (this.reportProblems) {
                        this.sourceParser.problemReporter().javadocMissingUsesClassName(this.tagSourceStart, this.tagSourceEnd, this.sourceParser.modifiers);
                    }
                    break block5;
                }
                return this.pushUsesReference(object);
            }
            catch (InvalidInputException invalidInputException) {
                if (!this.reportProblems) break block5;
                this.sourceParser.problemReporter().javadocInvalidUsesClass(n, this.getTokenEndPosition());
            }
        }
        return false;
    }

    protected boolean pushUsesReference(Object object) {
        int n;
        if ((long)this.usesReferencesPtr == -1L) {
            this.usesReferencesStack = new TypeReference[10];
        }
        if (++this.usesReferencesPtr >= (n = this.usesReferencesStack.length)) {
            this.usesReferencesStack = new TypeReference[n + 10];
            System.arraycopy(this.usesReferencesStack, 0, this.usesReferencesStack, 0, n);
        }
        this.usesReferencesStack[this.usesReferencesPtr] = (TypeReference)object;
        return true;
    }

    protected boolean parseProvidesReference() {
        block5: {
            int n = this.scanner.currentPosition;
            try {
                Object object = this.parseQualifiedName(true);
                if (this.abort) {
                    return false;
                }
                if (object == null) {
                    if (this.reportProblems) {
                        this.sourceParser.problemReporter().javadocMissingProvidesClassName(this.tagSourceStart, this.tagSourceEnd, this.sourceParser.modifiers);
                    }
                    break block5;
                }
                return this.pushProvidesReference(object);
            }
            catch (InvalidInputException invalidInputException) {
                if (!this.reportProblems) break block5;
                this.sourceParser.problemReporter().javadocInvalidProvidesClass(n, this.getTokenEndPosition());
            }
        }
        return false;
    }

    protected boolean pushProvidesReference(Object object) {
        int n;
        if ((long)this.providesReferencesPtr == -1L) {
            this.providesReferencesStack = new TypeReference[10];
        }
        if (++this.providesReferencesPtr >= (n = this.providesReferencesStack.length)) {
            this.providesReferencesStack = new TypeReference[n + 10];
            System.arraycopy(this.providesReferencesStack, 0, this.providesReferencesStack, 0, n);
        }
        this.providesReferencesStack[this.providesReferencesPtr] = (TypeReference)object;
        return true;
    }
}

