/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.tool;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.jdt.internal.compiler.tool.ArchiveFileObject;

public class Archive {
    public static final Archive UNKNOWN_ARCHIVE = new Archive();
    ZipFile zipFile;
    File file;
    protected Hashtable<String, ArrayList<String[]>> packagesCache;

    protected Archive() {
    }

    public Archive(File file) throws ZipException, IOException {
        this.file = file;
        this.zipFile = new ZipFile(file);
        this.initialize();
    }

    private void initialize() {
        this.packagesCache = new Hashtable();
        Enumeration<? extends ZipEntry> enumeration = this.zipFile.entries();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement().getName();
            int n = string.lastIndexOf(47);
            String string2 = string.substring(0, n + 1);
            String string3 = string.substring(n + 1);
            if (string3.length() == 0) continue;
            this.cacheTypes(string2, string3);
        }
    }

    protected void cacheTypes(String string, String string2) {
        ArrayList<Object> arrayList = this.packagesCache.get(string);
        if (string2 == null) {
            return;
        }
        if (arrayList == null) {
            arrayList = new ArrayList();
            arrayList.add(new String[]{string2, null});
            this.packagesCache.put(string, arrayList);
        } else {
            arrayList.add(new String[]{string2, null});
        }
    }

    public ArchiveFileObject getArchiveFileObject(String string, String string2, Charset charset) {
        return new ArchiveFileObject(this.file, string, charset);
    }

    public boolean contains(String string) {
        return this.zipFile.getEntry(string) != null;
    }

    public Set<String> allPackages() {
        if (this.packagesCache == null) {
            this.initialize();
        }
        return this.packagesCache.keySet();
    }

    public List<String[]> getTypes(String string) {
        if (this.packagesCache == null) {
            try {
                this.zipFile = new ZipFile(this.file);
            }
            catch (IOException iOException) {
                return Collections.emptyList();
            }
            this.initialize();
        }
        return this.packagesCache.get(string);
    }

    public void flush() {
        this.packagesCache = null;
    }

    public void close() {
        try {
            if (this.zipFile != null) {
                this.zipFile.close();
            }
            this.packagesCache = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String toString() {
        return "Archive: " + (this.file == null ? "UNKNOWN_ARCHIVE" : this.file.getAbsolutePath());
    }
}

