/*
 * Decompiled with CFR 0.152.
 */
package netrexx.lang;

import java.io.PrintStream;
import java.util.Vector;
import netrexx.lang.Rexx;

public final class RexxTrace {
    private static final Rexx $01 = Rexx.toRexx("*=*");
    private static final Rexx $02 = new Rexx(' ');
    private static final Rexx $03 = Rexx.toRexx("*-*");
    private static final Rexx $04 = new Rexx('>');
    private static final Rexx $05 = new Rexx('\"');
    private static final Rexx $06 = Rexx.toRexx("---");
    private static final String $0 = "RexxTrace.nrx";
    public static final int OFF = 0;
    public static final int VAR = 1;
    public static final int METHODS = 2;
    public static final int ALL = 3;
    public static final int RESULTS = 4;
    public static final int TERMS = 5;
    public static final int OPS = 6;
    public static final int INT = 5;
    private static final Rexx levelwords = Rexx.toRexx("off var methods all results int");
    private static final String nulltrace = "[null]";
    private int level = 0;
    private boolean context = true;
    private int width;
    private int lastline = 0;
    private String programname;
    private PrintStream tracestream;
    private String[] varnames = new String[0];
    private static Thread lastthread = null;
    private static String lastprogramname = "";
    private static Object threadlock = new Object();

    public RexxTrace(int n) {
        this(n, System.err, "?");
    }

    public RexxTrace(int n, PrintStream printStream) {
        this(n, printStream, "?");
    }

    public RexxTrace(int n, PrintStream printStream, String string) {
        this.width = String.valueOf(n).length();
        this.tracestream = printStream;
        this.programname = string;
    }

    public RexxTrace(RexxTrace rexxTrace) {
        this.level = rexxTrace.level;
        this.width = rexxTrace.width;
        this.lastline = rexxTrace.lastline;
        this.tracestream = rexxTrace.tracestream;
        this.programname = rexxTrace.programname;
        this.varnames = rexxTrace.varnames;
        this.context = rexxTrace.context;
    }

    public static void reset() {
        lastthread = null;
        lastprogramname = "";
    }

    public Rexx levelword() {
        return levelwords.word(new Rexx(this.level + 1));
    }

    public void newlevel(int n) {
        this.level = n;
        if (this.level == 0) {
            this.lastline = 0;
        }
    }

    public boolean getContext() {
        return this.context;
    }

    public void setContext(boolean bl) {
        this.context = bl;
    }

    public void modnames(String[] stringArray, String[] stringArray2) {
        int n = 0;
        int n2 = 0;
        String string = null;
        int n3 = 0;
        if (this.level == 0) {
            this.level = 1;
        }
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        if (stringArray2 == null) {
            stringArray2 = new String[]{};
        }
        Vector<String> vector = new Vector<String>(this.varnames.length + stringArray.length);
        int n4 = stringArray.length;
        n = 0;
        while (n4 > 0) {
            vector.addElement(stringArray[n]);
            --n4;
            ++n;
        }
        n4 = this.varnames.length;
        n2 = 0;
        while (n4 > 0) {
            block9: {
                string = this.varnames[n2];
                int n5 = stringArray.length;
                n = 0;
                while (n5 > 0) {
                    if (!stringArray[n].equals(string)) {
                        --n5;
                        ++n;
                        continue;
                    }
                    break block9;
                }
                n5 = stringArray2.length;
                n3 = 0;
                while (n5 > 0) {
                    if (!stringArray2[n3].equals(string)) {
                        --n5;
                        ++n3;
                        continue;
                    }
                    break block9;
                }
                vector.addElement(string);
            }
            --n4;
            ++n2;
        }
        this.varnames = new String[vector.size()];
        vector.copyInto(this.varnames);
    }

    public void traceclause(int n, String string) {
        this.traceclause(n, string, 3, (String[])null);
    }

    public void traceclause(int n, String string, int n2) {
        this.traceclause(n, string, n2, (String[])null);
    }

    public void traceclause(int n, String string, int n2, String[] stringArray) {
        String[] stringArray2 = new String[]{string};
        this.traceclause(n, stringArray2, n2, stringArray);
    }

    public void traceclause(int n, String[] stringArray) {
        this.traceclause(n, stringArray, 3, (String[])null);
    }

    public void traceclause(int n, String[] stringArray, int n2) {
        this.traceclause(n, stringArray, n2, (String[])null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void traceclause(int n, String[] stringArray, int n2, String[] stringArray2) {
        int n3;
        int n4;
        Rexx rexx;
        block13: {
            int n5 = 0;
            String string = null;
            int n6 = 0;
            rexx = null;
            n4 = 0;
            if (this.level < n2) {
                return;
            }
            if (n2 == 1 && this.level < 3) {
                if (stringArray2 != null) {
                    int n7 = stringArray2.length;
                    n5 = 0;
                    while (n7 > 0) {
                        string = stringArray2[n5];
                        n3 = this.varnames.length;
                        n6 = 0;
                        while (n3 > 0) {
                            if (!this.varnames[n6].equals(string)) {
                                --n3;
                                ++n6;
                                continue;
                            }
                            break block13;
                        }
                        --n7;
                        ++n5;
                    }
                }
                return;
            }
        }
        Object object = threadlock;
        synchronized (object) {
            if (this.context) {
                this.showContext();
            }
            if (this.lastline == n) {
                rexx = new Rexx(' ').copies(new Rexx(this.width));
            } else {
                rexx = new Rexx(n).right(new Rexx(this.width));
                this.lastline = n + stringArray.length - 1;
            }
            rexx = rexx.OpCcblank(null, $01);
            n3 = stringArray.length - 1;
            for (n4 = 0; n4 <= n3; ++n4) {
                this.tracestream.println($02.OpCc(null, rexx).OpCcblank(null, Rexx.toRexx(stringArray[n4])));
                rexx = new Rexx(n + n4 + 1).right(new Rexx(this.width)).OpCcblank(null, $03);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void traceresult(int n, Rexx rexx, char c, String string) {
        int n2;
        char[] cArray;
        Rexx rexx2;
        block15: {
            String string2 = null;
            int n3 = 0;
            rexx2 = null;
            cArray = null;
            n2 = 0;
            if (this.level < 4 && (this.level < 2 || c != 'm')) {
                if (this.level < 1) {
                    return;
                }
                string2 = string.toLowerCase();
                int n4 = this.varnames.length;
                n3 = 0;
                while (n4 > 0) {
                    if (!this.varnames[n3].equals(string2)) {
                        --n4;
                        ++n3;
                        continue;
                    }
                    break block15;
                }
                return;
            }
        }
        if (c == 'm') {
            c = (char)97;
        }
        Object object = threadlock;
        synchronized (object) {
            if (this.context) {
                this.showContext();
            }
            if (this.lastline == n) {
                rexx2 = new Rexx(' ').copies(new Rexx(this.width));
            } else {
                rexx2 = new Rexx(n).right(new Rexx(this.width));
                this.lastline = n;
            }
            rexx2 = rexx2.OpCcblank(null, $04).OpCc(null, new Rexx(c)).OpCc(null, $04);
            if (!string.equals("")) {
                rexx2 = rexx2.OpCcblank(null, Rexx.toRexx(string));
            }
            if (rexx == null) {
                this.tracestream.println($02.OpCc(null, rexx2).OpCcblank(null, Rexx.toRexx(nulltrace)));
            } else {
                cArray = Rexx.tochararray(rexx);
                int n5 = cArray.length - 1;
                for (n2 = 0; n2 <= n5; ++n2) {
                    if (cArray[n2] >= ' ') continue;
                    cArray[n2] = cArray[n2] == '\t' ? 32 : 63;
                }
                this.tracestream.println($02.OpCc(null, rexx2).OpCcblank(null, $05).OpCc(null, Rexx.toRexx(cArray)).OpCc(null, $05));
            }
        }
    }

    public void showContext() {
        Thread thread = Thread.currentThread();
        if (lastthread == thread && lastprogramname.equals(this.programname)) {
            return;
        }
        Rexx rexx = new Rexx(' ').copies(new Rexx(this.width)).OpCcblank(null, $06);
        String string = thread.getName();
        String string2 = thread.getThreadGroup().getName();
        if (!string2.equals("main")) {
            string = string + "," + string2;
        }
        string = string.equals("main") ? "" : " [" + string + "]";
        this.tracestream.println($02.OpCc(null, rexx).OpCcblank(null, Rexx.toRexx(this.programname)).OpCc(null, Rexx.toRexx(string)));
        lastthread = thread;
        lastprogramname = this.programname;
        this.lastline = 0;
    }

    public char tracechar(int n, char c, char c2, int n2, String string) {
        if (this.level < n2) {
            return c;
        }
        this.traceresult(n, new Rexx(c), c2, string);
        return c;
    }

    public boolean traceboolean(int n, boolean bl, char c, int n2, String string) {
        if (this.level < n2) {
            return bl;
        }
        this.traceresult(n, new Rexx(bl), c, string);
        return bl;
    }

    public byte tracebyte(int n, byte by, char c, int n2, String string) {
        if (this.level < n2) {
            return by;
        }
        this.traceresult(n, new Rexx(by), c, string);
        return by;
    }

    public short traceshort(int n, short s, char c, int n2, String string) {
        if (this.level < n2) {
            return s;
        }
        this.traceresult(n, new Rexx(s), c, string);
        return s;
    }

    public int traceint(int n, int n2, char c, int n3, String string) {
        if (this.level < n3) {
            return n2;
        }
        this.traceresult(n, new Rexx(n2), c, string);
        return n2;
    }

    public long tracelong(int n, long l, char c, int n2, String string) {
        if (this.level < n2) {
            return l;
        }
        this.traceresult(n, new Rexx(l), c, string);
        return l;
    }

    public float tracefloat(int n, float f, char c, int n2, String string) {
        if (this.level < n2) {
            return f;
        }
        this.traceresult(n, new Rexx(f), c, string);
        return f;
    }

    public double tracedouble(int n, double d, char c, int n2, String string) {
        if (this.level < n2) {
            return d;
        }
        this.traceresult(n, new Rexx(d), c, string);
        return d;
    }

    public Rexx traceRexx(int n, Rexx rexx, char c, int n2, String string) {
        if (this.level < n2) {
            return rexx;
        }
        this.traceresult(n, rexx, c, string);
        return rexx;
    }

    public String traceString(int n, String string, char c, int n2, String string2) {
        Rexx rexx = null;
        if (this.level < n2) {
            return string;
        }
        rexx = string == null ? (Rexx)null : new Rexx(string);
        this.traceresult(n, rexx, c, string2);
        return string;
    }

    public char[] tracechararray(int n, char[] cArray, char c, int n2, String string) {
        Rexx rexx = null;
        if (this.level < n2) {
            return cArray;
        }
        rexx = cArray == null ? (Rexx)null : new Rexx(cArray);
        this.traceresult(n, rexx, c, string);
        return cArray;
    }

    public Object traceObject(int n, Object object, char c, int n2, String string) {
        Rexx rexx = null;
        if (this.level < n2) {
            return object;
        }
        rexx = object == null ? (Rexx)null : new Rexx(object.toString());
        this.traceresult(n, rexx, c, string);
        return object;
    }
}

