/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.apt.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import org.eclipse.jdt.internal.compiler.apt.dispatch.BaseProcessingEnvImpl;
import org.eclipse.jdt.internal.compiler.apt.model.ElementImpl;
import org.eclipse.jdt.internal.compiler.apt.model.Factory;
import org.eclipse.jdt.internal.compiler.apt.model.NameImpl;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.ModuleBinding;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.PlainPackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class ModuleElementImpl
extends ElementImpl
implements ModuleElement {
    ModuleBinding binding;
    private List<ModuleElement.Directive> directives;
    private static List<ModuleElement.Directive> EMPTY_DIRECTIVES = Collections.emptyList();

    ModuleElementImpl(BaseProcessingEnvImpl baseProcessingEnvImpl, ModuleBinding moduleBinding) {
        super(baseProcessingEnvImpl, moduleBinding);
        this.binding = moduleBinding;
    }

    @Override
    public ElementKind getKind() {
        return ElementKind.MODULE;
    }

    @Override
    public Set<Modifier> getModifiers() {
        int n = this.binding.modifiers;
        return Factory.getModifiers(n, this.getKind(), false);
    }

    @Override
    public Name getQualifiedName() {
        return new NameImpl(this.binding.moduleName);
    }

    @Override
    public Name getSimpleName() {
        char[] cArray = this.binding.moduleName;
        for (int i = cArray.length - 1; i >= 0; --i) {
            if (cArray[i] != '.') continue;
            cArray = Arrays.copyOfRange(cArray, i + 1, cArray.length);
            break;
        }
        return new NameImpl(cArray);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<? extends Element> getEnclosedElements() {
        Object object;
        ModuleBinding moduleBinding = this.binding;
        HashSet<Object> hashSet = new HashSet<Object>();
        for (PlainPackageBinding plainPackageBinding : moduleBinding.declaredPackages.values()) {
            if (!plainPackageBinding.hasCompilationUnit(true)) continue;
            hashSet.add(plainPackageBinding);
        }
        if (moduleBinding.isUnnamed()) {
            object = moduleBinding.environment.defaultPackage;
            if (object != null && ((PackageBinding)object).hasCompilationUnit(true)) {
                hashSet.add(object);
            }
        } else {
            void var5_10;
            void plainPackageBinding;
            object = this.binding.getExports();
            int n = ((PlainPackageBinding[])object).length;
            boolean bl = false;
            while (plainPackageBinding < n) {
                PlainPackageBinding plainPackageBinding2 = object[plainPackageBinding];
                hashSet.add(plainPackageBinding2);
                ++plainPackageBinding;
            }
            object = this.binding.getOpens();
            n = ((PlainPackageBinding[])object).length;
            boolean bl2 = false;
            while (var5_10 < n) {
                PlainPackageBinding plainPackageBinding3 = object[var5_10];
                hashSet.add(plainPackageBinding3);
                ++var5_10;
            }
        }
        object = new ArrayList(hashSet.size());
        for (PlainPackageBinding plainPackageBinding : hashSet) {
            PackageElement packageElement = (PackageElement)this._env.getFactory().newElement(plainPackageBinding);
            object.add(packageElement);
        }
        return Collections.unmodifiableList(object);
    }

    @Override
    public boolean isOpen() {
        return (this.binding.modifiers & 0x20) != 0;
    }

    @Override
    public boolean isUnnamed() {
        return this.binding.moduleName.length == 0;
    }

    @Override
    public Element getEnclosingElement() {
        return null;
    }

    @Override
    public List<? extends ModuleElement.Directive> getDirectives() {
        if (this.isUnnamed()) {
            return EMPTY_DIRECTIVES;
        }
        if (this.directives == null) {
            this.directives = new ArrayList<ModuleElement.Directive>();
        }
        PlainPackageBinding[] plainPackageBindingArray = this.binding.getExports();
        for (PlainPackageBinding plainPackageBinding : plainPackageBindingArray) {
            this.directives.add(new ExportsDirectiveImpl(plainPackageBinding));
        }
        HashSet hashSet = new HashSet();
        for (ModuleBinding moduleBinding : this.binding.getRequiresTransitive()) {
            hashSet.add(moduleBinding);
        }
        ModuleBinding[] moduleBindingArray = this.binding.getRequires();
        Binding[] bindingArray = moduleBindingArray;
        int n = bindingArray.length;
        for (int i = 0; i < n; ++i) {
            ModuleBinding moduleBinding = bindingArray[i];
            if (hashSet.contains(moduleBinding)) {
                this.directives.add(new RequiresDirectiveImpl(moduleBinding, true));
                continue;
            }
            this.directives.add(new RequiresDirectiveImpl(moduleBinding, false));
        }
        for (Binding binding : bindingArray = this.binding.getUses()) {
            this.directives.add(new UsesDirectiveImpl((TypeBinding)binding));
        }
        for (Binding binding : bindingArray = this.binding.getServices()) {
            this.directives.add(new ProvidesDirectiveImpl((TypeBinding)binding));
        }
        plainPackageBindingArray = this.binding.getOpens();
        for (Binding binding : plainPackageBindingArray) {
            this.directives.add(new OpensDirectiveImpl((PackageBinding)binding));
        }
        return this.directives;
    }

    @Override
    public <R, P> R accept(ElementVisitor<R, P> elementVisitor, P p) {
        return elementVisitor.visitModule(this, p);
    }

    @Override
    protected AnnotationBinding[] getAnnotationBindings() {
        return ((ModuleBinding)this._binding).getAnnotations();
    }

    class ExportsDirectiveImpl
    extends PackageDirectiveImpl
    implements ModuleElement.ExportsDirective {
        ExportsDirectiveImpl(PackageBinding packageBinding) {
            super(packageBinding);
        }

        @Override
        public <R, P> R accept(ModuleElement.DirectiveVisitor<R, P> directiveVisitor, P p) {
            return directiveVisitor.visitExports(this, p);
        }

        @Override
        public ModuleElement.DirectiveKind getKind() {
            return ModuleElement.DirectiveKind.EXPORTS;
        }

        @Override
        public PackageElement getPackage() {
            return ModuleElementImpl.this._env.getFactory().newPackageElement(this.binding);
        }

        @Override
        public List<? extends ModuleElement> getTargetModules() {
            if (this.targets != null) {
                return this.targets;
            }
            return this.getTargetModules(ModuleElementImpl.this.binding.getExportRestrictions(this.binding));
        }
    }

    class RequiresDirectiveImpl
    implements ModuleElement.RequiresDirective {
        ModuleBinding dependency;
        boolean transitive;

        RequiresDirectiveImpl(ModuleBinding moduleBinding, boolean bl) {
            this.dependency = moduleBinding;
            this.transitive = bl;
        }

        @Override
        public <R, P> R accept(ModuleElement.DirectiveVisitor<R, P> directiveVisitor, P p) {
            return directiveVisitor.visitRequires(this, p);
        }

        @Override
        public ModuleElement.DirectiveKind getKind() {
            return ModuleElement.DirectiveKind.REQUIRES;
        }

        @Override
        public ModuleElement getDependency() {
            return (ModuleElement)ModuleElementImpl.this._env.getFactory().newElement(this.dependency, ElementKind.MODULE);
        }

        @Override
        public boolean isStatic() {
            return false;
        }

        @Override
        public boolean isTransitive() {
            return this.transitive;
        }
    }

    class UsesDirectiveImpl
    implements ModuleElement.UsesDirective {
        TypeBinding binding = null;

        UsesDirectiveImpl(TypeBinding typeBinding) {
            this.binding = typeBinding;
        }

        @Override
        public <R, P> R accept(ModuleElement.DirectiveVisitor<R, P> directiveVisitor, P p) {
            return directiveVisitor.visitUses(this, p);
        }

        @Override
        public ModuleElement.DirectiveKind getKind() {
            return ModuleElement.DirectiveKind.USES;
        }

        @Override
        public TypeElement getService() {
            return (TypeElement)ModuleElementImpl.this._env.getFactory().newElement(this.binding);
        }
    }

    class ProvidesDirectiveImpl
    implements ModuleElement.ProvidesDirective {
        TypeBinding service;
        public List<? extends TypeElement> implementations;

        ProvidesDirectiveImpl(TypeBinding typeBinding) {
            this.service = typeBinding;
        }

        @Override
        public <R, P> R accept(ModuleElement.DirectiveVisitor<R, P> directiveVisitor, P p) {
            return directiveVisitor.visitProvides(this, p);
        }

        @Override
        public ModuleElement.DirectiveKind getKind() {
            return ModuleElement.DirectiveKind.PROVIDES;
        }

        @Override
        public List<? extends TypeElement> getImplementations() {
            if (this.implementations != null) {
                return this.implementations;
            }
            TypeBinding[] typeBindingArray = ModuleElementImpl.this.binding.getImplementations(this.service);
            if (typeBindingArray.length == 0) {
                this.implementations = Collections.emptyList();
                return this.implementations;
            }
            ArrayList<TypeElement> arrayList = new ArrayList<TypeElement>(typeBindingArray.length);
            Factory factory = ModuleElementImpl.this._env.getFactory();
            for (TypeBinding typeBinding : typeBindingArray) {
                TypeElement typeElement = (TypeElement)factory.newElement(typeBinding);
                arrayList.add(typeElement);
            }
            return Collections.unmodifiableList(arrayList);
        }

        @Override
        public TypeElement getService() {
            return (TypeElement)ModuleElementImpl.this._env.getFactory().newElement(this.service);
        }
    }

    class OpensDirectiveImpl
    extends PackageDirectiveImpl
    implements ModuleElement.OpensDirective {
        OpensDirectiveImpl(PackageBinding packageBinding) {
            super(packageBinding);
        }

        @Override
        public <R, P> R accept(ModuleElement.DirectiveVisitor<R, P> directiveVisitor, P p) {
            return directiveVisitor.visitOpens(this, p);
        }

        @Override
        public ModuleElement.DirectiveKind getKind() {
            return ModuleElement.DirectiveKind.OPENS;
        }

        @Override
        public List<? extends ModuleElement> getTargetModules() {
            if (this.targets != null) {
                return this.targets;
            }
            return this.getTargetModules(ModuleElementImpl.this.binding.getOpenRestrictions(this.binding));
        }
    }

    abstract class PackageDirectiveImpl {
        PackageBinding binding;
        List<ModuleElement> targets;

        PackageDirectiveImpl(PackageBinding packageBinding) {
            this.binding = packageBinding;
        }

        public PackageElement getPackage() {
            return ModuleElementImpl.this._env.getFactory().newPackageElement(this.binding);
        }

        public List<? extends ModuleElement> getTargetModules(String[] stringArray) {
            if (this.targets != null) {
                return this.targets;
            }
            if (stringArray.length == 0) {
                this.targets = null;
                return null;
            }
            ArrayList<ModuleElement> arrayList = new ArrayList<ModuleElement>(stringArray.length);
            for (String string : stringArray) {
                ModuleBinding moduleBinding = ModuleElementImpl.this.binding.environment.getModule(string.toCharArray());
                if (moduleBinding == null) continue;
                ModuleElement moduleElement = (ModuleElement)ModuleElementImpl.this._env.getFactory().newElement(moduleBinding);
                arrayList.add(moduleElement);
            }
            this.targets = Collections.unmodifiableList(arrayList);
            return this.targets;
        }
    }
}

