/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.Assignment;
import org.eclipse.jdt.internal.compiler.ast.BranchStatement;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.SubRoutineStatement;
import org.eclipse.jdt.internal.compiler.ast.SwitchExpression;
import org.eclipse.jdt.internal.compiler.ast.TryStatement;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.InsideSubRoutineFlowContext;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class YieldStatement
extends BranchStatement {
    public Expression expression;
    public SwitchExpression switchExpression;
    public TryStatement tryStatement;
    public boolean isImplicit;
    static final char[] SECRET_YIELD_RESULT_VALUE_NAME = " secretYieldValue".toCharArray();
    private LocalVariableBinding secretYieldResultValue = null;
    public BlockScope scope;

    public YieldStatement(Expression expression, int n, int n2) {
        super(null, n, n2);
        this.expression = expression;
    }

    @Override
    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        FlowContext flowContext2 = this.isImplicit ? flowContext.getTargetContextForDefaultBreak() : flowContext.getTargetContextForDefaultYield();
        flowInfo = this.expression.analyseCode(blockScope, flowContext, flowInfo);
        this.expression.checkNPEbyUnboxing(blockScope, flowContext, flowInfo);
        if (flowInfo.reachMode() == 0 && blockScope.compilerOptions().isAnnotationBasedNullAnalysisEnabled) {
            this.checkAgainstNullAnnotation(blockScope, flowContext, flowInfo, this.expression);
        }
        flowContext2.recordAbruptExit();
        flowContext2.expireNullCheckedFieldInfo();
        this.initStateIndex = blockScope.methodScope().recordInitializationStates(flowInfo);
        this.targetLabel = flowContext2.breakLabel();
        FlowContext flowContext3 = flowContext;
        int n = 0;
        this.subroutines = new SubRoutineStatement[5];
        do {
            SubRoutineStatement subRoutineStatement;
            if ((subRoutineStatement = flowContext3.subroutine()) != null) {
                if (n == this.subroutines.length) {
                    this.subroutines = new SubRoutineStatement[n * 2];
                    System.arraycopy(this.subroutines, 0, this.subroutines, 0, n);
                }
                this.subroutines[n++] = subRoutineStatement;
                if (subRoutineStatement.isSubRoutineEscaping()) break;
            }
            flowContext3.recordReturnFrom(flowInfo.unconditionalInits());
            flowContext3.recordBreakTo(flowContext2);
            if (flowContext3 instanceof InsideSubRoutineFlowContext) {
                ASTNode aSTNode = flowContext3.associatedNode;
                if (!(aSTNode instanceof TryStatement)) continue;
                flowInfo.addInitializationsFrom(((TryStatement)aSTNode).subRoutineInits);
                continue;
            }
            if (flowContext3 != flowContext2) continue;
            flowContext2.recordBreakFrom(flowInfo);
            break;
        } while ((flowContext3 = flowContext3.getLocalParent()) != null);
        if (n != this.subroutines.length) {
            this.subroutines = new SubRoutineStatement[n];
            System.arraycopy(this.subroutines, 0, this.subroutines, 0, n);
        }
        return FlowInfo.DEAD_END;
    }

    @Override
    protected void setSubroutineSwitchExpression(SubRoutineStatement subRoutineStatement) {
        subRoutineStatement.setSwitchExpression(this.switchExpression);
    }

    protected void addSecretYieldResultValue(BlockScope blockScope) {
        SwitchExpression switchExpression = this.switchExpression;
        if (switchExpression == null || !switchExpression.containsTry) {
            return;
        }
        LocalVariableBinding localVariableBinding = new LocalVariableBinding(SECRET_YIELD_RESULT_VALUE_NAME, switchExpression.resolvedType, 0, false);
        localVariableBinding.setConstant(Constant.NotAConstant);
        localVariableBinding.useFlag = 1;
        localVariableBinding.declaration = new LocalDeclaration(SECRET_YIELD_RESULT_VALUE_NAME, 0, 0);
        assert (switchExpression.yieldResolvedPosition >= 0);
        localVariableBinding.resolvedPosition = switchExpression.yieldResolvedPosition;
        assert (localVariableBinding.resolvedPosition < this.scope.maxOffset);
        this.scope.addLocalVariable(localVariableBinding);
        this.secretYieldResultValue = localVariableBinding;
    }

    @Override
    protected void restartExceptionLabels(CodeStream codeStream) {
        SubRoutineStatement.reenterAllExceptionHandlers(this.subroutines, -1, codeStream);
    }

    protected void generateExpressionResultCodeExpanded(BlockScope blockScope, CodeStream codeStream) {
        SwitchExpression switchExpression = this.switchExpression;
        this.addSecretYieldResultValue(this.scope);
        assert (this.secretYieldResultValue != null);
        codeStream.record(this.secretYieldResultValue);
        SingleNameReference singleNameReference = new SingleNameReference(this.secretYieldResultValue.name, 0L);
        singleNameReference.binding = this.secretYieldResultValue;
        singleNameReference.bits &= 0xFFFFFFF8;
        singleNameReference.bits |= 2;
        singleNameReference.bits |= 0x10;
        ((LocalVariableBinding)singleNameReference.binding).markReferenced();
        Assignment assignment = new Assignment(singleNameReference, this.expression, 0);
        assignment.generateCode(this.scope, codeStream);
        int n = codeStream.position;
        if (this.subroutines != null) {
            int n2 = this.subroutines.length;
            for (int i = 0; i < n2; ++i) {
                SubRoutineStatement subRoutineStatement = this.subroutines[i];
                subRoutineStatement.exitAnyExceptionHandler();
                subRoutineStatement.exitDeclaredExceptionHandlers(codeStream);
                SwitchExpression switchExpression2 = subRoutineStatement.getSwitchExpression();
                this.setSubroutineSwitchExpression(subRoutineStatement);
                boolean bl = subRoutineStatement.generateSubRoutineInvocation(blockScope, codeStream, this.targetLabel, this.initStateIndex, null);
                subRoutineStatement.setSwitchExpression(switchExpression2);
                if (!bl) continue;
                codeStream.removeVariable(this.secretYieldResultValue);
                codeStream.recordPositionsFrom(n, this.sourceStart);
                SubRoutineStatement.reenterAllExceptionHandlers(this.subroutines, i, codeStream);
                if (this.initStateIndex != -1) {
                    codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.initStateIndex);
                    codeStream.addDefinitelyAssignedVariables(blockScope, this.initStateIndex);
                }
                this.restartExceptionLabels(codeStream);
                return;
            }
        }
        switchExpression.loadStoredTypesAndKeep(codeStream);
        codeStream.load(this.secretYieldResultValue);
        codeStream.removeVariable(this.secretYieldResultValue);
        codeStream.goto_(this.targetLabel);
        codeStream.recordPositionsFrom(n, this.sourceStart);
        SubRoutineStatement.reenterAllExceptionHandlers(this.subroutines, -1, codeStream);
        if (this.initStateIndex != -1) {
            codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.initStateIndex);
            codeStream.addDefinitelyAssignedVariables(blockScope, this.initStateIndex);
        }
    }

    @Override
    public void generateCode(BlockScope blockScope, CodeStream codeStream) {
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        if (this.switchExpression != null && this.switchExpression.containsTry && this.switchExpression.resolvedType != null) {
            this.generateExpressionResultCodeExpanded(blockScope, codeStream);
            return;
        }
        this.expression.generateCode(this.scope, codeStream, this.switchExpression != null);
        int n = codeStream.position;
        if (this.subroutines != null) {
            int n2 = this.subroutines.length;
            for (int i = 0; i < n2; ++i) {
                SubRoutineStatement subRoutineStatement = this.subroutines[i];
                SwitchExpression switchExpression = subRoutineStatement.getSwitchExpression();
                this.setSubroutineSwitchExpression(subRoutineStatement);
                boolean bl = subRoutineStatement.generateSubRoutineInvocation(blockScope, codeStream, this.targetLabel, this.initStateIndex, null);
                subRoutineStatement.setSwitchExpression(switchExpression);
                if (!bl) continue;
                codeStream.recordPositionsFrom(n, this.sourceStart);
                SubRoutineStatement.reenterAllExceptionHandlers(this.subroutines, i, codeStream);
                if (this.initStateIndex != -1) {
                    codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.initStateIndex);
                    codeStream.addDefinitelyAssignedVariables(blockScope, this.initStateIndex);
                }
                this.restartExceptionLabels(codeStream);
                return;
            }
        }
        codeStream.goto_(this.targetLabel);
        codeStream.recordPositionsFrom(n, this.sourceStart);
        SubRoutineStatement.reenterAllExceptionHandlers(this.subroutines, -1, codeStream);
        if (this.initStateIndex != -1) {
            codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.initStateIndex);
            codeStream.addDefinitelyAssignedVariables(blockScope, this.initStateIndex);
        }
    }

    private boolean isInsideTry() {
        return this.switchExpression != null && this.switchExpression.containsTry;
    }

    @Override
    public void resolve(BlockScope blockScope) {
        this.scope = this.isInsideTry() ? new BlockScope(blockScope) : blockScope;
        super.resolve(this.scope);
        if (this.expression == null) {
            return;
        }
        if (this.switchExpression != null || this.isImplicit) {
            if (this.switchExpression == null && this.isImplicit && !this.expression.statementExpression() && this.scope.compilerOptions().sourceLevel >= 0x3A0000L) {
                this.scope.problemReporter().invalidExpressionAsStatement(this.expression);
                return;
            }
        } else if (this.scope.compilerOptions().sourceLevel >= 0x3A0000L) {
            this.scope.problemReporter().switchExpressionsYieldOutsideSwitchExpression(this);
        }
        this.expression.resolveType(this.scope);
    }

    @Override
    public TypeBinding resolveExpressionType(BlockScope blockScope) {
        return this.expression != null ? this.expression.resolveType(blockScope) : null;
    }

    @Override
    public StringBuffer printStatement(int n, StringBuffer stringBuffer) {
        if (!this.isImplicit) {
            YieldStatement.printIndent(n, stringBuffer).append("yield");
        }
        if (this.expression != null) {
            stringBuffer.append(' ');
            this.expression.printExpression(n, stringBuffer);
        }
        return stringBuffer.append(';');
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope) && this.expression != null) {
            this.expression.traverse(aSTVisitor, blockScope);
        }
        aSTVisitor.endVisit(this, blockScope);
    }

    @Override
    public boolean doesNotCompleteNormally() {
        return true;
    }

    @Override
    public boolean canCompleteNormally() {
        return false;
    }
}

