/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.flow;

import java.util.ArrayList;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FakedTrackingVariable;
import org.eclipse.jdt.internal.compiler.ast.LabeledStatement;
import org.eclipse.jdt.internal.compiler.ast.LambdaExpression;
import org.eclipse.jdt.internal.compiler.ast.NullAnnotationMatching;
import org.eclipse.jdt.internal.compiler.ast.Reference;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.SubRoutineStatement;
import org.eclipse.jdt.internal.compiler.ast.ThrowStatement;
import org.eclipse.jdt.internal.compiler.ast.TryStatement;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.codegen.BranchLabel;
import org.eclipse.jdt.internal.compiler.flow.ExceptionHandlingFlowContext;
import org.eclipse.jdt.internal.compiler.flow.ExceptionInferenceFlowContext;
import org.eclipse.jdt.internal.compiler.flow.FieldInitsFakingFlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.InitializationFlowContext;
import org.eclipse.jdt.internal.compiler.flow.InsideSubRoutineFlowContext;
import org.eclipse.jdt.internal.compiler.flow.LoopingFlowContext;
import org.eclipse.jdt.internal.compiler.flow.SwitchFlowContext;
import org.eclipse.jdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.CatchParameterBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.VariableBinding;

public class FlowContext
implements TypeConstants {
    public static final FlowContext NotContinuableContext = new FlowContext(null, null, true);
    public ASTNode associatedNode;
    public FlowContext parent;
    public FlowInfo initsOnFinally;
    public int conditionalLevel = -1;
    public int tagBits;
    public TypeBinding[][] providedExpectedTypes = null;
    private Reference[] nullCheckedFieldReferences = null;
    private int[] timesToLiveForNullCheckInfo = null;
    public static final int DEFER_NULL_DIAGNOSTIC = 1;
    public static final int PREEMPT_NULL_DIAGNOSTIC = 2;
    public static final int INSIDE_NEGATION = 4;
    public static final int HIDE_NULL_COMPARISON_WARNING = 4096;
    public static final int HIDE_NULL_COMPARISON_WARNING_MASK = 61440;
    public static final int CAN_ONLY_NULL_NON_NULL = 0;
    public static final int CAN_ONLY_NULL = 1;
    public static final int CAN_ONLY_NON_NULL = 2;
    public static final int MAY_NULL = 3;
    public static final int ASSIGN_TO_NONNULL = 128;
    public static final int IN_UNBOXING = 16;
    public static final int EXIT_RESOURCE = 2048;
    public static final int CHECK_MASK = 255;
    public static final int IN_COMPARISON_NULL = 256;
    public static final int IN_COMPARISON_NON_NULL = 512;
    public static final int IN_ASSIGNMENT = 768;
    public static final int IN_INSTANCEOF = 1024;
    public static final int CONTEXT_MASK = -61696;

    public FlowContext(FlowContext flowContext, ASTNode aSTNode, boolean bl) {
        this.parent = flowContext;
        this.associatedNode = aSTNode;
        if (flowContext != null) {
            if ((flowContext.tagBits & 3) != 0) {
                this.tagBits |= 1;
            }
            this.initsOnFinally = flowContext.initsOnFinally;
            this.conditionalLevel = flowContext.conditionalLevel;
            if (bl) {
                this.copyNullCheckedFieldsFrom(flowContext);
            }
        }
    }

    public void copyNullCheckedFieldsFrom(FlowContext flowContext) {
        Reference[] referenceArray = flowContext.nullCheckedFieldReferences;
        if (referenceArray != null && referenceArray.length > 0 && referenceArray[0] != null) {
            this.nullCheckedFieldReferences = flowContext.nullCheckedFieldReferences;
            this.timesToLiveForNullCheckInfo = flowContext.timesToLiveForNullCheckInfo;
        }
    }

    public void recordNullCheckedFieldReference(Reference reference, int n) {
        if (this.nullCheckedFieldReferences == null) {
            this.nullCheckedFieldReferences = new Reference[]{reference, null};
            this.timesToLiveForNullCheckInfo = new int[]{n, -1};
        } else {
            int n2 = this.nullCheckedFieldReferences.length;
            for (int i = 0; i < n2; ++i) {
                if (this.nullCheckedFieldReferences[i] != null) continue;
                this.nullCheckedFieldReferences[i] = reference;
                this.timesToLiveForNullCheckInfo[i] = n;
                return;
            }
            this.nullCheckedFieldReferences = new Reference[n2 + 2];
            System.arraycopy(this.nullCheckedFieldReferences, 0, this.nullCheckedFieldReferences, 0, n2);
            this.timesToLiveForNullCheckInfo = new int[n2 + 2];
            System.arraycopy(this.timesToLiveForNullCheckInfo, 0, this.timesToLiveForNullCheckInfo, 0, n2);
            this.nullCheckedFieldReferences[n2] = reference;
            this.timesToLiveForNullCheckInfo[n2] = n;
        }
    }

    public void extendTimeToLiveForNullCheckedField(int n) {
        if (this.timesToLiveForNullCheckInfo != null) {
            for (int i = 0; i < this.timesToLiveForNullCheckInfo.length; ++i) {
                if (this.timesToLiveForNullCheckInfo[i] <= 0) continue;
                int n2 = i;
                this.timesToLiveForNullCheckInfo[n2] = this.timesToLiveForNullCheckInfo[n2] + n;
            }
        }
    }

    public void expireNullCheckedFieldInfo() {
        if (this.nullCheckedFieldReferences != null) {
            for (int i = 0; i < this.nullCheckedFieldReferences.length; ++i) {
                int n = i;
                this.timesToLiveForNullCheckInfo[n] = this.timesToLiveForNullCheckInfo[n] - 1;
                if (this.timesToLiveForNullCheckInfo[n] != 0) continue;
                this.nullCheckedFieldReferences[i] = null;
            }
        }
    }

    public boolean isNullcheckedFieldAccess(Reference reference) {
        if (this.nullCheckedFieldReferences == null) {
            return false;
        }
        for (Reference reference2 : this.nullCheckedFieldReferences) {
            if (reference2 == null || !reference2.isEquivalent(reference)) continue;
            return true;
        }
        return false;
    }

    public BranchLabel breakLabel() {
        return null;
    }

    public void checkExceptionHandlers(TypeBinding typeBinding, ASTNode aSTNode, FlowInfo flowInfo, BlockScope blockScope) {
        this.checkExceptionHandlers(typeBinding, aSTNode, flowInfo, blockScope, false);
    }

    public void checkExceptionHandlers(TypeBinding typeBinding, ASTNode aSTNode, FlowInfo flowInfo, BlockScope blockScope, boolean bl) {
        Object object;
        Statement statement;
        FlowContext flowContext = this;
        ArrayList<FlowContext> arrayList = null;
        if (blockScope.compilerOptions().sourceLevel >= 0x330000L && aSTNode instanceof ThrowStatement) {
            statement = ((ThrowStatement)aSTNode).exception;
            object = ((Expression)statement).localVariableBinding();
            if (statement instanceof SingleNameReference && object instanceof CatchParameterBinding && ((VariableBinding)object).isEffectivelyFinal()) {
                CatchParameterBinding catchParameterBinding = (CatchParameterBinding)object;
                this.checkExceptionHandlers(catchParameterBinding.getPreciseTypes(), aSTNode, flowInfo, blockScope);
                return;
            }
        }
        while (flowContext != null) {
            statement = flowContext.subroutine();
            if (statement != null && ((SubRoutineStatement)statement).isSubRoutineEscaping()) {
                return;
            }
            if (flowContext instanceof ExceptionHandlingFlowContext) {
                boolean bl2;
                object = (ExceptionHandlingFlowContext)flowContext;
                ReferenceBinding[] referenceBindingArray = ((ExceptionHandlingFlowContext)object).handledExceptions;
                if (((ExceptionHandlingFlowContext)object).handledExceptions != Binding.NO_EXCEPTIONS) {
                    bl2 = false;
                    block5: for (ReferenceBinding referenceBinding : referenceBindingArray) {
                        int n;
                        FlowInfo flowInfo2 = flowInfo;
                        int n2 = n = referenceBinding == null ? -1 : Scope.compareTypes(typeBinding, referenceBinding);
                        if (arrayList != null && referenceBinding != null && n != 0) {
                            int n3 = arrayList.size();
                            for (int i = 0; i < n3; ++i) {
                                LoopingFlowContext loopingFlowContext = (LoopingFlowContext)arrayList.get(i);
                                loopingFlowContext.recordCatchContextOfEscapingException((ExceptionHandlingFlowContext)object, referenceBinding, flowInfo);
                            }
                            flowInfo2 = FlowInfo.DEAD_END;
                        }
                        switch (n) {
                            case -1: {
                                ((ExceptionHandlingFlowContext)object).recordHandlingException(referenceBinding, flowInfo2.unconditionalInits(), typeBinding, typeBinding, aSTNode, bl2);
                                bl2 = true;
                                continue block5;
                            }
                            case 1: {
                                ((ExceptionHandlingFlowContext)object).recordHandlingException(referenceBinding, flowInfo2.unconditionalInits(), typeBinding, referenceBinding, aSTNode, false);
                            }
                        }
                    }
                    if (bl2) {
                        return;
                    }
                }
                if (((ExceptionHandlingFlowContext)object).isMethodContext) {
                    AbstractMethodDeclaration abstractMethodDeclaration;
                    if (typeBinding.isUncheckedException(false)) {
                        return;
                    }
                    bl2 = object instanceof ExceptionInferenceFlowContext;
                    if (((ExceptionHandlingFlowContext)object).associatedNode instanceof AbstractMethodDeclaration && (abstractMethodDeclaration = (AbstractMethodDeclaration)((ExceptionHandlingFlowContext)object).associatedNode).isConstructor() && abstractMethodDeclaration.binding.declaringClass.isAnonymousType()) {
                        bl2 = true;
                    }
                    if (!bl2) break;
                    ((ExceptionHandlingFlowContext)object).mergeUnhandledException(typeBinding);
                    return;
                }
            } else if (flowContext instanceof LoopingFlowContext) {
                if (arrayList == null) {
                    arrayList = new ArrayList<FlowContext>(5);
                }
                arrayList.add(flowContext);
            }
            flowContext.recordReturnFrom(flowInfo.unconditionalInits());
            if (!bl && flowContext instanceof InsideSubRoutineFlowContext && (object = flowContext.associatedNode) instanceof TryStatement) {
                TryStatement tryStatement = (TryStatement)object;
                flowInfo.addInitializationsFrom(tryStatement.subRoutineInits);
            }
            flowContext = flowContext.getLocalParent();
        }
        if (bl) {
            blockScope.problemReporter().unhandledExceptionFromAutoClose(typeBinding, aSTNode);
        } else {
            blockScope.problemReporter().unhandledException(typeBinding, aSTNode);
        }
    }

    public void checkExceptionHandlers(TypeBinding[] typeBindingArray, ASTNode aSTNode, FlowInfo flowInfo, BlockScope blockScope) {
        Object object;
        int n;
        if (typeBindingArray == null || (n = typeBindingArray.length) == 0) {
            return;
        }
        int n2 = n;
        TypeBinding[] typeBindingArray2 = typeBindingArray;
        typeBindingArray = new TypeBinding[n];
        System.arraycopy(typeBindingArray2, 0, typeBindingArray, 0, n);
        ArrayList<FlowContext> arrayList = null;
        for (FlowContext flowContext = this; flowContext != null; flowContext = flowContext.getLocalParent()) {
            Object object2;
            SubRoutineStatement subRoutineStatement = flowContext.subroutine();
            if (subRoutineStatement != null && subRoutineStatement.isSubRoutineEscaping()) {
                return;
            }
            if (flowContext instanceof ExceptionHandlingFlowContext) {
                Object object3;
                int n3;
                object = (ExceptionHandlingFlowContext)flowContext;
                object2 = ((ExceptionHandlingFlowContext)object).handledExceptions;
                if (((ExceptionHandlingFlowContext)object).handledExceptions != Binding.NO_EXCEPTIONS) {
                    int n4;
                    n3 = ((ReferenceBinding[])object2).length;
                    object3 = new boolean[n];
                    for (n4 = 0; n4 < n3; ++n4) {
                        ReferenceBinding referenceBinding = object2[n4];
                        block6: for (int i = 0; i < n; ++i) {
                            int n5;
                            TypeBinding typeBinding = typeBindingArray[i];
                            if (typeBinding == null) continue;
                            FlowInfo flowInfo2 = flowInfo;
                            int n6 = n5 = referenceBinding == null ? -1 : Scope.compareTypes(typeBinding, referenceBinding);
                            if (arrayList != null && referenceBinding != null && n5 != 0) {
                                int n7 = arrayList.size();
                                for (int j = 0; j < n7; ++j) {
                                    LoopingFlowContext loopingFlowContext = (LoopingFlowContext)arrayList.get(j);
                                    loopingFlowContext.recordCatchContextOfEscapingException((ExceptionHandlingFlowContext)object, referenceBinding, flowInfo);
                                }
                                flowInfo2 = FlowInfo.DEAD_END;
                            }
                            switch (n5) {
                                case -1: {
                                    ((ExceptionHandlingFlowContext)object).recordHandlingException(referenceBinding, flowInfo2.unconditionalInits(), typeBinding, typeBinding, aSTNode, (boolean)object3[i]);
                                    if (object3[i] != false) continue block6;
                                    object3[i] = true;
                                    --n2;
                                    continue block6;
                                }
                                case 1: {
                                    ((ExceptionHandlingFlowContext)object).recordHandlingException(referenceBinding, flowInfo2.unconditionalInits(), typeBinding, referenceBinding, aSTNode, false);
                                }
                            }
                        }
                    }
                    for (n4 = 0; n4 < n; ++n4) {
                        if (object3[n4] == false) continue;
                        typeBindingArray[n4] = null;
                    }
                }
                if (((ExceptionHandlingFlowContext)object).isMethodContext) {
                    for (n3 = 0; n3 < n; ++n3) {
                        TypeBinding typeBinding = typeBindingArray[n3];
                        object3 = typeBinding;
                        if (typeBinding == null || !((TypeBinding)object3).isUncheckedException(false)) continue;
                        --n2;
                        typeBindingArray[n3] = null;
                    }
                    n3 = object instanceof ExceptionInferenceFlowContext;
                    if (((ExceptionHandlingFlowContext)object).associatedNode instanceof AbstractMethodDeclaration && ((AbstractMethodDeclaration)(object3 = (AbstractMethodDeclaration)((ExceptionHandlingFlowContext)object).associatedNode)).isConstructor() && ((AbstractMethodDeclaration)object3).binding.declaringClass.isAnonymousType()) {
                        n3 = 1;
                    }
                    if (n3 == 0) break;
                    for (int i = 0; i < n; ++i) {
                        TypeBinding typeBinding = typeBindingArray[i];
                        if (typeBinding == null) continue;
                        ((ExceptionHandlingFlowContext)object).mergeUnhandledException(typeBinding);
                    }
                    return;
                }
            } else if (flowContext instanceof LoopingFlowContext) {
                if (arrayList == null) {
                    arrayList = new ArrayList<FlowContext>(5);
                }
                arrayList.add(flowContext);
            }
            if (n2 == 0) {
                return;
            }
            flowContext.recordReturnFrom(flowInfo.unconditionalInits());
            if (!(flowContext instanceof InsideSubRoutineFlowContext) || !((object = flowContext.associatedNode) instanceof TryStatement)) continue;
            object2 = (TryStatement)object;
            flowInfo.addInitializationsFrom(object2.subRoutineInits);
        }
        block11: for (int i = 0; i < n; ++i) {
            object = typeBindingArray[i];
            if (object == null) continue;
            for (int j = 0; j < i; ++j) {
                if (TypeBinding.equalsEquals(typeBindingArray[j], (TypeBinding)object)) continue block11;
            }
            blockScope.problemReporter().unhandledException((TypeBinding)object, aSTNode);
        }
    }

    public BranchLabel continueLabel() {
        return null;
    }

    public FlowInfo getInitsForFinalBlankInitializationCheck(TypeBinding typeBinding, FlowInfo flowInfo) {
        FlowContext flowContext = this;
        FlowInfo flowInfo2 = flowInfo;
        do {
            ExceptionHandlingFlowContext exceptionHandlingFlowContext;
            if (flowContext instanceof InitializationFlowContext) {
                exceptionHandlingFlowContext = (InitializationFlowContext)flowContext;
                if (TypeBinding.equalsEquals(((TypeDeclaration)exceptionHandlingFlowContext.associatedNode).binding, typeBinding)) {
                    return flowInfo2;
                }
                flowInfo2 = exceptionHandlingFlowContext.initsBeforeContext;
                flowContext = exceptionHandlingFlowContext.initializationParent;
                continue;
            }
            if (flowContext instanceof ExceptionHandlingFlowContext) {
                if (flowContext instanceof FieldInitsFakingFlowContext) {
                    return FlowInfo.DEAD_END;
                }
                exceptionHandlingFlowContext = (ExceptionHandlingFlowContext)flowContext;
                flowContext = exceptionHandlingFlowContext.initializationParent == null ? exceptionHandlingFlowContext.parent : exceptionHandlingFlowContext.initializationParent;
                continue;
            }
            flowContext = flowContext.getLocalParent();
        } while (flowContext != null);
        throw new IllegalStateException(typeBinding.debugName());
    }

    public FlowContext getTargetContextForBreakLabel(char[] cArray) {
        FlowContext flowContext = null;
        for (FlowContext flowContext2 = this; flowContext2 != null; flowContext2 = flowContext2.getLocalParent()) {
            char[] cArray2;
            if (flowContext2.isNonReturningContext()) {
                flowContext = flowContext2;
            }
            if ((cArray2 = flowContext2.labelName()) == null || !CharOperation.equals(cArray2, cArray)) continue;
            ((LabeledStatement)flowContext2.associatedNode).bits |= 0x40;
            if (flowContext == null) {
                return flowContext2;
            }
            return flowContext;
        }
        return null;
    }

    public FlowContext getTargetContextForContinueLabel(char[] cArray) {
        FlowContext flowContext = null;
        FlowContext flowContext2 = null;
        for (FlowContext flowContext3 = this; flowContext3 != null; flowContext3 = flowContext3.getLocalParent()) {
            if (flowContext3.isNonReturningContext()) {
                flowContext2 = flowContext3;
            } else if (flowContext3.isContinuable()) {
                flowContext = flowContext3;
            }
            char[] cArray2 = flowContext3.labelName();
            if (cArray2 == null || !CharOperation.equals(cArray2, cArray)) continue;
            ((LabeledStatement)flowContext3.associatedNode).bits |= 0x40;
            if (flowContext != null && flowContext3.associatedNode.concreteStatement() == flowContext.associatedNode) {
                if (flowContext2 == null) {
                    return flowContext;
                }
                return flowContext2;
            }
            return NotContinuableContext;
        }
        return null;
    }

    public FlowContext getTargetContextForDefaultBreak() {
        FlowContext flowContext = null;
        for (FlowContext flowContext2 = this; flowContext2 != null; flowContext2 = flowContext2.getLocalParent()) {
            if (flowContext2.isNonReturningContext()) {
                flowContext = flowContext2;
            }
            if (!flowContext2.isBreakable() || flowContext2.labelName() != null) continue;
            if (flowContext == null) {
                return flowContext2;
            }
            return flowContext;
        }
        return null;
    }

    public FlowContext getTargetContextForDefaultYield() {
        FlowContext flowContext = null;
        for (FlowContext flowContext2 = this; flowContext2 != null; flowContext2 = flowContext2.getLocalParent()) {
            if (flowContext2.isNonReturningContext()) {
                flowContext = flowContext2;
            }
            if (!flowContext2.isBreakable() || flowContext2.labelName() != null || !((SwitchFlowContext)flowContext2).isExpression) continue;
            if (flowContext == null) {
                return flowContext2;
            }
            return flowContext;
        }
        return null;
    }

    public FlowContext getTargetContextForDefaultContinue() {
        FlowContext flowContext = null;
        for (FlowContext flowContext2 = this; flowContext2 != null; flowContext2 = flowContext2.getLocalParent()) {
            if (flowContext2.isNonReturningContext()) {
                flowContext = flowContext2;
            }
            if (!flowContext2.isContinuable()) continue;
            if (flowContext == null) {
                return flowContext2;
            }
            return flowContext;
        }
        return null;
    }

    public FlowContext getInitializationContext() {
        return null;
    }

    public FlowContext getLocalParent() {
        if (this.associatedNode instanceof AbstractMethodDeclaration || this.associatedNode instanceof TypeDeclaration || this.associatedNode instanceof LambdaExpression) {
            return null;
        }
        return this.parent;
    }

    public String individualToString() {
        return "Flow context";
    }

    public FlowInfo initsOnBreak() {
        return FlowInfo.DEAD_END;
    }

    public UnconditionalFlowInfo initsOnReturn() {
        return FlowInfo.DEAD_END;
    }

    public boolean isBreakable() {
        return false;
    }

    public boolean isContinuable() {
        return false;
    }

    public boolean isNonReturningContext() {
        return false;
    }

    public boolean isSubRoutine() {
        return false;
    }

    public char[] labelName() {
        return null;
    }

    public void markFinallyNullStatus(LocalVariableBinding localVariableBinding, int n) {
        if (this.initsOnFinally == null) {
            return;
        }
        if (this.conditionalLevel == -1) {
            return;
        }
        if (this.conditionalLevel == 0) {
            this.initsOnFinally.markNullStatus(localVariableBinding, n);
            return;
        }
        UnconditionalFlowInfo unconditionalFlowInfo = this.initsOnFinally.unconditionalCopy();
        unconditionalFlowInfo.markNullStatus(localVariableBinding, n);
        this.initsOnFinally = this.initsOnFinally.mergedWith(unconditionalFlowInfo);
    }

    public void mergeFinallyNullInfo(FlowInfo flowInfo) {
        if (this.initsOnFinally == null) {
            return;
        }
        if (this.conditionalLevel == -1) {
            return;
        }
        if (this.conditionalLevel == 0) {
            this.initsOnFinally.addNullInfoFrom(flowInfo);
            return;
        }
        this.initsOnFinally = this.initsOnFinally.mergedWith(flowInfo.unconditionalCopy());
    }

    public void recordAbruptExit() {
        if (this.conditionalLevel > -1) {
            ++this.conditionalLevel;
            if (!(this instanceof ExceptionHandlingFlowContext) && this.parent != null) {
                this.parent.recordAbruptExit();
            }
        }
    }

    public void recordBreakFrom(FlowInfo flowInfo) {
    }

    public void recordBreakTo(FlowContext flowContext) {
    }

    public void recordContinueFrom(FlowContext flowContext, FlowInfo flowInfo) {
    }

    public boolean recordExitAgainstResource(BlockScope blockScope, FlowInfo flowInfo, FakedTrackingVariable fakedTrackingVariable, ASTNode aSTNode) {
        return false;
    }

    protected void recordProvidedExpectedTypes(TypeBinding typeBinding, TypeBinding typeBinding2, int n) {
        if (n == 0) {
            this.providedExpectedTypes = new TypeBinding[5][];
        } else if (this.providedExpectedTypes == null) {
            int n2;
            for (n2 = 5; n2 <= n; n2 *= 2) {
            }
            this.providedExpectedTypes = new TypeBinding[n2][];
        } else if (n >= this.providedExpectedTypes.length) {
            int n3 = this.providedExpectedTypes.length;
            this.providedExpectedTypes = new TypeBinding[n * 2][];
            System.arraycopy(this.providedExpectedTypes, 0, this.providedExpectedTypes, 0, n3);
        }
        this.providedExpectedTypes[n] = new TypeBinding[]{typeBinding, typeBinding2};
    }

    protected boolean recordFinalAssignment(VariableBinding variableBinding, Reference reference) {
        return true;
    }

    protected final void recordNullReference(LocalVariableBinding localVariableBinding, ASTNode aSTNode, int n, FlowInfo flowInfo) {
        this.recordNullReferenceWithAnnotationStatus(localVariableBinding, aSTNode, n, flowInfo, null);
    }

    protected void recordNullReferenceWithAnnotationStatus(LocalVariableBinding localVariableBinding, ASTNode aSTNode, int n, FlowInfo flowInfo, NullAnnotationMatching nullAnnotationMatching) {
    }

    public void recordUnboxing(Scope scope, Expression expression, int n, FlowInfo flowInfo) {
        this.checkUnboxing(scope, expression, flowInfo);
    }

    protected void checkUnboxing(Scope scope, Expression expression, FlowInfo flowInfo) {
        int n = expression.nullStatus(flowInfo, this);
        if ((n & 2) != 0) {
            scope.problemReporter().nullUnboxing(expression, expression.resolvedType);
            return;
        }
        if ((n & 0x10) != 0) {
            scope.problemReporter().potentialNullUnboxing(expression, expression.resolvedType);
            return;
        }
        if ((n & 4) != 0) {
            return;
        }
        if (this.parent != null) {
            this.parent.recordUnboxing(scope, expression, 1, flowInfo);
        }
    }

    public void recordReturnFrom(UnconditionalFlowInfo unconditionalFlowInfo) {
    }

    public void recordSettingFinal(VariableBinding variableBinding, Reference reference, FlowInfo flowInfo) {
        if ((flowInfo.tagBits & 1) == 0) {
            for (FlowContext flowContext = this; flowContext != null && flowContext.recordFinalAssignment(variableBinding, reference); flowContext = flowContext.getLocalParent()) {
            }
        }
    }

    public void recordUsingNullReference(Scope scope, LocalVariableBinding localVariableBinding, ASTNode aSTNode, int n, FlowInfo flowInfo) {
        if ((flowInfo.tagBits & 3) != 0 || flowInfo.isDefinitelyUnknown(localVariableBinding)) {
            return;
        }
        int n2 = (n |= this.tagBits & 0x1000) & 0xFFFF0FFF;
        switch (n2) {
            case 256: 
            case 512: {
                if (flowInfo.isDefinitelyNonNull(localVariableBinding)) {
                    if (n2 == 512) {
                        if ((n & 0x1000) == 0) {
                            scope.problemReporter().localVariableRedundantCheckOnNonNull(localVariableBinding, aSTNode);
                        }
                        flowInfo.initsWhenFalse().setReachMode(2);
                    } else {
                        scope.problemReporter().localVariableNonNullComparedToNull(localVariableBinding, aSTNode);
                        flowInfo.initsWhenTrue().setReachMode(2);
                    }
                    return;
                }
                if (flowInfo.cannotBeDefinitelyNullOrNonNull(localVariableBinding)) {
                    return;
                }
            }
            case 257: 
            case 513: 
            case 769: 
            case 1025: {
                Expression expression = (Expression)aSTNode;
                if (flowInfo.isDefinitelyNull(localVariableBinding)) {
                    switch (n2 & 0xFFFF0F00) {
                        case 256: {
                            if ((n2 & 0xFF) == 1 && (expression.implicitConversion & 0x400) != 0) {
                                scope.problemReporter().localVariableNullReference(localVariableBinding, expression);
                                return;
                            }
                            if ((n & 0x1000) == 0) {
                                scope.problemReporter().localVariableRedundantCheckOnNull(localVariableBinding, expression);
                            }
                            flowInfo.initsWhenFalse().setReachMode(2);
                            return;
                        }
                        case 512: {
                            if ((n2 & 0xFF) == 1 && (expression.implicitConversion & 0x400) != 0) {
                                scope.problemReporter().localVariableNullReference(localVariableBinding, expression);
                                return;
                            }
                            scope.problemReporter().localVariableNullComparedToNonNull(localVariableBinding, expression);
                            flowInfo.initsWhenTrue().setReachMode(2);
                            return;
                        }
                        case 768: {
                            scope.problemReporter().localVariableRedundantNullAssignment(localVariableBinding, expression);
                            return;
                        }
                        case 1024: {
                            scope.problemReporter().localVariableNullInstanceof(localVariableBinding, expression);
                            return;
                        }
                    }
                    break;
                }
                if (flowInfo.isPotentiallyNull(localVariableBinding)) {
                    switch (n2 & 0xFFFF0F00) {
                        case 256: {
                            if ((n2 & 0xFF) != 1 || (expression.implicitConversion & 0x400) == 0) break;
                            scope.problemReporter().localVariablePotentialNullReference(localVariableBinding, expression);
                            return;
                        }
                        case 512: {
                            if ((n2 & 0xFF) != 1 || (expression.implicitConversion & 0x400) == 0) break;
                            scope.problemReporter().localVariablePotentialNullReference(localVariableBinding, expression);
                            return;
                        }
                    }
                    break;
                }
                if (!flowInfo.cannotBeDefinitelyNullOrNonNull(localVariableBinding)) break;
                return;
            }
            case 3: {
                if (flowInfo.isDefinitelyNull(localVariableBinding)) {
                    scope.problemReporter().localVariableNullReference(localVariableBinding, aSTNode);
                    return;
                }
                if (!flowInfo.isPotentiallyNull(localVariableBinding)) break;
                if (localVariableBinding.type.isFreeTypeVariable()) {
                    scope.problemReporter().localVariableFreeTypeVariableReference(localVariableBinding, aSTNode);
                    return;
                }
                scope.problemReporter().localVariablePotentialNullReference(localVariableBinding, aSTNode);
                return;
            }
        }
        if (this.parent != null) {
            this.parent.recordUsingNullReference(scope, localVariableBinding, aSTNode, n, flowInfo);
        }
    }

    void removeFinalAssignmentIfAny(Reference reference) {
    }

    public SubRoutineStatement subroutine() {
        return null;
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        FlowContext flowContext = this;
        int n2 = 0;
        while ((flowContext = flowContext.parent) != null) {
            ++n2;
        }
        FlowContext[] flowContextArray = new FlowContext[n2 + 1];
        flowContext = this;
        int n3 = n2;
        while (n3 >= 0) {
            flowContextArray[n3--] = flowContext;
            flowContext = flowContext.parent;
        }
        for (n = 0; n < n2; ++n) {
            for (int i = 0; i < n; ++i) {
                stringBuffer.append('\t');
            }
            stringBuffer.append(flowContextArray[n].individualToString()).append('\n');
        }
        stringBuffer.append('*');
        for (n = 0; n < n2 + 1; ++n) {
            stringBuffer.append('\t');
        }
        stringBuffer.append(this.individualToString()).append('\n');
        return stringBuffer.toString();
    }

    public void recordNullityMismatch(BlockScope blockScope, Expression expression, TypeBinding typeBinding, TypeBinding typeBinding2, FlowInfo flowInfo, int n, NullAnnotationMatching nullAnnotationMatching) {
        if (typeBinding == null) {
            return;
        }
        if (expression.localVariableBinding() != null) {
            FlowContext flowContext = this;
            while (flowContext != null) {
                int n2 = 0;
                if ((this.tagBits & 0x1000) != 0) {
                    n2 = 4096;
                }
                if (flowContext.internalRecordNullityMismatch(expression, typeBinding, flowInfo, n, nullAnnotationMatching, typeBinding2, 0x80 | n2)) {
                    return;
                }
                flowContext = flowContext.parent;
            }
        }
        if (nullAnnotationMatching != null) {
            blockScope.problemReporter().nullityMismatchingTypeAnnotation(expression, typeBinding, typeBinding2, nullAnnotationMatching);
        } else {
            blockScope.problemReporter().nullityMismatch(expression, typeBinding, typeBinding2, n, blockScope.environment().getNonNullAnnotationName());
        }
    }

    protected boolean internalRecordNullityMismatch(Expression expression, TypeBinding typeBinding, FlowInfo flowInfo, int n, NullAnnotationMatching nullAnnotationMatching, TypeBinding typeBinding2, int n2) {
        return false;
    }
}

