/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.charts.skin;

import eu.hansolo.enzo.charts.SimpleRadarChart;
import eu.hansolo.enzo.fonts.Fonts;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.CacheHint;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.chart.XYChart;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.Pane;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.Paint;
import javafx.scene.paint.RadialGradient;
import javafx.scene.paint.Stop;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;

public class SimpleRadarChartSkin
extends SkinBase<SimpleRadarChart>
implements Skin<SimpleRadarChart> {
    private static final double PREFERRED_WIDTH = 250.0;
    private static final double PREFERRED_HEIGHT = 250.0;
    private static final double MINIMUM_WIDTH = 100.0;
    private static final double MINIMUM_HEIGHT = 100.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    private double size;
    private double angleStep;
    private Pane pane;
    private Canvas canvas;
    private Text title;
    private Text unit;
    private Label minValue;
    private Label maxValue;
    private Label legend1;
    private Label legend2;
    private Label legend3;
    private Label legend4;
    private double legendStep;
    private List<Stop> gradientStops;
    private GraphicsContext ctx;

    public SimpleRadarChartSkin(SimpleRadarChart chart) {
        super((Control)chart);
        this.init();
        this.initGraphics();
        this.registerListeners();
    }

    private void init() {
        if (Double.compare(((SimpleRadarChart)this.getSkinnable()).getPrefWidth(), 0.0) <= 0 || Double.compare(((SimpleRadarChart)this.getSkinnable()).getPrefHeight(), 0.0) <= 0 || Double.compare(((SimpleRadarChart)this.getSkinnable()).getWidth(), 0.0) <= 0 || Double.compare(((SimpleRadarChart)this.getSkinnable()).getHeight(), 0.0) <= 0) {
            if (((SimpleRadarChart)this.getSkinnable()).getPrefWidth() > 0.0 && ((SimpleRadarChart)this.getSkinnable()).getPrefHeight() > 0.0) {
                ((SimpleRadarChart)this.getSkinnable()).setPrefSize(((SimpleRadarChart)this.getSkinnable()).getPrefWidth(), ((SimpleRadarChart)this.getSkinnable()).getPrefHeight());
            } else {
                ((SimpleRadarChart)this.getSkinnable()).setPrefSize(250.0, 250.0);
            }
        }
        if (Double.compare(((SimpleRadarChart)this.getSkinnable()).getMinWidth(), 0.0) <= 0 || Double.compare(((SimpleRadarChart)this.getSkinnable()).getMinHeight(), 0.0) <= 0) {
            ((SimpleRadarChart)this.getSkinnable()).setMinSize(100.0, 100.0);
        }
        if (Double.compare(((SimpleRadarChart)this.getSkinnable()).getMaxWidth(), 0.0) <= 0 || Double.compare(((SimpleRadarChart)this.getSkinnable()).getMaxHeight(), 0.0) <= 0) {
            ((SimpleRadarChart)this.getSkinnable()).setMaxSize(1024.0, 1024.0);
        }
    }

    private void initGraphics() {
        this.gradientStops = new ArrayList<Stop>(16);
        for (Stop stop : ((SimpleRadarChart)this.getSkinnable()).getGradientStops()) {
            if (Double.compare(stop.getOffset(), 0.0) == 0) {
                this.gradientStops.add(new Stop(0.0, stop.getColor()));
            }
            this.gradientStops.add(new Stop(stop.getOffset() * 0.69924 + 0.30076, stop.getColor()));
        }
        this.canvas = new Canvas(250.0, 250.0);
        this.ctx = this.canvas.getGraphicsContext2D();
        this.title = new Text(((SimpleRadarChart)this.getSkinnable()).getTitle());
        this.title.setTextAlignment(TextAlignment.CENTER);
        this.title.getStyleClass().add((Object)"title");
        this.title.setTextOrigin(VPos.CENTER);
        this.unit = new Text(((SimpleRadarChart)this.getSkinnable()).getUnit());
        this.unit.setTextAlignment(TextAlignment.CENTER);
        this.unit.getStyleClass().add((Object)"unit");
        this.unit.setTextOrigin(VPos.CENTER);
        this.minValue = new Label(String.format(Locale.US, "%.0f", ((SimpleRadarChart)this.getSkinnable()).getMinValue()));
        this.minValue.setTextAlignment(TextAlignment.CENTER);
        this.minValue.getStyleClass().add((Object)"range");
        this.minValue.setAlignment(Pos.CENTER);
        this.minValue.setVisible(((SimpleRadarChart)this.getSkinnable()).isScaleVisible());
        this.legendStep = (((SimpleRadarChart)this.getSkinnable()).getMaxValue() - ((SimpleRadarChart)this.getSkinnable()).getMinValue()) / 5.0;
        this.legend1 = new Label(String.format(Locale.US, "%.0f", ((SimpleRadarChart)this.getSkinnable()).getMinValue() + this.legendStep));
        this.legend1.setTextAlignment(TextAlignment.CENTER);
        this.legend1.getStyleClass().add((Object)"range");
        this.legend1.setAlignment(Pos.CENTER);
        this.legend1.setVisible(((SimpleRadarChart)this.getSkinnable()).isScaleVisible());
        this.legend2 = new Label(String.format(Locale.US, "%.0f", ((SimpleRadarChart)this.getSkinnable()).getMinValue() + this.legendStep * 2.0));
        this.legend2.setTextAlignment(TextAlignment.CENTER);
        this.legend2.getStyleClass().add((Object)"range");
        this.legend2.setAlignment(Pos.CENTER);
        this.legend2.setVisible(((SimpleRadarChart)this.getSkinnable()).isScaleVisible());
        this.legend3 = new Label(String.format(Locale.US, "%.0f", ((SimpleRadarChart)this.getSkinnable()).getMinValue() + this.legendStep * 3.0));
        this.legend3.setTextAlignment(TextAlignment.CENTER);
        this.legend3.getStyleClass().add((Object)"range");
        this.legend3.setAlignment(Pos.CENTER);
        this.legend3.setVisible(((SimpleRadarChart)this.getSkinnable()).isScaleVisible());
        this.legend4 = new Label(String.format(Locale.US, "%.0f", ((SimpleRadarChart)this.getSkinnable()).getMinValue() + this.legendStep * 3.0));
        this.legend4.setTextAlignment(TextAlignment.CENTER);
        this.legend4.getStyleClass().add((Object)"range");
        this.legend4.setAlignment(Pos.CENTER);
        this.legend4.setVisible(((SimpleRadarChart)this.getSkinnable()).isScaleVisible());
        this.maxValue = new Label(String.format(Locale.US, "%.0f", ((SimpleRadarChart)this.getSkinnable()).getMaxValue()));
        this.maxValue.setTextAlignment(TextAlignment.CENTER);
        this.maxValue.getStyleClass().add((Object)"range");
        this.maxValue.setAlignment(Pos.CENTER);
        this.maxValue.setVisible(((SimpleRadarChart)this.getSkinnable()).isScaleVisible());
        this.pane = new Pane();
        this.pane.getStyleClass().setAll((Object[])new String[]{"simple-radar-chart"});
        this.pane.getChildren().setAll((Object[])new Node[]{this.canvas, this.title, this.unit, this.minValue, this.legend4, this.legend3, this.legend2, this.legend1, this.maxValue});
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    private void registerListeners() {
        ((SimpleRadarChart)this.getSkinnable()).widthProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((SimpleRadarChart)this.getSkinnable()).heightProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((SimpleRadarChart)this.getSkinnable()).titleProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((SimpleRadarChart)this.getSkinnable()).unitProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((SimpleRadarChart)this.getSkinnable()).scaleVisibleProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((SimpleRadarChart)this.getSkinnable()).minValueProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((SimpleRadarChart)this.getSkinnable()).maxValueProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((SimpleRadarChart)this.getSkinnable()).polygonModeProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((SimpleRadarChart)this.getSkinnable()).noOfSectorsProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((SimpleRadarChart)this.getSkinnable()).getData().addListener(change -> this.handleControlPropertyChanged("RESIZE"));
        ((SimpleRadarChart)this.getSkinnable()).chartBackgroundProperty().addListener(observable -> this.handleControlPropertyChanged("REDRAW"));
        ((SimpleRadarChart)this.getSkinnable()).chartForegroundProperty().addListener(observable -> this.handleControlPropertyChanged("REDRAW"));
        ((SimpleRadarChart)this.getSkinnable()).chartFillProperty().addListener(observable -> this.handleControlPropertyChanged("REDRAW"));
        ((SimpleRadarChart)this.getSkinnable()).chartTextProperty().addListener(observable -> this.handleControlPropertyChanged("REDRAW"));
        ((SimpleRadarChart)this.getSkinnable()).getGradientStops().addListener(change -> this.handleControlPropertyChanged("REDRAW"));
        ((SimpleRadarChart)this.getSkinnable()).filledProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
    }

    protected void handleControlPropertyChanged(String PROPERTY) {
        if ("RESIZE".equals(PROPERTY)) {
            this.resize();
        } else if ("REDRAW".equals(PROPERTY)) {
            this.gradientStops.clear();
            for (Stop stop : ((SimpleRadarChart)this.getSkinnable()).getGradientStops()) {
                if (Double.compare(stop.getOffset(), 0.0) == 0) {
                    this.gradientStops.add(new Stop(0.0, stop.getColor()));
                }
                this.gradientStops.add(new Stop(stop.getOffset() * 0.69924 + 0.30076, stop.getColor()));
            }
            this.draw();
        }
    }

    private final void draw() {
        int i;
        double radius;
        int i2;
        this.ctx.clearRect(0.0, 0.0, this.size, this.size);
        double CENTER_X = 0.5 * this.size;
        double CENTER_Y = 0.5 * this.size;
        double CIRCLE_SIZE = 0.95 * this.size;
        double DATA_RANGE = ((SimpleRadarChart)this.getSkinnable()).getMaxValue() - ((SimpleRadarChart)this.getSkinnable()).getMinValue();
        double RANGE = 0.35714 * CIRCLE_SIZE;
        double OFFSET = 0.14286 * CIRCLE_SIZE;
        this.ctx.setFill((Paint)((SimpleRadarChart)this.getSkinnable()).getChartBackground());
        this.ctx.fillOval(0.5 * (this.size - CIRCLE_SIZE), 0.5 * (this.size - CIRCLE_SIZE), CIRCLE_SIZE, CIRCLE_SIZE);
        this.ctx.save();
        if (((SimpleRadarChart)this.getSkinnable()).getGradientStops().isEmpty()) {
            this.ctx.setFill(((SimpleRadarChart)this.getSkinnable()).getChartFill());
        } else {
            this.ctx.setFill((Paint)new RadialGradient(0.0, 0.0, CENTER_X, CENTER_Y, 0.5 * CIRCLE_SIZE, false, CycleMethod.NO_CYCLE, this.gradientStops));
        }
        this.ctx.setStroke((Paint)((SimpleRadarChart)this.getSkinnable()).getChartStroke());
        if (((SimpleRadarChart)this.getSkinnable()).isPolygonMode()) {
            this.ctx.beginPath();
            this.ctx.moveTo(CENTER_X, 0.36239 * this.size);
            for (i2 = 0; i2 < ((SimpleRadarChart)this.getSkinnable()).getNoOfSectors(); ++i2) {
                radius = ((Double)((XYChart.Data)((SimpleRadarChart)this.getSkinnable()).getData().get((Object)i2)).getYValue() - ((SimpleRadarChart)this.getSkinnable()).getMinValue()) / DATA_RANGE;
                this.ctx.lineTo(CENTER_X, CENTER_Y - OFFSET - radius * RANGE);
                this.ctx.translate(CENTER_X, CENTER_Y);
                this.ctx.rotate(this.angleStep);
                this.ctx.translate(-CENTER_X, -CENTER_Y);
            }
            radius = ((Double)((XYChart.Data)((SimpleRadarChart)this.getSkinnable()).getData().get((Object)((SimpleRadarChart)this.getSkinnable()).getNoOfSectors())).getYValue() - ((SimpleRadarChart)this.getSkinnable()).getMinValue()) / DATA_RANGE;
            this.ctx.lineTo(CENTER_X, CENTER_Y - OFFSET - radius * RANGE);
            this.ctx.closePath();
        } else {
            this.ctx.translate(CENTER_X, CENTER_Y);
            this.ctx.rotate(-90.0);
            this.ctx.translate(-CENTER_X, -CENTER_Y);
            for (i2 = 0; i2 < ((SimpleRadarChart)this.getSkinnable()).getNoOfSectors(); ++i2) {
                radius = ((Double)((XYChart.Data)((SimpleRadarChart)this.getSkinnable()).getData().get((Object)i2)).getYValue() - ((SimpleRadarChart)this.getSkinnable()).getMinValue()) / DATA_RANGE;
                this.ctx.beginPath();
                this.ctx.moveTo(CENTER_X, CENTER_Y);
                this.ctx.arc(CENTER_X, CENTER_Y, radius * RANGE + OFFSET, radius * RANGE + OFFSET, 0.0, -this.angleStep);
                this.ctx.closePath();
                this.ctx.translate(CENTER_X, CENTER_Y);
                this.ctx.rotate(this.angleStep);
                this.ctx.translate(-CENTER_X, -CENTER_Y);
            }
        }
        if (((SimpleRadarChart)this.getSkinnable()).isFilled()) {
            this.ctx.fill();
        } else {
            this.ctx.stroke();
        }
        this.ctx.restore();
        this.ctx.save();
        this.ctx.setFill((Paint)((SimpleRadarChart)this.getSkinnable()).getChartBackground());
        this.ctx.translate(CENTER_X - OFFSET, CENTER_Y - OFFSET);
        this.ctx.fillOval(0.0, 0.0, 2.0 * OFFSET, 2.0 * OFFSET);
        this.ctx.restore();
        this.ctx.setStroke((Paint)((SimpleRadarChart)this.getSkinnable()).getChartForeground());
        double ringStepSize = (CIRCLE_SIZE - CIRCLE_SIZE * 0.28571) / 20.0;
        double pos = 0.5 * (this.size - CIRCLE_SIZE);
        double ringSize = CIRCLE_SIZE;
        for (i = 0; i < 11; ++i) {
            this.ctx.strokeOval(pos, pos, ringSize, ringSize);
            pos += ringStepSize;
            ringSize -= 2.0 * ringStepSize;
        }
        this.ctx.save();
        for (i = 0; i < ((SimpleRadarChart)this.getSkinnable()).getNoOfSectors(); ++i) {
            this.ctx.strokeLine(CENTER_X, 0.36239 * this.size, CENTER_X, 0.5 * (this.size - CIRCLE_SIZE));
            this.ctx.translate(CENTER_X, CENTER_Y);
            this.ctx.rotate(this.angleStep);
            this.ctx.translate(-CENTER_X, -CENTER_Y);
        }
        this.ctx.restore();
        if (((SimpleRadarChart)this.getSkinnable()).isZeroLineVisible()) {
            this.ctx.setStroke((Paint)((SimpleRadarChart)this.getSkinnable()).getZeroLineColor());
            radius = -((SimpleRadarChart)this.getSkinnable()).getMinValue() / DATA_RANGE;
            this.ctx.strokeOval(0.5 * this.size - OFFSET - radius * RANGE, 0.5 * this.size - OFFSET - radius * RANGE, 2.0 * (radius * RANGE + OFFSET), 2.0 * (radius * RANGE + OFFSET));
        }
        this.ctx.save();
        if (!((SimpleRadarChart)this.getSkinnable()).isPolygonMode()) {
            this.ctx.translate(CENTER_X, CENTER_Y);
            this.ctx.rotate(this.angleStep * 0.5);
            this.ctx.translate(-CENTER_X, -CENTER_Y);
        }
        this.ctx.setFont(Fonts.robotoLight(0.025 * this.size));
        this.ctx.setTextAlign(TextAlignment.CENTER);
        this.ctx.setTextBaseline(VPos.CENTER);
        this.ctx.setFill((Paint)((SimpleRadarChart)this.getSkinnable()).getChartText());
        for (i = 0; i < ((SimpleRadarChart)this.getSkinnable()).getNoOfSectors(); ++i) {
            this.ctx.fillText((String)((XYChart.Data)((SimpleRadarChart)this.getSkinnable()).getData().get((Object)i)).getXValue(), CENTER_X, 0.01 * this.size);
            this.ctx.translate(CENTER_X, CENTER_Y);
            this.ctx.rotate(this.angleStep);
            this.ctx.translate(-CENTER_X, -CENTER_Y);
        }
        this.ctx.restore();
    }

    private void resizeText() {
        double decrement;
        this.title.setText(((SimpleRadarChart)this.getSkinnable()).getTitle());
        this.title.setFont(Fonts.robotoLight(0.045 * this.size));
        if (this.title.getLayoutBounds().getWidth() > 0.25 * this.size) {
            decrement = 0.0;
            while (this.title.getLayoutBounds().getWidth() > 0.25 * this.size && this.title.getFont().getSize() > 0.0) {
                this.title.setFont(Fonts.robotoLight(this.size * (0.05 - decrement)));
                decrement += 0.01;
            }
        }
        this.title.setTranslateX((this.size - this.title.getLayoutBounds().getWidth()) * 0.5);
        this.title.setTranslateY(this.size * 0.5);
        this.unit.setText(((SimpleRadarChart)this.getSkinnable()).getUnit());
        this.unit.setFont(Fonts.robotoLight(0.038 * this.size));
        if (this.unit.getLayoutBounds().getWidth() > 0.25 * this.size) {
            decrement = 0.0;
            while (this.unit.getLayoutBounds().getWidth() > 0.25 * this.size && this.unit.getFont().getSize() > 0.0) {
                this.unit.setFont(Fonts.robotoLight(this.size * (0.05 - decrement)));
                decrement += 0.01;
            }
        }
        this.unit.setTranslateX((this.size - this.unit.getLayoutBounds().getWidth()) * 0.5);
        if (((SimpleRadarChart)this.getSkinnable()).getTitle().isEmpty()) {
            this.unit.setTranslateY(this.size * 0.5);
        } else {
            this.unit.setTranslateY(this.size * 0.59);
        }
        this.minValue.setVisible(((SimpleRadarChart)this.getSkinnable()).isScaleVisible());
        this.legend1.setVisible(((SimpleRadarChart)this.getSkinnable()).isScaleVisible());
        this.legend2.setVisible(((SimpleRadarChart)this.getSkinnable()).isScaleVisible());
        this.legend3.setVisible(((SimpleRadarChart)this.getSkinnable()).isScaleVisible());
        this.legend4.setVisible(((SimpleRadarChart)this.getSkinnable()).isScaleVisible());
        this.maxValue.setVisible(((SimpleRadarChart)this.getSkinnable()).isScaleVisible());
        if (((SimpleRadarChart)this.getSkinnable()).isScaleVisible()) {
            this.minValue.setText(String.format(Locale.US, "%.0f", ((SimpleRadarChart)this.getSkinnable()).getMinValue()));
            this.minValue.setFont(Fonts.robotoRegular(0.02 * this.size));
            if (Double.compare(this.minValue.getLayoutBounds().getWidth(), 0.0) == 0) {
                this.minValue.relocate((this.size - 15.0) * 0.5, 0.3335 * this.size);
            } else {
                this.minValue.relocate((this.size - this.minValue.getLayoutBounds().getWidth()) * 0.5, 0.3335 * this.size);
            }
            this.legendStep = (((SimpleRadarChart)this.getSkinnable()).getMaxValue() - ((SimpleRadarChart)this.getSkinnable()).getMinValue()) / 5.0;
            this.legend1.setText(String.format(Locale.US, "%.0f", ((SimpleRadarChart)this.getSkinnable()).getMinValue() + this.legendStep));
            this.legend1.setFont(Fonts.robotoRegular(0.02 * this.size));
            if (Double.compare(this.legend1.getLayoutBounds().getWidth(), 0.0) == 0) {
                this.legend1.relocate((this.size - 15.0) * 0.5, 0.2723 * this.size);
            } else {
                this.legend1.relocate((this.size - this.legend1.getLayoutBounds().getWidth()) * 0.5, 0.2723 * this.size);
            }
            this.legend2.setText(String.format(Locale.US, "%.0f", ((SimpleRadarChart)this.getSkinnable()).getMinValue() + this.legendStep * 2.0));
            this.legend2.setFont(Fonts.robotoRegular(0.02 * this.size));
            if (Double.compare(this.legend2.getLayoutBounds().getWidth(), 0.0) == 0) {
                this.legend2.relocate((this.size - 15.0) * 0.5, 0.2111 * this.size);
            } else {
                this.legend2.relocate((this.size - this.legend2.getLayoutBounds().getWidth()) * 0.5, 0.2111 * this.size);
            }
            this.legend3.setText(String.format(Locale.US, "%.0f", ((SimpleRadarChart)this.getSkinnable()).getMinValue() + this.legendStep * 3.0));
            this.legend3.setFont(Fonts.robotoRegular(0.02 * this.size));
            if (Double.compare(this.legend3.getLayoutBounds().getWidth(), 0.0) == 0) {
                this.legend3.relocate((this.size - 15.0) * 0.5, 0.1499 * this.size);
            } else {
                this.legend3.relocate((this.size - this.legend3.getLayoutBounds().getWidth()) * 0.5, 0.1499 * this.size);
            }
            this.legend4.setText(String.format(Locale.US, "%.0f", ((SimpleRadarChart)this.getSkinnable()).getMinValue() + this.legendStep * 4.0));
            this.legend4.setFont(Fonts.robotoRegular(0.02 * this.size));
            if (Double.compare(this.legend4.getLayoutBounds().getWidth(), 0.0) == 0) {
                this.legend4.relocate((this.size - 15.0) * 0.5, 0.0887 * this.size);
            } else {
                this.legend4.relocate((this.size - this.legend4.getLayoutBounds().getWidth()) * 0.5, 0.0887 * this.size);
            }
            this.maxValue.setText(String.format(Locale.US, "%.0f", ((SimpleRadarChart)this.getSkinnable()).getMaxValue()));
            this.maxValue.setFont(Fonts.robotoRegular(0.02 * this.size));
            if (Double.compare(this.minValue.getLayoutBounds().getWidth(), 0.0) == 0) {
                this.maxValue.relocate((this.size - 15.0) * 0.5, 0.0275 * this.size);
            } else {
                this.maxValue.relocate((this.size - this.maxValue.getLayoutBounds().getWidth()) * 0.5, 0.0275 * this.size);
            }
        }
    }

    private void resize() {
        double d = this.size = ((SimpleRadarChart)this.getSkinnable()).getWidth() < ((SimpleRadarChart)this.getSkinnable()).getHeight() ? ((SimpleRadarChart)this.getSkinnable()).getWidth() : ((SimpleRadarChart)this.getSkinnable()).getHeight();
        if (this.size > 0.0) {
            this.pane.setMaxSize(this.size, this.size);
            this.pane.relocate((((SimpleRadarChart)this.getSkinnable()).getWidth() - this.size) * 0.5, (((SimpleRadarChart)this.getSkinnable()).getHeight() - this.size) * 0.5);
            this.canvas.setWidth(this.size);
            this.canvas.setHeight(this.size);
            this.angleStep = 360.0 / (double)((SimpleRadarChart)this.getSkinnable()).getNoOfSectors();
            this.draw();
            this.canvas.setCache(true);
            this.canvas.setCacheHint(CacheHint.QUALITY);
            this.resizeText();
        }
    }
}

