/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.gauge;

import eu.hansolo.enzo.gauge.FlatGauge;
import eu.hansolo.enzo.gauge.FlatGaugeBuilder;
import java.util.Random;
import javafx.animation.AnimationTimer;
import javafx.application.Application;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;

public class DemoFlatGauge
extends Application {
    private static final Random RND = new Random();
    private static int noOfNodes = 0;
    private FlatGauge gauge;
    private long lastTimerCall;
    private AnimationTimer timer;

    public void init() {
        this.gauge = ((FlatGaugeBuilder)((FlatGaugeBuilder)((FlatGaugeBuilder)((FlatGaugeBuilder)((FlatGaugeBuilder)((FlatGaugeBuilder)((FlatGaugeBuilder)((FlatGaugeBuilder)FlatGaugeBuilder.create().prefSize(600.0, 600.0)).title("Temperature")).unit("\u00b0C")).minValue(0.0)).maxValue(100.0)).backgroundColor(Color.TRANSPARENT)).barColor(Color.CYAN)).animationDuration(2000)).build();
        this.lastTimerCall = System.nanoTime() + 3000000000L;
        this.timer = new AnimationTimer(){

            public void handle(long now) {
                if (now > DemoFlatGauge.this.lastTimerCall + 5000000000L) {
                    DemoFlatGauge.this.gauge.setValue(RND.nextDouble() * (DemoFlatGauge.this.gauge.getMaxValue() - DemoFlatGauge.this.gauge.getMinValue()) + DemoFlatGauge.this.gauge.getMinValue());
                    DemoFlatGauge.this.lastTimerCall = now;
                }
            }
        };
    }

    public void start(Stage stage) throws Exception {
        HBox pane = new HBox();
        pane.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        pane.setSpacing(10.0);
        pane.getChildren().addAll((Object[])new Node[]{this.gauge});
        pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.WHITE, CornerRadii.EMPTY, Insets.EMPTY)}));
        Scene scene = new Scene((Parent)pane, (Paint)Color.WHITE);
        stage.setTitle("FlatGauge");
        stage.setScene(scene);
        stage.show();
        this.timer.start();
        DemoFlatGauge.calcNoOfNodes((Node)scene.getRoot());
        System.out.println(noOfNodes + " Nodes in SceneGraph");
    }

    public void stop() {
    }

    public static void main(String[] args) {
        Application.launch((String[])args);
    }

    private static void calcNoOfNodes(Node node) {
        if (node instanceof Parent && ((Parent)node).getChildrenUnmodifiable().size() != 0) {
            ObservableList tempChildren = ((Parent)node).getChildrenUnmodifiable();
            noOfNodes += tempChildren.size();
            for (Node n : tempChildren) {
                DemoFlatGauge.calcNoOfNodes(n);
            }
        }
    }
}

