/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.gauge;

import eu.hansolo.enzo.common.Section;
import eu.hansolo.enzo.gauge.skin.RectangularGaugeSkin;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.IntStream;
import javafx.animation.AnimationTimer;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Duration;

public class RectangularGauge
extends Control {
    public static final String STYLE_CLASS_NEEDLE_STANDARD = NeedleType.STANDARD.STYLE_CLASS;
    private static final PseudoClass LED_ON_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"led-on");
    private static final long LED_BLINK_INTERVAL = 500000000L;
    private static final Color DEFAULT_SECTION_FILL_0 = Color.rgb((int)0, (int)0, (int)178, (double)0.5);
    private static final Color DEFAULT_SECTION_FILL_1 = Color.rgb((int)0, (int)128, (int)255, (double)0.5);
    private static final Color DEFAULT_SECTION_FILL_2 = Color.rgb((int)0, (int)255, (int)255, (double)0.5);
    private static final Color DEFAULT_SECTION_FILL_3 = Color.rgb((int)0, (int)255, (int)64, (double)0.5);
    private static final Color DEFAULT_SECTION_FILL_4 = Color.rgb((int)128, (int)255, (int)0, (double)0.5);
    private static final Color DEFAULT_SECTION_FILL_5 = Color.rgb((int)255, (int)255, (int)0, (double)0.5);
    private static final Color DEFAULT_SECTION_FILL_6 = Color.rgb((int)255, (int)191, (int)0, (double)0.5);
    private static final Color DEFAULT_SECTION_FILL_7 = Color.rgb((int)255, (int)128, (int)0, (double)0.5);
    private static final Color DEFAULT_SECTION_FILL_8 = Color.rgb((int)255, (int)64, (int)0, (double)0.5);
    private static final Color DEFAULT_SECTION_FILL_9 = Color.rgb((int)255, (int)0, (int)0, (double)0.5);
    private DoubleProperty value;
    private DoubleProperty minValue;
    private double exactMinValue;
    private DoubleProperty maxValue;
    private double exactMaxValue;
    private int _decimals;
    private IntegerProperty decimals;
    private String _title;
    private StringProperty title;
    private String _unit;
    private StringProperty unit;
    private boolean _animated;
    private BooleanProperty animated;
    private double animationDuration;
    private double _startAngle;
    private DoubleProperty startAngle;
    private double _angleRange;
    private DoubleProperty angleRange;
    private boolean _autoScale;
    private BooleanProperty autoScale;
    private Color _needleColor;
    private ObjectProperty<Color> needleColor;
    private BooleanProperty ledOn;
    private BooleanProperty blinking;
    private ObjectProperty<Color> ledColor;
    private BooleanProperty ledVisible;
    private TickLabelOrientation _tickLabelOrientation;
    private ObjectProperty<TickLabelOrientation> tickLabelOrientation;
    private NumberFormat _numberFormat;
    private ObjectProperty<NumberFormat> numberFormat;
    private double _majorTickSpace;
    private DoubleProperty majorTickSpace;
    private double _minorTickSpace;
    private DoubleProperty minorTickSpace;
    private boolean _dropShadowEnabled;
    private BooleanProperty dropShadowEnabled;
    private ObservableList<Section> sections;
    private BooleanProperty sectionsVisible;
    private ObjectProperty<Color> sectionFill0;
    private ObjectProperty<Color> sectionFill1;
    private ObjectProperty<Color> sectionFill2;
    private ObjectProperty<Color> sectionFill3;
    private ObjectProperty<Color> sectionFill4;
    private ObjectProperty<Color> sectionFill5;
    private ObjectProperty<Color> sectionFill6;
    private ObjectProperty<Color> sectionFill7;
    private ObjectProperty<Color> sectionFill8;
    private ObjectProperty<Color> sectionFill9;
    private ObjectProperty<Paint> tickMarkFill;
    private ObjectProperty<Paint> tickLabelFill;
    private long lastTimerCall;
    private AnimationTimer timer;

    public RectangularGauge() {
        this.getStyleClass().add((Object)"rectangular-gauge");
        this.minValue = new SimpleDoubleProperty((Object)this, "minValue", 0.0);
        this.maxValue = new SimpleDoubleProperty((Object)this, "maxValue", 100.0);
        this.value = new DoublePropertyBase(this.minValue.get()){

            public void set(double VALUE) {
                super.set(RectangularGauge.this.clamp(RectangularGauge.this.getMinValue(), RectangularGauge.this.getMaxValue(), VALUE));
            }

            public Object getBean() {
                return this;
            }

            public String getName() {
                return "value";
            }
        };
        this._decimals = 1;
        this._title = "";
        this._unit = "";
        this._animated = true;
        this._startAngle = 225.0;
        this._angleRange = 90.0;
        this._autoScale = false;
        this._needleColor = Color.RED;
        this._tickLabelOrientation = TickLabelOrientation.HORIZONTAL;
        this._numberFormat = NumberFormat.STANDARD;
        this._majorTickSpace = 10.0;
        this._minorTickSpace = 1.0;
        this.animationDuration = 800.0;
        this._dropShadowEnabled = true;
        this.sections = FXCollections.observableArrayList();
        this.lastTimerCall = System.nanoTime();
        this.timer = new AnimationTimer(){

            public void handle(long NOW) {
                if (NOW > RectangularGauge.this.lastTimerCall + 500000000L) {
                    RectangularGauge.this.setLedOn(!RectangularGauge.this.isLedOn());
                    RectangularGauge.this.lastTimerCall = NOW;
                }
            }
        };
        this.registerListeners();
    }

    private void registerListeners() {
        this.sections.addListener(c -> IntStream.range(0, this.sections.size()).parallel().forEachOrdered(i -> {
            Section section = (Section)this.sections.get(i);
            switch (i) {
                case 0: {
                    this.setSectionFill0(section.getColor());
                    break;
                }
                case 1: {
                    this.setSectionFill1(section.getColor());
                    break;
                }
                case 2: {
                    this.setSectionFill2(section.getColor());
                    break;
                }
                case 3: {
                    this.setSectionFill3(section.getColor());
                    break;
                }
                case 4: {
                    this.setSectionFill4(section.getColor());
                    break;
                }
                case 5: {
                    this.setSectionFill5(section.getColor());
                    break;
                }
                case 6: {
                    this.setSectionFill6(section.getColor());
                    break;
                }
                case 7: {
                    this.setSectionFill7(section.getColor());
                    break;
                }
                case 8: {
                    this.setSectionFill8(section.getColor());
                    break;
                }
                case 9: {
                    this.setSectionFill9(section.getColor());
                }
            }
        }));
    }

    public final double getValue() {
        return this.value.get();
    }

    public final void setValue(double VALUE) {
        this.value.set(VALUE);
    }

    public final DoubleProperty valueProperty() {
        return this.value;
    }

    public final double getMinValue() {
        return this.minValue.get();
    }

    public final void setMinValue(double MIN_VALUE) {
        this.minValue.set(MIN_VALUE);
    }

    public final DoubleProperty minValueProperty() {
        return this.minValue;
    }

    public final double getMaxValue() {
        return this.maxValue.get();
    }

    public final void setMaxValue(double MAX_VALUE) {
        this.maxValue.set(MAX_VALUE);
    }

    public final DoubleProperty maxValueProperty() {
        return this.maxValue;
    }

    public final int getDecimals() {
        return null == this.decimals ? this._decimals : this.decimals.get();
    }

    public final void setDecimals(int DECIMALS) {
        if (null == this.decimals) {
            this._decimals = this.clamp(0, 3, DECIMALS);
        } else {
            this.decimals.set(this.clamp(0, 3, DECIMALS));
        }
    }

    public final IntegerProperty decimalsProperty() {
        if (null == this.decimals) {
            this.decimals = new SimpleIntegerProperty((Object)this, "decimals", this._decimals);
        }
        return this.decimals;
    }

    public final String getTitle() {
        return null == this.title ? this._title : (String)this.title.get();
    }

    public final void setTitle(String TITLE) {
        if (null == this.title) {
            this._title = TITLE;
        } else {
            this.title.set((Object)TITLE);
        }
    }

    public final StringProperty titleProperty() {
        if (null == this.title) {
            this.title = new SimpleStringProperty((Object)this, "title", this._title);
        }
        return this.title;
    }

    public final String getUnit() {
        return null == this.unit ? this._unit : (String)this.unit.get();
    }

    public final void setUnit(String UNIT) {
        if (null == this.unit) {
            this._unit = UNIT;
        } else {
            this.unit.set((Object)UNIT);
        }
    }

    public final StringProperty unitProperty() {
        if (null == this.unit) {
            this.unit = new SimpleStringProperty((Object)this, "unit", this._unit);
        }
        return this.unit;
    }

    public final boolean isAnimated() {
        return null == this.animated ? this._animated : this.animated.get();
    }

    public final void setAnimated(boolean ANIMATED) {
        if (null == this.animated) {
            this._animated = ANIMATED;
        } else {
            this.animated.set(ANIMATED);
        }
    }

    public final BooleanProperty animatedProperty() {
        if (null == this.animated) {
            this.animated = new SimpleBooleanProperty((Object)this, "animated", this._animated);
        }
        return this.animated;
    }

    public double getStartAngle() {
        return null == this.startAngle ? this._startAngle : this.startAngle.get();
    }

    public final void setStartAngle(double START_ANGLE) {
        if (null == this.startAngle) {
            this._startAngle = this.clamp(0.0, 360.0, START_ANGLE);
        } else {
            this.startAngle.set(START_ANGLE);
        }
    }

    public final DoubleProperty startAngleProperty() {
        if (null == this.startAngle) {
            this.startAngle = new DoublePropertyBase(this._startAngle){

                public void set(double START_ANGLE) {
                    super.set(RectangularGauge.this.clamp(0.0, 360.0, this.get()));
                }

                public Object getBean() {
                    return this;
                }

                public String getName() {
                    return "startAngle";
                }
            };
        }
        return this.startAngle;
    }

    public final double getAnimationDuration() {
        return this.animationDuration;
    }

    public final void setAnimationDuration(double ANIMATION_DURATION) {
        this.animationDuration = this.clamp(20.0, 5000.0, ANIMATION_DURATION);
    }

    public final double getAngleRange() {
        return null == this.angleRange ? this._angleRange : this.angleRange.get();
    }

    public final void setAngleRange(double ANGLE_RANGE) {
        if (null == this.angleRange) {
            this._angleRange = this.clamp(0.0, 360.0, ANGLE_RANGE);
        } else {
            this.angleRange.set(ANGLE_RANGE);
        }
    }

    public final DoubleProperty angleRangeProperty() {
        if (null == this.angleRange) {
            this.angleRange = new DoublePropertyBase(this._angleRange){

                public void set(double ANGLE_RANGE) {
                    super.set(RectangularGauge.this.clamp(0.0, 360.0, this.get()));
                }

                public Object getBean() {
                    return this;
                }

                public String getName() {
                    return "angleRange";
                }
            };
        }
        return this.angleRange;
    }

    public final boolean isAutoScale() {
        return null == this.autoScale ? this._autoScale : this.autoScale.get();
    }

    public final void setAutoScale(boolean AUTO_SCALE) {
        if (null == this.autoScale) {
            this._autoScale = AUTO_SCALE;
        } else {
            this.autoScale.set(AUTO_SCALE);
        }
    }

    public final BooleanProperty autoScaleProperty() {
        if (null == this.autoScale) {
            this.autoScale = new BooleanPropertyBase(this._autoScale){

                public void set(boolean AUTO_SCALE) {
                    if (this.get()) {
                        RectangularGauge.this.exactMinValue = RectangularGauge.this.getMinValue();
                        RectangularGauge.this.exactMaxValue = RectangularGauge.this.getMaxValue();
                    } else {
                        RectangularGauge.this.setMinValue(RectangularGauge.this.exactMinValue);
                        RectangularGauge.this.setMaxValue(RectangularGauge.this.exactMaxValue);
                    }
                    super.set(AUTO_SCALE);
                }

                public Object getBean() {
                    return this;
                }

                public String getName() {
                    return "autoScale";
                }
            };
        }
        return this.autoScale;
    }

    public final Color getNeedleColor() {
        return null == this.needleColor ? this._needleColor : (Color)this.needleColor.get();
    }

    public final void setNeedleColor(Color NEEDLE_COLOR) {
        if (null == this.needleColor) {
            this._needleColor = NEEDLE_COLOR;
        } else {
            this.needleColor.set((Object)NEEDLE_COLOR);
        }
    }

    public final ObjectProperty<Color> needleColorProperty() {
        if (null == this.needleColor) {
            this.needleColor = new SimpleObjectProperty((Object)this, "needleColor", (Object)this._needleColor);
        }
        return this.needleColor;
    }

    public final boolean isLedOn() {
        return null == this.ledOn ? false : this.ledOn.get();
    }

    public final void setLedOn(boolean LED_ON) {
        this.ledOnProperty().set(LED_ON);
    }

    public final BooleanProperty ledOnProperty() {
        if (null == this.ledOn) {
            this.ledOn = new BooleanPropertyBase(false){

                protected void invalidated() {
                    RectangularGauge.this.pseudoClassStateChanged(LED_ON_PSEUDO_CLASS, this.get());
                }

                public Object getBean() {
                    return this;
                }

                public String getName() {
                    return "on";
                }
            };
        }
        return this.ledOn;
    }

    public final boolean isBlinking() {
        return null == this.blinking ? false : this.blinking.get();
    }

    public final void setBlinking(boolean BLINKING) {
        this.blinkingProperty().set(BLINKING);
    }

    public final BooleanProperty blinkingProperty() {
        if (null == this.blinking) {
            this.blinking = new BooleanPropertyBase(){

                public void set(boolean BLINKING) {
                    super.set(BLINKING);
                    if (BLINKING) {
                        RectangularGauge.this.timer.start();
                    } else {
                        RectangularGauge.this.timer.stop();
                        RectangularGauge.this.setLedOn(false);
                    }
                }

                public Object getBean() {
                    return RectangularGauge.this;
                }

                public String getName() {
                    return "blinking";
                }
            };
        }
        return this.blinking;
    }

    public final Color getLedColor() {
        return null == this.ledColor ? Color.RED : (Color)this.ledColor.get();
    }

    public final void setLedColor(Color LED_COLOR) {
        this.ledColorProperty().set((Object)LED_COLOR);
    }

    public final ObjectProperty<Color> ledColorProperty() {
        if (null == this.ledColor) {
            this.ledColor = new SimpleObjectProperty((Object)this, "ledColor", (Object)Color.RED);
        }
        return this.ledColor;
    }

    public final boolean isLedVisible() {
        return null == this.ledVisible ? false : this.ledVisible.get();
    }

    public final void setLedVisible(boolean LED_VISIBLE) {
        this.ledVisibleProperty().set(LED_VISIBLE);
    }

    public final BooleanProperty ledVisibleProperty() {
        if (null == this.ledVisible) {
            this.ledVisible = new SimpleBooleanProperty((Object)this, "ledVisible", false);
        }
        return this.ledVisible;
    }

    public final TickLabelOrientation getTickLabelOrientation() {
        return null == this.tickLabelOrientation ? this._tickLabelOrientation : (TickLabelOrientation)((Object)this.tickLabelOrientation.get());
    }

    public final void setTickLabelOrientation(TickLabelOrientation TICK_LABEL_ORIENTATION) {
        if (null == this.tickLabelOrientation) {
            this._tickLabelOrientation = TICK_LABEL_ORIENTATION;
        } else {
            this.tickLabelOrientation.set((Object)TICK_LABEL_ORIENTATION);
        }
    }

    public final ObjectProperty<TickLabelOrientation> tickLabelOrientationProperty() {
        if (null == this.tickLabelOrientation) {
            this.tickLabelOrientation = new SimpleObjectProperty((Object)this, "tickLabelOrientation", (Object)this._tickLabelOrientation);
        }
        return this.tickLabelOrientation;
    }

    public final NumberFormat getNumberFormat() {
        return null == this.numberFormat ? this._numberFormat : (NumberFormat)((Object)this.numberFormat.get());
    }

    public final void setNumberFormat(NumberFormat NUMBER_FORMAT) {
        if (null == this.numberFormat) {
            this._numberFormat = NUMBER_FORMAT;
        } else {
            this.numberFormat.set((Object)NUMBER_FORMAT);
        }
    }

    public final ObjectProperty<NumberFormat> numberFormatProperty() {
        if (null == this.numberFormat) {
            this.numberFormat = new SimpleObjectProperty((Object)this, "numberFormat", (Object)this._numberFormat);
        }
        return this.numberFormat;
    }

    public final double getMajorTickSpace() {
        return null == this.majorTickSpace ? this._majorTickSpace : this.majorTickSpace.get();
    }

    public final void setMajorTickSpace(double MAJOR_TICK_SPACE) {
        if (null == this.majorTickSpace) {
            this._majorTickSpace = MAJOR_TICK_SPACE;
        } else {
            this.majorTickSpace.set(MAJOR_TICK_SPACE);
        }
    }

    public final DoubleProperty majorTickSpaceProperty() {
        if (null == this.majorTickSpace) {
            this.majorTickSpace = new SimpleDoubleProperty((Object)this, "majorTickSpace", this._majorTickSpace);
        }
        return this.majorTickSpace;
    }

    public final double getMinorTickSpace() {
        return null == this.minorTickSpace ? this._minorTickSpace : this.minorTickSpace.get();
    }

    public final void setMinorTickSpace(double MINOR_TICK_SPACE) {
        if (null == this.minorTickSpace) {
            this._minorTickSpace = MINOR_TICK_SPACE;
        } else {
            this.minorTickSpace.set(MINOR_TICK_SPACE);
        }
    }

    public final DoubleProperty minorTickSpaceProperty() {
        if (null == this.minorTickSpace) {
            this.minorTickSpace = new SimpleDoubleProperty((Object)this, "minorTickSpace", this._minorTickSpace);
        }
        return this.minorTickSpace;
    }

    public final boolean isDropShadowEnabled() {
        return null == this.dropShadowEnabled ? this._dropShadowEnabled : this.dropShadowEnabled.get();
    }

    public final void setDropShadowEnabled(boolean DROP_SHADOW_ENABLED) {
        if (null == this.dropShadowEnabled) {
            this._dropShadowEnabled = DROP_SHADOW_ENABLED;
        } else {
            this.dropShadowEnabled.set(DROP_SHADOW_ENABLED);
        }
    }

    public final BooleanProperty dropShadowEnabledProperty() {
        if (null == this.dropShadowEnabled) {
            this.dropShadowEnabled = new SimpleBooleanProperty((Object)this, "dropShadowEnabled", this._dropShadowEnabled);
        }
        return this.dropShadowEnabled;
    }

    public final ObservableList<Section> getSections() {
        return this.sections;
    }

    public final void setSections(List<Section> SECTIONS) {
        this.sections.setAll(SECTIONS);
    }

    public final void setSections(Section ... SECTIONS) {
        this.setSections(Arrays.asList(SECTIONS));
    }

    public final void addSection(Section SECTION) {
        if (!this.sections.contains((Object)SECTION)) {
            this.sections.add((Object)SECTION);
        }
    }

    public final void removeSection(Section SECTION) {
        if (this.sections.contains((Object)SECTION)) {
            this.sections.remove((Object)SECTION);
        }
    }

    public final boolean isSectionsVisible() {
        return null == this.sectionsVisible ? true : this.sectionsVisible.get();
    }

    public final void setSectionsVisible(boolean SECTIONS_VISIBLE) {
        this.sectionsVisibleProperty().set(SECTIONS_VISIBLE);
    }

    public final BooleanProperty sectionsVisibleProperty() {
        if (null == this.sectionsVisible) {
            this.sectionsVisible = new SimpleBooleanProperty((Object)this, "sectionsVisible", true);
        }
        return this.sectionsVisible;
    }

    public final Color getSectionFill0() {
        return null == this.sectionFill0 ? DEFAULT_SECTION_FILL_0 : (Color)this.sectionFill0.get();
    }

    public final void setSectionFill0(Color value) {
        this.sectionFill0Property().set((Object)value);
    }

    public final ObjectProperty<Color> sectionFill0Property() {
        if (null == this.sectionFill0) {
            this.sectionFill0 = new SimpleObjectProperty((Object)this, "sectionFill0", (Object)DEFAULT_SECTION_FILL_0);
        }
        return this.sectionFill0;
    }

    public final Color getSectionFill1() {
        return null == this.sectionFill1 ? DEFAULT_SECTION_FILL_1 : (Color)this.sectionFill1.get();
    }

    public final void setSectionFill1(Color value) {
        this.sectionFill1Property().set((Object)value);
    }

    public final ObjectProperty<Color> sectionFill1Property() {
        if (null == this.sectionFill1) {
            this.sectionFill1 = new SimpleObjectProperty((Object)this, "sectionFill1", (Object)DEFAULT_SECTION_FILL_1);
        }
        return this.sectionFill1;
    }

    public final Color getSectionFill2() {
        return null == this.sectionFill2 ? DEFAULT_SECTION_FILL_2 : (Color)this.sectionFill2.get();
    }

    public final void setSectionFill2(Color value) {
        this.sectionFill2Property().set((Object)value);
    }

    public final ObjectProperty<Color> sectionFill2Property() {
        if (null == this.sectionFill2) {
            this.sectionFill2 = new SimpleObjectProperty((Object)this, "sectionFill2", (Object)DEFAULT_SECTION_FILL_2);
        }
        return this.sectionFill2;
    }

    public final Color getSectionFill3() {
        return null == this.sectionFill3 ? DEFAULT_SECTION_FILL_3 : (Color)this.sectionFill3.get();
    }

    public final void setSectionFill3(Color value) {
        this.sectionFill3Property().set((Object)value);
    }

    public final ObjectProperty<Color> sectionFill3Property() {
        if (null == this.sectionFill3) {
            this.sectionFill3 = new SimpleObjectProperty((Object)this, "sectionFill3", (Object)DEFAULT_SECTION_FILL_3);
        }
        return this.sectionFill3;
    }

    public final Color getSectionFill4() {
        return null == this.sectionFill4 ? DEFAULT_SECTION_FILL_4 : (Color)this.sectionFill4.get();
    }

    public final void setSectionFill4(Color value) {
        this.sectionFill4Property().set((Object)value);
    }

    public final ObjectProperty<Color> sectionFill4Property() {
        if (null == this.sectionFill4) {
            this.sectionFill4 = new SimpleObjectProperty((Object)this, "sectionFill4", (Object)DEFAULT_SECTION_FILL_4);
        }
        return this.sectionFill4;
    }

    public final Color getSectionFill5() {
        return null == this.sectionFill5 ? DEFAULT_SECTION_FILL_5 : (Color)this.sectionFill5.get();
    }

    public final void setSectionFill5(Color value) {
        this.sectionFill5Property().set((Object)value);
    }

    public final ObjectProperty<Color> sectionFill5Property() {
        if (null == this.sectionFill5) {
            this.sectionFill5 = new SimpleObjectProperty((Object)this, "sectionFill5", (Object)DEFAULT_SECTION_FILL_5);
        }
        return this.sectionFill5;
    }

    public final Color getSectionFill6() {
        return null == this.sectionFill6 ? DEFAULT_SECTION_FILL_6 : (Color)this.sectionFill6.get();
    }

    public final void setSectionFill6(Color value) {
        this.sectionFill6Property().set((Object)value);
    }

    public final ObjectProperty<Color> sectionFill6Property() {
        if (null == this.sectionFill6) {
            this.sectionFill6 = new SimpleObjectProperty((Object)this, "sectionFill6", (Object)DEFAULT_SECTION_FILL_6);
        }
        return this.sectionFill6;
    }

    public final Color getSectionFill7() {
        return null == this.sectionFill7 ? DEFAULT_SECTION_FILL_7 : (Color)this.sectionFill7.get();
    }

    public final void setSectionFill7(Color value) {
        this.sectionFill7Property().set((Object)value);
    }

    public final ObjectProperty<Color> sectionFill7Property() {
        if (null == this.sectionFill7) {
            this.sectionFill7 = new SimpleObjectProperty((Object)this, "sectionFill7", (Object)DEFAULT_SECTION_FILL_7);
        }
        return this.sectionFill7;
    }

    public final Color getSectionFill8() {
        return null == this.sectionFill8 ? DEFAULT_SECTION_FILL_8 : (Color)this.sectionFill8.get();
    }

    public final void setSectionFill8(Color value) {
        this.sectionFill8Property().set((Object)value);
    }

    public final ObjectProperty<Color> sectionFill8Property() {
        if (null == this.sectionFill8) {
            this.sectionFill8 = new SimpleObjectProperty((Object)this, "sectionFill8", (Object)DEFAULT_SECTION_FILL_8);
        }
        return this.sectionFill8;
    }

    public final Color getSectionFill9() {
        return null == this.sectionFill9 ? DEFAULT_SECTION_FILL_9 : (Color)this.sectionFill9.get();
    }

    public final void setSectionFill9(Color value) {
        this.sectionFill9Property().set((Object)value);
    }

    public final ObjectProperty<Color> sectionFill9Property() {
        if (null == this.sectionFill9) {
            this.sectionFill9 = new SimpleObjectProperty((Object)this, "sectionFill9", (Object)DEFAULT_SECTION_FILL_9);
        }
        return this.sectionFill9;
    }

    private double clamp(double MIN_VALUE, double MAX_VALUE, double VALUE) {
        if (VALUE < MIN_VALUE) {
            return MIN_VALUE;
        }
        if (VALUE > MAX_VALUE) {
            return MAX_VALUE;
        }
        return VALUE;
    }

    private int clamp(int MIN_VALUE, int MAX_VALUE, int VALUE) {
        if (VALUE < MIN_VALUE) {
            return MIN_VALUE;
        }
        if (VALUE > MAX_VALUE) {
            return MAX_VALUE;
        }
        return VALUE;
    }

    private Duration clamp(Duration MIN_VALUE, Duration MAX_VALUE, Duration VALUE) {
        if (VALUE.lessThan(MIN_VALUE)) {
            return MIN_VALUE;
        }
        if (VALUE.greaterThan(MAX_VALUE)) {
            return MAX_VALUE;
        }
        return VALUE;
    }

    public void calcAutoScale() {
        if (this.isAutoScale()) {
            double maxNoOfMajorTicks = 10.0;
            double maxNoOfMinorTicks = 10.0;
            double niceRange = this.calcNiceNumber(this.getMaxValue() - this.getMinValue(), false);
            this.majorTickSpace.set(this.calcNiceNumber(niceRange / (maxNoOfMajorTicks - 1.0), true));
            double niceMinValue = Math.floor(this.getMinValue() / this.majorTickSpace.doubleValue()) * this.majorTickSpace.doubleValue();
            double niceMaxValue = Math.ceil(this.getMaxValue() / this.majorTickSpace.doubleValue()) * this.majorTickSpace.doubleValue();
            this.minorTickSpace.set(this.calcNiceNumber(this.majorTickSpace.doubleValue() / (maxNoOfMinorTicks - 1.0), true));
            this.setMinValue(niceMinValue);
            this.setMaxValue(niceMaxValue);
        }
    }

    private double calcNiceNumber(double RANGE, boolean ROUND) {
        double EXPONENT = Math.floor(Math.log10(RANGE));
        double FRACTION = RANGE / Math.pow(10.0, EXPONENT);
        double niceFraction = ROUND ? (FRACTION < 1.5 ? 1.0 : (FRACTION < 3.0 ? 2.0 : (FRACTION < 7.0 ? 5.0 : 10.0))) : (Double.compare(FRACTION, 1.0) <= 0 ? 1.0 : (Double.compare(FRACTION, 2.0) <= 0 ? 2.0 : (Double.compare(FRACTION, 5.0) <= 0 ? 5.0 : 10.0)));
        return niceFraction * Math.pow(10.0, EXPONENT);
    }

    public void validate() {
        if (this.getValue() < this.getMinValue()) {
            this.setValue(this.getMinValue());
        }
        if (this.getValue() > this.getMaxValue()) {
            this.setValue(this.getMaxValue());
        }
    }

    public final Paint getTickMarkFill() {
        return null == this.tickMarkFill ? Color.BLACK : (Paint)this.tickMarkFill.get();
    }

    public final void setTickMarkFill(Paint value) {
        this.tickMarkFillProperty().set((Object)value);
    }

    public final ObjectProperty<Paint> tickMarkFillProperty() {
        if (null == this.tickMarkFill) {
            this.tickMarkFill = new StyleableObjectProperty<Paint>((Paint)Color.BLACK){

                public CssMetaData getCssMetaData() {
                    return StyleableProperties.TICK_MARK_FILL;
                }

                public Object getBean() {
                    return RectangularGauge.this;
                }

                public String getName() {
                    return "tickMarkFill";
                }
            };
        }
        return this.tickMarkFill;
    }

    public final Paint getTickLabelFill() {
        return null == this.tickLabelFill ? Color.BLACK : (Paint)this.tickLabelFill.get();
    }

    public final void setTickLabelFill(Paint value) {
        this.tickLabelFillProperty().set((Object)value);
    }

    public final ObjectProperty<Paint> tickLabelFillProperty() {
        if (null == this.tickLabelFill) {
            this.tickLabelFill = new StyleableObjectProperty<Paint>((Paint)Color.BLACK){

                public CssMetaData getCssMetaData() {
                    return StyleableProperties.TICK_LABEL_FILL;
                }

                public Object getBean() {
                    return RectangularGauge.this;
                }

                public String getName() {
                    return "tickLabelFill";
                }
            };
        }
        return this.tickLabelFill;
    }

    protected Skin createDefaultSkin() {
        return new RectangularGaugeSkin(this);
    }

    public String getUserAgentStylesheet() {
        return ((Object)((Object)this)).getClass().getResource("rectangular-gauge.css").toExternalForm();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return RectangularGauge.getClassCssMetaData();
    }

    private static class StyleableProperties {
        private static final CssMetaData<RectangularGauge, Paint> TICK_MARK_FILL = new CssMetaData<RectangularGauge, Paint>("-tick-mark-fill", StyleConverter.getPaintConverter(), (Paint)Color.BLACK){

            public boolean isSettable(RectangularGauge gauge) {
                return null == gauge.tickMarkFill || !gauge.tickMarkFill.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(RectangularGauge gauge) {
                return (StyleableProperty)gauge.tickMarkFillProperty();
            }
        };
        private static final CssMetaData<RectangularGauge, Paint> TICK_LABEL_FILL = new CssMetaData<RectangularGauge, Paint>("-tick-label-fill", StyleConverter.getPaintConverter(), (Paint)Color.BLACK){

            public boolean isSettable(RectangularGauge gauge) {
                return null == gauge.tickLabelFill || !gauge.tickLabelFill.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(RectangularGauge gauge) {
                return (StyleableProperty)gauge.tickLabelFillProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(Control.getClassCssMetaData());
            Collections.addAll(styleables, TICK_MARK_FILL, TICK_LABEL_FILL);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }

    public static enum NumberFormat {
        AUTO("0"),
        STANDARD("0"),
        FRACTIONAL("0.0#"),
        SCIENTIFIC("0.##E0"),
        PERCENTAGE("##0.0%");

        private final DecimalFormat DF;

        private NumberFormat(String FORMAT_STRING) {
            Locale.setDefault(new Locale("en", "US"));
            this.DF = new DecimalFormat(FORMAT_STRING);
        }

        public String format(Number NUMBER) {
            return this.DF.format(NUMBER);
        }
    }

    public static enum TickLabelOrientation {
        ORTHOGONAL,
        HORIZONTAL,
        TANGENT;

    }

    public static enum NeedleType {
        STANDARD("needle-standard");

        public final String STYLE_CLASS;

        private NeedleType(String STYLE_CLASS) {
            this.STYLE_CLASS = STYLE_CLASS;
        }
    }
}

