/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.gauge.skin;

import eu.hansolo.enzo.common.Marker;
import eu.hansolo.enzo.common.Section;
import eu.hansolo.enzo.common.ValueEvent;
import eu.hansolo.enzo.fonts.Fonts;
import eu.hansolo.enzo.gauge.Gauge;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.stream.IntStream;
import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.ParallelTransition;
import javafx.animation.PauseTransition;
import javafx.animation.SequentialTransition;
import javafx.animation.Timeline;
import javafx.beans.value.WritableValue;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.Point2D;
import javafx.geometry.VPos;
import javafx.scene.CacheHint;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.effect.Blend;
import javafx.scene.effect.BlendMode;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.effect.InnerShadow;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TouchEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.Path;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;
import javafx.util.Duration;

public class GaugeSkin
extends SkinBase<Gauge>
implements Skin<Gauge> {
    private static final double PREFERRED_WIDTH = 200.0;
    private static final double PREFERRED_HEIGHT = 200.0;
    private static final double MINIMUM_WIDTH = 50.0;
    private static final double MINIMUM_HEIGHT = 50.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    private double oldValue;
    private double size;
    private double centerX;
    private double centerY;
    private Pane pane;
    private Region background;
    private Canvas ticksAndSectionsCanvas;
    private GraphicsContext ticksAndSections;
    private Region threshold;
    private Rotate thresholdRotate;
    private boolean thresholdExceeded;
    private Region minMeasuredValue;
    private Rotate minMeasuredValueRotate;
    private Region maxMeasuredValue;
    private Rotate maxMeasuredValueRotate;
    private Region needle;
    private Region needleHighlight;
    private Rotate needleRotate;
    private Region knob;
    private Group shadowGroup;
    private DropShadow dropShadow;
    private Text titleText;
    private Text unitText;
    private Text valueText;
    private DropShadow valueBlendBottomShadow;
    private InnerShadow valueBlendTopShadow;
    private Blend valueBlend;
    private Path histogram;
    private double angleStep;
    private Timeline timeline;
    private double interactiveAngle;
    private EventHandler<MouseEvent> mouseEventHandler;
    private List<Node> markersToRemove;
    private String limitString;
    private Instant lastCall;
    private boolean withinSpeedLimit;

    public GaugeSkin(Gauge gauge) {
        super((Control)gauge);
        this.angleStep = gauge.getAngleRange() / (gauge.getMaxValue() - gauge.getMinValue());
        this.timeline = new Timeline();
        this.mouseEventHandler = mouseEvent -> this.handleMouseEvent((MouseEvent)mouseEvent);
        this.markersToRemove = new ArrayList<Node>();
        this.oldValue = ((Gauge)this.getSkinnable()).getValue();
        this.limitString = "";
        this.lastCall = Instant.now();
        this.withinSpeedLimit = true;
        this.init();
        this.initGraphics();
        this.registerListeners();
    }

    private void init() {
        if ((Double.compare(((Gauge)this.getSkinnable()).getPrefWidth(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getPrefHeight(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getWidth(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getHeight(), 0.0) <= 0) && ((Gauge)this.getSkinnable()).getPrefWidth() < 0.0 && ((Gauge)this.getSkinnable()).getPrefHeight() < 0.0) {
            ((Gauge)this.getSkinnable()).setPrefSize(200.0, 200.0);
        }
        if (Double.compare(((Gauge)this.getSkinnable()).getMinWidth(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getMinHeight(), 0.0) <= 0) {
            ((Gauge)this.getSkinnable()).setMinSize(50.0, 50.0);
        }
        if (Double.compare(((Gauge)this.getSkinnable()).getMaxWidth(), 0.0) <= 0 || Double.compare(((Gauge)this.getSkinnable()).getMaxHeight(), 0.0) <= 0) {
            ((Gauge)this.getSkinnable()).setMaxSize(1024.0, 1024.0);
        }
    }

    private void initGraphics() {
        this.valueBlendBottomShadow = new DropShadow();
        this.valueBlendBottomShadow.setBlurType(BlurType.TWO_PASS_BOX);
        this.valueBlendBottomShadow.setColor(Color.rgb((int)255, (int)255, (int)255, (double)0.5));
        this.valueBlendBottomShadow.setOffsetX(0.0);
        this.valueBlendBottomShadow.setOffsetY(1.0);
        this.valueBlendBottomShadow.setRadius(0.0);
        this.valueBlendTopShadow = new InnerShadow();
        this.valueBlendTopShadow.setBlurType(BlurType.TWO_PASS_BOX);
        this.valueBlendTopShadow.setColor(Color.rgb((int)0, (int)0, (int)0, (double)0.7));
        this.valueBlendTopShadow.setOffsetX(0.0);
        this.valueBlendTopShadow.setOffsetY(1.0);
        this.valueBlendTopShadow.setRadius(1.0);
        this.valueBlend = new Blend();
        this.valueBlend.setMode(BlendMode.MULTIPLY);
        this.valueBlend.setBottomInput((Effect)this.valueBlendBottomShadow);
        this.valueBlend.setTopInput((Effect)this.valueBlendTopShadow);
        this.background = new Region();
        this.background.getStyleClass().setAll((Object[])new String[]{"background"});
        this.ticksAndSectionsCanvas = new Canvas(200.0, 200.0);
        this.ticksAndSections = this.ticksAndSectionsCanvas.getGraphicsContext2D();
        this.histogram = new Path();
        this.histogram.setFillRule(FillRule.NON_ZERO);
        this.histogram.getStyleClass().add((Object)"histogram-fill");
        this.minMeasuredValue = new Region();
        this.minMeasuredValue.getStyleClass().setAll((Object[])new String[]{"min-measured-value"});
        this.minMeasuredValueRotate = new Rotate(180.0 - ((Gauge)this.getSkinnable()).getStartAngle() + (((Gauge)this.getSkinnable()).getValue() - ((Gauge)this.getSkinnable()).getMinValue()) * this.angleStep);
        this.minMeasuredValue.getTransforms().setAll((Object[])new Transform[]{this.minMeasuredValueRotate});
        this.minMeasuredValue.setOpacity(((Gauge)this.getSkinnable()).isMinMeasuredValueVisible() ? 1.0 : 0.0);
        this.minMeasuredValue.setManaged(((Gauge)this.getSkinnable()).isMinMeasuredValueVisible());
        this.maxMeasuredValue = new Region();
        this.maxMeasuredValue.getStyleClass().setAll((Object[])new String[]{"max-measured-value"});
        this.maxMeasuredValueRotate = new Rotate(180.0 - ((Gauge)this.getSkinnable()).getStartAngle() + (((Gauge)this.getSkinnable()).getValue() - ((Gauge)this.getSkinnable()).getMinValue()) * this.angleStep);
        this.maxMeasuredValue.getTransforms().setAll((Object[])new Transform[]{this.maxMeasuredValueRotate});
        this.maxMeasuredValue.setOpacity(((Gauge)this.getSkinnable()).isMaxMeasuredValueVisible() ? 1.0 : 0.0);
        this.maxMeasuredValue.setManaged(((Gauge)this.getSkinnable()).isMaxMeasuredValueVisible());
        this.threshold = new Region();
        this.threshold.getStyleClass().setAll((Object[])new String[]{"threshold"});
        this.thresholdRotate = new Rotate(180.0 - ((Gauge)this.getSkinnable()).getStartAngle() - ((Gauge)this.getSkinnable()).getMinValue() * this.angleStep);
        this.threshold.getTransforms().setAll((Object[])new Transform[]{this.thresholdRotate});
        this.threshold.setOpacity(((Gauge)this.getSkinnable()).isThresholdVisible() ? 1.0 : 0.0);
        this.threshold.setManaged(((Gauge)this.getSkinnable()).isThresholdVisible());
        this.thresholdExceeded = false;
        this.angleStep = ((Gauge)this.getSkinnable()).getAngleRange() / (((Gauge)this.getSkinnable()).getMaxValue() - ((Gauge)this.getSkinnable()).getMinValue());
        double targetAngle = 180.0 - ((Gauge)this.getSkinnable()).getStartAngle() + (((Gauge)this.getSkinnable()).getValue() - ((Gauge)this.getSkinnable()).getMinValue()) * this.angleStep;
        targetAngle = this.clamp(180.0 - ((Gauge)this.getSkinnable()).getStartAngle(), 180.0 - ((Gauge)this.getSkinnable()).getStartAngle() + ((Gauge)this.getSkinnable()).getAngleRange(), targetAngle);
        this.needle = new Region();
        this.needle.getStyleClass().setAll((Object[])new String[]{Gauge.STYLE_CLASS_NEEDLE_STANDARD});
        this.needleRotate = new Rotate(180.0 - ((Gauge)this.getSkinnable()).getStartAngle());
        this.needleRotate.setAngle(targetAngle);
        this.needle.getTransforms().setAll((Object[])new Transform[]{this.needleRotate});
        this.needleHighlight = new Region();
        this.needleHighlight.setMouseTransparent(true);
        this.needleHighlight.getStyleClass().setAll((Object[])new String[]{"needle-highlight"});
        this.needleHighlight.getTransforms().setAll((Object[])new Transform[]{this.needleRotate});
        this.knob = new Region();
        this.knob.setPickOnBounds(false);
        this.knob.getStyleClass().setAll((Object[])new String[]{"knob"});
        this.dropShadow = new DropShadow();
        this.dropShadow.setColor(Color.rgb((int)0, (int)0, (int)0, (double)0.25));
        this.dropShadow.setBlurType(BlurType.TWO_PASS_BOX);
        this.dropShadow.setRadius(3.0);
        this.dropShadow.setOffsetY(3.0);
        this.shadowGroup = new Group(new Node[]{this.needle, this.needleHighlight});
        this.shadowGroup.setEffect((Effect)(((Gauge)this.getSkinnable()).isDropShadowEnabled() ? this.dropShadow : null));
        this.titleText = new Text(((Gauge)this.getSkinnable()).getTitle());
        this.titleText.setTextOrigin(VPos.CENTER);
        this.titleText.getStyleClass().setAll((Object[])new String[]{"title"});
        this.unitText = new Text(((Gauge)this.getSkinnable()).getUnit());
        this.unitText.setMouseTransparent(true);
        this.unitText.setTextOrigin(VPos.CENTER);
        this.unitText.getStyleClass().setAll((Object[])new String[]{"unit"});
        this.valueText = new Text(String.format(Locale.US, "%." + ((Gauge)this.getSkinnable()).getDecimals() + "f", ((Gauge)this.getSkinnable()).getValue()));
        this.valueText.setMouseTransparent(true);
        this.valueText.setTextOrigin(VPos.CENTER);
        this.valueText.getStyleClass().setAll((Object[])new String[]{"value"});
        this.valueText.setEffect((Effect)(((Gauge)this.getSkinnable()).isPlainValue() ? null : this.valueBlend));
        this.pane = new Pane();
        this.pane.getChildren().setAll((Object[])new Node[]{this.background, this.histogram, this.ticksAndSectionsCanvas, this.minMeasuredValue, this.maxMeasuredValue, this.threshold, this.titleText, this.shadowGroup, this.knob, this.unitText, this.valueText});
        this.pane.getChildren().addAll((Collection)((Gauge)this.getSkinnable()).getMarkers().keySet());
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    private void registerListeners() {
        ((Gauge)this.getSkinnable()).widthProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((Gauge)this.getSkinnable()).heightProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((Gauge)this.getSkinnable()).minMeasuredValueProperty().addListener(observable -> this.handleControlPropertyChanged("MIN_MEASURED_VALUE"));
        ((Gauge)this.getSkinnable()).minMeasuredValueVisibleProperty().addListener(observable -> this.handleControlPropertyChanged("MIN_MEASURED_VALUE_VISIBLE"));
        ((Gauge)this.getSkinnable()).maxMeasuredValueProperty().addListener(observable -> this.handleControlPropertyChanged("MAX_MEASURED_VALUE"));
        ((Gauge)this.getSkinnable()).maxMeasuredValueVisibleProperty().addListener(observable -> this.handleControlPropertyChanged("MAX_MEASURED_VALUE_VISIBLE"));
        ((Gauge)this.getSkinnable()).tickLabelOrientationProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((Gauge)this.getSkinnable()).needleTypeProperty().addListener(observable -> this.handleControlPropertyChanged("NEEDLE_TYPE"));
        ((Gauge)this.getSkinnable()).needleColorProperty().addListener(observable -> this.handleControlPropertyChanged("NEEDLE_COLOR"));
        ((Gauge)this.getSkinnable()).animatedProperty().addListener(observable -> this.handleControlPropertyChanged("ANIMATED"));
        ((Gauge)this.getSkinnable()).thresholdProperty().addListener(observable -> this.handleControlPropertyChanged("THRESHOLD"));
        ((Gauge)this.getSkinnable()).thresholdVisibleProperty().addListener(observable -> this.handleControlPropertyChanged("THRESHOLD_VISIBLE"));
        ((Gauge)this.getSkinnable()).angleRangeProperty().addListener(observable -> this.handleControlPropertyChanged("ANGLE_RANGE"));
        ((Gauge)this.getSkinnable()).numberFormatProperty().addListener(observable -> this.handleControlPropertyChanged("RECALC"));
        ((Gauge)this.getSkinnable()).plainValueProperty().addListener(observable -> this.handleControlPropertyChanged("PLAIN_VALUE"));
        ((Gauge)this.getSkinnable()).histogramEnabledProperty().addListener(observable -> this.handleControlPropertyChanged("HISTOGRAM"));
        ((Gauge)this.getSkinnable()).dropShadowEnabledProperty().addListener(observable -> this.handleControlPropertyChanged("DROP_SHADOW"));
        ((Gauge)this.getSkinnable()).interactiveProperty().addListener(observable -> this.handleControlPropertyChanged("INTERACTIVE"));
        ((Gauge)this.getSkinnable()).getSections().addListener(change -> this.handleControlPropertyChanged("CANVAS_REFRESH"));
        ((Gauge)this.getSkinnable()).getAreas().addListener(change -> this.handleControlPropertyChanged("CANVAS_REFRESH"));
        ((Gauge)this.getSkinnable()).getMarkers().addListener(change -> this.handleControlPropertyChanged("MARKER"));
        ((Gauge)this.getSkinnable()).markersVisibleProperty().addListener(observable -> this.handleControlPropertyChanged("MARKER"));
        ((Gauge)this.getSkinnable()).sectionsVisibleProperty().addListener(observable -> this.handleControlPropertyChanged("CANVAS_REFRESH"));
        ((Gauge)this.getSkinnable()).areasVisibleProperty().addListener(observable -> this.handleControlPropertyChanged("CANVAS_REFRESH"));
        ((Gauge)this.getSkinnable()).customKnobClickHandlerProperty().addListener(observable -> this.handleControlPropertyChanged("CUSTOM_KNOB_CLICK_HANDLER"));
        ((Gauge)this.getSkinnable()).valueProperty().addListener((OV, OLD_VALUE, NEW_VALUE) -> {
            this.withinSpeedLimit = !Instant.now().minusMillis((long)((Gauge)this.getSkinnable()).getAnimationDuration()).isBefore(this.lastCall);
            this.lastCall = Instant.now();
            this.oldValue = OLD_VALUE.doubleValue();
            this.rotateNeedle();
        });
        ((Gauge)this.getSkinnable()).minValueProperty().addListener((OV, OLD_VALUE, NEW_VALUE) -> {
            this.angleStep = ((Gauge)this.getSkinnable()).getAngleRange() / (((Gauge)this.getSkinnable()).getMaxValue() - NEW_VALUE.doubleValue());
            this.needleRotate.setAngle(180.0 - ((Gauge)this.getSkinnable()).getStartAngle() + (((Gauge)this.getSkinnable()).getValue() - NEW_VALUE.doubleValue()) * this.angleStep);
            if (((Gauge)this.getSkinnable()).getValue() < NEW_VALUE.doubleValue()) {
                ((Gauge)this.getSkinnable()).setValue(NEW_VALUE.doubleValue());
                this.oldValue = NEW_VALUE.doubleValue();
            }
        });
        ((Gauge)this.getSkinnable()).maxValueProperty().addListener((OV, OLD_VALUE, NEW_VALUE) -> {
            this.angleStep = ((Gauge)this.getSkinnable()).getAngleRange() / (NEW_VALUE.doubleValue() - ((Gauge)this.getSkinnable()).getMinValue());
            this.needleRotate.setAngle(180.0 - ((Gauge)this.getSkinnable()).getStartAngle() + (((Gauge)this.getSkinnable()).getValue() - ((Gauge)this.getSkinnable()).getMinValue()) * this.angleStep);
            if (((Gauge)this.getSkinnable()).getValue() > NEW_VALUE.doubleValue()) {
                ((Gauge)this.getSkinnable()).setValue(NEW_VALUE.doubleValue());
                this.oldValue = NEW_VALUE.doubleValue();
            }
        });
        ((Gauge)this.getSkinnable()).limitProperty().addListener(observable -> this.handleControlPropertyChanged("LIMIT"));
        this.needleRotate.angleProperty().addListener(observable -> this.handleControlPropertyChanged("ANGLE"));
        if (null == ((Gauge)this.getSkinnable()).getCustomKnobClickHandler()) {
            this.knob.setOnMousePressed(event -> {
                this.timeline.stop();
                this.needleRotate.setAngle(180.0 - ((Gauge)this.getSkinnable()).getStartAngle() + (((Gauge)this.getSkinnable()).getValue() - ((Gauge)this.getSkinnable()).getMinValue()) * this.angleStep);
                ((Gauge)this.getSkinnable()).setInteractive(!((Gauge)this.getSkinnable()).isInteractive());
            });
        } else {
            this.knob.setOnMousePressed(((Gauge)this.getSkinnable()).getCustomKnobClickHandler());
        }
        this.minMeasuredValue.setOnMousePressed(this.mouseEventHandler);
        this.minMeasuredValue.setOnMouseReleased(this.mouseEventHandler);
        this.maxMeasuredValue.setOnMousePressed(this.mouseEventHandler);
        this.maxMeasuredValue.setOnMouseReleased(this.mouseEventHandler);
        this.threshold.setOnMousePressed(this.mouseEventHandler);
        this.threshold.setOnMouseDragged(this.mouseEventHandler);
        this.threshold.setOnMouseReleased(this.mouseEventHandler);
        for (Marker marker : ((Gauge)this.getSkinnable()).getMarkers().keySet()) {
            marker.setOnMousePressed(this.mouseEventHandler);
            marker.setOnMouseDragged(this.mouseEventHandler);
            marker.setOnMouseReleased(this.mouseEventHandler);
        }
    }

    protected void handleControlPropertyChanged(String PROPERTY) {
        if ("RESIZE".equals(PROPERTY)) {
            this.resize();
        } else if ("ANGLE".equals(PROPERTY)) {
            if (((Gauge)this.getSkinnable()).isInteractive()) {
                return;
            }
            double currentValue = (this.needleRotate.getAngle() + ((Gauge)this.getSkinnable()).getStartAngle() - 180.0) / this.angleStep + ((Gauge)this.getSkinnable()).getMinValue();
            this.valueText.setText(this.limitString + String.format(Locale.US, "%." + ((Gauge)this.getSkinnable()).getDecimals() + "f", currentValue));
            this.valueText.setTranslateX((this.size - this.valueText.getLayoutBounds().getWidth()) * 0.5);
            if (this.thresholdExceeded) {
                if (currentValue < ((Gauge)this.getSkinnable()).getThreshold()) {
                    ((Gauge)this.getSkinnable()).fireEvent(new ValueEvent((Object)this, null, ValueEvent.VALUE_UNDERRUN));
                    this.thresholdExceeded = false;
                }
            } else if (currentValue > ((Gauge)this.getSkinnable()).getThreshold()) {
                ((Gauge)this.getSkinnable()).fireEvent(new ValueEvent((Object)this, null, ValueEvent.VALUE_EXCEEDED));
                this.thresholdExceeded = true;
            }
            for (Marker marker : ((Gauge)this.getSkinnable()).getMarkers().keySet()) {
                if (marker.isExceeded()) {
                    if (!(currentValue < marker.getValue())) continue;
                    marker.fireMarkerEvent(new Marker.MarkerEvent((Object)this, null, Marker.MarkerEvent.MARKER_UNDERRUN));
                    marker.setExceeded(false);
                    continue;
                }
                if (!(currentValue > marker.getValue())) continue;
                marker.fireMarkerEvent(new Marker.MarkerEvent((Object)this, null, Marker.MarkerEvent.MARKER_EXCEEDED));
                marker.setExceeded(true);
            }
            if (currentValue < ((Gauge)this.getSkinnable()).getMinMeasuredValue()) {
                ((Gauge)this.getSkinnable()).setMinMeasuredValue(currentValue);
                this.minMeasuredValueRotate.setAngle(currentValue * this.angleStep - 180.0 - ((Gauge)this.getSkinnable()).getStartAngle() - ((Gauge)this.getSkinnable()).getMinValue() * this.angleStep);
            }
            if (currentValue > ((Gauge)this.getSkinnable()).getMaxMeasuredValue()) {
                ((Gauge)this.getSkinnable()).setMaxMeasuredValue(currentValue);
                this.maxMeasuredValueRotate.setAngle(currentValue * this.angleStep - 180.0 - ((Gauge)this.getSkinnable()).getStartAngle() - ((Gauge)this.getSkinnable()).getMinValue() * this.angleStep);
            }
            for (Section section : ((Gauge)this.getSkinnable()).getSections()) {
                if (!section.contains(currentValue)) continue;
                section.fireSectionEvent(new Section.SectionEvent(section, null, Section.SectionEvent.ENTERING_SECTION));
                break;
            }
            for (Section area : ((Gauge)this.getSkinnable()).getAreas()) {
                if (!area.contains(currentValue)) continue;
                area.fireSectionEvent(new Section.SectionEvent(area, null, Section.SectionEvent.ENTERING_SECTION));
                break;
            }
        } else if ("PLAIN_VALUE".equals(PROPERTY)) {
            this.valueText.setEffect((Effect)(((Gauge)this.getSkinnable()).isPlainValue() ? null : this.valueBlend));
        } else if ("HISTOGRAM".equals(PROPERTY)) {
            this.histogram.setVisible(((Gauge)this.getSkinnable()).isHistogramEnabled());
            this.histogram.setManaged(((Gauge)this.getSkinnable()).isHistogramEnabled());
        } else if ("DROP_SHADOW".equals(PROPERTY)) {
            this.shadowGroup.setEffect((Effect)(((Gauge)this.getSkinnable()).isDropShadowEnabled() ? this.dropShadow : null));
        } else if ("INTERACTIVE".equals(PROPERTY)) {
            this.needle.setMouseTransparent(((Gauge)this.getSkinnable()).isInteractive());
            if (((Gauge)this.getSkinnable()).isInteractive()) {
                this.unitText.setText("Interactive");
                this.valueText.setText("");
                this.resizeText();
                this.shadowGroup.setEffect(null);
            } else {
                this.unitText.setText(((Gauge)this.getSkinnable()).getUnit());
                this.valueText.setText(String.format(Locale.US, "%." + ((Gauge)this.getSkinnable()).getDecimals() + "f", (this.needleRotate.getAngle() + ((Gauge)this.getSkinnable()).getStartAngle() - 180.0) / this.angleStep));
                this.resizeText();
                this.shadowGroup.setEffect((Effect)this.dropShadow);
            }
        } else if ("CANVAS_REFRESH".equals(PROPERTY)) {
            this.ticksAndSections.clearRect(0.0, 0.0, this.size, this.size);
            this.drawSections(this.ticksAndSections);
            this.drawAreas(this.ticksAndSections);
            this.drawTickMarks(this.ticksAndSections);
        } else if ("THRESHOLD".equals(PROPERTY)) {
            this.thresholdRotate.setAngle(((Gauge)this.getSkinnable()).getThreshold() * this.angleStep - 180.0 - ((Gauge)this.getSkinnable()).getStartAngle());
        } else if ("THRESHOLD_VISIBLE".equals(PROPERTY)) {
            this.threshold.setOpacity(((Gauge)this.getSkinnable()).isThresholdVisible() ? 1.0 : 0.0);
            this.threshold.setManaged(((Gauge)this.getSkinnable()).isThresholdVisible());
        } else if ("MIN_MEASURED_VALUE_VISIBLE".equals(PROPERTY)) {
            this.minMeasuredValue.setOpacity(((Gauge)this.getSkinnable()).isMinMeasuredValueVisible() ? 1.0 : 0.0);
            this.minMeasuredValue.setManaged(((Gauge)this.getSkinnable()).isMinMeasuredValueVisible());
        } else if ("MAX_MEASURED_VALUE_VISIBLE".equals(PROPERTY)) {
            this.maxMeasuredValue.setOpacity(((Gauge)this.getSkinnable()).isMaxMeasuredValueVisible() ? 1.0 : 0.0);
            this.maxMeasuredValue.setManaged(((Gauge)this.getSkinnable()).isMaxMeasuredValueVisible());
        } else if ("MARKER".equals(PROPERTY)) {
            this.checkForRemovedMarkers();
            for (Marker marker : ((Gauge)this.getSkinnable()).getMarkers().keySet()) {
                if (this.pane.getChildren().contains((Object)marker)) continue;
                this.pane.getChildren().add((Object)marker);
                marker.setOnMousePressed(this.mouseEventHandler);
                marker.setOnMouseDragged(this.mouseEventHandler);
                marker.setOnMouseReleased(this.mouseEventHandler);
            }
            this.drawMarkers();
        } else if ("LIMIT".equals(PROPERTY)) {
            switch (((Gauge)this.getSkinnable()).getLimit()) {
                case EXCEEDED: {
                    this.limitString = ">";
                    break;
                }
                case IN_RANGE: {
                    this.limitString = "";
                    break;
                }
                case UNDERRUN: {
                    this.limitString = "<";
                }
            }
        } else if ("CUSTOM_KNOB_CLICK_HANDLER".equals(PROPERTY)) {
            if (null == ((Gauge)this.getSkinnable()).getCustomKnobClickHandler()) {
                this.knob.setOnMousePressed(event -> {
                    this.timeline.stop();
                    this.needleRotate.setAngle(180.0 - ((Gauge)this.getSkinnable()).getStartAngle() + (((Gauge)this.getSkinnable()).getValue() - ((Gauge)this.getSkinnable()).getMinValue()) * this.angleStep);
                    ((Gauge)this.getSkinnable()).setInteractive(!((Gauge)this.getSkinnable()).isInteractive());
                });
            } else {
                this.knob.setOnMousePressed(((Gauge)this.getSkinnable()).getCustomKnobClickHandler());
            }
        }
    }

    private void checkForRemovedMarkers() {
        this.markersToRemove.clear();
        for (Node node : this.pane.getChildren()) {
            if (!(node instanceof Marker) || ((Gauge)this.getSkinnable()).getMarkers().keySet().contains(node)) continue;
            node.setManaged(false);
            node.removeEventHandler(MouseEvent.MOUSE_PRESSED, this.mouseEventHandler);
            node.removeEventHandler(MouseEvent.MOUSE_DRAGGED, this.mouseEventHandler);
            node.removeEventHandler(MouseEvent.MOUSE_RELEASED, this.mouseEventHandler);
            this.markersToRemove.add(node);
        }
        for (Node node : this.markersToRemove) {
            this.pane.getChildren().remove((Object)node);
        }
    }

    private void handleMouseEvent(MouseEvent MOUSE_EVENT) {
        Object SRC = MOUSE_EVENT.getSource();
        EventType TYPE = MOUSE_EVENT.getEventType();
        if (((Gauge)this.getSkinnable()).isInteractive() && SRC.equals(this.threshold)) {
            if (MouseEvent.MOUSE_PRESSED == TYPE) {
                this.unitText.setText("Threshold");
                this.valueText.setText(String.format(Locale.US, "%." + ((Gauge)this.getSkinnable()).getDecimals() + "f", ((Gauge)this.getSkinnable()).getThreshold()));
                this.resizeText();
            } else if (MouseEvent.MOUSE_DRAGGED == TYPE) {
                Point2D point = ((Gauge)this.getSkinnable()).sceneToLocal(MOUSE_EVENT.getSceneX(), MOUSE_EVENT.getSceneY());
                this.touchRotate(point.getX(), point.getY(), this.thresholdRotate);
            } else if (MouseEvent.MOUSE_RELEASED == TYPE) {
                ((Gauge)this.getSkinnable()).setThreshold(Double.parseDouble(this.valueText.getText()));
                this.fadeBackToInteractive();
            }
        } else if (((Gauge)this.getSkinnable()).isInteractive() && SRC instanceof Marker) {
            if (MouseEvent.MOUSE_PRESSED == TYPE) {
                this.unitText.setText(((Marker)((Object)SRC)).getText());
                this.valueText.setText(String.format(Locale.US, "%." + ((Gauge)this.getSkinnable()).getDecimals() + "f", ((Marker)((Object)SRC)).getValue()));
                this.resizeText();
            } else if (MouseEvent.MOUSE_DRAGGED == TYPE) {
                Point2D point = ((Gauge)this.getSkinnable()).sceneToLocal(MOUSE_EVENT.getSceneX(), MOUSE_EVENT.getSceneY());
                this.touchRotate(point.getX(), point.getY(), (Rotate)((Gauge)this.getSkinnable()).getMarkers().get(SRC));
            } else if (MouseEvent.MOUSE_RELEASED == TYPE) {
                ((Marker)((Object)SRC)).setValue(Double.parseDouble(this.valueText.getText()));
                this.fadeBackToInteractive();
            }
        } else if (((Gauge)this.getSkinnable()).isInteractive() && SRC.equals(this.minMeasuredValue)) {
            if (MouseEvent.MOUSE_PRESSED == TYPE) {
                this.unitText.setText("Min");
                this.valueText.setText(String.format(Locale.US, "%." + ((Gauge)this.getSkinnable()).getDecimals() + "f", ((Gauge)this.getSkinnable()).getMinMeasuredValue()));
                this.resizeText();
            } else if (MouseEvent.MOUSE_RELEASED == TYPE) {
                this.fadeBackToInteractive();
            }
        } else if (((Gauge)this.getSkinnable()).isInteractive() && SRC.equals(this.maxMeasuredValue)) {
            if (MouseEvent.MOUSE_PRESSED == TYPE) {
                this.unitText.setText("Max");
                this.valueText.setText(String.format(Locale.US, "%." + ((Gauge)this.getSkinnable()).getDecimals() + "f", ((Gauge)this.getSkinnable()).getMaxMeasuredValue()));
                this.resizeText();
            } else if (MouseEvent.MOUSE_RELEASED == TYPE) {
                this.fadeBackToInteractive();
            }
        }
    }

    private void handleTouchEvent(TouchEvent TOUCH_EVENT) {
        Object SRC = TOUCH_EVENT.getSource();
        EventType TYPE = TOUCH_EVENT.getEventType();
        if (SRC.equals(this.threshold)) {
            if (TouchEvent.TOUCH_PRESSED == TYPE) {
                this.unitText.setText("Threshold");
                this.valueText.setText(String.format(Locale.US, "%." + ((Gauge)this.getSkinnable()).getDecimals() + "f", ((Gauge)this.getSkinnable()).getThreshold()));
                this.resizeText();
            } else if (TouchEvent.TOUCH_MOVED == TYPE) {
                Point2D point = ((Gauge)this.getSkinnable()).sceneToLocal(TOUCH_EVENT.getTouchPoint().getSceneX(), TOUCH_EVENT.getTouchPoint().getSceneY());
                this.touchRotate(point.getX(), point.getY(), this.thresholdRotate);
            } else if (TouchEvent.TOUCH_RELEASED == TYPE) {
                ((Gauge)this.getSkinnable()).setThreshold(Double.parseDouble(this.valueText.getText()));
                this.fadeBackToInteractive();
            }
        } else if (SRC instanceof Marker) {
            if (TouchEvent.TOUCH_PRESSED == TYPE) {
                this.unitText.setText(((Marker)((Object)SRC)).getText());
                this.valueText.setText(String.format(Locale.US, "%." + ((Gauge)this.getSkinnable()).getDecimals() + "f", ((Marker)((Object)SRC)).getValue()));
                this.resizeText();
            } else if (TouchEvent.TOUCH_MOVED == TYPE) {
                Point2D point = ((Gauge)this.getSkinnable()).sceneToLocal(TOUCH_EVENT.getTouchPoint().getSceneX(), TOUCH_EVENT.getTouchPoint().getSceneY());
                this.touchRotate(point.getX(), point.getY(), (Rotate)((Gauge)this.getSkinnable()).getMarkers().get(SRC));
            } else if (TouchEvent.TOUCH_RELEASED == TYPE) {
                ((Marker)((Object)SRC)).setValue(Double.parseDouble(this.valueText.getText()));
                this.fadeBackToInteractive();
            }
        } else if (SRC.equals(this.minMeasuredValue)) {
            if (TouchEvent.TOUCH_PRESSED == TYPE) {
                this.unitText.setText("Min");
                this.valueText.setText(String.format(Locale.US, "%." + ((Gauge)this.getSkinnable()).getDecimals() + "f", ((Gauge)this.getSkinnable()).getMinMeasuredValue()));
                this.resizeText();
            } else if (TouchEvent.TOUCH_RELEASED == TYPE) {
                this.fadeBackToInteractive();
            }
        } else if (SRC.equals(this.maxMeasuredValue)) {
            if (TouchEvent.TOUCH_PRESSED == TYPE) {
                this.unitText.setText("Max");
                this.valueText.setText(String.format(Locale.US, "%." + ((Gauge)this.getSkinnable()).getDecimals() + "f", ((Gauge)this.getSkinnable()).getMaxMeasuredValue()));
                this.resizeText();
            } else if (TouchEvent.TOUCH_RELEASED == TYPE) {
                this.fadeBackToInteractive();
            }
        }
    }

    private double getTheta(double x, double y) {
        double nx;
        double radius;
        double deltaX = x - ((Gauge)this.getSkinnable()).getWidth() * 0.5;
        double deltaY = y - ((Gauge)this.getSkinnable()).getHeight() * 0.5;
        double ny = deltaY / (radius = Math.sqrt(deltaX * deltaX + deltaY * deltaY));
        double theta = Math.atan2(ny, nx = deltaX / radius);
        return Double.compare(theta, 0.0) >= 0 ? Math.toDegrees(theta) : Math.toDegrees(theta) + 360.0;
    }

    private void touchRotate(double X, double Y, Rotate ROTATE) {
        double newValue;
        double theta = this.getTheta(X, Y);
        this.interactiveAngle = (theta + 90.0) % 360.0;
        double d = newValue = Double.compare(this.interactiveAngle, 180.0) <= 0 ? (this.interactiveAngle + 180.0 + ((Gauge)this.getSkinnable()).getStartAngle() - 360.0) / this.angleStep + ((Gauge)this.getSkinnable()).getMinValue() : (this.interactiveAngle - 180.0 + ((Gauge)this.getSkinnable()).getStartAngle() - 360.0) / this.angleStep + ((Gauge)this.getSkinnable()).getMinValue();
        if (Double.compare(newValue, ((Gauge)this.getSkinnable()).getMinValue()) >= 0 && Double.compare(newValue, ((Gauge)this.getSkinnable()).getMaxValue()) <= 0) {
            ROTATE.setAngle(this.interactiveAngle);
            this.valueText.setText(String.format(Locale.US, "%." + ((Gauge)this.getSkinnable()).getDecimals() + "f", newValue));
            this.resizeText();
        }
    }

    private void fadeBackToInteractive() {
        FadeTransition fadeUnitOut = new FadeTransition(Duration.millis((double)425.0), (Node)this.unitText);
        fadeUnitOut.setFromValue(1.0);
        fadeUnitOut.setToValue(0.0);
        FadeTransition fadeValueOut = new FadeTransition(Duration.millis((double)425.0), (Node)this.valueText);
        fadeValueOut.setFromValue(1.0);
        fadeValueOut.setToValue(0.0);
        PauseTransition pause = new PauseTransition(Duration.millis((double)50.0));
        FadeTransition fadeUnitIn = new FadeTransition(Duration.millis((double)425.0), (Node)this.unitText);
        fadeUnitIn.setFromValue(0.0);
        fadeUnitIn.setToValue(1.0);
        FadeTransition fadeValueIn = new FadeTransition(Duration.millis((double)425.0), (Node)this.valueText);
        fadeValueIn.setFromValue(0.0);
        fadeValueIn.setToValue(1.0);
        ParallelTransition parallelIn = new ParallelTransition(new Animation[]{fadeUnitIn, fadeValueIn});
        ParallelTransition parallelOut = new ParallelTransition(new Animation[]{fadeUnitOut, fadeValueOut});
        parallelOut.setOnFinished(event -> {
            this.unitText.setText("Interactive");
            this.valueText.setText("");
            this.resizeText();
        });
        SequentialTransition sequence = new SequentialTransition(new Animation[]{parallelOut, pause, parallelIn});
        sequence.play();
    }

    private void rotateNeedle() {
        if (((Gauge)this.getSkinnable()).isInteractive()) {
            return;
        }
        this.timeline.stop();
        this.angleStep = ((Gauge)this.getSkinnable()).getAngleRange() / (((Gauge)this.getSkinnable()).getMaxValue() - ((Gauge)this.getSkinnable()).getMinValue());
        double targetAngle = 180.0 - ((Gauge)this.getSkinnable()).getStartAngle() + (((Gauge)this.getSkinnable()).getValue() - ((Gauge)this.getSkinnable()).getMinValue()) * this.angleStep;
        targetAngle = this.clamp(180.0 - ((Gauge)this.getSkinnable()).getStartAngle(), 180.0 - ((Gauge)this.getSkinnable()).getStartAngle() + ((Gauge)this.getSkinnable()).getAngleRange(), targetAngle);
        if (this.withinSpeedLimit && ((Gauge)this.getSkinnable()).isAnimated()) {
            KeyValue KEY_VALUE = new KeyValue((WritableValue)this.needleRotate.angleProperty(), (Object)targetAngle, Interpolator.SPLINE((double)0.5, (double)0.4, (double)0.4, (double)1.0));
            KeyFrame KEY_FRAME = new KeyFrame(Duration.millis((double)((Gauge)this.getSkinnable()).getAnimationDuration()), new KeyValue[]{KEY_VALUE});
            this.timeline.getKeyFrames().setAll((Object[])new KeyFrame[]{KEY_FRAME});
            this.timeline.play();
        } else {
            this.needleRotate.setAngle(targetAngle);
        }
    }

    private void changeNeedle() {
        switch (((Gauge)this.getSkinnable()).getNeedleType()) {
            default: 
        }
        this.needle.getStyleClass().setAll((Object[])new String[]{Gauge.STYLE_CLASS_NEEDLE_STANDARD});
    }

    private void drawTickMarks(GraphicsContext CTX) {
        if (((Gauge)this.getSkinnable()).isHistogramEnabled()) {
            double step = 0.0;
            double OFFSET = 90.0 - ((Gauge)this.getSkinnable()).getStartAngle();
            double ANGLE_EXTEND = ((Gauge)this.getSkinnable()).getMaxValue() * this.angleStep;
            CTX.setStroke((Paint)Color.rgb((int)200, (int)200, (int)200));
            CTX.setLineWidth(this.size * 0.001);
            CTX.setLineCap(StrokeLineCap.BUTT);
            for (int i = 0; i < 5; ++i) {
                double xy = (this.size - (0.435 + step) * this.size) / 2.0;
                double wh = this.size * (0.435 + step);
                CTX.strokeArc(xy, xy, wh, wh, -OFFSET, -ANGLE_EXTEND, ArcType.OPEN);
                step += 0.075;
            }
        }
        double startAngle = ((Gauge)this.getSkinnable()).getStartAngle();
        double orthText = Gauge.TickLabelOrientation.ORTHOGONAL == ((Gauge)this.getSkinnable()).getTickLabelOrientation() ? 0.33 : 0.31;
        Point2D center = new Point2D(this.size * 0.5, this.size * 0.5);
        boolean smallRange = ((Gauge)this.getSkinnable()).getMaxValue() - ((Gauge)this.getSkinnable()).getMinValue() < 10.0;
        double tmpMinValue = smallRange ? ((Gauge)this.getSkinnable()).getMinValue() * 10.0 : ((Gauge)this.getSkinnable()).getMinValue();
        double tmpMaxValue = smallRange ? ((Gauge)this.getSkinnable()).getMaxValue() * 10.0 : ((Gauge)this.getSkinnable()).getMaxValue();
        double tmpAngleStep = smallRange ? this.angleStep / 10.0 : this.angleStep;
        double angle = 0.0;
        double counter = tmpMinValue;
        while (Double.compare(counter, tmpMaxValue) <= 0) {
            double sinValue = Math.sin(Math.toRadians(angle + startAngle));
            double cosValue = Math.cos(Math.toRadians(angle + startAngle));
            Point2D innerMainPoint = new Point2D(center.getX() + this.size * 0.368 * sinValue, center.getY() + this.size * 0.368 * cosValue);
            Point2D innerMediumPoint = new Point2D(center.getX() + this.size * 0.388 * sinValue, center.getY() + this.size * 0.388 * cosValue);
            Point2D innerMinorPoint = new Point2D(center.getX() + this.size * 0.3975 * sinValue, center.getY() + this.size * 0.3975 * cosValue);
            Point2D outerPoint = new Point2D(center.getX() + this.size * 0.432 * sinValue, center.getY() + this.size * 0.432 * cosValue);
            Point2D textPoint = new Point2D(center.getX() + this.size * orthText * sinValue, center.getY() + this.size * orthText * cosValue);
            CTX.setStroke(((Gauge)this.getSkinnable()).getTickMarkFill());
            if (counter % ((Gauge)this.getSkinnable()).getMajorTickSpace() == 0.0) {
                CTX.setLineWidth(this.size * 0.0055);
                CTX.strokeLine(innerMainPoint.getX(), innerMainPoint.getY(), outerPoint.getX(), outerPoint.getY());
                CTX.save();
                CTX.translate(textPoint.getX(), textPoint.getY());
                switch (((Gauge)this.getSkinnable()).getTickLabelOrientation()) {
                    case ORTHOGONAL: {
                        if ((360.0 - startAngle - angle) % 360.0 > 90.0 && (360.0 - startAngle - angle) % 360.0 < 270.0) {
                            CTX.rotate((180.0 - startAngle - angle) % 360.0);
                            break;
                        }
                        CTX.rotate((360.0 - startAngle - angle) % 360.0);
                        break;
                    }
                    case TANGENT: {
                        if ((360.0 - startAngle - angle - 90.0) % 360.0 > 90.0 && (360.0 - startAngle - angle - 90.0) % 360.0 < 270.0) {
                            CTX.rotate((90.0 - startAngle - angle) % 360.0);
                            break;
                        }
                        CTX.rotate((270.0 - startAngle - angle) % 360.0);
                        break;
                    }
                }
                CTX.setFont(Font.font((String)"Verdana", (FontWeight)FontWeight.NORMAL, (double)(0.045 * this.size)));
                CTX.setTextAlign(TextAlignment.CENTER);
                CTX.setTextBaseline(VPos.CENTER);
                CTX.setFill(((Gauge)this.getSkinnable()).getTickLabelFill());
                CTX.fillText(Integer.toString((int)(smallRange ? counter / 10.0 : counter)), 0.0, 0.0);
                CTX.restore();
            } else if (((Gauge)this.getSkinnable()).getMinorTickSpace() % 2.0 != 0.0 && counter % 5.0 == 0.0) {
                CTX.setLineWidth(this.size * 0.0035);
                CTX.strokeLine(innerMediumPoint.getX(), innerMediumPoint.getY(), outerPoint.getX(), outerPoint.getY());
            } else if (counter % ((Gauge)this.getSkinnable()).getMinorTickSpace() == 0.0) {
                CTX.setLineWidth(this.size * 0.00225);
                CTX.strokeLine(innerMinorPoint.getX(), innerMinorPoint.getY(), outerPoint.getX(), outerPoint.getY());
            }
            angle -= tmpAngleStep;
            counter += 1.0;
        }
    }

    private final void drawSections(GraphicsContext CTX) {
        double xy = (this.size - 0.83 * this.size) / 2.0;
        double wh = this.size * 0.83;
        double MIN_VALUE = ((Gauge)this.getSkinnable()).getMinValue();
        double MAX_VALUE = ((Gauge)this.getSkinnable()).getMaxValue();
        double OFFSET = 90.0 - ((Gauge)this.getSkinnable()).getStartAngle();
        IntStream.range(0, ((Gauge)this.getSkinnable()).getSections().size()).parallel().forEachOrdered(i -> {
            Section SECTION = (Section)((Gauge)this.getSkinnable()).getSections().get(i);
            if (Double.compare(SECTION.getStart(), MAX_VALUE) <= 0 && Double.compare(SECTION.getStop(), MIN_VALUE) >= 0) {
                double SECTION_START_ANGLE = SECTION.getStart() < MIN_VALUE && SECTION.getStop() < MAX_VALUE ? MIN_VALUE * this.angleStep : (SECTION.getStart() - MIN_VALUE) * this.angleStep;
                double SECTION_ANGLE_EXTEND = SECTION.getStop() > MAX_VALUE ? (MAX_VALUE - SECTION.getStart()) * this.angleStep : (SECTION.getStop() - SECTION.getStart()) * this.angleStep;
                CTX.save();
                switch (i) {
                    case 0: {
                        CTX.setStroke(((Gauge)this.getSkinnable()).getSectionFill0());
                        break;
                    }
                    case 1: {
                        CTX.setStroke(((Gauge)this.getSkinnable()).getSectionFill1());
                        break;
                    }
                    case 2: {
                        CTX.setStroke(((Gauge)this.getSkinnable()).getSectionFill2());
                        break;
                    }
                    case 3: {
                        CTX.setStroke(((Gauge)this.getSkinnable()).getSectionFill3());
                        break;
                    }
                    case 4: {
                        CTX.setStroke(((Gauge)this.getSkinnable()).getSectionFill4());
                        break;
                    }
                    case 5: {
                        CTX.setStroke(((Gauge)this.getSkinnable()).getSectionFill5());
                        break;
                    }
                    case 6: {
                        CTX.setStroke(((Gauge)this.getSkinnable()).getSectionFill6());
                        break;
                    }
                    case 7: {
                        CTX.setStroke(((Gauge)this.getSkinnable()).getSectionFill7());
                        break;
                    }
                    case 8: {
                        CTX.setStroke(((Gauge)this.getSkinnable()).getSectionFill8());
                        break;
                    }
                    case 9: {
                        CTX.setStroke(((Gauge)this.getSkinnable()).getSectionFill9());
                    }
                }
                CTX.setLineWidth(this.size * 0.037);
                CTX.setLineCap(StrokeLineCap.BUTT);
                CTX.strokeArc(xy, xy, wh, wh, -(OFFSET + SECTION_START_ANGLE), -SECTION_ANGLE_EXTEND, ArcType.OPEN);
                CTX.restore();
            }
        });
    }

    private final void drawAreas(GraphicsContext CTX) {
        double xy = (this.size - 0.7916 * this.size) / 2.0;
        double wh = this.size * 0.7916;
        double MIN_VALUE = ((Gauge)this.getSkinnable()).getMinValue();
        double MAX_VALUE = ((Gauge)this.getSkinnable()).getMaxValue();
        double OFFSET = 90.0 - ((Gauge)this.getSkinnable()).getStartAngle();
        IntStream.range(0, ((Gauge)this.getSkinnable()).getAreas().size()).parallel().forEachOrdered(i -> {
            Section AREA = (Section)((Gauge)this.getSkinnable()).getAreas().get(i);
            if (Double.compare(AREA.getStart(), MAX_VALUE) <= 0 && Double.compare(AREA.getStop(), MIN_VALUE) >= 0) {
                double AREA_START_ANGLE = AREA.getStart() < MIN_VALUE && AREA.getStop() < MAX_VALUE ? MIN_VALUE * this.angleStep : (AREA.getStart() - MIN_VALUE) * this.angleStep;
                double AREA_ANGLE_EXTEND = AREA.getStop() > MAX_VALUE ? (MAX_VALUE - AREA.getStart()) * this.angleStep : (AREA.getStop() - AREA.getStart()) * this.angleStep;
                CTX.save();
                switch (i) {
                    case 0: {
                        CTX.setFill(((Gauge)this.getSkinnable()).getAreaFill0());
                        break;
                    }
                    case 1: {
                        CTX.setFill(((Gauge)this.getSkinnable()).getAreaFill1());
                        break;
                    }
                    case 2: {
                        CTX.setFill(((Gauge)this.getSkinnable()).getAreaFill2());
                        break;
                    }
                    case 3: {
                        CTX.setFill(((Gauge)this.getSkinnable()).getAreaFill3());
                        break;
                    }
                    case 4: {
                        CTX.setFill(((Gauge)this.getSkinnable()).getAreaFill4());
                        break;
                    }
                    case 5: {
                        CTX.setFill(((Gauge)this.getSkinnable()).getAreaFill5());
                        break;
                    }
                    case 6: {
                        CTX.setFill(((Gauge)this.getSkinnable()).getAreaFill6());
                        break;
                    }
                    case 7: {
                        CTX.setFill(((Gauge)this.getSkinnable()).getAreaFill7());
                        break;
                    }
                    case 8: {
                        CTX.setFill(((Gauge)this.getSkinnable()).getAreaFill8());
                        break;
                    }
                    case 9: {
                        CTX.setFill(((Gauge)this.getSkinnable()).getAreaFill9());
                    }
                }
                CTX.fillArc(xy, xy, wh, wh, -(OFFSET + AREA_START_ANGLE), -AREA_ANGLE_EXTEND, ArcType.ROUND);
                CTX.restore();
            }
        });
    }

    private final void drawMarkers() {
        for (Marker marker : ((Gauge)this.getSkinnable()).getMarkers().keySet()) {
            marker.setPrefSize(0.0325 * this.size, 0.0325 * this.size);
            marker.relocate((this.size - marker.getPrefWidth()) * 0.5, this.size * 0.04);
            ((Rotate)((Gauge)this.getSkinnable()).getMarkers().get((Object)marker)).setPivotX(marker.getPrefWidth() * 0.5);
            ((Rotate)((Gauge)this.getSkinnable()).getMarkers().get((Object)marker)).setPivotY(this.size * 0.46);
            ((Rotate)((Gauge)this.getSkinnable()).getMarkers().get((Object)marker)).setAngle(marker.getValue() * this.angleStep - 180.0 - ((Gauge)this.getSkinnable()).getStartAngle() - ((Gauge)this.getSkinnable()).getMinValue() * this.angleStep);
        }
    }

    private double clamp(double MIN_VALUE, double MAX_VALUE, double VALUE) {
        if (VALUE < MIN_VALUE) {
            return MIN_VALUE;
        }
        if (VALUE > MAX_VALUE) {
            return MAX_VALUE;
        }
        return VALUE;
    }

    private void resizeText() {
        this.titleText.setFont(Fonts.robotoMedium(this.size * 0.06));
        this.titleText.setTranslateX((this.size - this.titleText.getLayoutBounds().getWidth()) * 0.5);
        this.titleText.setTranslateY(this.size * 0.84);
        this.unitText.setFont(Fonts.robotoMedium(this.size * 0.045));
        this.unitText.setTranslateX((this.size - this.unitText.getLayoutBounds().getWidth()) * 0.5);
        this.unitText.setTranslateY(this.size * 0.4);
        this.valueText.setFont(Fonts.robotoBold(this.size * 0.1));
        this.valueText.setTranslateX((this.size - this.valueText.getLayoutBounds().getWidth()) * 0.5);
        this.valueText.setTranslateY(this.size * 0.5);
    }

    private void resize() {
        this.size = ((Gauge)this.getSkinnable()).getWidth() < ((Gauge)this.getSkinnable()).getHeight() ? ((Gauge)this.getSkinnable()).getWidth() : ((Gauge)this.getSkinnable()).getHeight();
        this.centerX = this.size * 0.5;
        this.centerY = this.size * 0.5;
        if (this.size > 0.0) {
            this.pane.setMaxSize(this.size, this.size);
            this.pane.relocate((((Gauge)this.getSkinnable()).getWidth() - this.size) * 0.5, (((Gauge)this.getSkinnable()).getHeight() - this.size) * 0.5);
            this.valueBlendBottomShadow.setOffsetY(0.005 * this.size);
            this.valueBlendTopShadow.setOffsetY(0.005 * this.size);
            this.valueBlendTopShadow.setRadius(0.005 * this.size);
            this.dropShadow.setRadius(0.015 * this.size);
            this.dropShadow.setOffsetY(0.015 * this.size);
            this.background.setPrefSize(this.size, this.size);
            this.background.setStyle("-fx-background-insets: 0, " + 0.018 * this.size + ", " + 0.02 * this.size + ", " + 0.036 * this.size + ";");
            this.ticksAndSectionsCanvas.setWidth(this.size);
            this.ticksAndSectionsCanvas.setHeight(this.size);
            this.ticksAndSections.clearRect(0.0, 0.0, this.size, this.size);
            if (((Gauge)this.getSkinnable()).isSectionsVisible()) {
                this.drawSections(this.ticksAndSections);
            }
            if (((Gauge)this.getSkinnable()).isAreasVisible()) {
                this.drawAreas(this.ticksAndSections);
            }
            this.drawTickMarks(this.ticksAndSections);
            this.ticksAndSectionsCanvas.setCache(true);
            this.ticksAndSectionsCanvas.setCacheHint(CacheHint.QUALITY);
            if (((Gauge)this.getSkinnable()).isMarkersVisible()) {
                this.drawMarkers();
            }
            this.minMeasuredValue.setPrefSize(0.03 * this.size, 0.03 * this.size);
            this.minMeasuredValue.relocate((this.size - this.minMeasuredValue.getPrefWidth()) * 0.5, this.size * 0.11);
            this.minMeasuredValueRotate.setPivotX(this.minMeasuredValue.getPrefWidth() * 0.5);
            this.minMeasuredValueRotate.setPivotY(this.size * 0.39);
            this.minMeasuredValueRotate.setAngle(((Gauge)this.getSkinnable()).getMinMeasuredValue() * this.angleStep - 180.0 - ((Gauge)this.getSkinnable()).getStartAngle() - ((Gauge)this.getSkinnable()).getMinValue() * this.angleStep);
            this.maxMeasuredValue.setPrefSize(0.03 * this.size, 0.03 * this.size);
            this.maxMeasuredValue.relocate((this.size - this.maxMeasuredValue.getPrefWidth()) * 0.5, this.size * 0.11);
            this.maxMeasuredValueRotate.setPivotX(this.maxMeasuredValue.getPrefWidth() * 0.5);
            this.maxMeasuredValueRotate.setPivotY(this.size * 0.39);
            this.maxMeasuredValueRotate.setAngle(((Gauge)this.getSkinnable()).getMaxMeasuredValue() * this.angleStep - 180.0 - ((Gauge)this.getSkinnable()).getStartAngle() - ((Gauge)this.getSkinnable()).getMinValue() * this.angleStep);
            this.threshold.setPrefSize(0.03 * this.size, 0.0275 * this.size);
            this.threshold.relocate((this.size - this.threshold.getPrefWidth()) * 0.5, this.size * 0.11);
            this.thresholdRotate.setPivotX(this.threshold.getPrefWidth() * 0.5);
            this.thresholdRotate.setPivotY(this.size * 0.39);
            this.thresholdRotate.setAngle(((Gauge)this.getSkinnable()).getThreshold() * this.angleStep - 180.0 - ((Gauge)this.getSkinnable()).getStartAngle() - ((Gauge)this.getSkinnable()).getMinValue() * this.angleStep);
            switch (((Gauge)this.getSkinnable()).getNeedleType()) {
                default: 
            }
            this.needle.setPrefSize(this.size * 0.04, this.size * 0.425);
            this.needle.relocate((this.size - this.needle.getPrefWidth()) * 0.5, this.size * 0.5 - this.needle.getPrefHeight());
            this.needleRotate.setPivotX(this.needle.getPrefWidth() * 0.5);
            this.needleRotate.setPivotY(this.needle.getPrefHeight());
            this.needleHighlight.setPrefSize(this.size * 0.04, this.size * 0.425);
            this.needleHighlight.setTranslateX((this.size - this.needle.getPrefWidth()) * 0.5);
            this.needleHighlight.setTranslateY(this.size * 0.5 - this.needle.getPrefHeight());
            this.knob.setPrefSize(this.size * 0.35, this.size * 0.35);
            this.knob.setTranslateX((this.size - this.knob.getPrefWidth()) * 0.5);
            this.knob.setTranslateY((this.size - this.knob.getPrefHeight()) * 0.5);
            this.resizeText();
        }
    }
}

