/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.gauge.skin;

import eu.hansolo.enzo.fonts.Fonts;
import eu.hansolo.enzo.gauge.OneEightyGauge;
import java.time.Instant;
import java.util.Locale;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.WritableValue;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.Effect;
import javafx.scene.effect.InnerShadow;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.ArcTo;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.util.Duration;

public class OneEightyGaugeSkin
extends SkinBase<OneEightyGauge>
implements Skin<OneEightyGauge> {
    private static final double PREFERRED_WIDTH = 540.0;
    private static final double PREFERRED_HEIGHT = 400.0;
    private static final double MINIMUM_WIDTH = 5.0;
    private static final double MINIMUM_HEIGHT = 5.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    private static final double ASPECT_RATIO = 0.7407407407407407;
    private double size;
    private double width;
    private double height;
    private double centerX;
    private DoubleProperty currentValue = new SimpleDoubleProperty((Object)this, "currentValue", ((OneEightyGauge)this.getSkinnable()).getValue());
    private double range = ((OneEightyGauge)this.getSkinnable()).getMaxValue() - ((OneEightyGauge)this.getSkinnable()).getMinValue();
    private double angleStep = 180.0 / this.range;
    private double currentValueAngle = 0.0;
    private Pane pane;
    private Text unitText;
    private Text titleText;
    private Text valueText;
    private Text minText;
    private Text maxText;
    private Path barBackground;
    private MoveTo barBackgroundStart;
    private ArcTo barBackgroundOuterArc;
    private LineTo barBackgroundLineToInnerArc;
    private ArcTo barBackgroundInnerArc;
    private Path dataBar;
    private MoveTo dataBarStart;
    private ArcTo dataBarOuterArc;
    private LineTo dataBarLineToInnerArc;
    private ArcTo dataBarInnerArc;
    private InnerShadow innerShadow;
    private Font smallFont;
    private Font bigFont;
    private Timeline timeline;
    private Instant lastCall = Instant.now();
    private boolean withinSpeedLimit = true;

    public OneEightyGaugeSkin(OneEightyGauge gauge) {
        super((Control)gauge);
        this.timeline = new Timeline();
        this.init();
        this.initGraphics();
        this.registerListeners();
    }

    private void init() {
        if (Double.compare(((OneEightyGauge)this.getSkinnable()).getPrefWidth(), 0.0) <= 0 || Double.compare(((OneEightyGauge)this.getSkinnable()).getPrefHeight(), 0.0) <= 0 || Double.compare(((OneEightyGauge)this.getSkinnable()).getWidth(), 0.0) <= 0 || Double.compare(((OneEightyGauge)this.getSkinnable()).getHeight(), 0.0) <= 0) {
            if (((OneEightyGauge)this.getSkinnable()).getPrefWidth() > 0.0 && ((OneEightyGauge)this.getSkinnable()).getPrefHeight() > 0.0) {
                ((OneEightyGauge)this.getSkinnable()).setPrefSize(((OneEightyGauge)this.getSkinnable()).getPrefWidth(), ((OneEightyGauge)this.getSkinnable()).getPrefHeight());
            } else {
                ((OneEightyGauge)this.getSkinnable()).setPrefSize(540.0, 400.0);
            }
        }
        if (Double.compare(((OneEightyGauge)this.getSkinnable()).getMinWidth(), 0.0) <= 0 || Double.compare(((OneEightyGauge)this.getSkinnable()).getMinHeight(), 0.0) <= 0) {
            ((OneEightyGauge)this.getSkinnable()).setMinSize(5.0, 5.0);
        }
        if (Double.compare(((OneEightyGauge)this.getSkinnable()).getMaxWidth(), 0.0) <= 0 || Double.compare(((OneEightyGauge)this.getSkinnable()).getMaxHeight(), 0.0) <= 0) {
            ((OneEightyGauge)this.getSkinnable()).setMaxSize(1024.0, 1024.0);
        }
    }

    private void initGraphics() {
        this.unitText = new Text(((OneEightyGauge)this.getSkinnable()).getUnit());
        this.unitText.setTextOrigin(VPos.CENTER);
        this.unitText.getStyleClass().setAll((Object[])new String[]{"unit"});
        this.unitText.setFill(((OneEightyGauge)this.getSkinnable()).getUnitColor());
        this.titleText = new Text(((OneEightyGauge)this.getSkinnable()).getTitle());
        this.titleText.setTextOrigin(VPos.CENTER);
        this.titleText.getStyleClass().setAll((Object[])new String[]{"title"});
        this.titleText.setFill(((OneEightyGauge)this.getSkinnable()).getTitleColor());
        this.valueText = new Text(String.format(Locale.US, "%." + ((OneEightyGauge)this.getSkinnable()).getDecimals() + "f", ((OneEightyGauge)this.getSkinnable()).getValue()));
        this.valueText.setTextOrigin(VPos.CENTER);
        this.valueText.getStyleClass().setAll((Object[])new String[]{"value"});
        this.valueText.setFill(((OneEightyGauge)this.getSkinnable()).getValueColor());
        this.minText = new Text(String.format(Locale.US, "%." + ((OneEightyGauge)this.getSkinnable()).getDecimals() + "f", ((OneEightyGauge)this.getSkinnable()).getMinValue()));
        this.minText.setTextOrigin(VPos.CENTER);
        this.minText.getStyleClass().setAll((Object[])new String[]{"min-text"});
        this.minText.setFill(((OneEightyGauge)this.getSkinnable()).getMinTextColor());
        this.maxText = new Text(String.format(Locale.US, "%." + ((OneEightyGauge)this.getSkinnable()).getDecimals() + "f", ((OneEightyGauge)this.getSkinnable()).getMaxValue()));
        this.maxText.setTextOrigin(VPos.CENTER);
        this.maxText.getStyleClass().setAll((Object[])new String[]{"max-text"});
        this.maxText.setFill(((OneEightyGauge)this.getSkinnable()).getMaxTextColor());
        this.innerShadow = new InnerShadow(BlurType.TWO_PASS_BOX, Color.rgb((int)0, (int)0, (int)0, (double)0.3), 30.0, 0.0, 0.0, 10.0);
        this.barBackgroundStart = new MoveTo(0.0, 270.0);
        this.barBackgroundOuterArc = new ArcTo(270.0, 270.0, 0.0, 540.0, 270.0, true, true);
        this.barBackgroundLineToInnerArc = new LineTo(389.99879999999996, 270.0);
        this.barBackgroundInnerArc = new ArcTo(120.0, 120.0, 0.0, 150.0012, 270.0, false, false);
        this.barBackground = new Path();
        this.barBackground.setFillRule(FillRule.EVEN_ODD);
        this.barBackground.getElements().add((Object)this.barBackgroundStart);
        this.barBackground.getElements().add((Object)this.barBackgroundOuterArc);
        this.barBackground.getElements().add((Object)this.barBackgroundLineToInnerArc);
        this.barBackground.getElements().add((Object)this.barBackgroundInnerArc);
        this.barBackground.getElements().add((Object)new ClosePath());
        this.barBackground.getStyleClass().setAll((Object[])new String[]{"bar-background"});
        this.barBackground.setFill(((OneEightyGauge)this.getSkinnable()).getBarBackgroundColor());
        this.barBackground.setEffect((Effect)(((OneEightyGauge)this.getSkinnable()).isShadowsEnabled() ? this.innerShadow : null));
        this.dataBarStart = new MoveTo(0.0, 270.0);
        this.dataBarOuterArc = new ArcTo(270.0, 270.0, 0.0, 0.0, 0.0, false, true);
        this.dataBarLineToInnerArc = new LineTo(150.0012, 270.0);
        this.dataBarInnerArc = new ArcTo(120.0, 120.0, 0.0, 0.0, 0.0, false, false);
        this.dataBar = new Path();
        this.dataBar.setFillRule(FillRule.EVEN_ODD);
        this.dataBar.getElements().add((Object)this.dataBarStart);
        this.dataBar.getElements().add((Object)this.dataBarOuterArc);
        this.dataBar.getElements().add((Object)this.dataBarLineToInnerArc);
        this.dataBar.getElements().add((Object)this.dataBarInnerArc);
        this.dataBar.getElements().add((Object)new ClosePath());
        this.dataBar.getStyleClass().setAll((Object[])new String[]{"data-bar"});
        this.dataBar.setFill(((OneEightyGauge)this.getSkinnable()).getBarColor());
        this.dataBar.setEffect((Effect)(((OneEightyGauge)this.getSkinnable()).isShadowsEnabled() ? this.innerShadow : null));
        this.pane = new Pane();
        this.pane.getChildren().setAll((Object[])new Node[]{this.unitText, this.titleText, this.valueText, this.minText, this.maxText, this.barBackground, this.dataBar});
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    private void registerListeners() {
        ((OneEightyGauge)this.getSkinnable()).widthProperty().addListener(observable -> this.resize());
        ((OneEightyGauge)this.getSkinnable()).heightProperty().addListener(observable -> this.resize());
        ((OneEightyGauge)this.getSkinnable()).minValueProperty().addListener(observable -> this.handleControlPropertyChanged("RECALC"));
        ((OneEightyGauge)this.getSkinnable()).maxValueProperty().addListener(observable -> this.handleControlPropertyChanged("RECALC"));
        ((OneEightyGauge)this.getSkinnable()).titleProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((OneEightyGauge)this.getSkinnable()).titleProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((OneEightyGauge)this.getSkinnable()).unitProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((OneEightyGauge)this.getSkinnable()).barBackgroundColorProperty().addListener(observable -> this.handleControlPropertyChanged("BAR_BACKGROUND_COLOR"));
        ((OneEightyGauge)this.getSkinnable()).barColorProperty().addListener(observable -> this.handleControlPropertyChanged("BAR_COLOR"));
        ((OneEightyGauge)this.getSkinnable()).dynamicBarColorProperty().addListener(observable1 -> this.handleControlPropertyChanged("BAR_COLOR"));
        ((OneEightyGauge)this.getSkinnable()).titleColorProperty().addListener(observable -> this.handleControlPropertyChanged("TITLE_COLOR"));
        ((OneEightyGauge)this.getSkinnable()).valueColorProperty().addListener(observable -> this.handleControlPropertyChanged("VALUE_COLOR"));
        ((OneEightyGauge)this.getSkinnable()).unitColorProperty().addListener(observable -> this.handleControlPropertyChanged("UNIT_COLOR"));
        ((OneEightyGauge)this.getSkinnable()).minTextColorProperty().addListener(observable -> this.handleControlPropertyChanged("MIN_TEXT_COLOR"));
        ((OneEightyGauge)this.getSkinnable()).maxTextColorProperty().addListener(observable -> this.handleControlPropertyChanged("MAX_TEXT_COLOR"));
        ((OneEightyGauge)this.getSkinnable()).shadowsEnabledProperty().addListener(observable -> this.handleControlPropertyChanged("SHADOWS_ENABLED"));
        this.currentValue.addListener(observable -> this.handleControlPropertyChanged("CURRENT_VALUE"));
        ((OneEightyGauge)this.getSkinnable()).valueProperty().addListener((OV, OLD_VALUE, NEW_VALUE) -> {
            this.withinSpeedLimit = !Instant.now().minusMillis((long)((OneEightyGauge)this.getSkinnable()).getAnimationDuration()).isBefore(this.lastCall);
            this.lastCall = Instant.now();
            if (this.withinSpeedLimit && ((OneEightyGauge)this.getSkinnable()).isAnimated()) {
                this.timeline.stop();
                KeyValue KEY_VALUE = new KeyValue((WritableValue)this.currentValue, (Object)((OneEightyGauge)this.getSkinnable()).getValue(), Interpolator.SPLINE((double)0.5, (double)0.4, (double)0.4, (double)1.0));
                KeyFrame KEY_FRAME = new KeyFrame(Duration.millis((double)((OneEightyGauge)this.getSkinnable()).getAnimationDuration()), new KeyValue[]{KEY_VALUE});
                this.timeline.getKeyFrames().setAll((Object[])new KeyFrame[]{KEY_FRAME});
                this.timeline.play();
            } else {
                this.currentValue.set(((OneEightyGauge)this.getSkinnable()).getValue());
            }
        });
    }

    protected void handleControlPropertyChanged(String PROPERTY) {
        if ("RESIZE".equals(PROPERTY)) {
            this.resize();
        } else if ("RECALC".equals(PROPERTY)) {
            this.range = ((OneEightyGauge)this.getSkinnable()).getMaxValue() - ((OneEightyGauge)this.getSkinnable()).getMinValue();
            this.angleStep = 180.0 / this.range;
            this.currentValue.set(((OneEightyGauge)this.getSkinnable()).getMinValue());
            this.resize();
        } else if ("CURRENT_VALUE".equals(PROPERTY)) {
            this.updateBar();
        } else if ("ANGLE".equals(PROPERTY)) {
            double currentValue = this.dataBarOuterArc.getXAxisRotation() / this.angleStep + ((OneEightyGauge)this.getSkinnable()).getMinValue();
            this.valueText.setText(String.format(Locale.US, "%." + ((OneEightyGauge)this.getSkinnable()).getDecimals() + "f", currentValue));
            this.valueText.setTranslateX((this.size - this.valueText.getLayoutBounds().getWidth()) * 0.5);
        } else if ("BAR_BACKGROUND_COLOR".equals(PROPERTY)) {
            this.barBackground.setFill(((OneEightyGauge)this.getSkinnable()).getBarBackgroundColor());
        } else if ("BAR_COLOR".equals(PROPERTY)) {
            if (((OneEightyGauge)this.getSkinnable()).isDynamicBarColor() && !((OneEightyGauge)this.getSkinnable()).getGradientLookup().getStops().isEmpty()) {
                this.dataBar.setFill((Paint)((OneEightyGauge)this.getSkinnable()).getGradientLookup().getColorAt(this.currentValue.get() / this.range));
            } else {
                this.dataBar.setFill(((OneEightyGauge)this.getSkinnable()).getBarColor());
            }
        } else if ("TITLE_COLOR".equals(PROPERTY)) {
            this.titleText.setFill(((OneEightyGauge)this.getSkinnable()).getTitleColor());
        } else if ("VALUE_COLOR".equals(PROPERTY)) {
            this.valueText.setFill(((OneEightyGauge)this.getSkinnable()).getValueColor());
        } else if ("UNIT_COLOR".equals(PROPERTY)) {
            this.unitText.setFill(((OneEightyGauge)this.getSkinnable()).getUnitColor());
        } else if ("MIN_TEXT_COLOR".equals(PROPERTY)) {
            this.minText.setFill(((OneEightyGauge)this.getSkinnable()).getMinTextColor());
        } else if ("MAX_TEXT_COLOR".equals(PROPERTY)) {
            this.maxText.setFill(((OneEightyGauge)this.getSkinnable()).getMaxTextColor());
        } else if ("SHADOWS_ENABLED".equals(PROPERTY)) {
            this.barBackground.setEffect((Effect)(((OneEightyGauge)this.getSkinnable()).isShadowsEnabled() ? this.innerShadow : null));
            this.dataBar.setEffect((Effect)(((OneEightyGauge)this.getSkinnable()).isShadowsEnabled() ? this.innerShadow : null));
        }
    }

    private void updateBar() {
        this.currentValueAngle = (this.currentValue.get() + Math.abs(((OneEightyGauge)this.getSkinnable()).getMinValue())) * this.angleStep + 90.0;
        this.dataBarOuterArc.setX(this.centerX + 0.675 * this.height * Math.sin(-Math.toRadians(this.currentValueAngle)));
        this.dataBarOuterArc.setY(this.centerX + 0.675 * this.height * Math.cos(-Math.toRadians(this.currentValueAngle)));
        this.dataBarLineToInnerArc.setX(this.centerX + 0.3 * this.height * Math.sin(-Math.toRadians(this.currentValueAngle)));
        this.dataBarLineToInnerArc.setY(this.centerX + 0.3 * this.height * Math.cos(-Math.toRadians(this.currentValueAngle)));
        if (((OneEightyGauge)this.getSkinnable()).isDynamicBarColor() && ((OneEightyGauge)this.getSkinnable()).getGradientLookup().getStops().size() > 1) {
            this.dataBar.setFill((Paint)((OneEightyGauge)this.getSkinnable()).getGradientLookup().getColorAt(this.currentValue.get() / this.range));
        }
        this.valueText.setText(String.format(Locale.US, "%." + ((OneEightyGauge)this.getSkinnable()).getDecimals() + "f", this.currentValue.get()));
        this.valueText.relocate((this.width - this.valueText.getLayoutBounds().getWidth()) * 0.5, 0.62 * this.height);
    }

    private void resize() {
        this.size = ((OneEightyGauge)this.getSkinnable()).getWidth() < ((OneEightyGauge)this.getSkinnable()).getHeight() ? ((OneEightyGauge)this.getSkinnable()).getWidth() : ((OneEightyGauge)this.getSkinnable()).getHeight();
        this.width = ((OneEightyGauge)this.getSkinnable()).getWidth();
        this.height = ((OneEightyGauge)this.getSkinnable()).getHeight();
        if (0.7407407407407407 * this.width > this.height) {
            this.width = 1.0 / (0.7407407407407407 / this.height);
        } else if (1.0 / (0.7407407407407407 / this.height) > this.width) {
            this.height = 0.7407407407407407 * this.width;
        }
        if (this.width > 0.0 && this.height > 0.0) {
            this.pane.setMaxSize(this.width, this.height);
            this.pane.relocate((((OneEightyGauge)this.getSkinnable()).getWidth() - this.width) * 0.5, (((OneEightyGauge)this.getSkinnable()).getHeight() - this.height) * 0.5);
            this.centerX = this.width * 0.5;
            this.smallFont = Fonts.robotoThin(0.12 * this.height);
            this.bigFont = Fonts.robotoRegular(0.24 * this.height);
            this.unitText.setFont(this.smallFont);
            this.unitText.relocate((this.width - this.unitText.getLayoutBounds().getWidth()) * 0.5, 0.5 * this.height);
            this.titleText.setFont(this.smallFont);
            this.titleText.relocate((this.width - this.titleText.getLayoutBounds().getWidth()) * 0.5, 0.87 * this.height);
            this.valueText.setFont(this.bigFont);
            this.valueText.relocate((this.width - this.valueText.getLayoutBounds().getWidth()) * 0.5, 0.62 * this.height);
            this.minText.setFont(this.smallFont);
            this.minText.relocate((0.27778 * this.width - this.minText.getLayoutBounds().getWidth()) * 0.5, 0.7 * this.height);
            this.maxText.setFont(this.smallFont);
            this.maxText.relocate((0.27778 * this.width - this.maxText.getLayoutBounds().getWidth()) * 0.5 + 0.72222 * this.width, 0.7 * this.height);
            if (((OneEightyGauge)this.getSkinnable()).isShadowsEnabled()) {
                this.innerShadow.setRadius(0.075 * this.height);
                this.innerShadow.setOffsetY(0.025 * this.height);
            }
            this.barBackgroundStart.setX(0.0);
            this.barBackgroundStart.setY(0.675 * this.height);
            this.barBackgroundOuterArc.setRadiusX(0.675 * this.height);
            this.barBackgroundOuterArc.setRadiusY(0.675 * this.height);
            this.barBackgroundOuterArc.setX(this.width);
            this.barBackgroundOuterArc.setY(0.675 * this.height);
            this.barBackgroundLineToInnerArc.setX(0.72222 * this.width);
            this.barBackgroundLineToInnerArc.setY(0.675 * this.height);
            this.barBackgroundInnerArc.setRadiusX(0.3 * this.height);
            this.barBackgroundInnerArc.setRadiusY(0.3 * this.height);
            this.barBackgroundInnerArc.setX(0.27778 * this.width);
            this.barBackgroundInnerArc.setY(0.675 * this.height);
            this.currentValueAngle = (this.currentValue.get() + Math.abs(((OneEightyGauge)this.getSkinnable()).getMinValue())) * this.angleStep + 90.0;
            this.dataBarStart.setX(0.0);
            this.dataBarStart.setY(0.675 * this.height);
            this.dataBarOuterArc.setRadiusX(0.675 * this.height);
            this.dataBarOuterArc.setRadiusY(0.675 * this.height);
            this.dataBarOuterArc.setX(this.centerX + 0.675 * this.height * Math.sin(-Math.toRadians(this.currentValueAngle)));
            this.dataBarOuterArc.setY(this.centerX + 0.675 * this.height * Math.cos(-Math.toRadians(this.currentValueAngle)));
            this.dataBarLineToInnerArc.setX(this.centerX + 0.3 * this.height * Math.sin(-Math.toRadians(this.currentValueAngle)));
            this.dataBarLineToInnerArc.setY(this.centerX + 0.3 * this.height * Math.cos(-Math.toRadians(this.currentValueAngle)));
            this.dataBarInnerArc.setRadiusX(0.3 * this.height);
            this.dataBarInnerArc.setRadiusY(0.3 * this.height);
            this.dataBarInnerArc.setX(0.27778 * this.width);
            this.dataBarInnerArc.setY(0.675 * this.height);
        }
    }
}

