/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.lcd;

import eu.hansolo.enzo.common.ValueEvent;
import eu.hansolo.enzo.lcd.Lcd;
import eu.hansolo.enzo.lcd.LcdBuilder;
import java.util.Random;
import javafx.animation.AnimationTimer;
import javafx.application.Application;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;

public class DemoLcd
extends Application {
    private static final Random RND = new Random();
    private static int noOfNodes = 0;
    private Lcd control;
    private long lastTimerCall;
    private double charge;
    private int styleClassCounter;
    private AnimationTimer timer;

    public void init() {
        this.control = ((LcdBuilder)((LcdBuilder)((LcdBuilder)((LcdBuilder)((LcdBuilder)((LcdBuilder)((LcdBuilder)((LcdBuilder)((LcdBuilder)((LcdBuilder)((LcdBuilder)((LcdBuilder)((LcdBuilder)((LcdBuilder)((LcdBuilder)((LcdBuilder)((LcdBuilder)((LcdBuilder)((LcdBuilder)((LcdBuilder)((LcdBuilder)((LcdBuilder)((LcdBuilder)((LcdBuilder)((LcdBuilder)((LcdBuilder)((LcdBuilder)((LcdBuilder)((LcdBuilder)((LcdBuilder)((LcdBuilder)LcdBuilder.create().minSize(128.0, 40.0)).maxSize(1280.0, 400.0)).prefWidth(640.0)).prefHeight(200.0)).keepAspect(true)).lcdDesign(Lcd.LcdDesign.GREEN_DARKGREEN)).foregroundShadowVisible(true)).crystalOverlayVisible(true)).title("Room Temp")).batteryVisible(true)).signalVisible(true)).alarmVisible(true)).unit("\u00b0C")).unitVisible(true)).decimals(3)).animationDurationInMs(1500.0)).minMeasuredValueDecimals(2)).minMeasuredValueVisible(true)).maxMeasuredValueDecimals(2)).maxMeasuredValueVisible(true)).formerValueVisible(true)).threshold(26.0)).thresholdVisible(true)).trendVisible(true)).numberSystemVisible(false)).lowerRightTextVisible(true)).lowerRightText("Info")).minValue(-100.0)).maxValue(100.0)).valueFont(Lcd.LcdFont.LCD)).animated(true)).build();
        this.control.addEventHandler(ValueEvent.VALUE_EXCEEDED, valueEvent -> System.out.println("exceeded"));
        this.charge = 0.0;
        this.styleClassCounter = 0;
        this.lastTimerCall = System.nanoTime();
        this.timer = new AnimationTimer(){

            public void handle(long now) {
                if (now > DemoLcd.this.lastTimerCall + 5000000000L) {
                    DemoLcd.this.styleClassCounter++;
                    if (DemoLcd.this.styleClassCounter >= Lcd.LcdDesign.values().length) {
                        DemoLcd.this.styleClassCounter = 0;
                        DemoLcd.this.control.setMainInnerShadowVisible(true);
                        DemoLcd.this.control.setForegroundShadowVisible(true);
                        DemoLcd.this.control.setCrystalOverlayVisible(true);
                    }
                    DemoLcd.this.control.getStyleClass().setAll((Object[])new String[]{"lcd", Lcd.LcdDesign.values()[((DemoLcd)DemoLcd.this).styleClassCounter].STYLE_CLASS});
                    double value = RND.nextDouble() * 200.0 - 100.0;
                    DemoLcd.this.control.setValue(value);
                    DemoLcd.this.control.setTrend(Lcd.Trend.values()[RND.nextInt(5)]);
                    DemoLcd.this.charge = DemoLcd.this.charge + 0.02;
                    if (DemoLcd.this.charge > 1.0) {
                        DemoLcd.this.charge = 0.0;
                    }
                    DemoLcd.this.control.setBatteryCharge(DemoLcd.this.charge);
                    DemoLcd.this.control.setSignalStrength(DemoLcd.this.charge);
                    if (DemoLcd.this.styleClassCounter > 34) {
                        DemoLcd.this.control.setMainInnerShadowVisible(false);
                        DemoLcd.this.control.setForegroundShadowVisible(false);
                        DemoLcd.this.control.setCrystalOverlayVisible(false);
                    }
                    DemoLcd.this.lastTimerCall = now;
                }
            }
        };
    }

    public void start(Stage stage) {
        StackPane pane = new StackPane();
        pane.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        pane.getChildren().setAll((Object[])new Node[]{this.control});
        pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.DARKGRAY, CornerRadii.EMPTY, Insets.EMPTY)}));
        Scene scene = new Scene((Parent)pane);
        stage.setTitle("Lcd demo");
        stage.centerOnScreen();
        stage.setScene(scene);
        stage.show();
        this.timer.start();
        DemoLcd.calcNoOfNodes((Node)scene.getRoot());
        System.out.println(noOfNodes + " Nodes in SceneGraph");
    }

    public static void main(String[] args) {
        DemoLcd.launch((String[])args);
    }

    private static void calcNoOfNodes(Node node) {
        if (node instanceof Parent && ((Parent)node).getChildrenUnmodifiable().size() != 0) {
            ObservableList tempChildren = ((Parent)node).getChildrenUnmodifiable();
            noOfNodes += tempChildren.size();
            for (Node n : tempChildren) {
                DemoLcd.calcNoOfNodes(n);
            }
        }
    }
}

