/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.lcd;

import eu.hansolo.enzo.lcd.Alarm;
import eu.hansolo.enzo.lcd.LcdClock;
import eu.hansolo.enzo.lcd.LcdClockBuilder;
import java.time.LocalDateTime;
import java.util.Locale;
import javafx.animation.AnimationTimer;
import javafx.application.Application;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;

public class DemoLcdClock
extends Application {
    private static int noOfNodes = 0;
    private static final String[] STYLE_CLASSES = new String[]{"lcd-beige", "lcd-blue", "lcd-orange", "lcd-red", "lcd-yellow", "lcd-white", "lcd-gray", "lcd-black", "lcd-green", "lcd-green-darkgreen", "lcd-blue2", "lcd-blue-black", "lcd-blue-darkblue", "lcd-blue-lightblue", "lcd-blue-gray", "lcd-standard", "lcd-lightgreen", "lcd-standard-green", "lcd-blue-blue", "lcd-red-darkred", "lcd-darkblue", "lcd-purple", "lcd-black-red", "lcd-darkgreen", "lcd-amber", "lcd-lightblue", "lcd-green-black", "lcd-yellow-black", "lcd-black-yellow", "lcd-lightgreen-black", "lcd-darkpurple", "lcd-darkamber", "lcd-blue-lightblue2", "lcd-gray-purple", "lcd-sections", "lcd-flat-turqoise", "lcd-flat-gree-sea", "lcd-flat-emerland", "lcd-flat-nephritis", "lcd-flat-peter-river", "lcd-flat-belize-hole", "lcd-flat-amethyst", "lcd-flat-wisteria", "lcd-flat-sunflower", "lcd-flat-orange", "lcd-flat-carrot", "lcd-flat-pumpkin", "lcd-flat-alizarin", "lcd-flat-pomegranate", "lcd-flat-clouds", "lcd-flat-silver", "lcd-flat-concrete", "lcd-flat-asbestos", "lcd-flat-wet-asphalt", "lcd-flat-midnight-blue"};
    private LcdClock control;
    private long lastTimerCall;
    private int styleClassCounter;
    private AnimationTimer timer;
    private Commando1 commando1 = new Commando1();
    private Commando2 commando2 = new Commando2();

    public void init() {
        this.control = ((LcdClockBuilder)((LcdClockBuilder)LcdClockBuilder.create().prefWidth(760.0)).prefHeight(400.0)).title("M\u00fcnster").styleClass("lcd-yoctopuce").foregroundShadowVisible(true).crystalOverlayVisible(true).timeFont(LcdClock.LcdFont.LCD).locale(Locale.GERMAN).dateFormat(LcdClock.DateFormat.DAY_MONTH_YEAR).dateSeparator(LcdClock.DateSeparator.DOT).alarms(new Alarm(Alarm.Repetition.ONCE, LocalDateTime.now().plusSeconds(20L), true, "20s after Start"), new Alarm(Alarm.Repetition.ONCE, LocalDateTime.now().plusSeconds(30L), true, "30s after Start", this.commando2)).build();
        this.control.addEventHandler(Alarm.AlarmEvent.ALARM, (EventHandler)new EventHandler<Alarm.AlarmEvent>(){

            public void handle(Alarm.AlarmEvent alarmEvent) {
                System.out.println("Alarm: " + alarmEvent.getAlarm().getText());
            }
        });
        this.styleClassCounter = 34;
        this.lastTimerCall = System.nanoTime();
        this.timer = new AnimationTimer(){

            public void handle(long now) {
                if (now > DemoLcdClock.this.lastTimerCall + 5000000000L) {
                    DemoLcdClock.this.styleClassCounter++;
                    if (DemoLcdClock.this.styleClassCounter >= STYLE_CLASSES.length) {
                        DemoLcdClock.this.styleClassCounter = 0;
                        DemoLcdClock.this.control.setMainInnerShadowVisible(true);
                        DemoLcdClock.this.control.setForegroundShadowVisible(true);
                        DemoLcdClock.this.control.setCrystalOverlayVisible(true);
                    }
                    DemoLcdClock.this.control.getStyleClass().setAll((Object[])new String[]{"lcd-clock", STYLE_CLASSES[DemoLcdClock.this.styleClassCounter]});
                    if (DemoLcdClock.this.styleClassCounter > 34) {
                        DemoLcdClock.this.control.setMainInnerShadowVisible(false);
                        DemoLcdClock.this.control.setForegroundShadowVisible(false);
                        DemoLcdClock.this.control.setCrystalOverlayVisible(false);
                    }
                    DemoLcdClock.this.lastTimerCall = now;
                }
            }
        };
    }

    public void start(Stage stage) {
        StackPane pane = new StackPane();
        pane.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        pane.getChildren().setAll((Object[])new Node[]{this.control});
        Scene scene = new Scene((Parent)pane, (Paint)Color.TRANSPARENT);
        stage.setTitle("Lcd demo");
        stage.centerOnScreen();
        stage.setScene(scene);
        stage.show();
        DemoLcdClock.calcNoOfNodes((Node)scene.getRoot());
        System.out.println(noOfNodes + " Nodes in SceneGraph");
    }

    public static void main(String[] args) {
        DemoLcdClock.launch((String[])args);
    }

    private static void calcNoOfNodes(Node node) {
        if (node instanceof Parent && ((Parent)node).getChildrenUnmodifiable().size() != 0) {
            ObservableList tempChildren = ((Parent)node).getChildrenUnmodifiable();
            noOfNodes += tempChildren.size();
            for (Node n : tempChildren) {
                DemoLcdClock.calcNoOfNodes(n);
            }
        }
    }

    public class Commando2
    implements Alarm.Command {
        @Override
        public void execute() {
            System.out.println("Another class that will be executed by an Alarm");
        }
    }

    public class Commando1
    implements Alarm.Command {
        @Override
        public void execute() {
            System.out.println("Now execute something triggered by the Alarm");
        }
    }
}

