/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.notification;

import eu.hansolo.enzo.notification.Notification;
import eu.hansolo.enzo.notification.NotificationBuilder;
import eu.hansolo.enzo.notification.NotificationEvent;
import eu.hansolo.enzo.notification.NotifierBuilder;
import java.util.Random;
import javafx.animation.AnimationTimer;
import javafx.application.Application;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;

public class Demo
extends Application {
    private static final Random RND = new Random();
    private static final Notification[] NOTIFICATIONS = new Notification[]{((NotificationBuilder)((NotificationBuilder)((NotificationBuilder)NotificationBuilder.create().title("Info")).message("New Information")).image(Notification.INFO_ICON)).build(), ((NotificationBuilder)((NotificationBuilder)((NotificationBuilder)NotificationBuilder.create().title("Warning")).message("Attention, somethings wrong")).image(Notification.WARNING_ICON)).build(), ((NotificationBuilder)((NotificationBuilder)((NotificationBuilder)NotificationBuilder.create().title("Success")).message("Great it works")).image(Notification.SUCCESS_ICON)).build(), ((NotificationBuilder)((NotificationBuilder)((NotificationBuilder)NotificationBuilder.create().title("Error")).message("ZOMG")).image(Notification.ERROR_ICON)).build()};
    private Notification.Notifier notifier;
    private Button button;
    private int count;
    private long lastTimerCall;
    private AnimationTimer timer;

    public void init() {
        this.button = new Button("Notify");
        this.button.setOnAction(event -> this.notifier.notify(NOTIFICATIONS[RND.nextInt(4)]));
        this.count = 0;
        this.lastTimerCall = System.nanoTime();
        this.timer = new AnimationTimer(){

            public void handle(long now) {
                if (now > Demo.this.lastTimerCall + 5000000000L) {
                    if (Demo.this.count == 10) {
                        Demo.this.timer.stop();
                    }
                    Demo.this.notifier.notify(NOTIFICATIONS[RND.nextInt(4)]);
                    Demo.this.count++;
                    Demo.this.lastTimerCall = now;
                }
            }
        };
    }

    public void start(Stage stage) {
        Notification.Notifier.INSTANCE.setAlwaysOnTop(false);
        this.notifier = NotifierBuilder.create().build();
        this.notifier.setOnNotificationPressed((EventHandler<NotificationEvent>)((EventHandler)event -> System.out.println("Notification pressed: " + event.NOTIFICATION.TITLE)));
        this.notifier.setOnShowNotification((EventHandler<NotificationEvent>)((EventHandler)event -> System.out.println("Notification shown: " + event.NOTIFICATION.TITLE)));
        this.notifier.setOnHideNotification((EventHandler<NotificationEvent>)((EventHandler)event -> System.out.println("Notification hidden: " + event.NOTIFICATION.TITLE)));
        StackPane pane = new StackPane();
        pane.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        pane.getChildren().addAll((Object[])new Node[]{this.button});
        Scene scene = new Scene((Parent)pane);
        stage.setOnCloseRequest(observable -> this.notifier.stop());
        stage.setScene(scene);
        stage.show();
    }

    public void stop() {
    }

    public static void main(String[] args) {
        Demo.launch((String[])args);
    }
}

