/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.onoffswitch.skin;

import eu.hansolo.enzo.common.Symbol;
import eu.hansolo.enzo.common.SymbolType;
import eu.hansolo.enzo.common.Util;
import eu.hansolo.enzo.onoffswitch.IconSwitch;
import java.io.InputStream;
import javafx.animation.TranslateTransition;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;
import javafx.scene.text.TextAlignment;
import javafx.util.Duration;

public class IconSwitchSkin
extends SkinBase<IconSwitch>
implements Skin<IconSwitch> {
    private static final double PREFERRED_WIDTH = 80.0;
    private static final double PREFERRED_HEIGHT = 32.0;
    private static final double MINIMUM_WIDTH = 20.0;
    private static final double MINIMUM_HEIGHT = 8.0;
    private static final double MAXIMUM_WIDTH = 1024.0;
    private static final double MAXIMUM_HEIGHT = 1024.0;
    private double size;
    private double width;
    private double height;
    private Pane pane;
    private double aspectRatio = 0.4;
    private Region background;
    private Region thumb;
    private Symbol symbol;
    private Font font;
    private Label text;
    private TranslateTransition moveToDeselected;
    private TranslateTransition moveToSelected;

    public IconSwitchSkin(IconSwitch CONTROL) {
        super((Control)CONTROL);
        this.init();
        this.initGraphics();
        this.registerListeners();
    }

    private void init() {
        if (Double.compare(((IconSwitch)this.getSkinnable()).getPrefWidth(), 0.0) <= 0 || Double.compare(((IconSwitch)this.getSkinnable()).getPrefHeight(), 0.0) <= 0 || Double.compare(((IconSwitch)this.getSkinnable()).getWidth(), 0.0) <= 0 || Double.compare(((IconSwitch)this.getSkinnable()).getHeight(), 0.0) <= 0) {
            if (((IconSwitch)this.getSkinnable()).getPrefWidth() > 0.0 && ((IconSwitch)this.getSkinnable()).getPrefHeight() > 0.0) {
                ((IconSwitch)this.getSkinnable()).setPrefSize(((IconSwitch)this.getSkinnable()).getPrefWidth(), ((IconSwitch)this.getSkinnable()).getPrefHeight());
            } else {
                ((IconSwitch)this.getSkinnable()).setPrefSize(80.0, 32.0);
            }
        }
        if (Double.compare(((IconSwitch)this.getSkinnable()).getMinWidth(), 0.0) <= 0 || Double.compare(((IconSwitch)this.getSkinnable()).getMinHeight(), 0.0) <= 0) {
            ((IconSwitch)this.getSkinnable()).setMinSize(20.0, 8.0);
        }
        if (Double.compare(((IconSwitch)this.getSkinnable()).getMaxWidth(), 0.0) <= 0 || Double.compare(((IconSwitch)this.getSkinnable()).getMaxHeight(), 0.0) <= 0) {
            ((IconSwitch)this.getSkinnable()).setMaxSize(1024.0, 1024.0);
        }
        if (((IconSwitch)this.getSkinnable()).getPrefWidth() != 80.0 || ((IconSwitch)this.getSkinnable()).getPrefHeight() != 32.0) {
            this.aspectRatio = ((IconSwitch)this.getSkinnable()).getPrefHeight() / ((IconSwitch)this.getSkinnable()).getPrefWidth();
        }
    }

    private void initGraphics() {
        Font.loadFont((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/eu/hansolo/enzo/fonts/opensans-semibold.ttf"), (double)16.0);
        this.font = Font.font((String)"Open Sans", (double)16.0);
        this.background = new Region();
        this.background.getStyleClass().setAll((Object[])new String[]{"background"});
        this.background.setStyle("-switch-color: " + Util.colorToCss((Color)((IconSwitch)this.getSkinnable()).getSwitchColor()) + ";");
        this.symbol = ((IconSwitch)this.getSkinnable()).getSymbol();
        this.symbol.setMouseTransparent(true);
        this.text = new Label(((IconSwitch)this.getSkinnable()).getText());
        this.text.setTextAlignment(TextAlignment.CENTER);
        this.text.setAlignment(Pos.CENTER);
        this.text.setTextFill((Paint)((IconSwitch)this.getSkinnable()).getSymbolColor());
        this.text.setFont(this.font);
        this.thumb = new Region();
        this.thumb.getStyleClass().setAll((Object[])new String[]{"thumb"});
        this.thumb.setStyle("-thumb-color: " + Util.colorToCss((Color)((IconSwitch)this.getSkinnable()).getThumbColor()) + ";");
        this.thumb.setMouseTransparent(true);
        this.pane = new Pane(new Node[]{this.background, this.symbol, this.text, this.thumb});
        this.pane.getStyleClass().setAll((Object[])new String[]{"icon-switch"});
        this.moveToDeselected = new TranslateTransition(Duration.millis((double)180.0), (Node)this.thumb);
        this.moveToSelected = new TranslateTransition(Duration.millis((double)180.0), (Node)this.thumb);
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    private void registerListeners() {
        ((IconSwitch)this.getSkinnable()).widthProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((IconSwitch)this.getSkinnable()).heightProperty().addListener(observable -> this.handleControlPropertyChanged("RESIZE"));
        ((IconSwitch)this.getSkinnable()).switchColorProperty().addListener(observable -> this.handleControlPropertyChanged("SWITCH_COLOR"));
        ((IconSwitch)this.getSkinnable()).thumbColorProperty().addListener(observable -> this.handleControlPropertyChanged("THUMB_COLOR"));
        ((IconSwitch)this.getSkinnable()).symbolColorProperty().addListener(observable -> this.handleControlPropertyChanged("SYMBOL_COLOR"));
        ((IconSwitch)this.getSkinnable()).textProperty().addListener(observable -> this.handleControlPropertyChanged("TEXT"));
        ((IconSwitch)this.getSkinnable()).selectedProperty().addListener(observable -> this.handleControlPropertyChanged("SELECTED"));
        this.pane.setOnMouseClicked(mouseEvent -> {
            if (null == ((IconSwitch)this.getSkinnable()).getToggleGroup() || ((IconSwitch)this.getSkinnable()).getToggleGroup().getToggles().isEmpty()) {
                ((IconSwitch)this.getSkinnable()).setSelected(!((IconSwitch)this.getSkinnable()).isSelected());
            } else {
                ((IconSwitch)this.getSkinnable()).setSelected(true);
            }
        });
    }

    protected void handleControlPropertyChanged(String PROPERTY) {
        if ("RESIZE".equals(PROPERTY)) {
            this.resize();
        } else if ("SWITCH_COLOR".equals(PROPERTY)) {
            this.background.setStyle("-switch-color: " + Util.colorToCss((Color)((IconSwitch)this.getSkinnable()).getSwitchColor()) + ";");
        } else if ("THUMB_COLOR".equals(PROPERTY)) {
            this.thumb.setStyle("-thumb-color: " + Util.colorToCss((Color)((IconSwitch)this.getSkinnable()).getThumbColor()) + ";");
        } else if ("SYMBOL_COLOR".equals(PROPERTY)) {
            this.text.setTextFill((Paint)((IconSwitch)this.getSkinnable()).getSymbolColor());
            this.resize();
        } else if ("TEXT".equals(PROPERTY)) {
            this.text.setText(((IconSwitch)this.getSkinnable()).getText());
            this.resize();
        } else if ("SELECTED".equals(PROPERTY)) {
            if (((IconSwitch)this.getSkinnable()).isSelected()) {
                this.moveToSelected.play();
            } else {
                this.moveToDeselected.play();
            }
        }
    }

    private void resize() {
        this.width = ((IconSwitch)this.getSkinnable()).getWidth();
        this.height = ((IconSwitch)this.getSkinnable()).getHeight();
        double d = this.size = this.width < this.height ? this.width : this.height;
        if (this.width > 0.0 && this.height > 0.0) {
            if (this.aspectRatio * this.width > this.height) {
                this.width = 1.0 / (this.aspectRatio / this.height);
            } else if (1.0 / (this.aspectRatio / this.height) > this.width) {
                this.height = this.aspectRatio * this.width;
            }
            this.pane.setMaxSize(this.width, this.height);
            this.font = Font.font((String)"Open Sans", (FontWeight)FontWeight.BOLD, (FontPosture)FontPosture.REGULAR, (double)(this.height * 0.5));
            this.background.setPrefSize(this.width, this.height);
            this.symbol.setPrefSize(this.height * 0.59375 * ((IconSwitch)this.getSkinnable()).getSymbolType().WIDTH_FACTOR, this.height * 0.59375 * ((IconSwitch)this.getSkinnable()).getSymbolType().HEIGHT_FACTOR);
            this.symbol.relocate(this.height * 0.15 + (this.height * 0.59375 - this.height * 0.59375 * ((IconSwitch)this.getSkinnable()).getSymbolType().WIDTH_FACTOR) * 0.5, this.height * 0.18 + (this.height * 0.59375 - this.height * 0.59375 * ((IconSwitch)this.getSkinnable()).getSymbolType().HEIGHT_FACTOR) * 0.5);
            this.text.setFont(this.font);
            this.text.setVisible(!((IconSwitch)this.getSkinnable()).getText().isEmpty() && SymbolType.NONE == ((IconSwitch)this.getSkinnable()).getSymbolType());
            this.text.setPrefSize(this.height * 0.59375, this.height * 0.59375);
            this.text.relocate(this.height * 0.125, this.height * 0.15);
            this.thumb.setPrefSize(this.height * 0.75, this.height * 0.75);
            this.thumb.setTranslateX(((IconSwitch)this.getSkinnable()).isSelected() ? this.height * 1.625 : this.height * 0.875);
            this.thumb.setTranslateY(this.height * 0.125);
            this.moveToDeselected.setFromX(this.height * 1.625);
            this.moveToDeselected.setToX(this.height * 0.875);
            this.moveToSelected.setFromX(this.height * 0.875);
            this.moveToSelected.setToX(this.height * 1.625);
        }
    }
}

