/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.enzo.radialmenu;

import eu.hansolo.enzo.common.SymbolType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.scene.control.Control;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;

public class RadialMenuItem
extends Region {
    private static final double PREFERRED_SIZE = 35.0;
    private static final double MINIMUM_SIZE = 15.0;
    private static final double MAXIMUM_SIZE = 1024.0;
    public static final Color DEFAULT_BACKGROUND_COLOR = Color.rgb((int)41, (int)41, (int)40);
    public static final Color DEFAULT_BORDER_COLOR = Color.rgb((int)24, (int)24, (int)24);
    public static final Color DEFAULT_FOREGROUND_COLOR = Color.WHITE;
    public static final Color DEFAULT_SELECTED_BACKGROUND_COLOR = Color.rgb((int)253, (int)153, (int)52);
    public static final Color DEFAULT_SELECTED_FOREGROUND_COLOR = Color.WHITE;
    private static final PseudoClass SELECT_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"select");
    private BooleanProperty selected;
    private boolean _selectable;
    private BooleanProperty selectable;
    private String _tooltip;
    private StringProperty tooltip;
    private double _size;
    private DoubleProperty size;
    private Color _backgroundColor;
    private ObjectProperty<Color> backgroundColor;
    private Color _borderColor;
    private ObjectProperty<Color> borderColor;
    private Color _foregroundColor;
    private ObjectProperty<Color> foregroundColor;
    private Color _selectedBackgroundColor;
    private ObjectProperty<Color> selectedBackgroundColor;
    private Color _selectedForegroundColor;
    private ObjectProperty<Color> selectedForegroundColor;
    private SymbolType _symbolType;
    private ObjectProperty<SymbolType> symbolType;
    private StringProperty thumbnailImageName;
    private StringProperty text;

    public RadialMenuItem() {
        this("", 35.0, DEFAULT_BACKGROUND_COLOR, DEFAULT_BORDER_COLOR, DEFAULT_FOREGROUND_COLOR, DEFAULT_SELECTED_BACKGROUND_COLOR, DEFAULT_SELECTED_FOREGROUND_COLOR, SymbolType.NONE, "");
    }

    public RadialMenuItem(SymbolType SYMBOL_TYPE) {
        this("", 35.0, DEFAULT_BACKGROUND_COLOR, DEFAULT_BORDER_COLOR, DEFAULT_FOREGROUND_COLOR, DEFAULT_SELECTED_BACKGROUND_COLOR, DEFAULT_FOREGROUND_COLOR, SYMBOL_TYPE, "");
    }

    public RadialMenuItem(String THUMBNAIL_IMAGE_NAME) {
        this("", 35.0, DEFAULT_BACKGROUND_COLOR, DEFAULT_BORDER_COLOR, DEFAULT_FOREGROUND_COLOR, DEFAULT_SELECTED_BACKGROUND_COLOR, DEFAULT_FOREGROUND_COLOR, SymbolType.NONE, THUMBNAIL_IMAGE_NAME);
    }

    public RadialMenuItem(SymbolType SYMBOL_TYPE, String TOOLTIP) {
        this(TOOLTIP, 35.0, DEFAULT_BACKGROUND_COLOR, DEFAULT_BORDER_COLOR, DEFAULT_FOREGROUND_COLOR, DEFAULT_SELECTED_BACKGROUND_COLOR, DEFAULT_FOREGROUND_COLOR, SYMBOL_TYPE, "");
    }

    public RadialMenuItem(SymbolType SYMBOL_TYPE, String TOOLTIP, Color INNER_COLOR, Color SELECTED_COLOR) {
        this(TOOLTIP, 35.0, DEFAULT_BACKGROUND_COLOR, DEFAULT_BORDER_COLOR, DEFAULT_FOREGROUND_COLOR, DEFAULT_SELECTED_BACKGROUND_COLOR, DEFAULT_FOREGROUND_COLOR, SYMBOL_TYPE, "");
    }

    public RadialMenuItem(String TOOLTIP, double SIZE, Color BACKGROUND_COLOR, Color BORDER_COLOR, Color FOREGROUND_COLOR, Color SELECTED_BACKGROUND_COLOR, Color SELECTED_FOREGROUND_COLOR, SymbolType SYMBOL_TYPE, String THUMBNAIL_IMAGE_NAME) {
        this.getStyleClass().setAll((Object[])new String[]{"menu-item"});
        this._tooltip = TOOLTIP;
        this._size = SIZE;
        this._backgroundColor = BACKGROUND_COLOR;
        this._borderColor = BORDER_COLOR;
        this._foregroundColor = FOREGROUND_COLOR;
        this._selectedBackgroundColor = SELECTED_BACKGROUND_COLOR;
        this._selectedForegroundColor = SELECTED_FOREGROUND_COLOR;
        this._symbolType = SYMBOL_TYPE;
        this._selectable = false;
        this.thumbnailImageName = new SimpleStringProperty((Object)this, "thumbnailImageName", THUMBNAIL_IMAGE_NAME);
        this.init();
        this.initGraphics();
        this.registerListeners();
        this.setPrefSize(this.getSize(), this.getSize());
    }

    private void init() {
        if (Double.compare(this.getWidth(), 0.0) <= 0 || Double.compare(this.getHeight(), 0.0) <= 0 || Double.compare(this.getPrefWidth(), 0.0) <= 0 || Double.compare(this.getPrefHeight(), 0.0) <= 0) {
            this.setPrefSize(35.0, 35.0);
        }
        if (Double.compare(this.getMinWidth(), 0.0) <= 0 || Double.compare(this.getMinHeight(), 0.0) <= 0) {
            this.setMinSize(15.0, 15.0);
        }
        if (Double.compare(this.getMaxWidth(), 0.0) <= 0 || Double.compare(this.getMaxHeight(), 0.0) <= 0) {
            this.setMaxSize(1024.0, 1024.0);
        }
    }

    private void initGraphics() {
        this.setPickOnBounds(false);
    }

    private void registerListeners() {
        this.sizeProperty().addListener((ov, oldSize, newSize) -> this.setPrefSize(newSize.doubleValue(), newSize.doubleValue()));
    }

    protected double computePrefWidth(double PREF_HEIGHT) {
        double prefHeight = 35.0;
        if (PREF_HEIGHT != -1.0) {
            prefHeight = Math.max(0.0, PREF_HEIGHT - this.getInsets().getTop() - this.getInsets().getBottom());
        }
        return super.computePrefWidth(prefHeight);
    }

    protected double computePrefHeight(double PREF_WIDTH) {
        double prefWidth = 35.0;
        if (PREF_WIDTH != -1.0) {
            prefWidth = Math.max(0.0, PREF_WIDTH - this.getInsets().getLeft() - this.getInsets().getRight());
        }
        return super.computePrefWidth(prefWidth);
    }

    protected double computeMinWidth(double MIN_HEIGHT) {
        return super.computeMinWidth(Math.max(15.0, MIN_HEIGHT - this.getInsets().getTop() - this.getInsets().getBottom()));
    }

    protected double computeMinHeight(double MIN_WIDTH) {
        return super.computeMinHeight(Math.max(15.0, MIN_WIDTH - this.getInsets().getLeft() - this.getInsets().getRight()));
    }

    protected double computeMaxWidth(double MAX_HEIGHT) {
        return super.computeMaxWidth(Math.min(1024.0, MAX_HEIGHT - this.getInsets().getTop() - this.getInsets().getBottom()));
    }

    protected double computeMaxHeight(double MAX_WIDTH) {
        return super.computeMaxHeight(Math.min(1024.0, MAX_WIDTH - this.getInsets().getLeft() - this.getInsets().getRight()));
    }

    public String getTooltip() {
        return null == this.tooltip ? this._tooltip : (String)this.tooltip.get();
    }

    public void setTooltip(String TOOLTIP) {
        if (null == this.tooltip) {
            this._tooltip = TOOLTIP;
        } else {
            this.tooltip.set((Object)TOOLTIP);
        }
    }

    public StringProperty tooltipProperty() {
        if (null == this.tooltip) {
            this.tooltip = new SimpleStringProperty((Object)this, "tooltip", this._tooltip);
        }
        return this.tooltip;
    }

    public double getSize() {
        return null == this.size ? this._size : this.size.get();
    }

    public void setSize(double SIZE) {
        if (null == this.size) {
            this._size = SIZE;
        } else {
            this.size.set(SIZE);
        }
    }

    public DoubleProperty sizeProperty() {
        if (null == this.size) {
            this.size = new SimpleDoubleProperty((Object)this, "size", this._size);
        }
        return this.size;
    }

    public Color getBackgroundColor() {
        return null == this.backgroundColor ? this._backgroundColor : (Color)this.backgroundColor.get();
    }

    public void setBackgroundColor(Color BACKGROUND_COLOR) {
        if (null == this.backgroundColor) {
            this._backgroundColor = BACKGROUND_COLOR;
        } else {
            this.backgroundColor.set((Object)BACKGROUND_COLOR);
        }
    }

    public ObjectProperty<Color> backgroundColorProperty() {
        if (null == this.backgroundColor) {
            this.backgroundColor = new StyleableObjectProperty<Color>(DEFAULT_BACKGROUND_COLOR){

                public CssMetaData getCssMetaData() {
                    return StyleableProperties.BACKGROUND_COLOR;
                }

                public Object getBean() {
                    return RadialMenuItem.this;
                }

                public String getName() {
                    return "backgroundColor";
                }
            };
        }
        return this.backgroundColor;
    }

    public Color getBorderColor() {
        return null == this.borderColor ? this._borderColor : (Color)this.borderColor.get();
    }

    public void setBorderColor(Color BORDER_COLOR) {
        if (null == this.borderColor) {
            this._borderColor = BORDER_COLOR;
        } else {
            this.borderColor.set((Object)BORDER_COLOR);
        }
    }

    public ObjectProperty<Color> borderColorProperty() {
        if (null == this.borderColor) {
            this.borderColor = new StyleableObjectProperty<Color>(DEFAULT_BORDER_COLOR){

                public CssMetaData getCssMetaData() {
                    return StyleableProperties.BORDER_COLOR;
                }

                public Object getBean() {
                    return RadialMenuItem.this;
                }

                public String getName() {
                    return "borderColor";
                }
            };
        }
        return this.borderColor;
    }

    public Color getForegroundColor() {
        return null == this.foregroundColor ? this._foregroundColor : (Color)this.foregroundColor.get();
    }

    public void setForegroundColor(Color FOREGROUND_COLOR) {
        if (null == this.foregroundColor) {
            this._foregroundColor = FOREGROUND_COLOR;
        } else {
            this.foregroundColor.set((Object)FOREGROUND_COLOR);
        }
    }

    public ObjectProperty<Color> foregroundColorProperty() {
        if (null == this.foregroundColor) {
            this.foregroundColor = new StyleableObjectProperty<Color>(DEFAULT_FOREGROUND_COLOR){

                public CssMetaData getCssMetaData() {
                    return StyleableProperties.FOREGROUND_COLOR;
                }

                public Object getBean() {
                    return RadialMenuItem.this;
                }

                public String getName() {
                    return "foregroundColor";
                }
            };
        }
        return this.foregroundColor;
    }

    public Color getSelectedBackgroundColor() {
        return null == this.selectedBackgroundColor ? this._selectedBackgroundColor : (Color)this.selectedBackgroundColor.get();
    }

    public void setSelectedBackgroundColor(Color SELECTED_BACKGROUND_COLOR) {
        if (null == this.selectedBackgroundColor) {
            this._selectedBackgroundColor = SELECTED_BACKGROUND_COLOR;
        } else {
            this.selectedBackgroundColor.set((Object)SELECTED_BACKGROUND_COLOR);
        }
    }

    public ObjectProperty<Color> selectedBackgroundColorProperty() {
        if (null == this.selectedBackgroundColor) {
            this.selectedBackgroundColor = new StyleableObjectProperty<Color>(DEFAULT_SELECTED_BACKGROUND_COLOR){

                public CssMetaData getCssMetaData() {
                    return StyleableProperties.SELECTED_BACKGROUND_COLOR;
                }

                public Object getBean() {
                    return RadialMenuItem.this;
                }

                public String getName() {
                    return "selectedBackgroundColor";
                }
            };
        }
        return this.selectedBackgroundColor;
    }

    public Color getSelectedForegroundColor() {
        return null == this.selectedForegroundColor ? this._selectedForegroundColor : (Color)this.selectedForegroundColor.get();
    }

    public void setSelectedForegroundColor(Color SELECTED_FOREGROUND_COLOR) {
        if (null == this.selectedForegroundColor) {
            this._selectedForegroundColor = SELECTED_FOREGROUND_COLOR;
        } else {
            this.selectedForegroundColor.set((Object)SELECTED_FOREGROUND_COLOR);
        }
    }

    public ObjectProperty<Color> selectedForegroundColorProperty() {
        if (null == this.selectedForegroundColor) {
            this.selectedForegroundColor = new StyleableObjectProperty<Color>(DEFAULT_SELECTED_FOREGROUND_COLOR){

                public CssMetaData getCssMetaData() {
                    return StyleableProperties.SELECTED_FOREGROUND_COLOR;
                }

                public Object getBean() {
                    return RadialMenuItem.this;
                }

                public String getName() {
                    return "selectedForegroundColor";
                }
            };
        }
        return this.selectedForegroundColor;
    }

    public SymbolType getSymbolType() {
        return null == this.symbolType ? this._symbolType : (SymbolType)((Object)this.symbolType.get());
    }

    public void setSymbolType(SymbolType SYMBOL_TYPE) {
        if (null == this.symbolType) {
            this._symbolType = SYMBOL_TYPE;
        } else {
            this.symbolType.set((Object)SYMBOL_TYPE);
        }
    }

    public ObjectProperty<SymbolType> symbolTypeProperty() {
        if (null == this.symbolType) {
            this.symbolType = new SimpleObjectProperty((Object)this, "symbolType", (Object)this._symbolType);
        }
        return this.symbolType;
    }

    public String getThumbnailImageName() {
        return (String)this.thumbnailImageName.get();
    }

    public void setThumbnailImageName(String THUMBNAIL_IMAGE_NAME) {
        this.thumbnailImageName.set((Object)THUMBNAIL_IMAGE_NAME);
    }

    public StringProperty thumbnailImageNameProperty() {
        return this.thumbnailImageName;
    }

    public String getText() {
        return null == this.text ? "" : (String)this.text.get();
    }

    public void setText(String TEXT) {
        this.textProperty().set((Object)TEXT);
    }

    public StringProperty textProperty() {
        if (null == this.text) {
            this.text = new SimpleStringProperty((Object)this, "text", "");
        }
        return this.text;
    }

    public boolean isSelectable() {
        return null == this.selectable ? this._selectable : this.selectable.get();
    }

    public void setSelectable(boolean SELECTABLE) {
        if (null == this.selectable) {
            this._selectable = SELECTABLE;
        } else {
            this.selectable.set(SELECTABLE);
        }
    }

    public BooleanProperty selectableProperty() {
        if (null == this.selectable) {
            this.selectable = new SimpleBooleanProperty((Object)this, "selectable", this._selectable);
        }
        return this.selectable;
    }

    public final boolean isSelected() {
        return null == this.selected ? false : this.selected.get();
    }

    public final void setSelected(boolean SELECTED) {
        if (this.isSelectable()) {
            if (null == this.selected) {
                this.initSelected();
            }
            this.selected.set(SELECTED);
        }
    }

    public final ReadOnlyBooleanProperty selectedProperty() {
        if (null == this.selected) {
            this.initSelected();
        }
        return this.selected;
    }

    private void initSelected() {
        this.selected = new BooleanPropertyBase(false){

            protected void invalidated() {
                RadialMenuItem.this.pseudoClassStateChanged(SELECT_PSEUDO_CLASS, this.get());
            }

            public Object getBean() {
                return this;
            }

            public String getName() {
                return "select";
            }
        };
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    private static class StyleableProperties {
        private static final CssMetaData<RadialMenuItem, Color> BACKGROUND_COLOR = new CssMetaData<RadialMenuItem, Color>("-item-background", StyleConverter.getColorConverter(), DEFAULT_BACKGROUND_COLOR){

            public boolean isSettable(RadialMenuItem node) {
                return null == node.backgroundColor || !node.backgroundColor.isBound();
            }

            public StyleableProperty<Color> getStyleableProperty(RadialMenuItem node) {
                return (StyleableProperty)node.backgroundColorProperty();
            }

            public Color getInitialValue(RadialMenuItem node) {
                return node.getBackgroundColor();
            }
        };
        private static final CssMetaData<RadialMenuItem, Color> BORDER_COLOR = new CssMetaData<RadialMenuItem, Color>("-item-border", StyleConverter.getColorConverter(), DEFAULT_BORDER_COLOR){

            public boolean isSettable(RadialMenuItem node) {
                return null == node.borderColor || !node.borderColor.isBound();
            }

            public StyleableProperty<Color> getStyleableProperty(RadialMenuItem node) {
                return (StyleableProperty)node.borderColorProperty();
            }

            public Color getInitialValue(RadialMenuItem node) {
                return node.getBorderColor();
            }
        };
        private static final CssMetaData<RadialMenuItem, Color> FOREGROUND_COLOR = new CssMetaData<RadialMenuItem, Color>("-item-foreground", StyleConverter.getColorConverter(), DEFAULT_FOREGROUND_COLOR){

            public boolean isSettable(RadialMenuItem node) {
                return null == node.foregroundColor || !node.foregroundColor.isBound();
            }

            public StyleableProperty<Color> getStyleableProperty(RadialMenuItem node) {
                return (StyleableProperty)node.foregroundColorProperty();
            }

            public Color getInitialValue(RadialMenuItem node) {
                return node.getForegroundColor();
            }
        };
        private static final CssMetaData<RadialMenuItem, Color> SELECTED_BACKGROUND_COLOR = new CssMetaData<RadialMenuItem, Color>("-item-selected-background", StyleConverter.getColorConverter(), DEFAULT_SELECTED_BACKGROUND_COLOR){

            public boolean isSettable(RadialMenuItem node) {
                return null == node.selectedBackgroundColor || !node.selectedBackgroundColor.isBound();
            }

            public StyleableProperty<Color> getStyleableProperty(RadialMenuItem node) {
                return (StyleableProperty)node.selectedBackgroundColorProperty();
            }

            public Color getInitialValue(RadialMenuItem node) {
                return node.getSelectedBackgroundColor();
            }
        };
        private static final CssMetaData<RadialMenuItem, Color> SELECTED_FOREGROUND_COLOR = new CssMetaData<RadialMenuItem, Color>("-item-selected-foreground", StyleConverter.getColorConverter(), DEFAULT_SELECTED_FOREGROUND_COLOR){

            public boolean isSettable(RadialMenuItem node) {
                return null == node.selectedForegroundColor || !node.selectedForegroundColor.isBound();
            }

            public StyleableProperty<Color> getStyleableProperty(RadialMenuItem node) {
                return (StyleableProperty)node.selectedForegroundColorProperty();
            }

            public Color getInitialValue(RadialMenuItem node) {
                return node.getSelectedForegroundColor();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(Control.getClassCssMetaData());
            Collections.addAll(styleables, BACKGROUND_COLOR, BORDER_COLOR, FOREGROUND_COLOR, SELECTED_BACKGROUND_COLOR, SELECTED_FOREGROUND_COLOR);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

